package com.viontech.mall.report.service.impl;

import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.AbstractReportDataService;
import com.viontech.mall.report.service.adapter.MallDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.SaleDataService;
import com.viontech.mall.service.adapter.MallService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class MallReportDataServiceImpl extends AbstractReportDataService implements MallReportDataService {
	
	@Resource
	private MallDataService mallDataService;
	
	@Resource
	private SaleDataService saleDataService;
	
	@Resource
	private MallService mallService;
	
	@Resource
	private ZoneService zoneService;

	
	
	/**获取多个商场时间段的小时级的客流数据*/
	public List<MallHourCountData>  getOrQueryMallBetweenDateHourTraffic(Long[] mallIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<MallHourCountData> datas = (List<MallHourCountData>) dataMap.get(KEY_MALL_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<MallHourCountData>();
			List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
			datas = (List<MallHourCountData>) mallDataService.getHourData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个商场多个时间点的小时级的客流数据*/
	public List<MallMinuteCountData>  getOrQueryMallInDatesMinTraffic(Long[] mallIds,List<Date> dates,Map<String,Object> dataMap){
		List<MallMinuteCountData> datas = (List<MallMinuteCountData>) dataMap.get(KEY_10MINUTE_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<MallMinuteCountData>();
			datas = (List<MallMinuteCountData>) mallDataService.getMinuteData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_10MINUTE_TRAFFIC, datas);
		}
		return datas;
	}
	
	
	/**获取多个商场多个时间点的小时级的客流数据*/
	public List<MallHourCountData>  getOrQueryMallDaysHourTraffic(Long[] mallIds,List<Date> dates,Map<String,Object> dataMap){
		List<MallHourCountData> datas = (List<MallHourCountData>) dataMap.get(KEY_MALL_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<MallHourCountData>();
			datas = (List<MallHourCountData>) mallDataService.getHourData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个商场时间段的天级的客流数据*/
	public List<MallDayCountData> getOrQueryMallBetweenDateDayTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<MallDayCountData>();
			datas = (List<MallDayCountData>) mallDataService.getDayData(startDate, endDate, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个商场时间点的天级的客流数据*/
	public List<MallDayCountData> getOrQueryMallInDatesDayTraffic(Long[] mallIds,List<Date> dates, Map<String, Object> dataMap) {
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<MallDayCountData>();
			datas = (List<MallDayCountData>) mallDataService.getDayData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	/**获取多个商场时间段的天级的销售数据*/
	@Override
	public List<Sale> getOrQueryMallBetweenDateDaySale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			sales = saleDataService.getDayData(startDate, endDate, Arrays.asList(mallIds), OrgType.mall);
			dataMap.put(KEY_MALL_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取多个商场时间点的天级的销售数据*/
	@Override
	public List<Sale> getOrQueryMallInDateDaySale(Long[] mallIds, List<Date> dates, Map<String, Object> dataMap) {
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			sales = saleDataService.getDayData(dates, Arrays.asList(mallIds), OrgType.mall);
			dataMap.put(KEY_MALL_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取多个商场时间段的人脸数据*/
	@Override
	public List<MallDayFaceRecognitionSta> getOrQueryMallFaceData(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		//人脸
		List<MallDayFaceRecognitionSta> faceDatas= (List<MallDayFaceRecognitionSta>) dataMap.get(KEY_FACE_DATA);
		if (dataMap.get(KEY_FACE_DATA) == null) {
			faceDatas = new ArrayList<MallDayFaceRecognitionSta>();
			faceDatas = (List<MallDayFaceRecognitionSta>) mallDataService.getFaceDayData(startDate, endDate, Arrays.asList(mallIds));
			dataMap.put(KEY_FACE_DATA,faceDatas);
		}
		return faceDatas;
	}
	
	/**根据集团ID获取商场列表*/
	public Map<Long,Mall> getOrQueryMallsByAccountId(Long accountId,Map<String,Object> dataMap){
		Map<Long, Mall> mallMaps = (Map<Long, Mall>) dataMap.get(KEY_MALL_INFO);
		if (mallMaps == null) {
			mallMaps = new HashMap<Long, Mall>();
			MallExample example = new MallExample();
			example.createColumns().hasIdColumn().hasNameColumn().hasCityIdColumn().hasAreaColumn().hasStatusColumn();
			example.createCriteria().andAccountIdEqualTo(accountId).andStatusEqualTo(PARAM_MALL_STATUS_OPEN);
			List<Mall> malls = mallService.selectByExample(example);
			if (malls != null) {
				for (Mall mall : malls) {
					Long mallId = mall.getId();
					mallMaps.put(mallId, mall);
				}
			}
			dataMap.put(KEY_MALL_INFO, mallMaps);
		}
		return mallMaps;
	}
	
	/**根据商场ID获取商场信息*/
	public Mall getMallByMallId(Long mallId,Map<String,Object> dataMap){
		Map<Long, Mall>  mallMaps =  (Map<Long, Mall>) dataMap.get(KEY_MALL_INFO);
		Mall mall = null;
		if (mallMaps == null) {
			mall = mallService.selectByPrimaryKey(mallId);
			if (mall == null) {
				return mall;
			}
			//获取商场隶属集团下的所有商场数据
			Long accountId = mall.getAccountId();
			mallMaps = getOrQueryMallsByAccountId(accountId, dataMap);
			dataMap.put(KEY_MALL_INFO,mallMaps);
		}
		return mallMaps.get(mallId);
	}
	
	/**根据商场id获取商场所有的店铺数据 */
	public List<Zone> getOrQueryZonesOfMallId(Long mallId, Map<String, Object> dataMap) {
		List<Zone> datas = (List<Zone>) dataMap.get(KEY_ZONE_OF_MALL);
		if (datas == null) {
			datas = new ArrayList<Zone>();
			ZoneExample zoneExample = new ZoneExample();
			zoneExample.createColumns().hasIdColumn().hasNameColumn().hasTypeColumn().hasStatusColumn()
					.hasFormatIdColumn().hasBrandIdColumn().hasFloorIdColumn().hasMallIdColumn().hasAccountIdColumn().hasAreaColumn();
			zoneExample.createCriteria().andMallIdEqualTo(mallId);
			datas = zoneService.selectByExample(zoneExample);
			dataMap.put(KEY_ZONE_OF_MALL, datas);
		}
		return datas;
	}
	
	/**根据商场id获取商场店铺id列表*/
	public List<Long> getZoneIdsByMallId(Long mallId, Map<String, Object> dataMap){
		List<Zone> datas = (List<Zone>) dataMap.get(KEY_ZONE_OF_MALL);
		if (datas == null) {
			datas = getOrQueryZonesOfMallId(mallId, dataMap);
		}
		List<Long> zoneIds = new ArrayList<Long>();
		if (datas == null) {
			return zoneIds;
		}
		for (Zone zone : datas) {
			zoneIds.add(zone.getId());
		}
		return zoneIds;
	}
	
	/**
	 * 把监控点人脸数据转成通用人脸数据类中
	 * @param faceDatas
	 * @return
	 */
	public List<FaceVo> convertFace2Data(List<MallDayFaceRecognitionSta> faceDatas){
		List<FaceVo> faceVos = new ArrayList<FaceVo>();
		if (faceDatas != null && faceDatas.size() > 0) {
			for (MallDayFaceRecognitionSta faceData : faceDatas) {
				FaceVo faceVo = new FaceVo();
				faceVo.setPersonMantime(faceData.getPersonMantime());
				faceVo.setPersonCount(faceData.getPersonCount());
				faceVo.setCustomMantime(faceData.getCustomMantime());
				faceVo.setCustomCount(faceData.getCustomCount());
				faceVo.setMaleMantime(faceData.getMaleMantime());
				faceVo.setMaleCount(faceData.getMaleCount());
				faceVo.setFemaleMantime(faceData.getFemaleMantime());
				faceVo.setFemaleCount(faceData.getFemaleCount());
				faceVo.setStaffMantime(faceData.getStaffMantime());
				faceVo.setStaffCount(faceData.getStaffCount());
				faceVo.setCountdate(faceData.getCountdate());
				faceVo.setMallId(faceData.getMallId());
				faceVo.setAccountId(faceData.getAccountId());
				faceVo.setMaleStage(faceData.getMaleStage());
				faceVo.setFemaleStage(faceData.getFemaleStage());
				faceVos.add(faceVo);
			}
		}
		return faceVos;
	}
	
	/**
	 * 把监控点的小时客流、天级客流、销售    数据转成通用的数据类
	 * @param datas
	 * @return
	 */
	public   <T> List<DataVo> convert2Data(List<T> datas){
		List<DataVo> dataVos = new ArrayList<DataVo>();
		
		if (datas != null && datas.size() > 0) {
			boolean typeFlag = false;
			//泛型类型   1：MallHourCountData  2： MallDayCountData  3: Sale  4:MallMinuteCountDate
			int type = 0;
			for (T t : datas) {
				if (!typeFlag) {
					if(t instanceof MallHourCountData){
						type = 1;
						typeFlag = true;
					}else if (t instanceof MallDayCountData) {
						type = 2;
						typeFlag = true;
					}else if (t instanceof Sale) {
						type = 3;
						typeFlag = true;
					}else if(t instanceof MallMinuteCountData){
						type = 4;
						typeFlag = true;
					}
				}
				
				DataVo dataVo = new DataVo();
				dataVo.setDataType(type);
				switch (type) {
				case 1:
					MallHourCountData hourData = (MallHourCountData) t;
					dataVo.setMallId(hourData.getMallId());
					dataVo.setAccountId(hourData.getAccountId());
					dataVo.setDate(hourData.getCountdate());
					dataVo.setTime(hourData.getCounttime());
					dataVo.setOutnum(hourData.getOutnum());
					dataVo.setInnum(hourData.getInnum());
					dataVo.setPassInnum(Optional.ofNullable(hourData.getOutsideInnum()).orElse(0));
					dataVo.setPassOutnum(Optional.ofNullable(hourData.getOutsideOutnum()).orElse(0));
					dataVos.add(dataVo);
					break;
				case 2:
					MallDayCountData dayData = (MallDayCountData) t;
					dataVo.setMallId(dayData.getMallId());
					dataVo.setAccountId(dayData.getAccountId());
					dataVo.setDate(dayData.getCountdate());
					dataVo.setTime(dayData.getCounttime());
					dataVo.setOutnum(dayData.getOutnum());
					dataVo.setInnum(dayData.getInnum());
					dataVo.setPassInnum(Optional.ofNullable(dayData.getOutsideInnum()).orElse(0));
					dataVo.setPassOutnum(Optional.ofNullable(dayData.getOutsideOutnum()).orElse(0));
					dataVos.add(dataVo);
					break;
				case 3:
					Sale sale = (Sale) t;
					dataVo.setZoneId(sale.getZoneId());
					dataVo.setFloorId(sale.getFloorId());
					dataVo.setMallId(sale.getMallId());
					dataVo.setSaleCount(sale.getSalecount());
					dataVo.setDate(sale.getSaledate());
					dataVo.setMoney(sale.getMoney());
					dataVos.add(dataVo);
					break;
				case 4:
					MallMinuteCountData minuteData = (MallMinuteCountData) t;
					dataVo.setMallId(minuteData.getMallId());
					dataVo.setAccountId(minuteData.getAccountId());
					dataVo.setDate(minuteData.getCountdate());
					dataVo.setTime(minuteData.getCounttime());
					dataVo.setOutnum(minuteData.getOutnum());
					dataVo.setInnum(minuteData.getInnum());
					dataVo.setPassInnum(Optional.ofNullable(minuteData.getOutsideInnum()).orElse(0));
					dataVo.setPassOutnum(Optional.ofNullable(minuteData.getOutsideOutnum()).orElse(0));
					dataVos.add(dataVo);
					break;
				default:
					break;
				}
			}
		}
		return dataVos;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//------------------------------------------------------以下代码需要修改---------------------------------------------------------------------//
	/**获取楼层近5年 的客流数据*/
	@SuppressWarnings("unchecked")
	public List<MallDayCountData> getNear5YearMallTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			datas = (List<MallDayCountData>) mallDataService.getDayData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取楼层近5年的销售数据  */
	@SuppressWarnings("unchecked")
	public List<Sale> getNear5YearMallSale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(mallIds, dates, dataMap);
			dataMap.put(KEY_MALL_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取楼层近三月 的客流数据         本月  +  上月  + 去年同月*/
	@SuppressWarnings("unchecked")
	public List<MallDayCountData> getNear3MonthMallTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear6MonthDates(startDate, endDate));
			datas = (List<MallDayCountData>) mallDataService.getDayData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取楼层近三月 的销售数据         本月  +  上月  + 去年同月*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear3MonthMallSale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(getNear3MonthDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(mallIds, dates, dataMap);
			dataMap.put(KEY_MALL_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取楼层近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<MallDayCountData> getNear3WeekMallTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(get8WeekDates(startDate, endDate));
			datas = (List<MallDayCountData>) mallDataService.getDayData(dates, Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取楼层近三周 的销售数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear3WeekMallSale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(get3WeekDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(mallIds, dates, dataMap);
			dataMap.put(KEY_MALL_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取商场的销售数据  当天   昨天  上周同期     上月同期    上年同期   （近15天）*/
	public List<Sale> getMallNear15DaySales(Long[] mallIds,Date date,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			sales = getOrQueryMallSales(mallIds, startDate, date, dataMap);
		}
		return sales;
	}
	
	/**获取商场天级的客流数据  当天   昨天  上周同期     上月同期    上年同期     （近15天）*/
	public List<MallDayCountData> getMallNear15DayTraffic(Long[] mallIds,Date date,Map<String,Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			datas = getOrQueryMallDayTraffic(mallIds, startDate, date, dataMap);
		}
		return datas;
	}
	
	/**获取商场的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期  （当天）*/
	public List<MallHourCountData> getMallCurrentDayHourTraffic(Long[] mallIds,Date date,Map<String,Object> dataMap){
		List<MallHourCountData> datas = (List<MallHourCountData>) dataMap.get(KEY_MALL_HOUR_TRAFFIC);
		if (datas == null) {
			datas = getOrQueryMallHourData(mallIds, date, date, dataMap);
		}
		return datas;
	}
	
	/**
	 * 获取商场的销售额   近n天的（当天+上周同期+上月同期+上年同期）
	 * @param mallIds
	 * @param startDate  起始时间
	 * @param endDate	 结束日期
	 * @param dataMap
	 * @return
	 */
	public List<Sale> getOrQueryMallSales(Long[] mallIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_DAY_SALE);
		if (sales == null) {
			sales = new ArrayList<Sale>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			sales = querySalesByDatesAndOrgIds(mallIds,new ArrayList<Date>(dates), dataMap);
			dataMap.put(KEY_MALL_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**
	 * 获取商场近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  
	 * @param mallIds
	 * @param dataMap
	 * @param endDate
	 * @param dataMap
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<MallDayCountData> getOrQueryMallDayTraffic(Long[] mallIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<MallDayCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<MallDayCountData>) mallDataService.getDayData(new ArrayList<Date>(dates), Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取商场小时级的客流数据     近n天的数据+上周同期+上月同期+上年同期*/
	public List<MallHourCountData>  getOrQueryMallHourData(Long[] mallIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<MallHourCountData> datas = (List<MallHourCountData>) dataMap.get(KEY_MALL_HOUR_TRAFFIC);
		Date todayDate = endDate;
		if (datas == null) {
			datas = new ArrayList<MallHourCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<MallHourCountData>) mallDataService.getHourData(new ArrayList<Date>(dates), Arrays.asList(mallIds));
			dataMap.put(KEY_MALL_HOUR_TRAFFIC, datas);
		}
		return datas;
	}

}
