package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.MallDayCountData;
import com.viontech.mall.model.ReportChart;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service
public class MallMonthReportServiceImpl extends AbstractMallReportServiceImpl {

	/** 月客流环比 */
	private  final String FIELD_MONTH_COMPARED_INNUM = "comparedMonthInnum";

	/** 月环比客流量 */
	private final String FIELD_LASTMONTH_INNUM = "lastMonthInnum";

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Map<String, Object> head = super.getHead(orgIds, startDate, endDate, dataMap);
		Long orgId = orgIds[0];
		Integer comparedInnum=null;
		java.util.List<MallDayCountData> historyDatas = getOrQueryHistoryMallDayData(orgId, DateUtil.getLastMonth(startDate), DateUtil.getLastDateOfMonth(DateUtil.getLastMonth(endDate)), dataMap);
		if(historyDatas != null && historyDatas.size() > 0){
			comparedInnum = 0;
			for (MallDayCountData mallDayCountData : historyDatas) {
				comparedInnum += mallDayCountData.getInnum();
			}
		}
		if(head.get(FIELD_DAY_INNUM )==null){
			return head;
		}
		String trafficgrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_DAY_INNUM ))), comparedInnum);
		if (trafficgrowRate != null) {
			head.put(FIELD_MONTH_COMPARED_INNUM,trafficgrowRate.replace("%", ""));
			//月环比客流量
			head.put(FIELD_LASTMONTH_INNUM,comparedInnum);
		}
		return head;
	}

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_MALL_CUSTOMERFEATURE_GENDER:// 商场顾客特征--性别分布
			chart = genderDistributionReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_CUSTOMERFEATURE_AGE:// 商场顾客特征--年龄分布
			chart = ageDistributionReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_FLOOR_CUSTOMERFEATURE_NAO:// 商场顾客特征--新老顾客
			//chart = visitorStatisticReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_TRAFFICANDSALE_TREND:// 商场趋势
			chart = trafficAndSaleTrendReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_COSTOMER_RANKING:// 商场主力店排名--客流量
			chart = trafficRankReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_SALE_RANKING:// 商场主力店场排名--销售额
			chart = salesRankReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_ENTERING_RANKING:// 商场主力店场排名--进店率
			chart = enteringRateReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_PERCUSTOMERTRANSACTIONRANK:// 商场主力店场排名--客单价
			chart = perPriceTransactionReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_SALES_PERSQUAREMETERRANK:// 商场主力店场排名--坪效
			chart = perAreaValueReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_TURNOVERRANK:// 商场主力店场排名--成交量
			chart = saleCountReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_HANDBAGRATERANK:// 商场主力店场排名--提袋率
			chart = handbagRateReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_MALL_DURATIONTIMERANK:// 商场主力店场排名--滞留时间 
			chart = durationTimeReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_FORMAT_SALE_RANKING:// 商场业态排名--销售额
			chart = FormatSalesRankReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_FORMAT_TRIFFIC_RANKING:// 商场业态排名--客流量
			chart = formatTrifficRankReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_GATE_TRIFFIC:// 商场出入口--客流量
			chart = gateTrafficRankReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_FLOOR_TRIFFIC:// 商场楼层--客流量
			chart = FloorTrifficRankReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		default:
			break;
		}
		return chart;
	}


}
