package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.ConfigParamsService;
import com.viontech.mall.service.adapter.MallDayFaceRecognitionStaService;
import org.aspectj.bridge.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

@Service
public class MallDayReportServiceImpl extends AbstractMallReportServiceImpl {

	private final static Logger logger = LoggerFactory.getLogger(MallDayReportServiceImpl.class);

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private SaleDataService saleDataService;

	@Resource
	private MallDataService mallDataService;

	@Resource
	private FloorDataService floorDateService;

	@Resource
	private ZoneDataService zoneDataService;

	@Resource
	private GateDataService gateDateService;

	@Resource
	private MallDayFaceRecognitionStaService mallDayFaceRecognitionStaService;

	@Resource
	private MallReportDataService mallReportDataService;

	@Resource
	private ConfigParamsService configParamsService;

	/** 商场顾客特征--性别分布（日） */
	private final String REPORT_MALL_DAY_CUSTOMERFEATURE_GENDER = "customerfeature_denger";
	/** 商场顾客特征--年龄分布（日） */
	private final String REPORT_MALL_DAY_CUSTOMERFEATURE_AGE = "customerfeature_age";
	/**楼层顾客特征--新老顾客*/
	private final String REPORT_FLOOR_DAY_CUSTOMERFEATURE_NAO ="customerfeature_NAO";
	/** 商场实时客流（日） */
	private final String REPORT_MALL_DAY_COSTOMERCOUNTING = "customercounting";
	/** 商场累计客流（日） */
	private final String REPORT_MALL_DAY_COSTOMERADD = "customeradd";
	/** 商场近期趋势--近7天（日） */
	private final String REPORT_MALL_DAY_TREND7 = "trend7";
	/** 商场近期趋势--近15天（日） */
	private final String REPORT_MALL_DAY_TREND15 = "trend15";
	/** 商场近期趋势--近30天（日） */
	private final String REPORT_MALL_DAY_TREND30 = "trend30";
	/** 商场主力店排名--客流量（日） */
	private final String REPORT_MALL_DAY_COSTOMER_RANKING = "costomer_ranking";
	/** 商场主力店场排名--进店率（日） */
	private final String REPORT_MALL_DAY_ENTERING_RANKING = "entering_ranking";
	/** 商场主力店排名--销售额（日） */
	private final String REPORT_MALL_DAY_SALE_RANKING = "mall_sale_ranking";
	/** 商场主力店排名--客单价（日） */
	private final String REPORT_MALL_DAY_PERCUSTOMERTRANSACTIONRANK = "perTransactionRank";
	/** 商场主力店排名--坪效（日） */
	private final String REPORT_MALL_DAY_SALES_PERSQUAREMETERRANK = "perSquareMeterRank";
	/** 商场主力店排名--成交量（日） */
	private final String REPORT_MALL_DAY_TURNOVERRANK = "turnoverRank";
	/** 商场主力店排名--提袋率（日） */
	private final String REPORT_MALL_DAY_HANDBAGRATERANK = "handbagRateRank";
	/** 商场主力店排名--滞留时间（日） */
	private final String REPORT_MALL_DAY_DURATIONTIMERANK = "durationTimeRank";
	/** 商场业态排名--销售额（日） */
	private final String REPORT_FORMAT_DAY_SALE_RANKING = "format_sale_ranking";
	/** 商场业态排名--客流量（日） */
	private final String REPORT_FORMAT_DAY_TRIFFIC_RANKING = "triffic_ranking";
	/** 商场出入口--客流量（日） */
	private final String REPORT_GATE_DAY_TRIFFIC = "gate_triffic";
	/** 商场楼层--客流量（日） */
	private final String REPORT_FLOOR_DAY_TRIFFIC = "floor_triffic";



	/**商场销售额（销售额是以店铺为单位）*/
	private final String KEY_MALL_SALES = "mallSale";
	/**商场当天小时级客流*/
	private final String KEY_MALL_HOUR_TRAFFIC = "mallHourTrafffic";
	/**商场天级客流*/
	private final String KEY_MALL_DAY_TRAFFIC = "mallDayTrafffic";
	/**楼层当天小时级客流*/
	private final String KEY_FLOOR_HOUR_TRAFFIC = "floorHourTraffic";
	/**店铺当天小时级客流*/
	private final String KEY_ZONE_HOUR_TRAFFIC = "zoneHourTraffic";
	/**出入口当天小时级客流*/
	private final String KEY_GATE_HOUR_TRAFFIC = "gateHourTraffic";
	/**商场当天的人脸数据*/
	private final String KEY_FACERECONGNITION = "faceRecognition";
	/**商场营业时间*/
	private final String KEY_MALL_OPENTIME = "mallOpenTime";

	/** 商场面积 */
	private  final String FIELD_MALL_OPENED_AREA = "mallArea";
	/** 日客流环比 */
	private  final String FIELD_DAY_COMPARED_INNUM = "comparedInnum";
	/** 日客流同比 年*/
	private  final String FIELD_DAY_COMPARED_LASTYEAR_INNUM = "comparedLastYearInnum";
	/** 商场昨日客流量 */
	private final String FEILD_MALL_YESTERDAY_INNUM = "mallYesterdayInnum";
	/** 去年同比客流量 */
	private final String FEILD_MALL_LASTYEAR_INNUM = "mallLastyearInnum";
	/** 日同比客流 周 */
	private final String FIELD_DAY_COMPARED_LASTWEEK_INNUM = "comparedLastWeekInnum";
	/** 上周同比客流量 */
	private final String FEILD_MALL_LASTWEEK_INNUM = "mallLastweekInnum";

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Map<String, Object> head = new HashMap<String, Object>();
		long startPoint = System.currentTimeMillis();
		Mall mall=getMallById(orgId);
		/** 商场面积 */
		head.put(FIELD_MALL_OPENED_AREA,mall.getArea());
		logger.debug("商场面积---"+(System.currentTimeMillis()-startPoint));
		/** 日累计客流量 */

		Map<DateType, List<MallHourCountData>> mallHourData = getOrQueryMallHourData(orgId, date, dataMap);
		List<MallHourCountData> todayHourDatas = mallHourData.get(DateType.TODAY);
		Integer innum = null;
		if (todayHourDatas!= null && todayHourDatas.size() >0) {
			innum = 0;
			for (MallHourCountData mallHourCountData : todayHourDatas) {
				innum += mallHourCountData.getInnum();
			}
		}
		head.put(FIELD_DAY_INNUM, innum);
		logger.debug("日累计客流量---"+(System.currentTimeMillis()-startPoint));
		/** 日客流环比 */
		List<MallHourCountData> yesterdayHourDatas = mallHourData.get(DateType.YESTERDAY);
		Integer comparedInnum = null;
		if (yesterdayHourDatas!= null && yesterdayHourDatas.size() >0) {
			comparedInnum = 0;
			for (MallHourCountData mallHourCountData : yesterdayHourDatas) {
				comparedInnum += mallHourCountData.getInnum();
			}
		}
		String trafficgrowRate = NumberUtil.growthRate(innum, comparedInnum);
		if (trafficgrowRate != null) {
			head.put(FIELD_DAY_COMPARED_INNUM,trafficgrowRate.replace("%", ""));
			//返回昨天客流量
			head.put(FEILD_MALL_YESTERDAY_INNUM,comparedInnum);
		}
		logger.debug("日客流环比---"+(System.currentTimeMillis()-startPoint));
		/** 日客流同比 年*/
		List<MallHourCountData> lastyearHourDatas = mallHourData.get(DateType.LASTYEARDAY);
		Integer comparedLastYearInnum = null;
		if (lastyearHourDatas!= null && lastyearHourDatas.size() >0) {
			comparedLastYearInnum = 0;
			for (MallHourCountData mallHourCountData : lastyearHourDatas) {
				comparedLastYearInnum += mallHourCountData.getInnum();
			}
		}
		String trafficlastyeargrowRate = NumberUtil.growthRate(innum, comparedLastYearInnum);
		if (trafficlastyeargrowRate != null) {
			head.put(FIELD_DAY_COMPARED_LASTYEAR_INNUM,trafficlastyeargrowRate.replace("%", ""));
			//返回去年同比客流量
			head.put(FEILD_MALL_LASTYEAR_INNUM,comparedLastYearInnum);
		}
		logger.debug("日客流同比 年---"+(System.currentTimeMillis()-startPoint));

		/** 日客流同比 周 */
		List<MallHourCountData> lastWeekHourDatas = mallHourData.get(DateType.LASTWEEKDAY);
		Integer comparedLastWeekInnum = null;
		if(lastWeekHourDatas != null && !lastWeekHourDatas.isEmpty()){
			comparedLastWeekInnum = 0;
			for(MallHourCountData mallHourCountData : lastWeekHourDatas){
				comparedLastWeekInnum += mallHourCountData.getInnum();
			}
		}
		String trifficLastWeekGrowRate = NumberUtil.growthRate(innum,comparedLastWeekInnum);
		if(trifficLastWeekGrowRate != null){
			head.put(FIELD_DAY_COMPARED_LASTWEEK_INNUM,trifficLastWeekGrowRate.replace("%",""));
			head.put(FEILD_MALL_LASTWEEK_INNUM,comparedLastWeekInnum);
		}
		logger.debug("日客流同比 周 ---"+(System.currentTimeMillis()-startPoint));

		/** 日有效客流 */
		List<MallDayFaceRecognitionSta> faceDatas = getOrQueryFaceRecognitionStas(orgId, date,date, dataMap);
		Integer enableInnum = null;
		Integer staffInnum = null;
		Integer maleInnum = null;
		Integer femaleInnum = null;

		//获取系统配置参数
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(orgId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

		if (faceDatas != null && faceDatas.size() > 0) {
			for (MallDayFaceRecognitionSta mallFaceRecognitionSta : faceDatas) {
				//计算有效客流
				if (enableInnum == null){
					if("0".equals(enableTrafficFlag))
						enableInnum = mallFaceRecognitionSta.getCustomCount();
					else
						enableInnum = mallFaceRecognitionSta.getMaleCount()+mallFaceRecognitionSta.getFemaleCount();
				}else{
					if("0".equals(enableTrafficFlag))
						enableInnum = mallFaceRecognitionSta.getCustomCount();
					else
						enableInnum = mallFaceRecognitionSta.getMaleCount()+mallFaceRecognitionSta.getFemaleCount();
				}


				if(mallFaceRecognitionSta.getStaffCount() != null){
					if (staffInnum == null)
						staffInnum = mallFaceRecognitionSta.getStaffMantime();
					else
						staffInnum += mallFaceRecognitionSta.getStaffMantime();
				}
				if(mallFaceRecognitionSta.getMaleCount() != null){
					if (maleInnum == null)
						maleInnum = mallFaceRecognitionSta.getMaleCount();
					else
						maleInnum += mallFaceRecognitionSta.getMaleCount();
				}
				if(mallFaceRecognitionSta.getFemaleCount() != null){
					if (femaleInnum == null)
						femaleInnum = mallFaceRecognitionSta.getFemaleCount();
					else
						femaleInnum += mallFaceRecognitionSta.getFemaleCount();
				}
			}
		}
		head.put(FIELD_DAY_ENABLE_INNUM, enableInnum);
		head.put(FIELD_DAY_STAFF_INNUM, staffInnum);
		/**男性客流 */
		head.put(FIELD_MALE_INNUM, maleInnum);
		/**女性客流*/
		head.put(FIELD_FEMALE_INNUM, femaleInnum);
		logger.debug("日有效客流  ---"+(System.currentTimeMillis()-startPoint));


		/** 日累计销售额 */
		/*List<Sale> todaySales = getOrQueryMallTodaySales(orgId, date, dataMap);
		Double salesNum = null,perAreaPrice = null;
		Integer saleCount = null;
		if (todaySales != null && todaySales.size() > 0) {
			salesNum =0.0;saleCount = 0;
			for (Sale sale : todaySales) {
				salesNum += sale.getMoney();
				saleCount += sale.getSalecount();
			}
		}
		head.put(FIELD_DAY_SALE_MONEY, salesNum);
		*//** 客单价 *//*
		head.put(FIELD_DAY_PERTRANSACTION, NumberUtil.divide(salesNum, saleCount, 2));
		*//** 坪效 *//*
		if (mall != null  && mall.getArea()!= null) {
			perAreaPrice = NumberUtil.divide(salesNum, mall.getArea(), 2);
		}
		head.put(FIELD_DAY_PERSQUARE, perAreaPrice);
		*//**游逛深度 *//*
		head.put(FIELD_DAY_DEPTH, null);*/
		return head;
	}

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Chart chart = null;
		Long startTime = null;
		switch (reportChart.getKey()) {
			case REPORT_MALL_DAY_CUSTOMERFEATURE_GENDER:// 商场顾客特征--性别分布（日）
				startTime = System.currentTimeMillis();
				chart = genderDistributionReport(orgId, date, dataMap, reportChart);
				logger.debug("性别分布消耗时间"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_CUSTOMERFEATURE_AGE:// 商场顾客特征--年龄分布（日）
				startTime = System.currentTimeMillis();
				chart = ageDistributionReport(orgId, date, dataMap, reportChart);
				logger.debug("年龄分布"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_FLOOR_DAY_CUSTOMERFEATURE_NAO:// 商场顾客特征--新老顾客（日）
				//chart = visitorStatisticReport(orgId, date, dataMap, reportChart);
				break;
			case REPORT_MALL_DAY_COSTOMERCOUNTING:// 商场实时客流(日)
				startTime = System.currentTimeMillis();
				chart = CostomerCountingReport(orgId, date, dataMap, reportChart);
				logger.debug("商场实时客流"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_COSTOMERADD:// 商场累计客流(日)
				startTime = System.currentTimeMillis();
				chart = CostomerAddReport(orgId, date, dataMap, reportChart);
				logger.debug("商场累计客流"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_TREND7:// 商场近期趋势--近7天（日）
				startTime = System.currentTimeMillis();
				chart = trafficAndSaleTrendReport(orgId, date, dataMap, reportChart, -6);
				logger.debug("商场近期趋势--近7天"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_TREND15:// 商场近期趋势--近15天（日）
				startTime = System.currentTimeMillis();
				chart = trafficAndSaleTrendReport(orgId, date, dataMap, reportChart, -14);
				logger.debug("商场近期趋势--近15天"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_TREND30:// 商场近期趋势--近30天（日）
				startTime = System.currentTimeMillis();
				chart = trafficAndSaleTrendReport(orgId, date, dataMap, reportChart, -29);
				logger.debug("商场近期趋势--近30天"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_COSTOMER_RANKING:// 商场主力店排名--客流量（日）
				startTime = System.currentTimeMillis();
				chart = trafficRankReport(orgId, date, dataMap, reportChart);
				logger.debug("商场主力店排名--客流量"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_SALE_RANKING:// 商场主力店场排名--销售额（日）
				startTime = System.currentTimeMillis();
				chart = salesRankReport(orgId, date, dataMap, reportChart);
				logger.error("商场主力店场排名--销售额"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_ENTERING_RANKING:// 商场主力店场排名--进店率（日）
				startTime = System.currentTimeMillis();
				chart = enteringRateReport(orgId, date, dataMap, reportChart);
				logger.debug("商场主力店场排名--进店率"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_PERCUSTOMERTRANSACTIONRANK:// 商场主力店场排名--客单价（日）
				startTime = System.currentTimeMillis();
				chart = perPriceTransactionReport(orgId, date, dataMap, reportChart);
				logger.debug("商场主力店场排名--客单价"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_SALES_PERSQUAREMETERRANK:// 商场主力店场排名--坪效（日）
				startTime = System.currentTimeMillis();
				chart = perAreaValueReport(orgId, date, dataMap, reportChart);
				logger.debug(" 商场主力店场排名--坪效"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_TURNOVERRANK:// 商场主力店场排名--成交量（日）
				startTime = System.currentTimeMillis();
				chart = saleCountReport(orgId, date, dataMap, reportChart);
				logger.debug("商场主力店场排名--成交量"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_HANDBAGRATERANK:// 商场主力店场排名--提袋率（日）
				startTime = System.currentTimeMillis();
				chart = handbagRateReport(orgId, date, dataMap, reportChart);
				logger.debug("商场主力店场排名--提袋率"+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_MALL_DAY_DURATIONTIMERANK:// 商场主力店场排名--滞留时间 （日）
				startTime = System.currentTimeMillis();
				chart = durationTimeReport(orgId, date, dataMap, reportChart);
				logger.debug(" 商场主力店场排名--滞留时间 "+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_FORMAT_DAY_SALE_RANKING:// 商场业态排名--销售额（日）
				startTime = System.currentTimeMillis();
				chart = FormatSalesRankReport(orgId, date, dataMap, reportChart);
				logger.debug("商场业态排名--销售额 "+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_FORMAT_DAY_TRIFFIC_RANKING:// 商场业态排名--客流量（日）
				startTime = System.currentTimeMillis();
				chart = FormatTrifficRankReport(orgId, date, dataMap, reportChart);
				logger.debug(" 商场业态排名--客流量 "+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_GATE_DAY_TRIFFIC:// 商场出入口--客流量（日）
				startTime = System.currentTimeMillis();
				chart = gateTrafficRankReport(orgId, date, dataMap, reportChart);
				logger.debug(" 商场出入口--客流量 "+(System.currentTimeMillis()-startTime));
				break;
			case REPORT_FLOOR_DAY_TRIFFIC:// 商场楼层--客流量（日）
				startTime = System.currentTimeMillis();
				chart = FloorTrifficRankReport(orgId, date, dataMap, reportChart);
				logger.debug("商场楼层--客流量 "+(System.currentTimeMillis()-startTime));
				break;
			default:
				break;
		}
		return chart;
	}


	/**顾客特征--年龄分布*/
	private Chart ageDistributionReport(Long mallId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		String[] ages = ageStage.split(",");
		List<Integer> ageStages = new ArrayList<>();
		for (String age : ages) {
			Integer ageInt = Integer.parseInt(age);
			ageStages.add(ageInt);
		}
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);

		MallDayFaceRecognitionStaExample ageStatisticExample = new MallDayFaceRecognitionStaExample();
		ageStatisticExample.createColumns().hasMallIdColumn().hasMaleStageColumn().hasFemaleStageColumn().hasCountdateColumn();
		ageStatisticExample.createCriteria().andMallIdEqualTo(mallId).andCountdateEqualTo(date);
		List<MallDayFaceRecognitionSta> ageSta = mallDayFaceRecognitionStaService.selectByExample(ageStatisticExample);

		if (ageSta != null && ageSta.size() >0) {

			for (MallDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);

				if (maleAgestatic.length != femaleAgestatic.length) {
					continue;
				}

				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {

					int maleNum = Integer.parseInt("" + maleAgestatic[rangeNum].trim());
					int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}
			}
		}

		return chart;
	}


	/**顾客特征--性别分布*/
	private Chart genderDistributionReport(Long mallId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);

		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());

		List<MallDayFaceRecognitionSta> datas = getOrQueryFaceRecognitionStas(mallId, date,date, dataMap);

		for (MallDayFaceRecognitionSta faceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE,faceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE, faceRecognitionSta.getMaleCount());
		}
		return chart;
	}

	/**实时客流 */
	private Chart CostomerCountingReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = mallReportDataService.getMallOpentimesByOrgId(orgId,null,dataMap);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);

		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());


		Map<DateType,List<MallHourCountData>> dataMaps =  getOrQueryMallHourData(orgId, date, dataMap);
		for (Entry<DateType, List<MallHourCountData>> entry : dataMaps.entrySet()) {
			DateType dateType = entry.getKey();
			List<MallHourCountData> mall_Hour_countDates = entry.getValue();
			for (MallHourCountData mallHourCountData : mall_Hour_countDates) {
				Date counttime = mallHourCountData.getCounttime();
				chart.getSeries(dateType.toString()).adjustOrPutValueByCoordinate(counttime,mallHourCountData.getInnum());
			}
		}

		return chart;
	}

	/**累计客流 */
	private Chart CostomerAddReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line) {
			@Override
			public Object calcValue(String name,int index, List data) {
				Double result = null;
				if (data.get(index) != null) {
					result = Double.parseDouble(data.get(index).toString());
					if(index==0){
						return result;
					}
					int pre = index;
					while((--pre) > 0){
						if(data.get(pre) == null){
							continue;
						}
						result += Double.parseDouble(data.get(pre).toString());
						break;
					}
				}
				return result;
			}
		};

		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = mallReportDataService.getMallOpentimesByOrgId(orgId,null,dataMap);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);
		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());


		Map<DateType,List<MallHourCountData>> dataMaps =  getOrQueryMallHourData(orgId, date, dataMap);
		for (Entry<DateType, List<MallHourCountData>> entry : dataMaps.entrySet()) {
			DateType dateType = entry.getKey();
			List<MallHourCountData> mall_Hour_countDates = entry.getValue();
			for (MallHourCountData mallHourCountData : mall_Hour_countDates) {
				Date counttime = mallHourCountData.getCounttime();
				chart.getSeries(dateType.toString()).adjustOrPutValueByCoordinate(counttime,mallHourCountData.getInnum());
			}
		}

		return chart;
	}

	/**近期趋势*/
	private Chart trafficAndSaleTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		final String effectiveTraffic = LocalMessageUtil.getMessage("effective");
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		//chart.createSeries(ParamName.SALES.toString());
		chart.createSeries(effectiveTraffic);
		// 客流量
		List<MallDayCountData> DayTraffic = getOrQueryMallDayData(orgId, date, dataMap);
		List<Date> dates = DateUtil.getDaysBetweenDates(beforeDate, date);
		for (MallDayCountData DayCountData : DayTraffic) {
			Date dataTime = DayCountData.getCountdate();
			if (dates.contains(dataTime)) {
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(DayCountData.getCountdate(), DayCountData.getInnum());
			}
		}
//		//销售额
//		List<Sale> sales = getOrQueryMallSales(orgId, date, dataMap);
//		for (Sale sale : sales) {
//			Date saleDate = sale.getSaledate();
//			if (dates.contains(saleDate)) {
//				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
//			}
//		}
		//有效客流
		dataMap.remove(KEY_FACERECONGNITION);

		//获取系统配置参数
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(orgId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

		List<MallDayFaceRecognitionSta> mallDayFaceRecognitionStas = getOrQueryFaceRecognitionStas(orgId,DateUtil.addDays(date,DayNum),date, dataMap);
		for(MallDayFaceRecognitionSta mallDayFaceRecognitionSta:mallDayFaceRecognitionStas){
			Date faceDate = mallDayFaceRecognitionSta.getCountdate();
			if(dates.contains(faceDate)){
				if("0".equals(enableTrafficFlag)) {
					chart.getSeries(effectiveTraffic).adjustOrPutValueByCoordinate(mallDayFaceRecognitionSta.getCountdate(), mallDayFaceRecognitionSta.getCustomCount());
				}else{
					chart.getSeries(effectiveTraffic).adjustOrPutValueByCoordinate(mallDayFaceRecognitionSta.getCountdate(), mallDayFaceRecognitionSta.getFemaleCount()+mallDayFaceRecognitionSta.getMaleCount());
				}
			}
		}

		return chart;
	}

	/**店铺排行--客流量*/
	private Chart trafficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Long startTime = System.currentTimeMillis();
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		// 客流量
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		chart.createSeries(ParamName.TRAFFIC.toString());

		Map<Long,List<ZoneHourCountData>>  trafficMap =   getOrQueryZoneHourMapData(orgId, date, dataMap);
		logger.error("店铺数据查询"+(System.currentTimeMillis() - startTime));
		if (trafficMap != null) {
			Map<Long, Zone> zoneMaps = getOrQueryZonesOfMallMap(orgId, dataMap);
			for (Entry<Long, List<ZoneHourCountData>> entry: trafficMap.entrySet()) {
				Long zoneId = entry.getKey();
				if (zoneMaps == null || zoneMaps.get(zoneId)== null) {
					continue;
				}
				Zone zone = zoneMaps.get(zoneId);

				int zoneInnum = 0;
				for (ZoneHourCountData zoneHourCountData : entry.getValue()) {
					zoneInnum += zoneHourCountData.getInnum();
				}
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(zone.getName(),zoneInnum);
			}
			logger.error("for循环"+(System.currentTimeMillis() - startTime));
		}
		logger.debug("主力店排名，排序前"+System.currentTimeMillis());
		chart.sort(ParamName.TRAFFIC.toString(), (Comparator<Integer>) (o1, o2) -> {
			if(o1 == null) o1 = Integer.MIN_VALUE;
			if(o2 == null) o2 = Integer.MIN_VALUE;
			return Integer.compare(o1.intValue(), o2.intValue());
		});
		logger.debug("主力店排名，排序后"+System.currentTimeMillis());
		chart.subData(0, 10);
		logger.debug("主力店排名，subData后"+System.currentTimeMillis());
		return chart;
	}

	/**店铺排行--销售额*/
	private Chart salesRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.SALES.toString());

		List<Sale> sales = getOrQueryMallTodaySales(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(zone.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), (Comparator<Double>) (o1, o2) -> {
			if (o1 == null) o1 = Double.MIN_VALUE;
			if (o2 == null) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--进店率*/
	private Chart enteringRateReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);

		Axis< String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.ENTERINGRATE.toString());

		Map<Long,List<ZoneHourCountData>> zoneDatas =  getOrQueryZoneHourMapData(orgId, date, dataMap);
		if (zoneDatas != null && zoneDatas.size() > 0) {
			for (Entry<Long,List<ZoneHourCountData>> entry: zoneDatas.entrySet()) {
				Long zoneId = entry.getKey();
				Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
				List<ZoneHourCountData> dates = entry.getValue();
				int allInum = 0;//店铺总近店人数
				int allNum = 1;//总经过人数
				for (ZoneHourCountData zoneHourCountData : dates) {
					int passNum = zoneHourCountData.getOutsideInnum()+zoneHourCountData.getOutsideOutnum();
					allNum += passNum;
					allInum += zoneHourCountData.getInnum();
				}

				chart.getSeries(ParamName.ENTERINGRATE.toString()).adjustOrPutValueByCoordinate(
						zone.getName(),NumberUtil.percentage(allInum, allNum, 2));
			}
		}
		chart.sort(ParamName.ENTERINGRATE.toString(), (Comparator<Double>) (o1, o2) -> {
			if (o1 == null) o1 = Double.MIN_VALUE;
			if (o2 == null) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--客单价*/
	private Chart perPriceTransactionReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.PREPRICE.toString());

		List<Sale> sales = getOrQueryMallTodaySales(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			Double perPrice = NumberUtil.divide(sale.getMoney(), sale.getSalecount(), 2);
			chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(zone.getName() ,perPrice);
		}
		chart.sort(ParamName.PREPRICE.toString(), (Comparator<Double>) (o1, o2) -> {
			if (o1 == null) o1 = Double.MIN_VALUE;
			if (o2 == null) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--坪效*/
	private Chart perAreaValueReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.PERAREAVALUE.toString());
		List<Sale> sales = getOrQueryMallTodaySales(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			float area = zone.getArea();
			chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(zone.getName(),NumberUtil.divide(sale.getMoney(), area, 2));
		}
		chart.sort(ParamName.PERAREAVALUE.toString(), (Comparator<Double>) (o1, o2) -> {
			if(o1 == null) o1 = Double.MIN_VALUE;
			if (o2 == null) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--成交量*/
	private Chart saleCountReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.ORDER.toString());
		List<Sale> sales = getOrQueryMallTodaySales(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			chart.getSeries(ParamName.ORDER.toString()).adjustOrPutValueByCoordinate(zone.getName(),sale.getSalecount());
		}
		chart.sort(ParamName.ORDER.toString(), (Comparator<Integer>) (o1, o2) -> {
			if (o1 == null) o1 = Integer.MIN_VALUE;
			if (o2 == null) o2 = Integer.MIN_VALUE;
			return Integer.compare(o1.intValue(), o2.intValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--提袋率*/
	private Chart handbagRateReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.HANDBAGRATE.toString());

		List<Sale> sales = getOrQueryMallTodaySales(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			int takebagNum = sale.getSalecount();
			int inNum = 0;
			Map<Long, List<ZoneHourCountData>> zoneHourMaps = getOrQueryZoneHourMapData(orgId, date, dataMap);
			if (zoneHourMaps != null && zoneHourMaps.size() > 0) {
				List<ZoneHourCountData> zoneDatas = zoneHourMaps.get(zoneId);
				for (ZoneHourCountData zoneHourCountData : zoneDatas) {
					inNum += zoneHourCountData.getInnum();
				}

			}else {
				inNum = 1;
			}
			chart.getSeries(ParamName.HANDBAGRATE.toString()).adjustOrPutValueByCoordinate(zone.getName(),
					NumberUtil.percentage(takebagNum, inNum, 2));
		}
		chart.sort(ParamName.HANDBAGRATE.toString(), (Comparator<Double>) (o1, o2) -> {
			if (o1 == null ) o1 = Double.MIN_VALUE;
			if (o2 == null ) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--滞留时间       滞留时间 = （总进人数 - 总出人数）* 统计时间单位 / 进店总人数   */
	private Chart durationTimeReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.DURATIONTIME.toString());
		Map<Long, List<ZoneHourCountData>> zoneDataMap =  getOrQueryZoneHourMapData(orgId, date, dataMap);
		if (zoneDataMap != null && zoneDataMap.size() > 0) {
			for(Entry<Long, List<ZoneHourCountData>> entry: zoneDataMap.entrySet()){
				Long zoneId = entry.getKey();
				Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
				int allInnum = 0,allOutnum = 0,allDurationTime = 0;
				for (ZoneHourCountData zoneHourCountData : entry.getValue()) {
					allInnum += zoneHourCountData.getInnum();
					allOutnum += zoneHourCountData.getOutnum();
					int durationNum = allInnum-allOutnum;
					if (allInnum-allOutnum < 0 ) {
						durationNum = 0;
					}
					allDurationTime += durationNum;
				}
				chart.getSeries(ParamName.DURATIONTIME.toString()).adjustOrPutValueByCoordinate(zone.getName(),
						NumberUtil.divide(allDurationTime, allInnum, 2));
			}
		}
		chart.sort(ParamName.DURATIONTIME.toString(), (Comparator<Double>) (o1, o2) -> {
			if(o1 == null) o1 = Double.MIN_VALUE;
			if(o2 == null) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**业态排名--销售额*/
	private Chart FormatSalesRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.SALES.toString());

		List<Sale> sales = getOrQueryMallTodaySales(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(format.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), (Comparator<Double>) (o1, o2) -> {
			if (o1 == null) o1 = Double.MIN_VALUE;
			if(o2 == null) o2 = Double.MIN_VALUE;
			return Double.compare(o1.doubleValue(), o2.doubleValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**业态排名--客流量 */
	private Chart FormatTrifficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());

		Map<Long,List<ZoneHourCountData>> trifficMap = getOrQueryZoneHourMapData(orgId, date, dataMap);
		if (trifficMap != null && trifficMap.size() > 0) {
			for (Entry<Long, List<ZoneHourCountData>> entry : trifficMap.entrySet()) {
				Long zoneId = entry.getKey();
				Map<Long, Zone> zoneMaps = getOrQueryZonesOfMallMap(orgId, dataMap);
				if (zoneMaps == null || zoneMaps.get(zoneId) == null) {
					continue;
				}
				Zone zone = zoneMaps.get(zoneId);
				if (zone.getFormatId() == null) {
					continue;
				}
				Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
				String formatName = LocalMessageUtil.getMessage("unknownFormat");
				if (format != null && !format.getName().isEmpty()) {
					formatName = format.getName();
				}
				int zoneInnum = 0;
				for (ZoneHourCountData zoneHourCountData : entry.getValue()) {
					zoneInnum += zoneHourCountData.getInnum();
				}
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(formatName, zoneInnum);
			}
		}
		chart.sort(ParamName.TRAFFIC.toString(), (Comparator<Integer>) (o1, o2) -> {
			if (o1 == null) o1 = Integer.MIN_VALUE;
			if (o2 == null) o2 = Integer.MIN_VALUE;
			return Integer.compare(o1.intValue(), o2.intValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/**出入口客流*/
	private Chart gateTrafficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Long start = System.currentTimeMillis();
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		logger.error("获取监控点小时数据前"+(System.currentTimeMillis()-start));
		List<GateHourCountData> datas = getOrQueryGateHourData(orgId, date, dataMap);
		logger.error("获取监控点小时数据后"+(System.currentTimeMillis()-start));
		if (datas != null && datas.size() >0) {
			Map<Long, Gate> gateMaps= getOrQueryGatesOfMall(orgId, dataMap);
			if (gateMaps != null && gateMaps.size() >0) {
				logger.error("for循环前"+(System.currentTimeMillis()-start));
				for (GateHourCountData gateHourCountData : datas) {
					Long gateId = gateHourCountData.getGateId();
					Gate gate = gateMaps.get(gateId);
					short isMallGate = gate.getIsMallGate();
					if (NumberUtil.parseInteger(isMallGate).equals(1)) {
						chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(gate.getName(), gateHourCountData.getInnum().intValue());
					}
				}
				logger.error("for循环后"+(System.currentTimeMillis()-start));
				chart.sort(ParamName.TRAFFIC.toString(), (Comparator<Integer>) (o1, o2) -> {
					if (o1 == null) o1 = Integer.MIN_VALUE;
					if (o2 == null) o2 = Integer.MIN_VALUE;
					return Integer.compare(o1.intValue(), o2.intValue());
				});
				chart.subData(0, 10);
			}
		}
		return chart;
	}

	/**楼层客流*/
	private Chart FloorTrifficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());

		List<FloorHourCountData> triffic = getOrQueryFloorTodayHourTraffic(orgId, date, dataMap);
		Map<Long, Floor> floorMaps = getOrQueryFloorsOfMall(orgId, dataMap);
		for (FloorHourCountData floorHourCountData : triffic) {
			Long floorId = floorHourCountData.getFloorId();
			Floor floor = floorMaps.get(floorId);
			if(floor == null)
				continue;
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(floor.getName(),floorHourCountData.getInnum().intValue());
		}
		chart.sort(ParamName.TRAFFIC.toString(), (Comparator<Integer>) (o1, o2) -> {
			if (o1 == null ) o1 = Integer.MIN_VALUE;
			if (o2 == null ) o2 = Integer.MIN_VALUE;
			return Integer.compare(o1.intValue(), o2.intValue());
		});
		chart.subData(0, 10);
		return chart;
	}

	/** 获取商场当天的销售额 */
	private List<Sale> getOrQueryMallTodaySales(Long mallId, Date date, Map<String, Object> dataMap) {
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_SALES);
		if ( sales == null) {
			sales = getOrQueryMallSales(mallId, date, dataMap);
		}
		List<Sale> todaySales = new ArrayList<Sale>();
		for (Sale sale : sales) {
			Date saleDate = sale.getSaledate();
			if (DateUtil.isSameDay(saleDate, date)) {
				todaySales.add(sale);
			}
		}
		return todaySales;
	}

	/** 获取商场销售额 (默认最近30天)*/
	private List<Sale> getOrQueryMallSales(Long mallId, Date date, Map<String, Object> dataMap) {
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_SALES);
		if ( sales == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			sales =saleDataService.getDayData(startDate, date, mallId, OrgType.mall);
			dataMap.put(KEY_MALL_SALES, sales);
		}
		return sales;
	}

	/**获取商场小时级客流(当日 昨日  上周同期   上月同期    上年同期)*/
	private Map<DateType,List<MallHourCountData>>  getOrQueryMallHourData(Long mallId, Date date, Map<String, Object> dataMap){
		Map<DateType,List<MallHourCountData>> datas =  (Map<DateType, List<MallHourCountData>>) dataMap.get(KEY_MALL_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new HashMap<>();
			List<Date> dates = new ArrayList<Date>();
			dates.add(date);
			Date yesterday = DateUtil.getYesterday(date);
			dates.add(yesterday);
			Date lastWeekDay = DateUtil.getLastWeek(date);
			dates.add(lastWeekDay);
			Date lastMontdDay = DateUtil.getLastMonth(date);
			dates.add(lastMontdDay);
			Date lastYearDay = DateUtil.getLastYear(date);
			dates.add(lastYearDay);

			List<MallHourCountData>	mallHourDatas = (List<MallHourCountData>) mallDataService.getHourData(dates, mallId);

			for (MallHourCountData mallHourData : mallHourDatas) {
				Date dataTime = mallHourData.getCountdate();
				DateType dateType = DateType.valueOfDay(date, dataTime);
				List<MallHourCountData> addMapList = datas.get(dateType);
				if(addMapList == null){
					addMapList = new ArrayList<>();
				}
				addMapList.add(mallHourData);
				datas.put(dateType, addMapList);
			}
			dataMap.put(KEY_MALL_HOUR_TRAFFIC, datas);
		}
		return datas;
	}

	/**获取商场天级客流(默认近30天的数据)*/
	private List<MallDayCountData>  getOrQueryMallDayData(Long mallId, Date date, Map<String, Object> dataMap){
		List<MallDayCountData> datas =  (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			datas = (List<MallDayCountData>) mallDataService.getDayData(startDate, date, mallId);
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}

	/**获取所有店铺当天的小时级客流*/
	private Map<Long,List<ZoneHourCountData>> getOrQueryZoneHourMapData(Long mallId, Date date, Map<String, Object> dataMap){
		Map<Long, List<ZoneHourCountData>> datas = (Map<Long, List<ZoneHourCountData>>) dataMap.get(KEY_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new HashMap<>();
			//获取商场所有店铺
			Map<Long, Zone> zoneMaps = getOrQueryZonesOfMallMap(mallId, dataMap);
			logger.debug("执行查询sql前"+System.currentTimeMillis());
			List<ZoneHourCountData> zoneHourDataList = (List<ZoneHourCountData>) zoneDataService.getHourData(date,new ArrayList<Long>(zoneMaps.keySet()));
			logger.debug("执行查询sql后"+System.currentTimeMillis());
			for (ZoneHourCountData zoneHourCountData : zoneHourDataList) {
				Long zoneId = zoneHourCountData.getZoneId();
				List<ZoneHourCountData> addMapDatas = datas.get(zoneId);
				if (addMapDatas == null) {
					addMapDatas = new ArrayList<>();
				}
				addMapDatas.add(zoneHourCountData);
				datas.put(zoneId, addMapDatas);
			}
			dataMap.put(KEY_ZONE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}

	/**获取出入口当天的小时级客流*/
	private List<GateHourCountData> getOrQueryGateHourData(Long mallId, Date date, Map<String, Object> dataMap){
		List<GateHourCountData> datas = (List<GateHourCountData>) dataMap.get(KEY_GATE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<>();
			//获取商场所有的出入口
			Map<Long, Gate>  gateMaps = getOrQueryGatesOfMall(mallId, dataMap);
			if (gateMaps != null && gateMaps.size() >0) {
				datas = (List<GateHourCountData>) gateDateService.getHourData(date, new ArrayList<>(gateMaps.keySet()));
			}else {
				MessageUtil.error("该出入口未找到");
			}
			//获取出入口客流数据
			dataMap.put(KEY_GATE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}

	/**获取楼层当天的小时级客流*/
	private List<FloorHourCountData> getOrQueryFloorTodayHourTraffic(Long mallId,Date date,Map<String,Object> dataMap){
		List<FloorHourCountData> datas = (List<FloorHourCountData>) dataMap.get(KEY_FLOOR_HOUR_TRAFFIC);
		if (datas == null) {
			Map<Long, Floor> floorMaps = getOrQueryFloorsOfMall(mallId, dataMap);
			datas = (List<FloorHourCountData>) floorDateService.getHourData(date,new ArrayList<Long>(floorMaps.keySet()));

			dataMap.put(KEY_FLOOR_HOUR_TRAFFIC, datas);
		}
		return datas;
	}


}
