package com.viontech.mall.report.service.impl;

import com.viontech.keliu.base.BaseModel;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.service.adapter.MallDataService;
import com.viontech.mall.service.adapter.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
/**
 * 商场客流数据服务类
 * @author dugw
 *
 */
@Service
public class MallDataServiceImpl extends BaseDataServiceImpl implements MallDataService {
	
	@Resource
	private MallMinuteCountDataService mallMinuteService;
	@Resource
	private MallHourCountDataService mallHourService;
	@Resource
	private MallDayCountDataService mallDayService;
	@Resource
	private MallDayFaceRecognitionStaService mallDayFaceRecognitionStaService;
	@Resource
	private MallHourFaceRecognitionStaService mallHourFaceRecognitionStaService;
	
	@Override
	public List<? extends BaseModel> getMinuteData(List<Date> dates, List<Long> ids) {
		MallMinuteCountDataExample example = new MallMinuteCountDataExample();
		example.createColumns().hasMallIdColumn().hasAccountIdColumn().hasInnumColumn().hasOutnumColumn().hasCountdateColumn().hasCounttimeColumn().hasOutsideInnumColumn().hasOutsideOutnumColumn();
		MallMinuteCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() >1){
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return mallMinuteService.selectByExample(example);
	}
	

	@Override
	public List<? extends BaseModel> getHourData(List<Date> dates, List<Long> ids) {
		MallHourCountDataExample example = new MallHourCountDataExample();
		example.createColumns().hasMallIdColumn().hasAccountIdColumn().hasInnumColumn().hasOutnumColumn().hasCountdateColumn().hasCounttimeColumn().hasOutsideInnumColumn().hasOutsideOutnumColumn();
		MallHourCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() >1){
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return mallHourService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getDayData(List<Date> dates, List<Long> ids) {
		MallDayCountDataExample example = new MallDayCountDataExample();
		example.createColumns().hasMallIdColumn().hasAccountIdColumn().hasInnumColumn().hasOutnumColumn().hasCountdateColumn().hasCounttimeColumn().hasOutsideInnumColumn().hasOutsideOutnumColumn();
		MallDayCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() >1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return mallDayService.selectByExample(example);
	}


	@Override
	public List<? extends BaseModel> getDaysData(List<DateCriteria> dates, List<Long> ids) {
		MallDayCountDataExample example = new MallDayCountDataExample();
		example.createColumns().hasMallIdColumn().hasAccountIdColumn().hasInnumColumn().hasOutnumColumn().hasCountdateColumn().hasCounttimeColumn().hasOutsideInnumColumn().hasOutsideOutnumColumn();
		MallDayCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return mallDayService.selectByExample(example);
	}


	@Override
	public List<? extends BaseModel> getFaceDayData(List<Date> dates, List<Long> ids) {
		MallDayFaceRecognitionStaExample example = new MallDayFaceRecognitionStaExample();
		example.createColumns();
		MallDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return mallDayFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceHourData(List<Date> dates, List<Long> ids) {
		MallHourFaceRecognitionStaExample example = new MallHourFaceRecognitionStaExample();
		example.createColumns();
		MallHourFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCounttimeEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCounttimeIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return mallHourFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceDaysData(List<DateCriteria> dates, List<Long> ids) {
		MallDayFaceRecognitionStaExample example = new MallDayFaceRecognitionStaExample();
		example.createColumns();
		MallDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andMallIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andMallIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".countdate asc");
		return mallDayFaceRecognitionStaService.selectByExample(example);
	}

}
