package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.service.adapter.ZoneDayCountDataService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: ShoppingMall-parent
 * @description: 主力店铺同环比对比分析
 * @author: WJY
 * @create: 2019-01-25 15:45
 **/
@Service
public class MainZoneYOAnalysis extends ChartReportBaseService{

    //天级主力店铺同环比分析
    private static final String CHARTDAYYOANALYSIS = "dayMainZoneYOAnalysis";

    //周级主力店铺同环比对比分析
    private static final String CHARTWEEKYOANALYSIS = "weekMainZoneYOAnalysis";

    //月级主力店铺同环比分析
    private static final String CHARTMONTHYOANALYSIS = "monthMainZoneYOAnalysis";

    //年级主力店铺同环比分析
    private static final String CHARTYEARYOANALYSIS = "yearMainZoneYOAnalysis";

    @Resource
    private ZoneService zoneService;

    @Resource
    private ZoneDayCountDataService zoneDayCountDataService;

    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;
        List<Long> zoneIds = Arrays.asList(orgIds);
        String key = reportChart.getKey();
        switch(key){
            case CHARTDAYYOANALYSIS:
                chart = getDayMainYOAnalysis(zoneIds,startDate,endDate,dataMap,reportChart);
                break;
            case CHARTWEEKYOANALYSIS:
                chart = getWeekMainYOAnalysis(zoneIds,startDate,endDate,dataMap,reportChart);
                break;
            case CHARTMONTHYOANALYSIS:
                chart = getMonthMainYOAnalysis(zoneIds,startDate,endDate,dataMap,reportChart);
                break;
            case CHARTYEARYOANALYSIS:
                chart = getYearMainYOAnalysis(zoneIds,startDate,endDate,dataMap,reportChart);
                break;
                default:
                    break;
        }
        return chart;
    }

    /**
    * @Description: 主力店铺同环比分析日级表
    * @Param: [orgIds, startDate, endDate, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/28
    */ 
    private Chart getDayMainYOAnalysis(List<Long> orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
        Table table = new Table(reportChart.getTitle());
        List<Date> dateList = new ArrayList<>();
        Date yesterdayDay = DateUtil.getYesterday(startDate);
        Date lastWeekDay = DateUtil.getLastWeek(startDate);
        Date lastMonthDay = DateUtil.getLastMonth(startDate);
        Date lastYearDay = DateUtil.getLastYear(startDate);
        dateList.add(yesterdayDay);
        dateList.add(lastWeekDay);
        dateList.add(lastMonthDay);
        dateList.add(lastYearDay);
        dateList.add(startDate);
        ZoneDayCountDataExample zoneDayCountDataExample = new ZoneDayCountDataExample();
        zoneDayCountDataExample.createCriteria().andZoneIdIn(orgIds).andCountdateIn(dateList);
        zoneDayCountDataExample.createColumns().hasZoneIdColumn().hasInnumColumn().hasCountdateColumn();
        zoneDayCountDataExample.setOrderByClause("\"zoneDay\".zone_id asc,\"zoneDay\".countdate desc");
        List<ZoneDayCountData> zoneDayCountDataList = zoneDayCountDataService.selectByExample(zoneDayCountDataExample);
        String mainZone = LocalMessageUtil.getMessage("MAINZONE");
        String today = LocalMessageUtil.getMessage("DateType.today");
        String yesterday = LocalMessageUtil.getMessage("DateType.yesterday");
        String yesterdayYO = LocalMessageUtil.getMessage("ToY");
        String lastWeek = LocalMessageUtil.getMessage("DateType.lastWeekDay");
        String lastWeekYO = LocalMessageUtil.getMessage("ToWD");
        String lastMonth = LocalMessageUtil.getMessage("DateType.lastMonthDay");
        String lastMonthYO = LocalMessageUtil.getMessage("ToMD");
        String lastYear = LocalMessageUtil.getMessage("DateType.lastYearDay");
        String lastYearYO = LocalMessageUtil.getMessage("ToYD");
        TableHead tableHead = new TableHead();
        tableHead.addData(mainZone,today,yesterday,yesterdayYO,lastWeek,lastWeekYO,lastMonth,lastMonthYO,lastYear,lastYearYO);
        table.setTableHead(tableHead);
        Map<Long,String> zoneMap =zoneMap(orgIds);
        //ZoneDayCountData zoneData = zoneDayCountDataList.get(0);
        for(ZoneDayCountData zoneDayCountData : zoneDayCountDataList) {
            //zoneData = zoneDayCountData;
            Date countDate = zoneDayCountData.getCountdate();
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            table.getRow(zoneName).putValueByHeadColumn(mainZone, zoneName);
//            if (table.getRow(zoneName) == null) {
//                table.getRow(zoneName).putValueByHeadColumn(mainZone, zoneName);
//            }
            if (DateUtil.isSameDay(startDate, countDate)) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(today, innum);
                continue;
            }
            if (DateUtil.isYesterday(startDate, countDate)) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(yesterday, innum);
            }
            Number todayInnum = (Number) (table.getRow(zoneName).getValueByHeadColumn(today));
            Number yesterdayInnum = (Number) (table.getRow(zoneName).getValueByHeadColumn(yesterday));
            if (todayInnum != null && yesterdayInnum != null && table.getRow(zoneName).getValueByHeadColumn(yesterdayYO)== null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(yesterdayYO, NumberUtil.growthRate(todayInnum, yesterdayInnum));
                continue;
            }

            if (DateUtil.isLastWeekDay(startDate, countDate)) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastWeek, innum);
            }
            // Number todayInnum = (Number) (table.getRow(zoneName).getValueByHeadColumn(today));
            Number lastWeekInnum = (Number) (table.getRow(zoneName).getValueByHeadColumn(lastWeek));
            if (todayInnum != null && lastWeekInnum != null && table.getRow(zoneName).getValueByHeadColumn(lastWeekYO)== null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastWeekYO, NumberUtil.growthRate(todayInnum, lastWeekInnum));
                continue;
            }
            if (DateUtil.isLastMonthDay(startDate, countDate)) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastMonth, innum);
            }
            Number lastMonthInnum = (Number) (table.getRow(zoneName).getValueByHeadColumn(lastMonth));
            if (todayInnum != null && lastMonthInnum != null && table.getRow(zoneName).getValueByHeadColumn(lastMonthYO)== null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastMonthYO, NumberUtil.growthRate(todayInnum, lastMonthInnum));
                continue;
            }
            if (DateUtil.isLastYearDay(startDate, countDate)) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYear, innum);
            }
            Number lastYearInnum = (Number) (table.getRow(zoneName).getValueByHeadColumn(lastYear));
            if (todayInnum != null && lastYearInnum != null && table.getRow(zoneName).getValueByHeadColumn(lastYearYO)== null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYearYO, NumberUtil.growthRate(todayInnum, lastYearInnum));
            }
        }
        return table;
    }

    /**
    * @Description: 主力店铺同环比分析周级表
    * @Param: [orgIds, startDate, endDate, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/28
    */ 
    private Chart getWeekMainYOAnalysis(List<Long> orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
        Map<Long,String> zoneMap =zoneMap(orgIds);
        String mainZone = LocalMessageUtil.getMessage("MAINZONE");
        String week = LocalMessageUtil.getMessage("DateType.week");
        String lastWeek = LocalMessageUtil.getMessage("DateType.lastWeek");
        String lastWeekYO = LocalMessageUtil.getMessage("ToWD");
        String lastYear = LocalMessageUtil.getMessage("DateType.lastYearDay");
        String lastYearYO = LocalMessageUtil.getMessage("ToYD");
        Table table = new Table(reportChart.getTitle());
        TableHead tableHead = new TableHead();
        tableHead.addData(mainZone,week,lastWeek,lastWeekYO,lastYear,lastYearYO);
        table.setTableHead(tableHead);
        List<Date> thisWeekDates = DateUtil.getDaysOfWeek(startDate);
        List<Date> lastWeekDates = DateUtil.getDaysOfWeek(DateUtil.getLastWeek(startDate));
        List<Date> lastYearDates = DateUtil.getDaysOfWeek(DateUtil.getLastYear(startDate));
        //查询本周数据
        ZoneDayCountDataExample zoneDayCountDataExample = new ZoneDayCountDataExample();
        zoneDayCountDataExample.createCriteria().andCountdateIn(thisWeekDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> thisWeekData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample);
        //查询上周数据
        ZoneDayCountDataExample zoneDayCountDataExample1 = new ZoneDayCountDataExample();
        zoneDayCountDataExample1.createCriteria().andCountdateIn(lastWeekDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample1.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample1.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample1.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> lastWeekData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample1);
        //查询去年同周数据
        ZoneDayCountDataExample zoneDayCountDataExample2 = new ZoneDayCountDataExample();
        zoneDayCountDataExample2.createCriteria().andCountdateIn(lastYearDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample2.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample2.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample2.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> lastYearData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample2);

        for(ZoneDayCountData zoneDayCountData : thisWeekData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone,zoneName);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(week,innum);
        }

        for(ZoneDayCountData zoneDayCountData : lastWeekData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            if(table.getRow(zoneName).getValueByHeadColumn(mainZone) == null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone, zoneName);
            }
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastWeek,innum);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastWeekYO,NumberUtil.growthRate((Number) (table.getRow(zoneName).getValueByHeadColumn(week)),(Number)(table.getRow(zoneName).getValueByHeadColumn(lastWeek))));
        }

        for(ZoneDayCountData zoneDayCountData : lastYearData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            if(table.getRow(zoneName).getValueByHeadColumn(mainZone) == null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone, zoneName);
            }
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYear,innum);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYearYO,NumberUtil.growthRate((Number) (table.getRow(zoneName).getValueByHeadColumn(week)),(Number)(table.getRow(zoneName).getValueByHeadColumn(lastYear))));
        }

        return table;
}

    /**
    * @Description: 主力店铺同环比分析月级表
    * @Param: [orgIds, startDate, endDate, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/28
    */ 
    private Chart getMonthMainYOAnalysis(List<Long> orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
        Map<Long,String> zoneMap =zoneMap(orgIds);
        String mainZone = LocalMessageUtil.getMessage("MAINZONE");
        String month = LocalMessageUtil.getMessage("THISMONTH");
        String lastMonth = LocalMessageUtil.getMessage("LASTMONTH");
        String lastWeekYO = LocalMessageUtil.getMessage("ToWD");
        String lastYear = LocalMessageUtil.getMessage("DateType.lastYearDay");
        String lastYearYO = LocalMessageUtil.getMessage("ToYD");
        Table table = new Table(reportChart.getTitle());
        TableHead tableHead = new TableHead();
        tableHead.addData(mainZone,month,lastMonth,lastWeekYO,lastYear,lastYearYO);
        table.setTableHead(tableHead);
        List<Date> thisMonthDates = DateUtil.getMonthDyas(startDate);
        List<Date> lastMonthDates = DateUtil.getMonthDyas(DateUtil.getLastMonth(startDate));
        List<Date> lastYearDates = DateUtil.getMonthDyas(DateUtil.getLastYear(startDate));
        //查询本月数据
        ZoneDayCountDataExample zoneDayCountDataExample = new ZoneDayCountDataExample();
        zoneDayCountDataExample.createCriteria().andCountdateIn(thisMonthDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> thisMonthData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample);
        //查询上月数据
        ZoneDayCountDataExample zoneDayCountDataExample1 = new ZoneDayCountDataExample();
        zoneDayCountDataExample1.createCriteria().andCountdateIn(lastMonthDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample1.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample1.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample1.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> lastMonthData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample1);
        //查询去年同月数据
        ZoneDayCountDataExample zoneDayCountDataExample2 = new ZoneDayCountDataExample();
        zoneDayCountDataExample2.createCriteria().andCountdateIn(lastYearDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample2.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample2.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample2.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> lastYearData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample2);

        for(ZoneDayCountData zoneDayCountData : thisMonthData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone,zoneName);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(month,innum);
        }

        for(ZoneDayCountData zoneDayCountData : lastMonthData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            if(table.getRow(zoneName).getValueByHeadColumn(mainZone) == null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone, zoneName);
            }
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastMonth,innum);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastWeekYO,NumberUtil.growthRate((Number) (table.getRow(zoneName).getValueByHeadColumn(month)),(Number)(table.getRow(zoneName).getValueByHeadColumn(lastMonth))));
        }

        for(ZoneDayCountData zoneDayCountData : lastYearData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            if(table.getRow(zoneName).getValueByHeadColumn(mainZone) == null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone, zoneName);
            }
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYear,innum);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYearYO,NumberUtil.growthRate((Number) (table.getRow(zoneName).getValueByHeadColumn(month)),(Number)(table.getRow(zoneName).getValueByHeadColumn(lastYear))));
        }
        return table;
    }

    /**
    * @Description: 主力店铺同环比分析年级表
    * @Param: [orgIds, startDate, endDate, dataMap, reportChart]
    * @return: com.viontech.keliu.chart.Chart
    * @Date: 2019/1/28
    */ 
    private Chart getYearMainYOAnalysis(List<Long> orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
        Map<Long,String> zoneMap =zoneMap(orgIds);
        String mainZone = LocalMessageUtil.getMessage("MAINZONE");
        String year = LocalMessageUtil.getMessage("THISYEAR");
        String lastYear = LocalMessageUtil.getMessage("DateType.lastYear");
        String lastYearYO = LocalMessageUtil.getMessage("YoLY");
        Table table = new Table(reportChart.getTitle());
        TableHead tableHead = new TableHead();
        tableHead.addData(mainZone,year,lastYear,lastYearYO);
        table.setTableHead(tableHead);
        List<Date> thisDates = DateUtil.getDaysBetweenDates(DateUtil.getFirstDateOfYear(startDate),DateUtil.getLastDateOfYear(startDate));
        List<Date> lastYearDates = DateUtil.getDaysBetweenDates(DateUtil.getFirstDateOfYear(DateUtil.getLastYear(startDate)),DateUtil.getLastDateOfYear(DateUtil.getLastYear(startDate)));
        //List<Date> lastYearDates = DateUtil.getMonthDyas(DateUtil.getLastYear(startDate));
        //查询本周数据
        ZoneDayCountDataExample zoneDayCountDataExample = new ZoneDayCountDataExample();
        zoneDayCountDataExample.createCriteria().andCountdateIn(thisDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> thisYearData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample);

        //查询去年同周数据
        ZoneDayCountDataExample zoneDayCountDataExample2 = new ZoneDayCountDataExample();
        zoneDayCountDataExample2.createCriteria().andCountdateIn(lastYearDates).andZoneIdIn(orgIds);
        zoneDayCountDataExample2.createColumns().hasZoneIdColumn().addColumnStr("sum(innum) as zoneDay_innum");
        zoneDayCountDataExample2.setGroupByClause("\"zoneDay\".zone_id");
        zoneDayCountDataExample2.setOrderByClause("\"zoneDay\".zone_id");
        List<ZoneDayCountData> lastYearData = zoneDayCountDataService.selectByExample(zoneDayCountDataExample2);

        for(ZoneDayCountData zoneDayCountData : thisYearData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone,zoneName);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(year,innum);
        }
        

        for(ZoneDayCountData zoneDayCountData : lastYearData){
            Long zoneId = zoneDayCountData.getZoneId();
            String zoneName = zoneMap.get(zoneId);
            Integer innum = zoneDayCountData.getInnum();
            if(table.getRow(zoneName).getValueByHeadColumn(mainZone) == null) {
                table.getRow(zoneName).adjustOrPutValueByHeadColumn(mainZone, zoneName);
            }
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYear,innum);
            table.getRow(zoneName).adjustOrPutValueByHeadColumn(lastYearYO,NumberUtil.growthRate((Number) (table.getRow(zoneName).getValueByHeadColumn(year)),(Number)(table.getRow(zoneName).getValueByHeadColumn(lastYear))));
        }

        return table;
    }

    /**
    * @Description: 得到zone的Map对象
    * @Param: [orgIds]
    * @return: java.util.Map<java.lang.Long,java.lang.String>
    * @Date: 2019/1/25
    */ 
    private Map<Long,String> zoneMap(List<Long> orgIds){
        Map<Long,String> zoneMap = new HashMap<>();
        ZoneExample zoneExample = new ZoneExample();
        zoneExample.createCriteria().andIdIn(orgIds);
        zoneExample.createColumns().hasIdColumn().hasNameColumn();
        List<Zone> zones =zoneService.selectByExample(zoneExample);
        zoneMap = zones.stream().collect(Collectors.toMap(Zone::getId,Zone::getName));
        return zoneMap;
    }
}
