package com.viontech.mall.report.service.impl;


import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.report.util.EventReportUtil;
import com.viontech.mall.service.adapter.EventService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 同节日对象对比分析
 * @author dugw
 *
 */
@Service
public class HolidayObjectReportServiceImpl extends ChartReportBaseService {

	@Resource
	private MallReportDataService mallReportDataService;

	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private GateReportDataService gateReportDataService;
		
	@Resource
	private EventService eventService;
	@Resource
	private EventReportUtil eventReportUtil;
	
	/**活动近期对比*/
	public static final String REPORT_HOLIDAY_NEAR ="HolidayNear";
	/**活动效果对比*/
	public static final String REPORT_HOLIDAY_EFFECT ="HolidayEffect";
	/**活动当日时刻对比*/
	public static final String REPORT_HOLIDAY_HOUR_DETAIL ="HolidayHourDetail";
	
	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		//获取节假日、活动对象
		String eventId = (String) dataMap.get("holidayEventId");
		Long id = Long.parseLong(eventId.trim());
		
		Event event =eventService.selectByPrimaryKey(id);
		if(event == null)
			return null;
		
		dataMap.put("arg_event", event);
		dataMap.put("year", event.getEventDate());
		dataMap.put("mallId", event.getMallId());
		Date eventDate = event.getEventDate();
		
		//确定数据的开始，结束时间（元旦要特殊处理）
		Date newYearDay = DateUtil.getFirstDateOfYear(eventDate);
		if( DateUtil.isSameDay(eventDate, newYearDay)){
			startDate = DateUtil.addYears(newYearDay, -1);
		}else{
			startDate = newYearDay;
		}
		if(event.getEndDate() == null){
			event.setEndDate(startDate);
		}
		endDate =DateUtil.addDays(event.getEndDate(), 5);
		
		//获取时间内的天级数据
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		List<?> datas = new ArrayList();
		List<DataVo> dayData = new ArrayList<DataVo>();
		List<DataVo> hourData = new ArrayList<DataVo>();
		DateCriteria mallOpentimes  = new DateCriteria();
		if (orgType == OrgType.gate) {
			List<GateDayCountData> dayTraffic = gateReportDataService.getOrQueryGateBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dayData = gateReportDataService.convert2Data(dayTraffic);
			List<GateHourCountData> HourTraffic = gateReportDataService.getOrQueryGateHourData(orgIds, eventDate,eventDate, dataMap);
			hourData = gateReportDataService.convert2Data(HourTraffic);
			mallOpentimes= gateReportDataService.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("arg_mallOpenTime", mallOpentimes);
		}else if (orgType == OrgType.zone) {
			if(kpiType == KPIType.SALES){
				datas = zoneReportDataService.getOrQueryZoneBetweenDateSale(orgIds, startDate, endDate, dataMap);
			}else{
				datas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			}
			dayData = zoneReportDataService.convert2Data(datas);
			List<ZoneHourCountData> hourTraffic = zoneReportDataService.getOrQueryZoneBetweenDateHourTraffic(orgIds,eventDate,eventDate, dataMap);
			hourData = zoneReportDataService.convert2Data(hourTraffic);
			mallOpentimes= zoneReportDataService.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("arg_mallOpenTime", mallOpentimes);
		}else if (orgType == OrgType.floor) {
			if(kpiType == KPIType.SALES){
				datas = floorReportDataService.getOrQueryFloorBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			}else{
				datas = floorReportDataService.getOrQueryFloorBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			}
			dayData = floorReportDataService.convert2Data(datas);
			List<FloorHourCountData> hourTraffic = floorReportDataService.getOrQueryFloorBetweenDateHourTraffic(orgIds, startDate, endDate, dataMap);
			hourData = floorReportDataService.convert2Data(hourTraffic);
			mallOpentimes= floorReportDataService.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("arg_mallOpenTime", mallOpentimes);
		}else if (orgType == OrgType.mall) {
			if(kpiType == KPIType.SALES){
				datas = mallReportDataService.getOrQueryMallBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			}else{
				datas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			}
			dayData = mallReportDataService.convert2Data(datas);
			List<MallHourCountData> hourTraffic = mallReportDataService.getOrQueryMallBetweenDateHourTraffic(orgIds, startDate, endDate, dataMap);
			hourData = mallReportDataService.convert2Data(hourTraffic);
			mallOpentimes= mallReportDataService.getMallOpentimesByOrgId(orgIds[0], orgType, dataMap);
			dataMap.put("arg_mallOpenTime", mallOpentimes);
		}
		Chart chart = null;
		switch (reportChart.getKey()) {
			case REPORT_HOLIDAY_NEAR:
				chart = holidayNear5DayReport(dayData, dataMap, reportChart);
				break;
			case REPORT_HOLIDAY_EFFECT:
				chart = holidayEffectReport(dayData, dataMap, reportChart);
				break;
			case REPORT_HOLIDAY_HOUR_DETAIL:
				chart = holidayDetailReport(hourData, dataMap, reportChart);
				break;
			default:
				break;
		}
		
		return chart;
	}
	/**
	 * 活动当日时刻对比
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart holidayDetailReport(List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		
		Axis<Date> xAxis = AxisFactory.createHourOfDayAxis();
		//商场的营业时间
		DateCriteria mallOpentimes = (DateCriteria) dataMap.get("arg_mallOpenTime");
		xAxis.setMin(mallOpentimes.getStartDate());
		xAxis.setMax(mallOpentimes.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);

		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		for (DataVo dataVo : dataVos) {
			Date dataDate = dataVo.getTime();
			String seriesName = getSeriesName(dataVo, dataMap);
			Number result = getKpiResult(dataVo, dataVos, dataMap, kpiType);
			chart.getSeries(seriesName).putValueByCoordinate(dataDate, result);
		}
		return chart;
	}

	/**
	 * 活动效果对比
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart holidayEffectReport(List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		KPIType kpi = (KPIType) dataMap.get("KPITYPE");
		String avgNum = LocalMessageUtil.getMessage("Holiday.avgData", new Object[]{kpi.getName()});
		String avgWeekdayData = LocalMessageUtil.getMessage("Holiday.avgWeekdayData", new Object[]{kpi.getName()});
		String avgWeekendData = LocalMessageUtil.getMessage("Holiday.avgWeekendData", new Object[]{kpi.getName()});
		
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		
		Axis<String> xAxis =AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		
		//对日期数据进行分类
		Map<String,List<Date>> sortDateMap = eventReportUtil.getClassifyByDate(dataMap);
		Event event = (Event) dataMap.get("arg_event");
		String key =DateUtil.format(DateUtil.FORMAT_SHORT,event.getEventDate()); 
		List<Date> holidayDates = sortDateMap.get(key+"#holiday");
		List<Date> weekdayDates = sortDateMap.get(key+"#weekday");
		List<Date> weekendDates = sortDateMap.get(key+"#weekend");
		
		for (DataVo dataVo : dataVos) {
			Date dataDate = dataVo.getDate();
			String seriesName = getSeriesName(dataVo, dataMap);
			if (holidayDates.contains(dataDate)) {
				Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
				//System.out.println("节假日  \t"+result +"\t"+dataDate);
				chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgNum, result);
				chart.getSeries(seriesName).setCalcTypeByCoordinate(avgNum,  Series.CALC_TYPE_AVG);
			} else if (weekdayDates.contains(dataDate)) {
				Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
				//System.out.println("工作日  \t"+result +"\t"+dataDate);
				chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgWeekdayData, result);
				chart.getSeries(seriesName).setCalcTypeByCoordinate(avgWeekdayData,  Series.CALC_TYPE_AVG);
			} else if (weekendDates.contains(dataDate)) {
				Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
				//System.out.println("周末  \t"+result +"\t"+dataDate);
				chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgWeekendData, result);
				chart.getSeries(seriesName).setCalcTypeByCoordinate(avgWeekendData,  Series.CALC_TYPE_AVG);
			}
		}
		
		return chart;
	}
	
	/**
	 * 活动近期对比（前后5天）
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart holidayNear5DayReport(List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		
		Event event = (Event) dataMap.get("arg_event");
		Date startDate = DateUtil.addDays(event.getStartDate(), -5);
		Date endDate = DateUtil.addDays(event.getEndDate(), 5);
		// 指定需要数据的时间段
		List<Date> containDate = DateUtil.getDaysBetweenDates(startDate, endDate);
		
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
		chart.setXAxis(xAxis);
		
		KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
		for (DataVo dataVo : dataVos) {
			Date dataDate = dataVo.getDate();
			if(!containDate.contains(dataDate)){
				continue;
			}
			String seriesName = getSeriesName(dataVo, dataMap);
			Number result = getKpiResult(dataVo, dataVos, dataMap, kpiType);
			chart.getSeries(seriesName).putValueByCoordinate(dataDate, result);
		}
		return chart;
	}
	


	/**
	 * 根据组织机构类型，获取序列的名称
	 * @param dataVo
	 * @param dataMap
	 * @return
	 */
	private String getSeriesName(DataVo dataVo, Map<String, Object> dataMap){
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		String SeriesName = "";
		if (orgType == OrgType.gate) {
			Gate gate = gateReportDataService.getGateInfoById(dataVo.getGateId(), dataMap);
			SeriesName = gate.getName();
		}else if (orgType == OrgType.zone) {
			Zone zone = zoneReportDataService.getOrQueryZoneById(dataVo.getZoneId(), dataMap);
			SeriesName = zone.getName();
		}else if (orgType == OrgType.floor) {
			Floor floor = floorReportDataService.getFloorInfoById(dataVo.getFloorId(), dataMap);
			SeriesName = floor.getName();
		}else if (orgType == OrgType.mall) {
			Mall mall = mallReportDataService.getMallByMallId(dataVo.getMallId(), dataMap);
			SeriesName = mall.getName();
		}
		return SeriesName;
	}
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
