package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Series;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import com.viontech.mall.report.util.EventReportUtil;
import com.viontech.mall.service.adapter.FloorService;
import com.viontech.mall.service.adapter.GateService;
import com.viontech.mall.service.adapter.MallService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

/**
 * 节假日活动对比分析
 * @author dugw
 *
 */
@Service
public class HolidayEventReportServiceImpl extends ChartReportBaseService {
	
	@Resource
	private GateReportDataService gateReportDataService;
	@Resource
	private ZoneReportDataService zoneReportDataService;
	@Resource
	private FloorReportDataService floorReportDataService;
	@Resource
	private MallReportDataService mallReportDataService;
	
	@Resource
	private GateService gateService;
	@Resource
	private ZoneService zoneService;
	@Resource
	private FloorService floorService;
	@Resource
	private MallService mallService;
	@Resource
	private EventReportUtil eventReportUtil;
	
	/**节假日活动*/
	public static final String REPORT_HOLIDAY_EVENT ="HolidayEvent";
	/**节假日活动效果*/
	public static final String REPORT_HOLIDAY_EFFECT ="HolidayEffect";
	/**节假日增长率详情*/
	public static final String REPORT_HOLIDAY_DETAIL ="HolidayDetail";
	

	
	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		//计算数据的日期的起始、结束时间
		Date year = startDate;
		dataMap.put("year", year);//方法map中避免方法见同一个数据相互传参
		
		startDate = DateUtil.getFirstDateOfYear(DateUtil.addYears(startDate, -1));
		//日期数据是今年，截止日期到今天；日期数据是往年，截止日期到该年最后一天
		if(DateUtil.getYear(year) == DateUtil.getYear(new Date())){
			endDate = new Date();
		}else{
			endDate = DateUtil.getLastDateOfYear(year);
		}
		
		//获取数据
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		KPIType KpiType = (KPIType) dataMap.get("KPITYPE");
		
		List<?> datas = new ArrayList();
		List<DataVo>  dataVos = new ArrayList<DataVo>();
		if(orgType==OrgType.gate){
			Gate gate = gateService.selectByPrimaryKey(orgIds[0]);
			dataMap.put("mallId", gate.getMallId());
			datas = gateReportDataService.getOrQueryGateBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			dataVos = gateReportDataService.convert2Data(datas);
		}else if(orgType == OrgType.zone){
			Zone zone = zoneService.selectByPrimaryKey(orgIds[0]);
			dataMap.put("mallId", zone.getMallId());
			if(KpiType == KPIType.SALES){
				datas = zoneReportDataService.getOrQueryZoneBetweenDateSale(orgIds, startDate, endDate, dataMap);
			}else{
				datas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			}
			dataVos = zoneReportDataService.convert2Data(datas);
		}else if(orgType == OrgType.floor){
			Floor floor = floorService.selectByPrimaryKey(orgIds[0]);
			dataMap.put("mallId", floor.getMallId());
			if(KpiType == KPIType.SALES){
				datas = floorReportDataService.getOrQueryFloorBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			}else{
				datas = floorReportDataService.getOrQueryFloorBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			}
			dataVos = floorReportDataService.convert2Data(datas);
		}else if(orgType == OrgType.mall){
			dataMap.put("mallId", orgIds[0]);
			if(KpiType == KPIType.SALES){
				datas = mallReportDataService.getOrQueryMallBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			}else{
				datas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			}
			dataVos = mallReportDataService.convert2Data(datas);
		}
		
		Chart<?> chart = null;
		switch (reportChart.getKey()) {
		case REPORT_HOLIDAY_EVENT:
			chart = holidayEventRoport(dataVos, dataMap, reportChart);
			break;
		case REPORT_HOLIDAY_EFFECT:
			chart = holidayEventEffect(dataVos, dataMap, reportChart);
			break;
		case REPORT_HOLIDAY_DETAIL:
			chart = holidayEventEffectDetail(dataVos, dataMap, reportChart);
		    break;

		default:
			break;
		}
		
		return chart;
	}
	
	/**
	 * 节假日活动效果
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart holidayEventEffect(List<DataVo> dataVos, Map<String, Object> dataMap,ReportChart reportChart){
		KPIType kpi = (KPIType) dataMap.get("KPITYPE");
		
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis =AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		
		//节假日数据
		List<Event> holidays = eventReportUtil.getOrQueryHolidayAndEvent(dataMap);
		if(holidays == null){
			return chart;
		}
		//对日期数据进行分类
		Map<String,List<Date>> sortDateMap = eventReportUtil.getClassifyByDate(dataMap);
		
		String avgNum = LocalMessageUtil.getMessage("Holiday.avgData", new Object[]{kpi.getName()});
		String avgWeekdayData = LocalMessageUtil.getMessage("Holiday.avgWeekdayData", new Object[]{kpi.getName()});
		String avgWeekendData = LocalMessageUtil.getMessage("Holiday.avgWeekendData", new Object[]{kpi.getName()});
		
		for (Event holidayEvent : holidays) {
			String key = DateUtil.format(DateUtil.FORMAT_SHORT, holidayEvent.getEventDate());
			List<Date> holidayDates = sortDateMap.get(key + "#holiday");
			List<Date> weekdayDates = sortDateMap.get(key + "#weekday");
			List<Date> weekendDates = sortDateMap.get(key + "#weekend");
			
			String seriesName = holidayEvent.getName();
			
			for (DataVo dataVo : dataVos) {
				Date dataDate = dataVo.getDate();
				if (holidayDates.contains(dataDate)) {
					Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
					chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgNum, result);
					chart.getSeries(seriesName).setCalcTypeByCoordinate(avgNum,  Series.CALC_TYPE_AVG);
				} else if (weekdayDates.contains(dataDate)) {
					Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
					chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgWeekdayData, result);
					chart.getSeries(seriesName).setCalcTypeByCoordinate(avgWeekdayData,  Series.CALC_TYPE_AVG);
				} else if (weekendDates.contains(dataDate)) {
					Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
					chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgWeekendData, result);
					chart.getSeries(seriesName).setCalcTypeByCoordinate(avgWeekendData,  Series.CALC_TYPE_AVG);
				}
			}
			//初始化，防止没有数据无法创建x轴的bug
			List rawData = chart.getSeries(seriesName).getRawData();
			if(rawData.size() == 0){
				chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgNum,0);
				chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgWeekdayData,0);
				chart.getSeries(seriesName).adjustOrPutValueByCoordinate(avgWeekendData,0);
			}
		}
		return chart;
	}
	
	/**
	 * 节假日增长率详情
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart holidayEventEffectDetail(List<DataVo> dataVos, Map<String, Object> dataMap,ReportChart reportChart){
		KPIType kpi = (KPIType) dataMap.get("KPITYPE");
		final String name = LocalMessageUtil.getMessage("Holiday.name");
		final String avgNum = LocalMessageUtil.getMessage("Holiday.avgData",new Object[]{kpi.getName()});
		final String avgWeekdayData = LocalMessageUtil.getMessage("Holiday.avgWeekdayData",new Object[]{kpi.getName()});
		final String avgWeekendData = LocalMessageUtil.getMessage("Holiday.avgWeekendData",new Object[]{kpi.getName()});
		final String compareWeekdayRate = LocalMessageUtil.getMessage("Holiday.compareWeekdayRate");
		final String compareWeekendRate = LocalMessageUtil.getMessage("Holiday.compareWeekendRate");
		
		Table table = new Table(reportChart.getTitle(), SeriesType.table){
			@Override
			public Object calcValue(String name, int index, List data_raw) {
				int compareWeekdayRate_index = getIndexByTableHead(compareWeekdayRate); 
				int compareWeekendRate_index = getIndexByTableHead(compareWeekendRate); 
				int avgNum_index = getIndexByTableHead(avgNum);
				if(index == compareWeekdayRate_index){
					int avgWeekdayData_index = getIndexByTableHead(avgWeekdayData);
					Number avgNum = (Number) data_raw.get(avgNum_index);
					Number avgWeekdayData = (Number) data_raw.get(avgWeekdayData_index);
					return NumberUtil.growthRate(avgNum, avgWeekdayData);
				}else if(index == compareWeekendRate_index){
					int avgWeekendData_index = getIndexByTableHead(avgWeekendData);
					Number avgNum = (Number) data_raw.get(avgNum_index);
					Number avgWeekendData = (Number) data_raw.get(avgWeekendData_index);
					return NumberUtil.growthRate(avgNum, avgWeekendData);
				}
				return super.calcValue(name, index, data_raw);
			}
			
		};
		//表头
		TableHead tableHead = new TableHead();
		tableHead.addData(name);
		tableHead.addData(avgNum);		
		tableHead.addData(avgWeekdayData);		
		tableHead.addData(avgWeekendData);		
		tableHead.addData(compareWeekdayRate);		
		tableHead.addData(compareWeekendRate);	
		table.setTableHead(tableHead);
		
		//节假日数据
		List<Event> holidays = eventReportUtil.getOrQueryHolidayAndEvent(dataMap);
		if(holidays == null){
			return table;
		}
		//对日期进行分类处理
		Map<String,List<Date>> sortDateMap = eventReportUtil.getClassifyByDate(dataMap);
		
		for (Event holidayEvent : holidays) {
			String rowName = DateUtil.format(DateUtil.FORMAT_SHORT, holidayEvent.getEventDate());
			List<Date> holidayDates = sortDateMap.get(rowName + "#holiday");
			List<Date> weekdayDates = sortDateMap.get(rowName + "#weekday");
			List<Date> weekendDates = sortDateMap.get(rowName + "#weekend");
			
			table.getRow(rowName).putValueByHeadColumn(name, holidayEvent.getName());
			for (DataVo dataVo : dataVos) {
				Date dataDate = dataVo.getDate();
				if (holidayDates.contains(dataDate)) {
					Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
					/*if("5周年店庆".equals(holidayEvent.getName())){
						System.out.println("节假日  \t"+result +"\t"+dataDate);
					}*/
					table.getRow(rowName).adjustOrPutValueByHeadColumn(avgNum, result);
					table.getRow(rowName).setCalcTypeByHeadColumn(avgNum, Series.CALC_TYPE_AVG);
				} else if (weekendDates.contains(dataDate)) {
					Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
					/*if("5周年店庆".equals(holidayEvent.getName())){
						System.out.println("周末  \t"+result +"\t"+dataDate);
					}*/
					table.getRow(rowName).adjustOrPutValueByHeadColumn(avgWeekendData, result);
					table.getRow(rowName).setCalcTypeByHeadColumn(avgWeekendData, Series.CALC_TYPE_AVG);
				}else if (weekdayDates.contains(dataDate)) {
					Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
					/*if("5周年店庆".equals(holidayEvent.getName())){
						System.out.println("工作日  \t"+result +"\t"+dataDate);
					}*/
					table.getRow(rowName).adjustOrPutValueByHeadColumn(avgWeekdayData, result);
					table.getRow(rowName).setCalcTypeByHeadColumn(avgWeekdayData, Series.CALC_TYPE_AVG);
				} 
			}
		}
		return table;
	}
	
	/**
	 * 节假日活动
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart holidayEventRoport(List<DataVo> dataVos, Map<String, Object> dataMap,ReportChart reportChart){
		KPIType kpi = (KPIType) dataMap.get("KPITYPE");
		final String name = LocalMessageUtil.getMessage("Holiday.name");
		final String startDate = LocalMessageUtil.getMessage("Holiday.startDate");
		final String endDate = LocalMessageUtil.getMessage("Holiday.endDate");
		final String duration = LocalMessageUtil.getMessage("Holiday.duration");
		final String currentNum = LocalMessageUtil.getMessage("Holiday.currentNum");
		final String avgNum = LocalMessageUtil.getMessage("Holiday.avgData",new Object[]{kpi.getName()});
		
		Table table = new Table(reportChart.getTitle(), SeriesType.table);
		//表头
		TableHead tableHead = new TableHead();
		tableHead.addData(name);
		tableHead.addData(startDate);
		tableHead.addData(endDate);
		tableHead.addData(duration);
		tableHead.addData(currentNum);
		tableHead.addData(avgNum);
		table.setTableHead(tableHead);
		
		//节假日数据
		List<Event> holidayHolidays =  eventReportUtil.getOrQueryHolidayAndEvent(dataMap);
		if(holidayHolidays == null)
				return table;
		
		Map<Date,List<Date>> argMap = new HashMap<Date,List<Date>>();
		for (Event holidayEvent : holidayHolidays) {
			String rowName =DateUtil.format(DateUtil.FORMAT_SHORT,holidayEvent.getEventDate()); 
			table.getRow(rowName).putValueByHeadColumn(name, holidayEvent.getName());
			Date date_start = holidayEvent.getStartDate();
			Date date_end = holidayEvent.getEndDate();
			table.getRow(rowName).putValueByHeadColumn(startDate, DateUtil.format(DateUtil.FORMAT_MM_DD,date_start));
			table.getRow(rowName).putValueByHeadColumn(endDate, DateUtil.format(DateUtil.FORMAT_MM_DD,date_end));
			List<Date> dates = DateUtil.getDaysBetweenDates(date_start, date_end);
			table.getRow(rowName).putValueByHeadColumn(duration, dates.size());
			//把有用的参数临时存储
			argMap.put(holidayEvent.getEventDate(),dates);
		}
		
		//节假日和活动的所有日期		
		Set<Date> holidaySet = eventReportUtil.getHolidayContainDate(holidayHolidays, dataMap);
		for (DataVo dataVo : dataVos) {
			Date dataDate = dataVo.getDate();
			//数据不在节假日日期中，排除
			if(!holidaySet.contains(dataDate)){
				continue;
			}
			for (Entry<Date, List<Date>> entry : argMap.entrySet()) {
				List<Date> containDates = entry.getValue();
				//数据不在当前节日的日期范围内
				if(!containDates.contains(dataDate)){
					continue;
				}
				Date holiday = entry.getKey();
				String rowName =DateUtil.format(DateUtil.FORMAT_SHORT,holiday); 
				Number result = getKpiResult(dataVo, dataVos, dataMap, kpi);
				if(DateUtil.isSameDay(dataDate, holiday)){
					table.getRow(rowName).putValueByHeadColumn(currentNum, result);
				}
				table.getRow(rowName).setCalcTypeByHeadColumn(avgNum, Series.CALC_TYPE_AVG);
				table.getRow(rowName).adjustOrPutValueByHeadColumn(avgNum, result);
			}
		}
		return table;
	}
	
	
		
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
