package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.service.adapter.ChannelService;
import com.viontech.mall.service.adapter.GateRetentionService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class HeatmapTrafficChartServiceImpl extends ChartReportBaseService {

    @Resource
    private GateRetentionService gateRetentionService;

    @Resource
    private ChannelService channelService;

    /**
     * 店内热力实时客流
     */
    private final String HEATMAPTRAFFIC = "heatmapTraffic";


    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;

        //首先先获取数据
        GateRetentionExample gateRetentionExample = new GateRetentionExample();
        GateRetentionExample.Criteria criteria = gateRetentionExample.createCriteria();
        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
        List<Long> orgIdList = Arrays.asList(orgIds);
        if(orgType == OrgType.gate){
            if (orgIds.length == 1)
                criteria.andGateIdEqualTo(orgIds[0]);
            else
                criteria.andGateIdIn(orgIdList);
        }else if(orgType == OrgType.mall){
            criteria.andMallIdEqualTo(orgIds[0]);
        }
        if (DateUtil.isSameDay(startDate,endDate))
            criteria.andCountdateEqualTo(startDate);
        else
            criteria.andCountdateGreaterThanOrEqualTo(startDate).andCountdateLessThanOrEqualTo(endDate);
        gateRetentionExample.setOrderByClause("counttime");
        List<GateRetention> gateRetentions = gateRetentionService.selectByExample(gateRetentionExample);

        //获取店铺内的热力监控点
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria channel_criteria = channelExample.createCriteria();
        if(orgType == OrgType.gate){
            channel_criteria.andGateIdIn(orgIdList);
        }else if(orgType == OrgType.mall){
            channel_criteria.andMallIdIn(orgIdList);
        }
        channel_criteria.andStatusEqualTo((short) 1).andTypeEqualTo((short) 3);
        List<Channel> channels = channelService.selectByExample(channelExample);
        if (channels == null || channels.size() <= 0)
            return chart;


        //创建报表
        String key = reportChart.getKey();
        Object chartOption = dataMap.get("chartOption");
        if(HEATMAPTRAFFIC.equals(key)){
            if (OptionsContain.TAB_TABLE.equals(chartOption))
                chart = heatMapTrafficTable(gateRetentions,channels,dataMap,reportChart);
            else if (OptionsContain.TAB_CHART.equals(chartOption))
                chart = heatMapTrafficChart(gateRetentions,channels,dataMap,reportChart);
        }
        return chart;
    }


    private Chart heatMapTrafficChart(List<GateRetention> gateRetentions,List<Channel> channels, Map<String, Object> dataMap, ReportChart reportChart){
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);

        //营业时间
       /* BaseDataServiceImpl.DateCriteria mallOpenTime = getMallOpenTime(dataMap, OrgType.mall, channels.get(0).getMallId());
        Date startDate = mallOpenTime.getStartDate();
        Date endDate = mallOpenTime.getEndDate();*/
       if (gateRetentions == null || gateRetentions.size() <= 0)
           return  chart;

        Date startDate = gateRetentions.get(0).getCounttime();
        Date endDate = gateRetentions.get(gateRetentions.size()-1).getCounttime();

        Axis axis = AxisFactory.creatSdfDateAxix(DateUtil.FORMAT_HHMMSS,Calendar.SECOND);
        axis.setMin(startDate);
        axis.setMax(endDate);
        axis.setScale(10);
        axis.lockMinMax();
        chart.setXAxis(axis);

        for (Channel channel : channels) {
            Long gateId = channel.getGateId();
            String gateName = getOrgNameById(gateId, OrgType.gate, dataMap);
            chart.createSeries(gateName);
        }

        for (GateRetention gateRetention : gateRetentions) {
            Date counttime = gateRetention.getCounttime();
            Long gateId = gateRetention.getGateId();
            String gateName = getOrgNameById(gateId, OrgType.gate, dataMap);
            chart.getSeries(gateName).putValueByCoordinate(counttime,gateRetention.getNum());
        }
        return chart;
    }

    private Chart heatMapTrafficTable(List<GateRetention> gateRetentions,List<Channel> channels, Map<String, Object> dataMap, ReportChart reportChart){
        Chart table = new Table(reportChart.getTitle());

        //设置表头
        TableHead tableHead = new TableHead();
        String time_tableHead = LocalMessageUtil.getMessage("DateMessage.time");
        tableHead.addHeadColumn(time_tableHead);
        if (channels == null || channels.size() <= 0)
            return table;
        for (Channel channel : channels) {
            Long gateId = channel.getGateId();
            String orgName = getOrgNameById(gateId,OrgType.gate, dataMap);
            tableHead.addHeadColumn(orgName);
        }
        ((Table) table).setTableHead(tableHead);

        //营业时间
        /*BaseDataServiceImpl.DateCriteria mallOpenTime = getMallOpenTime(dataMap, OrgType.mall, channels.get(0).getMallId());
        Date startDate = mallOpenTime.getStartDate();
        Date endDate = mallOpenTime.getEndDate();*/

        if(gateRetentions != null || gateRetentions.size() <= 0)
            return table;

        Date startDate = gateRetentions.get(0).getCounttime();
        Date endDate = gateRetentions.get(gateRetentions.size()-1).getCounttime();

        Date currentTime = startDate;
        while (currentTime.before(endDate)) {
            Date nextTime = DateUtil.addMilliseconds(currentTime, 10);
            String  nextTimeStr = DateUtil.format(DateUtil.FORMAT_HHMMSS,nextTime);
            ((Table) table).getRow(nextTimeStr).putValueByHeadColumn(time_tableHead, nextTimeStr);
            currentTime = nextTime;
        }

        for (GateRetention gateRetention : gateRetentions) {
            Date counttime = gateRetention.getCounttime();
            String counttime_str = DateUtil.format(DateUtil.FORMAT_HHMMSS, counttime);
            Long gateId = gateRetention.getGateId();
            String gateName = getOrgNameById(gateId, OrgType.gate, dataMap);
            ((Table) table).getRow(counttime_str).putValueByHeadColumn(gateName,gateRetention.getNum());
        }
        return table;
    }
}
