package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.service.adapter.FaceRecognitionService;
import com.viontech.mall.service.adapter.MallService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: WJY
 * @Date: 2018-12-25 14:34
 */
@Service
public class HappyIndexServiceImpl extends ChartReportBaseService{

    private final String REPORT_HAPPY_INDEX = "happyIndex";

    @Autowired
    MallService mallService;

    @Autowired
    FaceRecognitionService faceRecognitionService;

    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;
        switch (reportChart.getKey()){
            case REPORT_HAPPY_INDEX:
                chart = getHappyIndexChart(orgIds,startDate,dataMap,reportChart);
                break;
                default:
                    break;
        }
        return chart;
    }


    public Chart getHappyIndexChart(Long[] orgIds,Date countDate,Map<String,Object> dataMap,ReportChart reportChart) {
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        Axis xAxis = AxisFactory.createDayOFMonthAxis(DateUtil.getFirstDateOfMonth(countDate),DateUtil.getLastDateOfMonth(countDate));
        xAxis.lock();
        chart.setXAxis(xAxis);

        MallExample mallExample = new MallExample();
        mallExample.createCriteria().andIdIn(Arrays.asList(orgIds));
        mallExample.createColumns().hasNameColumn().hasIdColumn();
        List<Mall> mallList = mallService.selectByExample(mallExample);
        Map<Long,String> mallMap = mallList.stream().collect(Collectors.toMap(Mall::getId,Mall::getName));

        FaceRecognitionExample faceRecognitionExample = new FaceRecognitionExample();
        faceRecognitionExample.createColumns().hasMoodColumn().hasCountdateColumn().hasPersonUnidColumn().hasMallIdColumn();
        faceRecognitionExample.createCriteria().andCountdateBetween(DateUtil.getFirstDateOfMonth(countDate),DateUtil.getLastDateOfMonth(countDate))
                .andPersonTypeNotEqualTo((short)9).andMoodBetween((short)7,(short)10).andMallIdIn(Arrays.asList(orgIds));
        faceRecognitionExample.setOrderByClause("countdate");
        List<FaceRecognition> faceList = faceRecognitionService.selectByExample(faceRecognitionExample);
        for (Map.Entry<Long,String> entry : mallMap.entrySet()){
            chart.createSeries(entry.getValue());
        }
        Map<Long,Map<Date,Object>> datasMap = new HashMap<Long,Map<Date,Object>>();
        Map<Date,Object> mapData = null;
        for (FaceRecognition faceRecognition : faceList){
            Long mallId = faceRecognition.getMallId();
            mapData = datasMap.get(mallId);
            if(mapData == null){
                mapData = new HashMap<>();
            }
            ArrayList arr = (ArrayList) mapData.get(faceRecognition.getCountdate());
            if(arr == null){
                arr = new ArrayList();
            }
            arr.add(faceRecognition.getMood());
            mapData.put(faceRecognition.getCountdate(),arr);
            datasMap.put(mallId,mapData);
        }

        for(Map.Entry entry1 : datasMap.entrySet()){
            Map<String,Object> countDateMoodMap = (Map<String, Object>) entry1.getValue();
            for (Map.Entry entry2 : countDateMoodMap.entrySet()){
                List<Short> moodList = (List)entry2.getValue();
                double weight = calWeight(moodList);
                entry2.setValue(weight);
                    chart.getSeries(mallMap.get(entry1.getKey())).putValueByCoordinate(entry2.getKey(),entry2.getValue());
            }
        }

       return chart;
    }


    public double calWeight(List<Short> list){
        double result = 0.0;
        double sum = 0.0;
        for(short mood : list){
            sum += calSingleWeight(mood);
        }
        result = sum/list.size();
        return result;
    }

    public double calSingleWeight(short mood){
        double result =0.0;
        switch (mood){
            case 7:
                result = 0.65;
                break;
            case 8:
                result = 0.75;
                break;
            case 9:
                result = 0.85;
                break;
            case 10:
                result = 0.55;
                default:
                    break;
        }
        return result;
    }
}
