package com.viontech.mall.report.service.impl;

import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.AbstractReportDataService;
import com.viontech.mall.report.service.adapter.GateDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.service.adapter.GateService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class GateReportDataServiceImpl extends AbstractReportDataService implements GateReportDataService {
	@Resource
	private GateDataService gateDataService;
	
	@Resource
	private GateService gateService;
	
	
	
	/**获取多个监控点时间段的天级的客流数据*/
	@Override
	public List<GateDayCountData> getOrQueryGateBetweenDateDayTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<GateDayCountData>();
			datas = (List<GateDayCountData>) gateDataService.getDayData(startDate, endDate, Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	/**获取多个监控点多个时间点的天级的客流数据*/
	@Override
	public List<GateDayCountData> getOrQueryGateInDatesDayTraffic(Long[] gateIds, List<Date> dates, Map<String, Object> dataMap) {
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<GateDayCountData>();
			datas = (List<GateDayCountData>) gateDataService.getDayData(dates, Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	/**获取多个监控点多个时间点的小时客流数据*/
	@Override
	public List<GateHourCountData> getOrQueryGateDaysHourData(Long[] gateIds, List<Date> dates, Map<String, Object> dataMap) {
		List<GateHourCountData> datas = (List<GateHourCountData>) dataMap.get(KEY_GATE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<GateHourCountData>();
			datas = (List<GateHourCountData>) gateDataService.getHourData(dates, Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	/**获取多个监控点多个时间点的10分钟客流数据*/
	@Override
	public List<GateMinuteCountData> getOrQueryGateDays10MinData(Long[] gateIds, List<Date> dates, Map<String, Object> dataMap) {
		List<GateMinuteCountData> datas = (List<GateMinuteCountData>) dataMap.get(KEY_10MINUTE_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<GateMinuteCountData>();
			datas = (List<GateMinuteCountData>) gateDataService.getMinuteData(dates,Arrays.asList(gateIds));
			dataMap.put(KEY_10MINUTE_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个监控点时间段的人脸数据*/
	@Override
	public List<GateDayFaceRecognitionSta> getOrQueryGateFaceData(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		//人脸
		List<GateDayFaceRecognitionSta> faceDatas= (List<GateDayFaceRecognitionSta>) dataMap.get(KEY_FACE_DATA);
		if (dataMap.get(KEY_FACE_DATA) == null) {
			faceDatas = new ArrayList<GateDayFaceRecognitionSta>();
			faceDatas = (List<GateDayFaceRecognitionSta>) gateDataService.getFaceDayData(startDate, endDate, Arrays.asList(gateIds));
			dataMap.put(KEY_FACE_DATA,faceDatas);
		}
		return faceDatas;
	}
	/**获取所有的监控点*/
	public Gate getGateInfoById(Long gateId,Map<String,Object> dataMap){
		Map<Long,Gate> gateMaps =  (Map<Long, Gate>) dataMap.get(KEY_GATES);
		if (gateMaps == null) {
			gateMaps = new HashMap<Long, Gate>();
			GateExample example = new GateExample();
			List<Gate> gates = gateService.selectByExample(example);
			for (Gate gate : gates) {
				Long id = gate.getId();
				gateMaps.put(id, gate);
			}
		    dataMap.put(KEY_GATES, gateMaps);
		}
		return gateMaps.get(gateId);
	}

	
	/**
	 * 把监控点人脸数据转成通用人脸数据类中
	 * @param GateFaceDatas
	 * @return
	 */
	public List<FaceVo> convertFace2Data(List<GateDayFaceRecognitionSta> faceDatas){
		List<FaceVo> faceVos = new ArrayList<FaceVo>();
		if (faceDatas != null && faceDatas.size() > 0) {
			for (GateDayFaceRecognitionSta faceData : faceDatas) {
				FaceVo faceVo = new FaceVo();
				faceVo.setPersonMantime(faceData.getPersonMantime());
				faceVo.setPersonCount(faceData.getPersonCount());
				faceVo.setCustomMantime(faceData.getCustomMantime());
				faceVo.setCustomCount(faceData.getCustomCount());
				faceVo.setMaleMantime(faceData.getMaleMantime());
				faceVo.setMaleCount(faceData.getMaleCount());
				faceVo.setFemaleMantime(faceData.getFemaleMantime());
				faceVo.setFemaleCount(faceData.getFemaleCount());
				faceVo.setStaffMantime(faceData.getStaffMantime());
				faceVo.setStaffCount(faceData.getStaffCount());
				faceVo.setCountdate(faceData.getCountdate());
				faceVo.setMallId(faceData.getMallId());
				faceVo.setAccountId(faceData.getAccountId());
				faceVo.setGateId(faceData.getGateId());
				faceVo.setMaleStage(faceData.getMaleStage());
				faceVo.setFemaleStage(faceData.getFemaleStage());
				faceVos.add(faceVo);
			}
		}
		return faceVos;
	}
	
	/**
	 * 把监控点的小时客流、天级客流、销售    数据转成通用的数据类
	 * @param datas
	 * @return
	 */
	public   <T> List<DataVo> convert2Data(List<T> datas){
		List<DataVo> dataVos = new ArrayList<DataVo>();
		
		if (datas != null && datas.size() > 0) {
			boolean typeFlag = false;
			//泛型类型   1：HourCountData  2： DayCountData  3: Sale 	4: minuteCountData
			int type = 0;
			for (T t : datas) {
				if (!typeFlag) {
					if(t instanceof GateHourCountData){
						type = 1;
						typeFlag = true;
					}else if (t instanceof GateDayCountData) {
						type = 2;
						typeFlag = true;
					}else if (t instanceof GateMinuteCountData) {
						type = 4;
						typeFlag = true;
					}
				}
				
				DataVo dataVo = new DataVo();
				dataVo.setDataType(type);
				switch (type) {
				case 1:
					GateHourCountData hourData = (GateHourCountData) t;
					dataVo.setGateId(hourData.getGateId());
					dataVo.setMallId(hourData.getMallId());
					dataVo.setAccountId(hourData.getAccountId());
					dataVo.setDate(hourData.getCountdate());
					dataVo.setTime(hourData.getCounttime());
					dataVo.setOutnum(hourData.getOutnum());
					dataVo.setInnum(hourData.getInnum());
					dataVos.add(dataVo);
					break;
				case 2:
					GateDayCountData dayData = (GateDayCountData) t;
					dataVo.setGateId(dayData.getGateId());
					dataVo.setMallId(dayData.getMallId());
					dataVo.setAccountId(dayData.getAccountId());
					dataVo.setDate(dayData.getCountdate());
					dataVo.setTime(dayData.getCounttime());
					dataVo.setOutnum(dayData.getOutnum());
					dataVo.setInnum(dayData.getInnum());
					dataVos.add(dataVo);
					break;
				case 4:
					GateMinuteCountData minuteData = (GateMinuteCountData) t;
					dataVo.setGateId(minuteData.getGateId());
					dataVo.setMallId(minuteData.getMallId());
					dataVo.setAccountId(minuteData.getAccountId());
					dataVo.setDate(minuteData.getCountdate());
					dataVo.setTime(minuteData.getCounttime());
					dataVo.setOutnum(minuteData.getOutnum());
					dataVo.setInnum(minuteData.getInnum());
					dataVos.add(dataVo);
					break;
				default:
					break;
				}
			}
		}
		return dataVos;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//-----------------------------------------------------以下需要修改的代码--------------------------------------------------------------------//
	
	/**获取店铺近5年的客流数据  */
	@SuppressWarnings("unchecked")
	public List<GateDayCountData> getNear5YearGateTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			datas = (List<GateDayCountData>) gateDataService.getDayData(dates, Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取店铺近三月 的客流数据     本月  +  上月      + 去年同月  */
	@SuppressWarnings("unchecked")
	public List<GateDayCountData> getNear3MonthGateTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear6MonthDates(startDate, endDate));
			datas = (List<GateDayCountData>) gateDataService.getDayData(dates, Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	
	/**获取店铺近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<GateDayCountData> getNear3WeekGateTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(get8WeekDates(startDate, endDate));
			datas = (List<GateDayCountData>) gateDataService.getDayData(dates, Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	public List<GateDayCountData> getNear3WeekGateTraffic(Long gateId, Date startDate, Date endDate, Map<String, Object> dataMap){
		return getNear3WeekGateTraffic(new Long[]{gateId},startDate,endDate,dataMap);
	}
	
	/**获取监控点天级的客流数据   当天   昨天  上周同期     上月同期    上年同期 （近15天)*/
	public List<GateDayCountData> getGateNear15DayTraffic(Long[] gateIds,Date date,Map<String,Object> dataMap){
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			datas = getOrQueryGateDayTraffic(gateIds, startDate, date, dataMap);
		}
		return datas;
	}
	public List<GateDayCountData> getGateNear15DayTraffic(Long gateId,Date date,Map<String,Object> dataMap){
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			datas = getOrQueryGateDayTraffic(gateId, startDate, date, dataMap);
		}
		return datas;
	}
	
	/**获取监控点的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期 (当天) */
	public List<GateHourCountData> getGateCurrentDayHourTraffic(Long[] gateIds,Date date,Map<String,Object> dataMap){
		List<GateHourCountData> datas = (List<GateHourCountData>) dataMap.get(KEY_GATE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = getOrQueryGateHourData(gateIds, date, date, dataMap);
		}
		return datas;
	}
	/**获取监控点的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期 (当天) */
	public List<GateHourCountData> getGateCurrentDayHourTraffic(Long gateId,Date date,Map<String,Object> dataMap){
		List<GateHourCountData> datas = (List<GateHourCountData>) dataMap.get(KEY_GATE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = getOrQueryGateHourData(gateId, date, date, dataMap);
		}
		return datas;
	}
	
	/**
	 * 获取监控点近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  
	 * @param gateId
	 * @param tartDate
	 * @param endDate
	 * @param dataMap
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<GateDayCountData> getOrQueryGateDayTraffic(Long[] gateIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<GateDayCountData> datas = (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<GateDayCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<GateDayCountData>) gateDataService.getDayData(new ArrayList<Date>(dates), Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	public List<GateDayCountData> getOrQueryGateDayTraffic(Long gateId,Date startDate,Date endDate,Map<String,Object> dataMap){
		return getOrQueryGateDayTraffic(new Long[]{gateId},startDate,endDate,dataMap);
	}
	
	/**获取监控点小时级的客流数据     近n天的数据+上周同期+上月同期+上年同期*/
	public List<GateHourCountData>  getOrQueryGateHourData(Long[] gateIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<GateHourCountData> datas = (List<GateHourCountData>) dataMap.get(KEY_GATE_HOUR_TRAFFIC);
		Date todayDate = endDate;
		if (datas == null) {
			datas = new ArrayList<GateHourCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<GateHourCountData>) gateDataService.getHourData(new ArrayList<Date>(dates), Arrays.asList(gateIds));
			dataMap.put(KEY_GATE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	public List<GateHourCountData>  getOrQueryGateHourData(Long gateId,Date startDate,Date endDate,Map<String,Object> dataMap){
		return getOrQueryGateHourData(new Long[]{gateId},startDate,endDate,dataMap);
	}
	
	
}
