package com.viontech.mall.report.service.impl;

import com.viontech.mall.model.GateDayFaceRecognitionSta;
import com.viontech.mall.model.GateDayFaceRecognitionStaExample;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.service.adapter.GateDayFaceRecognitionStaService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Description: 出入口客流统计
 * @Author: WJY
 * @Date: 2018-11-07 13:45
 */
@Service
public class GateFaceAnalyzeStaReportServiceImpl extends AbstractFaceAnalyzeStaReportServiceImpl{

    @Resource
    private GateDayFaceRecognitionStaService gateDayFaceRecognitionStaService;

    /**
     * 获得gateFaceData数据
     */
    private final static String FELID_FACE_DATA="faceDatas";

     @SuppressWarnings("unchecked")
     @Override
     protected List<FaceVo> getFaceData(Long[] orgIds,Date startDate, Date endDate, Map<String, Object> dataMap){
        List<FaceVo> faceDatas = (List<FaceVo>) dataMap.get(FELID_FACE_DATA);

        if(faceDatas == null){
            List<GateDayFaceRecognitionSta> faceDatasRaw = null;
            FaceVo faceVo = null;
            faceDatas = new ArrayList<FaceVo>();
            GateDayFaceRecognitionStaExample gateDayFaceRecognitionStaExample = new GateDayFaceRecognitionStaExample();
            gateDayFaceRecognitionStaExample.createCriteria().andCountdateBetween(startDate,endDate).andGateIdIn(Arrays.asList(orgIds));
            faceDatasRaw = gateDayFaceRecognitionStaService.selectByExample(gateDayFaceRecognitionStaExample);
            for(GateDayFaceRecognitionSta gateDayFaceRecognitionSta:faceDatasRaw){
                faceVo = new FaceVo();
                faceVo.setPersonMantime(gateDayFaceRecognitionSta.getPersonMantime());
                faceVo.setPersonCount(gateDayFaceRecognitionSta.getPersonCount());
                faceVo.setCustomMantime(gateDayFaceRecognitionSta.getCustomMantime());
                faceVo.setCustomCount(gateDayFaceRecognitionSta.getCustomCount());
                faceVo.setMaleMantime(gateDayFaceRecognitionSta.getMaleMantime());
                faceVo.setMaleCount(gateDayFaceRecognitionSta.getMaleCount());
                faceVo.setFemaleMantime(gateDayFaceRecognitionSta.getFemaleMantime());
                faceVo.setFemaleCount(gateDayFaceRecognitionSta.getFemaleCount());
                faceVo.setStaffCount(gateDayFaceRecognitionSta.getStaffCount());
                faceVo.setStaffMantime(gateDayFaceRecognitionSta.getStaffMantime());
                faceVo.setCountdate(gateDayFaceRecognitionSta.getCountdate());
                faceVo.setMallId(gateDayFaceRecognitionSta.getMallId());
                faceVo.setAccountId(gateDayFaceRecognitionSta.getAccountId());
                faceVo.setMaleStage(gateDayFaceRecognitionSta.getMaleStage());
                faceVo.setFemaleStage(gateDayFaceRecognitionSta.getFemaleStage());
                faceVo.setGateId(gateDayFaceRecognitionSta.getGateId());
                faceDatas.add(faceVo);
            }
            dataMap.put(FELID_FACE_DATA,faceDatas);
        }
        return faceDatas;
    }


}
