package com.viontech.mall.report.service.impl;

import com.viontech.keliu.base.BaseModel;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.service.adapter.GateDataService;
import com.viontech.mall.service.adapter.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
public class GateDataServiceImpl extends BaseDataServiceImpl implements GateDataService {
	@Resource
	private GateMinuteCountDataService gateMinuteService;
	@Resource
	private GateHourCountDataService gateHourService;
	@Resource
	private GateDayCountDataService gateDataService;
	@Resource
	private GateDayFaceRecognitionStaService gateDayFaceRecognitionStaService;
	@Resource
	private GateHourFaceRecognitionStaService gateHourFaceRecognitionStaService;
	

	@Override
	public List<GateMinuteCountData> getMinuteData(List<Date> dates, List<Long> ids) {
	    GateMinuteCountDataExample example = new GateMinuteCountDataExample();
	    example.createColumns();
	    GateMinuteCountDataExample.Criteria criteria = example.createCriteria();
	    if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() > 1) {
			criteria.andGateIdIn(ids);
		}
	    if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1){
			criteria.andCountdateIn(dates);
		}
	    example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateMinuteService.selectByExample(example);
	}

	@Override
	public List<GateHourCountData> getHourData(List<Date> dates, List<Long> ids) {
		GateHourCountDataExample example = new GateHourCountDataExample();
		example.createColumns();
	    GateHourCountDataExample.Criteria criteria = example.createCriteria();
	    if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() >1){
			criteria.andGateIdIn(ids);
		}
	    if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() >1){
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateHourService.selectByExample(example);
	}

	@Override
	public List<GateDayCountData> getDayData(List<Date> dates, List<Long> ids) {
		GateDayCountDataExample example = new GateDayCountDataExample();
		example.createColumns();
		GateDayCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else if (ids != null && ids.size() >  1){
			criteria.andGateIdIn(ids);
		}
	    if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() >1){
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateDataService.selectByExample(example);
	}


	@Override
	public List<GateDayCountData> getDaysData(List<DateCriteria> dates, List<Long> ids) {
		GateDayCountDataExample example = new GateDayCountDataExample();
		example.createColumns();
		GateDayCountDataExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else if(ids != null && ids.size() >1){
			criteria.andGateIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateDataService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceDayData(List<Date> dates, List<Long> ids) {
		GateDayFaceRecognitionStaExample example = new GateDayFaceRecognitionStaExample();
		example.createColumns();
		GateDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andGateIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateDayFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceHourData(List<Date> dates, List<Long> ids) {
		GateHourFaceRecognitionStaExample example = new GateHourFaceRecognitionStaExample();
		example.createColumns();
		GateHourFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andGateIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCounttimeEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCounttimeIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateHourFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceDaysData(List<DateCriteria> dates, List<Long> ids) {
		GateDayFaceRecognitionStaExample example = new GateDayFaceRecognitionStaExample();
		example.createColumns();
		GateDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andGateIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andGateIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return gateDayFaceRecognitionStaService.selectByExample(example);
	}
	
}
