package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.mall.model.ReportChart;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service
public class FloorWeekReportServiceImpl extends AbstractFloorReportServiceImpl {

	@Override
	public Chart getChart(Long[] orgIds,  Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		Long orgId = orgIds[0];
		switch (reportChart.getKey()) {
		case REPORT_FLOOR_CUSTOMERFEATURE_GENDER:/**楼层顾客特征--性别分布*/
			chart =  genderDistributionReport(orgId, startDate,endDate, dataMap, reportChart);
			break;
		case REPORT_FLOOR_CUSTOMERFEATURE_AGE:/**楼层顾客特征--年龄分布*/
			chart = ageDistributionReport(orgId, startDate,endDate,  dataMap, reportChart);		
			break;
		case REPORT_FLOOR_CUSTOMERFEATURE_NAO:/**楼层顾客特征--新老顾客*/
			//chart = visitorStatisticReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_TRAFFICANDSALE_TREND:	/**楼层趋势*/
			chart = trafficAndSaleTrendReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_TRAFFICRANK:/**楼层店铺排行--客流量*/
			chart = trafficRankReport(orgId, startDate,endDate,  dataMap, reportChart);	
			break;
		case REPORT_FLOOR_SALERANK:/**楼层店铺排行--销售额*/
			chart = salesRankReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_ENTERINGRATERANK:/**楼层店铺排行--进店率*/
			chart = enteringRateReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_PERCUSTOMERTRANSACTIONRANK:/**楼层店铺排行--客单价*/
			chart = perPriceTransactionReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_SALES_PERSQUAREMETERRANK:/**楼层店铺排行--坪效*/
			chart = perAreaValueReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_TURNOVERRANK:/**楼层店铺排行--成交量*/
			chart = saleCountReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_HANDBAGRATERANK:/**楼层店铺排行--提袋率*/
			chart = handbagRateReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_DURATIONTIMERANK:/**楼层店铺排行--滞留时间 */
			chart = durationTimeReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		case REPORT_FLOOR_GATETRAFFIC:/**楼层出入口客流*/
			chart = gateTrafficReport(orgId, startDate,endDate,  dataMap, reportChart);
			break;
		default:
			break;
		}
		
		return chart;
	}

}
