package com.viontech.mall.report.service.impl;

import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.AbstractReportDataService;
import com.viontech.mall.report.service.adapter.FloorDataService;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.SaleDataService;
import com.viontech.mall.service.adapter.FloorService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class FloorReportDataServiceImpl extends AbstractReportDataService implements FloorReportDataService {
	
	@Resource
	private SaleDataService saleDataService;
	
	@Resource
	private FloorDataService floorDataService;
	
	@Resource
	private FloorService floorService;
	
	@Resource
	private ZoneService zoneService;
	
	/**获取多个楼层时间段的天级的客流数据*/
	@Override
	public List<FloorDayCountData> getOrQueryFloorBetweenDateDayTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<FloorDayCountData>();
			datas = (List<FloorDayCountData>) floorDataService.getDayData(startDate, endDate, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个楼层时间点的天级的客流数据*/
	@Override
	public List<FloorDayCountData> getOrQueryFloorInDatesDayTraffic(Long[] floorIds, List<Date> dates, Map<String, Object> dataMap) {
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<FloorDayCountData>();
			datas = (List<FloorDayCountData>) floorDataService.getDayData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个楼层时间段的小时级的客流数据*/
	public List<FloorHourCountData>  getOrQueryFloorBetweenDateHourTraffic(Long[] floorIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<FloorHourCountData> datas = (List<FloorHourCountData>) dataMap.get(KEY_FLOOR_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<FloorHourCountData>();
			List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
			datas = (List<FloorHourCountData>) floorDataService.getHourData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个楼层时间 点的小时级的客流数据*/
	public List<FloorHourCountData>  getOrQueryFloorInDatesHourTraffic(Long[] floorIds,List<Date> dates,Map<String,Object> dataMap){
		List<FloorHourCountData> datas = (List<FloorHourCountData>) dataMap.get(KEY_FLOOR_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<FloorHourCountData>();
			datas = (List<FloorHourCountData>) floorDataService.getHourData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个楼层多个时间点的10分钟级的客流数据*/
	@Override
	public List<FloorMinuteCountData>  getOrQueryFloorInDatesMinTraffic(Long[] floorIds,List<Date> dates,Map<String,Object> dataMap){
		List<FloorMinuteCountData> datas = (List<FloorMinuteCountData>) dataMap.get(KEY_10MINUTE_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<FloorMinuteCountData>();
			datas = (List<FloorMinuteCountData>) floorDataService.getMinuteData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_10MINUTE_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取多个楼层时间段的天级的销售数据*/
	@SuppressWarnings("unchecked")
	@Override
	public List<Sale> getOrQueryFloorBetweenDateDaySale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			sales = saleDataService.getDayData(startDate, endDate, Arrays.asList(floorIds), OrgType.floor);
			dataMap.put(KEY_FLOOR_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取多个楼层时间点的天级的销售数据*/
	@SuppressWarnings("unchecked")
	@Override
	public List<Sale> getOrQueryFloorInDateDaySale(Long[] floorIds, List<Date> dates, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			sales = saleDataService.getDayData(dates, Arrays.asList(floorIds), OrgType.floor);
			dataMap.put(KEY_FLOOR_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取店铺的人脸数据*/
	public List<FloorDayFaceRecognitionSta> getOrQueryFloorDayFaceRecognitionStas(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		//人脸
		List<FloorDayFaceRecognitionSta> faceDatas= (List<FloorDayFaceRecognitionSta>) dataMap.get(KEY_FACE_DATA);
		if (dataMap.get(KEY_FACE_DATA) == null) {
			faceDatas = new ArrayList<FloorDayFaceRecognitionSta>();
			faceDatas = (List<FloorDayFaceRecognitionSta>) floorDataService.getFaceDayData(startDate, endDate, Arrays.asList(floorIds));
			dataMap.put(KEY_FACE_DATA,faceDatas);
		}
		return faceDatas;
	}
	
	/**根据楼层id获取楼层信息*/
	public Floor getFloorInfoById(Long floorId,Map<String,Object> dataMap){
		Map<Long, Floor> floorMaps =  (Map<Long, Floor>) dataMap.get(KEY_FLOOR_INFO);
		if (floorMaps == null) {
			floorMaps  = new HashMap<Long, Floor>();
			FloorExample example = new FloorExample();
			List<Floor> floors =  floorService.selectByExample(example);
			if (floors != null) {
				for (Floor floor : floors) {
					Long id = floor.getId();
					floorMaps.put(id, floor);
				}
			}
		    dataMap.put(KEY_FLOOR_INFO, floorMaps);
		}
		return floorMaps.get(floorId);
	}
	
	public List<Zone> getZoneOfFloor(Long floorId,Map<String,Object> dataMap){
		List<Zone> zones = (List<Zone>) dataMap.get(KEY_ZONE_OF_FLOOR);
		if(zones == null){
			zones = new ArrayList<Zone>();
			ZoneExample zoneExample = new ZoneExample();
			zoneExample.createCriteria().andFloorIdEqualTo(floorId);
			zones = zoneService.selectByExample(zoneExample);
		}
		return zones;
	}
	
	/**
	 * 把楼层人脸数据转成通用人脸数据类中
	 * @param floorFaceDatas
	 * @return
	 */
	public List<FaceVo> convertFace2Data(List<FloorDayFaceRecognitionSta> floorFaceDatas){
		List<FaceVo> faceVos = new ArrayList<FaceVo>();
		if (floorFaceDatas != null && floorFaceDatas.size() > 0) {
			for (FloorDayFaceRecognitionSta faceData : floorFaceDatas) {
				FaceVo faceVo = new FaceVo();
				faceVo.setPersonMantime(faceData.getPersonMantime());
				faceVo.setPersonCount(faceData.getPersonCount());
				faceVo.setCustomMantime(faceData.getCustomMantime());
				faceVo.setCustomCount(faceData.getCustomCount());
				faceVo.setMaleMantime(faceData.getMaleMantime());
				faceVo.setMaleCount(faceData.getMaleCount());
				faceVo.setFemaleMantime(faceData.getFemaleMantime());
				faceVo.setFemaleCount(faceData.getFemaleCount());
				faceVo.setStaffMantime(faceData.getStaffMantime());
				faceVo.setStaffCount(faceData.getStaffCount());
				faceVo.setCountdate(faceData.getCountdate());
				faceVo.setMallId(faceData.getMallId());
				faceVo.setAccountId(faceData.getAccountId());
				faceVo.setFloorId(faceData.getFloorId());
				faceVo.setMaleStage(faceData.getMaleStage());
				faceVo.setFemaleStage(faceData.getFemaleStage());
				faceVos.add(faceVo);
			}
		}
		return faceVos;
	}
	
	/**
	 * 把店铺的小时客流、天级客流、销售    数据转成通用的数据类
	 * @param datas
	 * @return
	 */
	public   <T> List<DataVo> convert2Data(List<T> datas){
		List<DataVo> dataVos = new ArrayList<DataVo>();
		
		if (datas != null && datas.size() > 0) {
			boolean typeFlag = false;
			//泛型类型   1：FloorHourCountData  2： FloorDayCountData  3: Sale
			int type = 0;
			for (T t : datas) {
				if (!typeFlag) {
					if(t instanceof FloorHourCountData){
						type = 1;
						typeFlag = true;
					}else if (t instanceof FloorDayCountData) {
						type = 2;
						typeFlag = true;
					}else if (t instanceof Sale) {
						type = 3;
						typeFlag = true;
					}else if(t instanceof FloorMinuteCountData){
						type = 4;
						typeFlag = true;
					}
				}
				
				DataVo dataVo = new DataVo();
				dataVo.setDataType(type);
				switch (type) {
				case 1:
					FloorHourCountData hourData = (FloorHourCountData) t;
					dataVo.setFloorId(hourData.getFloorId());
					dataVo.setMallId(hourData.getMallId());
					dataVo.setAccountId(hourData.getAccountId());
					dataVo.setDate(hourData.getCountdate());
					dataVo.setTime(hourData.getCounttime());
					dataVo.setOutnum(hourData.getOutnum());
					dataVo.setInnum(hourData.getInnum());
					dataVos.add(dataVo);
					break;
				case 2:
					FloorDayCountData dayData = (FloorDayCountData) t;
					dataVo.setFloorId(dayData.getFloorId());
					dataVo.setMallId(dayData.getMallId());
					dataVo.setAccountId(dayData.getAccountId());
					dataVo.setDate(dayData.getCountdate());
					dataVo.setTime(dayData.getCounttime());
					dataVo.setOutnum(dayData.getOutnum());
					dataVo.setInnum(dayData.getInnum());
					dataVos.add(dataVo);
					break;
				case 3:
					Sale sale = (Sale) t;
					dataVo.setZoneId(sale.getZoneId());
					dataVo.setFloorId(sale.getFloorId());
					dataVo.setMallId(sale.getMallId());
					dataVo.setSaleCount(sale.getSalecount());
					dataVo.setDate(sale.getSaledate());
					dataVo.setMoney(sale.getMoney());
					dataVos.add(dataVo);
					break;
				case 4:
					FloorMinuteCountData minuteData = (FloorMinuteCountData) t;
					dataVo.setFloorId(minuteData.getFloorId());
					dataVo.setMallId(minuteData.getMallId());
					dataVo.setAccountId(minuteData.getAccountId());
					dataVo.setDate(minuteData.getCountdate());
					dataVo.setTime(minuteData.getCounttime());
					dataVo.setOutnum(minuteData.getOutnum());
					dataVo.setInnum(minuteData.getInnum());
					dataVos.add(dataVo);
					break;
				default:
					break;
				}
			}
		}
		return dataVos;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//------------------------------------------------------------------------------------------------------------------------------------------//
	
	/**获取楼层近5年 的客流数据*/
	@SuppressWarnings("unchecked")
	public List<FloorDayCountData> getNear5YearFloorTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			datas = (List<FloorDayCountData>) floorDataService.getDayData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取楼层近5年的销售数据*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear5YearFloorSale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(getNear5YearDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(floorIds, dates, dataMap);
			dataMap.put(KEY_FLOOR_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取楼层近三月 的客流数据     本月  +  上月  + 去年同月*/
	@SuppressWarnings("unchecked")
	public List<FloorDayCountData> getNear3MonthFloorTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(getNear6MonthDates(startDate, endDate));
			datas = (List<FloorDayCountData>) floorDataService.getDayData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取楼层近三月 的销售数据     本月  +  上月  + 去年同月*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear3MonthFloorSale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(getNear3MonthDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(floorIds, dates, dataMap);
			dataMap.put(KEY_FLOOR_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**获取楼层近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<FloorDayCountData> getNear3WeekFloorTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			List<Date> dates = new ArrayList<Date>(get8WeekDates(startDate, endDate));
			datas = (List<FloorDayCountData>) floorDataService.getDayData(dates, Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	public List<FloorDayCountData> getNear3WeekFloorTraffic(Long floorId, Date startDate, Date endDate, Map<String, Object> dataMap){
		return getNear3WeekFloorTraffic(new Long[]{floorId},startDate,endDate,dataMap);
	}
	
	/**获取楼层近三周 的销售数据     本周  +  上周  +上月同周   + 去年同周*/
	@SuppressWarnings("unchecked")
	public List<Sale> getNear3WeekFloorSale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			List<Date> dates = new ArrayList<Date>(get3WeekDates(startDate, endDate));
			sales = querySalesByDatesAndOrgIds(floorIds, dates, dataMap);
			dataMap.put(KEY_FLOOR_DAY_SALE, sales);
		}
		return sales;
	}
	public List<Sale> getNear3WeekFloorSale(Long floorId, Date startDate, Date endDate, Map<String, Object> dataMap){
		return getNear3WeekFloorSale(new Long[]{floorId},startDate,endDate,dataMap);
	}
	
	/**获取楼层的销售数据  当天   昨天  上周同期     上月同期    上年同期   近15天*/
	public List<Sale> getFloorNear15DaySales(Long[] floorIds,Date date,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			sales = getOrQueryFloorSales(floorIds, startDate, date, dataMap);
		}
		return sales;
	}
	
	public List<Sale> getFloorNear15DaySales(Long floorId,Date date,Map<String,Object> dataMap){
		return getFloorNear15DaySales(new Long[]{floorId},date,dataMap);
	}
	/**获取楼层天级的客流数据   近15天*/
	public List<FloorDayCountData> getFloorNear15DayTraffic(Long[] floorIds,Date date,Map<String,Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			Date startDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY15);
			datas = getOrQueryFloorDayTraffic(floorIds, startDate, date, dataMap);
		}
		return datas;
	}
	public List<FloorDayCountData> getFloorNear15DayTraffic(Long floorId,Date date,Map<String,Object> dataMap){
		return getFloorNear15DayTraffic(new Long[]{floorId},date,dataMap);
	}
	/**获取楼层的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期  (当天)*/
	public List<FloorHourCountData> getFloorNearCurrentDayHourTraffic(Long[] floorIds,Date date,Map<String,Object> dataMap){
		List<FloorHourCountData> datas = (List<FloorHourCountData>) dataMap.get(KEY_FLOOR_HOUR_TRAFFIC);
		if (datas == null) {
			datas = getOrQueryFloorHourData(floorIds, date, date, dataMap);
		}
		return datas;
	}
	/**
	 * 获取楼层的销售额   近n天的（当天+上周同期+上月同期+上年同期）
	 * @param floorIds
	 * @param startDate  起始时间
	 * @param endDate	 结束日期
	 * @param dataMap
	 * @return
	 */
	public List<Sale> getOrQueryFloorSales(Long[] floorIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_DAY_SALE);
		if (sales == null) {
			Set<Date> dates = getComparedDates(startDate, endDate);
			sales = querySalesByDatesAndOrgIds(floorIds, new ArrayList(dates), dataMap);
			dataMap.put(KEY_FLOOR_DAY_SALE, sales);
		}
		return sales;
	}
	
	/**
	 * 获取楼层近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  
	 * @param floorIds
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public List<FloorDayCountData> getOrQueryFloorDayTraffic(Long[] floorIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<FloorDayCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<FloorDayCountData>) floorDataService.getDayData(new ArrayList<Date>(dates), Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**获取楼层小时级的客流数据     近n天的数据+上周同期+上月同期+上年同期*/
	public List<FloorHourCountData>  getOrQueryFloorHourData(Long[] floorIds,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<FloorHourCountData> datas = (List<FloorHourCountData>) dataMap.get(KEY_FLOOR_HOUR_TRAFFIC);
		Date todayDate = endDate;
		if (datas == null) {
			datas = new ArrayList<FloorHourCountData>();
			Set<Date> dates = getComparedDates(startDate, endDate);
			datas = (List<FloorHourCountData>) floorDataService.getHourData(new ArrayList<Date>(dates), Arrays.asList(floorIds));
			dataMap.put(KEY_FLOOR_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
}
