package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.FloorService;
import com.viontech.mall.vo.ZoneVo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

@Service
public class FloorDayReportServiceImpl extends AbstractFloorReportServiceImpl {

	@Value("${Age.stage}")
	private String ageStage;
	
	@Resource
	private MallDataService mallDataService;
	
	@Resource
	private FloorDataService floorDataService;
	
	@Resource
	private ZoneDataService zoneDataService;
	
	@Resource
	private GateDataService gateDataService;
	
	@Resource
	private FloorService floorService;

	@Resource
	private FloorReportDataService floorReportDataService;

	
	/**累计客流*/
	private final String FIELD_FLOOR_ACCUMULATIVE_TRAFFIC = "accumulativeTraffic";
	/**客流占比*/
	private final String FIELD_FLOOR_RATIOOFTRAFFIC ="trafficRatio";
	/**累计销售额*/
	private final String FIELD_FLOOT_ACCUMULATIVE_SALE ="accumulativeSale";
	/**业态数*/
	private final String FIELD_FORMAT_NUM ="formatNum";
	/**店铺数*/
	private final String FIELD_STORE_NUM = "storeNum";
	/**出入口个数*/
	private final String FIELD_GATE_NUM = "gateNum";
	/**楼层平面图地址*/
	private final String FIELD_FLOOR_MAP_URL ="floorMapUrl";
	
	
	/**楼层顾客特征--性别分布*/
	private final String REPORT_FLOOR_DAY_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**楼层顾客特征--年龄分布*/
	private final String REPORT_FLOOR_DAY_CUSTOMERFEATURE_AGE ="customerfeature_age";
	/**楼层顾客特征--新老顾客*/
	private final String REPORT_FLOOR_DAY_CUSTOMERFEATURE_NAO ="customerfeature_NAO";
	/**楼层实时客流*/
	private final String REPORT_FLOOR_DAY_HOUR_TRAFFIC = "hourTrafficTrend";
	/**楼层累计客流*/
	private final String REPORT_FLOOR_DAY_HOUR_ACCUMULATIVETRAFFIC ="affumulativeTraffic";
	/**楼层近期趋势*/
	private final String REPORT_FLOOR_DAY_TRAFFICANDSALE_TREND7 = "trafficAndSaleTrend7";
	private final String REPORT_FLOOR_DAY_TRAFFICANDSALE_TREND15 = "trafficAndSaleTrend15";
	private final String REPORT_FLOOR_DAY_TRAFFICANDSALE_TREND30 = "trafficAndSaleTrend30";
	/**楼层店铺排行--客流量*/
	private final String REPORT_FLOOR_DAY_TRAFFICRANK ="trafficRank";
	/**楼层店铺排行--销售额*/
	private final String REPORT_FLOOR_DAY_SALERANK = "saleRank";
	/**楼层店铺排行--进店率*/
	private final String REPORT_FLOOR_DAY_ENTERINGRATERANK = "enteringRateRank";
	/**楼层店铺排行--客单价*/
	private final String REPORT_FLOOR_DAY_PERCUSTOMERTRANSACTIONRANK = "perTransactionRank";
	/**楼层店铺排行--坪效*/
	private final String REPORT_FLOOR_DAY_SALES_PERSQUAREMETERRANK = "perSquareMeterRank";
	/**楼层店铺排行--成交量*/
	private final String REPORT_FLOOR_DAY_TURNOVERRANK = "turnoverRank";
	/**楼层店铺排行--提袋率*/
	private final String REPORT_FLOOR_DAY_HANDBAGRATERANK = "handbagRateRank";
	/**楼层店铺排行--滞留时间 */
	private final String REPORT_FLOOR_DAY_DURATIONTIMERANK = "durationTimeRank";
	/**楼层出入口客流*/
	private final String REPORT_FLOOR_DAY_GATETRAFFIC = "gateTraffic";
	
	
	/**楼层    小时客流数据*/
	private final String KEY_FLOOR_TRAFFIC_HOUR = "hourTraffic";
	/**楼层    外围出入口小时客流数据*/
	private final String KEY_FLOOR_GATE_TRAFFIC_HOUR = "gateHourTraffic";
	/**楼层日报表    天级趋势客流数据(默认近30天)*/
	private final String KEY_FLOOR_TRAFFIC_DAY_TREND = "dayTrafficTrend";
	/**楼层日报表    天级趋势销售数据(默认近30天)*/
	private final String KEY_FLOOR_SALE_DAY_TREND = "daySaleTrend";
	/**楼层       店铺小时客流*/
	private final String KEY_FLOOR_ZONE_DAY_HOUR_TRAFFIC = "floorZoneHourTraffic"; 
	/**商场营业时间*/
	public final String KEY_MALL_OPENTIME = "mallOpenTime";

	/** 楼层面积 */
	private  final String FIELD_FLOOR_OPENED_AREA = "floorArea";
	
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds,  Date startDate, Date endDate,Map<String, Object> dataMap) {
		Long orgId = orgIds[0];
		Date date = startDate;
		Map<String,Object> head = new HashMap<String, Object>();
		List<FloorHourCountData> floorDatas = getOrQueryTodayFloorHourTraffic(orgId, date, dataMap);
		Floor floor =  floorService.selectByPrimaryKey(orgId);
		/** 商场面积 */
		head.put(FIELD_FLOOR_OPENED_AREA,floor.getArea());
		//楼层累计客流
		Integer floorInnum = null;
		if (floorDatas != null && floorDatas.size() > 0) {
			floorInnum = 0;
			for (FloorHourCountData floorHourCountData : floorDatas) {
				floorInnum += floorHourCountData.getInnum();
			}
		}
		head.put(FIELD_FLOOR_ACCUMULATIVE_TRAFFIC, floorInnum);
		//客流占比
		Integer mallInnum = null;
		head.put(FIELD_FLOOR_MAP_URL, floor.getMap());
		if ( floor != null && floor.getMallId() != null) {
			mallInnum = 0;
			Long mallId = floor.getMallId();
			List<MallHourCountData> mallDatas = (List<MallHourCountData>) mallDataService.getHourData(date, mallId);
			if (mallDatas != null && mallDatas.size() >0) {
				for (MallHourCountData mallHourCountData : mallDatas) {
					mallInnum += mallHourCountData.getInnum();
				}
			}
		}
		head.put(FIELD_FLOOR_RATIOOFTRAFFIC,NumberUtil.percentage(floorInnum, mallInnum, 2));

		//有效客流、店员人才、男性顾客人数、女性顾客人数
		Integer effectiveTraffic = null;
		Integer staffTime = null;
		Integer maleTraffic = null;
		Integer femaleTraffic = null;

		//获取系统配置参数
		Long mallId = Optional.ofNullable(floor.getMallId()).orElse(0L);
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

		List<FloorDayFaceRecognitionSta> floorFaceDatas = getOrQueryFloorFaceSta(orgId, date, date, dataMap);
		List<FloorDayFaceRecognitionSta> faceDatas = getOrQueryFloorFaceSta(orgId, startDate, endDate, dataMap);
		if (faceDatas != null && faceDatas.size() > 0) {
			for (FloorDayFaceRecognitionSta faceData : faceDatas) {
				//计算有效客流
				if (effectiveTraffic == null){
					if("0".equals(enableTrafficFlag))
						effectiveTraffic = faceData.getCustomCount();
					else
						effectiveTraffic = faceData.getMaleCount()+faceData.getFemaleCount();
				}else{
					if("0".equals(enableTrafficFlag))
						effectiveTraffic = faceData.getCustomCount();
					else
						effectiveTraffic = faceData.getMaleCount()+faceData.getFemaleCount();
				}

				if(faceData.getStaffCount() != null){
					if (staffTime == null)
						staffTime = faceData.getStaffMantime();
					else
						staffTime += faceData.getStaffMantime();
				}
				if(faceData.getMaleCount() != null){
					if (maleTraffic == null)
						maleTraffic = faceData.getMaleCount();
					else
						maleTraffic += faceData.getMaleCount();
				}
				if(faceData.getFemaleCount() != null){
					if (femaleTraffic == null)
						femaleTraffic = faceData.getFemaleCount();
					else
						femaleTraffic += faceData.getFemaleCount();
				}
			}
		}
		head.put(FIELD_ENABLE_INNUM,effectiveTraffic);
		head.put(FIELD_STAFF_INNUM,staffTime);
		head.put(FIELD_MALE_INNUM,maleTraffic);
		head.put(FIELD_FEMALE_INNUM,femaleTraffic);

		//累计销售额
		Double saleNum = null;
		List<Sale> sales = getOrQueryTodayFloorSale(orgId, date, dataMap);
		if (sales != null && sales.size() > 0) {
			saleNum = 0.0;
			for (Sale sale : sales) {
				saleNum += sale.getMoney();
			}
		}
		head.put(FIELD_FLOOT_ACCUMULATIVE_SALE, saleNum);
		//业态数
		Integer formatNum = null, zoneNum = null;
		Map<Long, Zone> zoneMaps = getOrQueryFloorZoneMaps(orgId, dataMap);
		Set<Long> formats = new HashSet<Long>();
		if (zoneMaps != null && zoneMaps.size() > 0) {
			for (Zone zone : zoneMaps.values()) {
				formats.add(zone.getFormatId());
			}
			zoneNum = zoneMaps.size();
			formatNum = formats.size();
		}
		head.put(FIELD_FORMAT_NUM, formatNum);
		//店铺数
		head.put(FIELD_STORE_NUM, zoneNum);
		//出入口
		Integer gateNum = null;
		Map<Long,Gate> gates = getOrQueryGatesMap(orgId, dataMap);
		if (gates != null && gates.size() > 0) {
			gateNum = gates.size();
		}
		head.put(FIELD_GATE_NUM, gateNum);
		
		//楼层分布详细信息
		List<ZoneVo> zoneDetails = floorDetail(orgId, dataMap);
		head.put(CHART_DETAIL_DATA, zoneDetails);
		//楼层业态列表
		Map<String, Set<Brand>> floorBrandsMap = new HashMap<String, Set<Brand>>();
		for (ZoneVo zoneVo : zoneDetails) {
			if(zoneVo.getBrand() == null) continue; //品牌不存在 跳过
			String key = zoneVo.getBrand().getName();
			Brand brand = getOrQueryBrandById(zoneVo.getBrandId(), dataMap);
			Set<Brand> values = floorBrandsMap.get(key);
			if (values == null) {
				values = new HashSet<Brand>();
			}
			values.add(brand);
			floorBrandsMap.put(key, values);
		}
		head.put(KEY_FLOOR_BRAND, floorBrandsMap);
		return head;
	}
	

	@Override
	public Chart getChart(Long[] orgIds,  Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_FLOOR_DAY_CUSTOMERFEATURE_GENDER:/**楼层顾客特征--性别分布*/
			chart =  genderDistributionReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_CUSTOMERFEATURE_AGE:/**楼层顾客特征--年龄分布*/
			chart = ageDistributionReport(orgId, date, dataMap, reportChart);		
			break;
		case REPORT_FLOOR_DAY_CUSTOMERFEATURE_NAO:/**楼层顾客特征--新老顾客*/
			//chart = visitorStatisticReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_HOUR_TRAFFIC:/**楼层实时客流*/
			chart = trafficCountingReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_HOUR_ACCUMULATIVETRAFFIC:/**楼层累计客流*/
			chart = trafficAddReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_TRAFFICANDSALE_TREND7:	/**楼层近期趋势*/
			chart = trafficAndSaleTrendReport(orgId, date, dataMap, reportChart, -6);
			break;
		case REPORT_FLOOR_DAY_TRAFFICANDSALE_TREND15:	/**楼层近期趋势*/
			chart = trafficAndSaleTrendReport(orgId, date, dataMap, reportChart, -14);
			break;
		case REPORT_FLOOR_DAY_TRAFFICANDSALE_TREND30:	/**楼层近期趋势*/
			chart = trafficAndSaleTrendReport(orgId, date, dataMap, reportChart, -29);
			break;
		case REPORT_FLOOR_DAY_TRAFFICRANK:/**楼层店铺排行--客流量*/
			chart = trafficRankReport(orgId, date, dataMap, reportChart);	
			break;
		case REPORT_FLOOR_DAY_SALERANK:/**楼层店铺排行--销售额*/
			chart = salesRankReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_ENTERINGRATERANK:/**楼层店铺排行--进店率*/
			chart = enteringRateReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_PERCUSTOMERTRANSACTIONRANK:/**楼层店铺排行--客单价*/
			chart = perPriceTransactionReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_SALES_PERSQUAREMETERRANK:/**楼层店铺排行--坪效*/
			chart = perAreaValueReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_TURNOVERRANK:/**楼层店铺排行--成交量*/
			chart = saleCountReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_HANDBAGRATERANK:/**楼层店铺排行--提袋率*/
			chart = handbagRateReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_DURATIONTIMERANK:/**楼层店铺排行--滞留时间 */
			chart = durationTimeReport(orgId, date, dataMap, reportChart);
			break;
		case REPORT_FLOOR_DAY_GATETRAFFIC:/**楼层出入口客流*/
			chart = gateTrafficReport(orgId, date, dataMap, reportChart);
			break;
		default:
			break;
		}
		
		return chart;
	}
	/**楼层出入口客流*/
	private Chart gateTrafficReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		List<GateHourCountData> datas = getOrQueryGateHourTraffic(orgId, date, dataMap);
		if (datas != null && datas.size() > 0) {
			Map<Long, Gate> gateMap = getOrQueryGatesMap(orgId, dataMap);
			for (GateHourCountData gateHourCountData : datas) {
				Long gateId = gateHourCountData.getGateId();
				Gate gate = gateMap.get(gateId);
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(gate.getName(), gateHourCountData.getInnum().intValue());
			}
		}
		
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null ) o1 = Integer.MIN_VALUE;
				if (o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--滞留时间       滞留时间 = （总进人数 - 总出人数）* 统计时间单位 / 进店总人数   */
	private Chart durationTimeReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.DURATIONTIME.toString());
		Map<Long, List<ZoneHourCountData>> zoneDataMap =  getOrQueryTodayZoneHourTraffic(orgId, date, dataMap);
		
		for(Entry<Long, List<ZoneHourCountData>> entry: zoneDataMap.entrySet()){
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if ( zone == null || zone.getName() == null) {
				continue;
			}
			int allInnum = 0,allOutnum = 0,allDurationTime = 0; 
			for (ZoneHourCountData zoneHourCountData : entry.getValue()) {
				allInnum += zoneHourCountData.getInnum();
				allOutnum += zoneHourCountData.getOutnum();
				int durationNum = allInnum-allOutnum;
				if (allInnum-allOutnum < 0 ) {
					durationNum = 0;
				}
				allDurationTime += durationNum;
			}
			chart.getSeries(ParamName.DURATIONTIME.toString()).adjustOrPutValueByCoordinate(zone.getName(), 
					NumberUtil.divide(allDurationTime, allInnum, 2));
		}
		chart.sort(ParamName.DURATIONTIME.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--提袋率*/
	private Chart handbagRateReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.HANDBAGRATE.toString());
		
		List<Sale> sales = getOrQueryTodayFloorSale(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				int takebagNum = sale.getSalecount();
				int inNum = 1;
				List<ZoneHourCountData> zoneDatas = getOrQueryTodayZoneHourTrafficById(zoneId, orgId, date, dataMap);
				if (zoneDatas != null && zoneDatas.size() > 0) {
					inNum = 0;
					for (ZoneHourCountData zoneHourCountData : zoneDatas) {
						inNum += zoneHourCountData.getInnum();
					}
				}
				chart.getSeries(ParamName.HANDBAGRATE.toString()).adjustOrPutValueByCoordinate(zone.getName(),
						NumberUtil.percentage(takebagNum, inNum, 2));
			}
		}
		chart.sort(ParamName.HANDBAGRATE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--成交量*/
	private Chart saleCountReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.ORDER.toString());
		List<Sale> sales = getOrQueryTodayFloorSale(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				chart.getSeries(ParamName.ORDER.toString()).adjustOrPutValueByCoordinate(zone.getName(),sale.getSalecount());
			}
		}
		chart.sort(ParamName.ORDER.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null ) o1 = Integer.MIN_VALUE;
				if (o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--坪效*/
	private Chart perAreaValueReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PERAREAVALUE.toString());
		List<Sale> sales = getOrQueryTodayFloorSale(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				float area = zone.getArea();
				chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(zone.getName(), 
						NumberUtil.divide(sale.getMoney(), area, 2));
			}
		}
		chart.sort(ParamName.PERAREAVALUE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--客单价*/
	private Chart perPriceTransactionReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PREPRICE.toString());
		
		List<Sale> sales = getOrQueryTodayFloorSale(orgId, date, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if(zone != null ){
				Double perPrice = NumberUtil.divide(sale.getMoney(), sale.getSalecount(), 2);
				chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(zone.getName() ,perPrice);
			}
		}
		chart.sort(ParamName.PREPRICE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--进店率*/
	private Chart enteringRateReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		
		Axis< String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.ENTERINGRATE.toString());
		
		Map<Long,List<ZoneHourCountData>> zoneDatas =  getOrQueryTodayZoneHourTraffic(orgId, date, dataMap);
		for (Entry<Long,List<ZoneHourCountData>> entry: zoneDatas.entrySet()) {
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone == null || zone.getName() == null) {
				continue;
			}
			List<ZoneHourCountData> dates = entry.getValue();
			int allInum = 0;//店铺总近店人数
			int allNum = 1;//总经过人数
			for (ZoneHourCountData zoneHourCountData : dates) {
				allNum += (zoneHourCountData.getOutsideInnum()+zoneHourCountData.getOutsideOutnum());
				allInum += zoneHourCountData.getInnum();
			}
			
			chart.getSeries(ParamName.ENTERINGRATE.toString()).adjustOrPutValueByCoordinate(
					zone.getName(),NumberUtil.percentage(allInum, allNum, 2));
		}
		chart.sort(ParamName.ENTERINGRATE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--销售额*/
	private Chart salesRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.SALES.toString());
		
		List<Sale> sales = getOrQueryTodayFloorSale(orgId, date, dataMap);
		if (sales != null && sales.size() >0 ) {
			for (Sale sale : sales) {
				Long zoneId = sale.getZoneId();
				Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
				if (zone != null ) {
					chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(zone.getName(), sale.getMoney());
				}
			}
		}
		
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--客流量*/
	private Chart trafficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		// 客流量
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		Map<Long,List<ZoneHourCountData>>  trafficMap =   getOrQueryTodayZoneHourTraffic(orgId, date, dataMap);
		for (Entry<Long, List<ZoneHourCountData>> entry: trafficMap.entrySet()) {
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone == null || zone.getName() == null) {
				continue;
			}
			int zoneInnum = 0;
			for (ZoneHourCountData zoneHourCountData : entry.getValue()) {
				zoneInnum += zoneHourCountData.getInnum();
			}
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(zone.getName(),zoneInnum);
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null ) o1 = Integer.MIN_VALUE;
				if (o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层近期趋势*/
	private Chart trafficAndSaleTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		chart.createSeries(ParamName.SALES.toString(), SeriesType.line);
		// 客流量
		List<FloorDayCountData> floorDayTraffic = getTrafficTrendData(orgId,  date, dataMap);
		List<Date> dates = DateUtil.getDaysBetweenDates(beforeDate, date);
		for (FloorDayCountData floorDayCountData : floorDayTraffic) {
			Date dataTime = floorDayCountData.getCountdate();
			if (dates.contains(dataTime)) {
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(floorDayCountData.getCountdate(), floorDayCountData.getInnum());
			}
		}
		//销售额
		List<Sale> sales = getOrQueryFloorSaleTrend(orgId, date, dataMap);
		for (Sale sale : sales) {
			Date saleDate = sale.getSaledate();
			if (dates.contains(saleDate)) {
				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
			}
		}
		
		return chart;
	}

	/**楼层累计客流*/
	private Chart trafficAddReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line) {
			@Override
			public Object calcValue(String name,int index, List data) {
				Double result = null;
				if (data.get(index) != null) {
					result = Double.parseDouble(data.get(index).toString());
					if(index==0){
						return result;
					}
					int pre = index;
					while((--pre) > 0){
						if(data.get(pre) == null){
							continue;
						}
						result += Double.parseDouble(data.get(pre).toString());
						break;
					}
				}
				return result;
			}
		};
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = floorReportDataService.getMallOpentimesByOrgId(orgId,null ,dataMap);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);

		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());

		List<FloorHourCountData> floorHourCountDatas = (List<FloorHourCountData>) getOrQueryFloorHourTraffic(orgId, date, dataMap);

		for (FloorHourCountData floorHourCountData : floorHourCountDatas) {
			Date dateTemp = floorHourCountData.getCountdate();
			DateType dateType = DateType.valueOfDay(date, dateTemp);
			Date counttime = floorHourCountData.getCounttime();
			chart.getSeries(dateType.toString()).adjustOrPutValueByCoordinate(counttime, floorHourCountData.getInnum());
		}
		return chart;
	}

	/**楼层实时客流*/
	private Chart trafficCountingReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = floorReportDataService.getMallOpentimesByOrgId(orgId,null,dataMap);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);

		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());

		List<FloorHourCountData> floorHourCountDatas =  getOrQueryFloorHourTraffic(orgId, date, dataMap);

		for (FloorHourCountData floorHourCountData : floorHourCountDatas) {
			Date countData = floorHourCountData.getCountdate();
			DateType dateType = DateType.valueOfDay(date, countData);
			Date counttime = floorHourCountData.getCounttime();
			chart.getSeries(dateType.toString()).adjustOrPutValueByCoordinate(counttime, floorHourCountData.getInnum());

		}
		return chart;
	}



	/**楼层顾客特征--年龄分布*/
	private Chart ageDistributionReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		String[] ages = ageStage.split(",");
		List<Integer> ageStages = new ArrayList<>();
		for (String age : ages) {
			Integer ageInt = Integer.parseInt(age);
			ageStages.add(ageInt);
		}
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
		Axis<String> axis = AxisFactory.createStringAxis();
		axis.addData(ageThresholdName);
		chart.setXAxis(axis);
		
		List<FloorDayFaceRecognitionSta> ageSta =  getOrQueryFloorFaceSta(orgId,date,date,dataMap);
		
		if (ageSta != null && ageSta.size() >0) {
			for (FloorDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);

				if (maleAgestatic.length != femaleAgestatic.length) {
					continue;
				}
				
				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
					int maleNum = Integer.parseInt("" + maleAgestatic[rangeNum].trim());
					int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					/*chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);*/
					chart.getSeries(ParamName.MALEAGEDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ageRange, maleNum);
					chart.getSeries(ParamName.FEMALEAGEDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ageRange, femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}
			}
		}
		return chart;
	}

	/**楼层顾客特征--性别分布*/
	private Chart genderDistributionReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
		
		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());

		List<FloorDayFaceRecognitionSta> datas = getOrQueryFloorFaceSta(orgId,date,date,dataMap);
		
		for (FloorDayFaceRecognitionSta faceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),faceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), faceRecognitionSta.getMaleCount());
		}
		return chart;
	}
	
	
	
	/**楼层外围监控点当天的小时级客流数据*/
	 @SuppressWarnings("unchecked")
	List<GateHourCountData> getOrQueryGateHourTraffic(Long orgId,Date date,Map<String,Object> dataMap){
		List<GateHourCountData> datas = (List<GateHourCountData>) dataMap.get(KEY_FLOOR_GATE_TRAFFIC_HOUR);
		if (datas ==  null) {
			datas = new ArrayList<GateHourCountData>();
			Map<Long, Gate> gateMaps = getOrQueryGatesMap(orgId, dataMap);
			if (gateMaps != null && gateMaps.size() > 0) {
				List<Long> gateIds = new ArrayList<Long>();
				for (Long gateId : gateMaps.keySet()) {
					gateIds.add(gateId);
				}
				datas = (List<GateHourCountData>) gateDataService.getHourData(date, gateIds);
			}
			dataMap.put(KEY_FLOOR_GATE_TRAFFIC_HOUR, datas);
		}
		return datas;
	}
	
	/**根据店铺id获取店铺的客流量*/
	private List<ZoneHourCountData> getOrQueryTodayZoneHourTrafficById(Long zoneId,Long floorId,Date date,Map<String,Object> dataMap){
		Map<Long,List<ZoneHourCountData>> datas = (Map<Long, List<ZoneHourCountData>>) dataMap.get(KEY_FLOOR_ZONE_DAY_HOUR_TRAFFIC);
		if (datas == null) {
			datas = getOrQueryTodayZoneHourTraffic(floorId, date, dataMap);
		}
		return datas.get(zoneId);
	}

	/**获取楼层当天的小时级数据*/
	private List<FloorHourCountData> getOrQueryTodayFloorHourTraffic(Long floorId,Date date,Map<String,Object> dataMap){
		 List<FloorHourCountData>  floorDatas = (List<FloorHourCountData>)dataMap.get(KEY_FLOOR_TRAFFIC_HOUR);
		if (floorDatas == null) {
			floorDatas = getOrQueryFloorHourTraffic(floorId, date, dataMap);
		}
		List<FloorHourCountData> todayDatas = new ArrayList<FloorHourCountData>();
		for (FloorHourCountData floorHourCountData : floorDatas) {
			DateType dateType = DateType.valueOfDay(date, floorHourCountData.getCountdate());
			if (dateType == DateType.TODAY) {
				todayDatas.add(floorHourCountData);
			}
		}
		return todayDatas;
	}
	
	/**获取楼层的小时级数据  当天   昨天  上周同期     上月同期    上年同期*/
	private List<FloorHourCountData> getOrQueryFloorHourTraffic(Long floorId,Date date,Map<String,Object> dataMap){
		List<FloorHourCountData> hourDatas = (List<FloorHourCountData>) dataMap.get(KEY_FLOOR_TRAFFIC_HOUR);
		if (hourDatas == null) {
			List<Date> dates = new ArrayList<Date>();
			dates.add(date);
			Date yesterday = DateUtil.getYesterday(date);
			dates.add(yesterday);
			Date lastWeekDay = DateUtil.getLastWeek(date);
			dates.add(lastWeekDay);
			Date lastMontdDay = DateUtil.getLastMonth(date);
			dates.add(lastMontdDay);
			Date lastYearDay = DateUtil.getLastYear(date);
			dates.add(lastYearDay);
			
			hourDatas = (List<FloorHourCountData>) floorDataService.getHourData(dates,floorId);
			
			dataMap.put(KEY_FLOOR_TRAFFIC_HOUR, hourDatas);
		}
		return hourDatas;
	}
	
	/**楼层中当天店铺的客流量(小时级)*/
	private Map<Long,List<ZoneHourCountData>> getOrQueryTodayZoneHourTraffic(Long floorId,Date date,Map<String,Object> dataMap){
		Map<Long,List<ZoneHourCountData>> datas = (Map<Long, List<ZoneHourCountData>>) dataMap.get(KEY_FLOOR_ZONE_DAY_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new HashMap<Long, List<ZoneHourCountData>>();
			Map<Long,Zone> zoneMaps =  getOrQueryFloorZoneMaps(floorId, dataMap);
			List<Long> zoneIds = new ArrayList<Long>(zoneMaps.keySet());
		    List<ZoneHourCountData>	zoneDatas = (List<ZoneHourCountData>) zoneDataService.getHourData(date, zoneIds);
		    if (zoneDatas != null && zoneDatas.size() > 0) {
		    	for (ZoneHourCountData zoneHourCountData : zoneDatas) {
			    	Long zoneId = zoneHourCountData.getZoneId();
			    	List<ZoneHourCountData> zoneDataList = datas.get(zoneId) ;
			    	if (zoneDataList == null || zoneDataList.size() == 0) {
						zoneDataList = new ArrayList<ZoneHourCountData>();
					}
			    	zoneDataList.add(zoneHourCountData);
					datas.put(zoneId, zoneDataList);
				}
			}else {
				zoneDatas = new ArrayList<ZoneHourCountData>();
			}
			dataMap.put(KEY_FLOOR_ZONE_DAY_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**楼层日报表  天级客流数据（近n天 默认30天）*/
	private List<FloorDayCountData> getTrafficTrendData(Long floorId,Date date,Map<String,Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_TRAFFIC_DAY_TREND);
		if ( datas == null) {
			Date beforeDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);// 向前推n天的日期
			datas = getOrQueryFloorDayTraffic(floorId, beforeDate, date, dataMap);
			dataMap.put(KEY_FLOOR_TRAFFIC_DAY_TREND, datas);
		}
		return datas;
	} 
	
	/**获取当天销售数据*/
	public List<Sale> getOrQueryTodayFloorSale(Long floorId,Date date,Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_SALE);
		if (sales == null) {
			Date befort30 = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			sales = getOrQueryFloorSale(floorId, befort30, date, dataMap);
		}
		List<Sale> todaySales = new ArrayList<Sale>();
		if (sales != null && sales.size() > 0) {
			for (Sale sale : sales) {
				if (DateUtil.isSameDay(date, sale.getSaledate())) {
					todaySales.add(sale);
				}
			}
		}
		return todaySales;
	}
	
	/**获取楼层的销售数据趋势(近30天)*/
	public List<Sale> getOrQueryFloorSaleTrend(Long floorId,Date date,Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_SALE_DAY_TREND);
		if (sales == null) {
			Date befort30 = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);
			sales = getOrQueryFloorSale(floorId, befort30, date, dataMap);
			dataMap.put(KEY_FLOOR_SALE_DAY_TREND, sales);
		}
		return sales;
	}
	


	
}
