package com.viontech.mall.report.service.impl;

import com.viontech.keliu.base.BaseModel;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.service.adapter.FloorDataService;
import com.viontech.mall.service.adapter.FloorDayCountDataService;
import com.viontech.mall.service.adapter.FloorDayFaceRecognitionStaService;
import com.viontech.mall.service.adapter.FloorHourCountDataService;
import com.viontech.mall.service.adapter.FloorMinuteCountDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
public class FloorDataServiceImpl extends BaseDataServiceImpl implements FloorDataService {
	@Resource
	private FloorDayCountDataService floorDayCountDataService;
	@Resource
	private FloorHourCountDataService floorHourCountDataService;
	@Resource
	private FloorMinuteCountDataService floorMinuteCountDataService;
	@Resource
    private FloorDayFaceRecognitionStaService floorDayFaceRecognitionStaService;
	@Resource
	private FloorDayFaceRecognitionStaService floorHourFaceRecognitionStaService;
	/**
	 * dates 指定的时间刻度（单位分钟）
	 * ids  指定的楼层id
	 */
	@Override
	public List<? extends BaseModel> getMinuteData(List<Date> dates, List<Long> ids) {
		FloorMinuteCountDataExample floorMinuteCountDataExample = new FloorMinuteCountDataExample();
		floorMinuteCountDataExample.createColumns();
		FloorMinuteCountDataExample.Criteria criteria = floorMinuteCountDataExample.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andFloorIdEqualTo(ids.get(0));
		}else if (ids != null && ids.size() > 1) {
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if (dates != null && dates.size() > 1){
			criteria.andCountdateIn(dates);
		}
		floorMinuteCountDataExample.setOrderByClause(floorMinuteCountDataExample.getTableAlias()+".counttime asc");
		List<FloorMinuteCountData> floorMinuteCountDataList = floorMinuteCountDataService.selectByExample(floorMinuteCountDataExample);
		return floorMinuteCountDataList;
	}

	@Override
	public List<? extends BaseModel> getHourData(List<Date> dates, List<Long> ids) {
		FloorHourCountDataExample floorHourCountDataExample = new FloorHourCountDataExample();
		floorHourCountDataExample.createColumns();
		FloorHourCountDataExample.Criteria criteria = floorHourCountDataExample.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andFloorIdEqualTo(ids.get(0));
		}else   if (ids != null && ids.size() > 1) {
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if (dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		floorHourCountDataExample.setOrderByClause(floorHourCountDataExample.getTableAlias()+".counttime asc");
		List<FloorHourCountData> floorHourCountDataList = floorHourCountDataService.selectByExample(floorHourCountDataExample);
		return floorHourCountDataList;
	}

	@Override
	public List<? extends BaseModel> getDayData(List<Date> dates, List<Long> ids) {
		FloorDayCountDataExample floorDayCountDataExample = new FloorDayCountDataExample();
		floorDayCountDataExample.createColumns();
		FloorDayCountDataExample.Criteria criteria = floorDayCountDataExample.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andFloorIdEqualTo(ids.get(0));
		}else if (ids != null && ids.size() > 1) {
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		floorDayCountDataExample.setOrderByClause(floorDayCountDataExample.getTableAlias()+".counttime asc");
		List<FloorDayCountData> floorDayCountDataList = floorDayCountDataService.selectByExample(floorDayCountDataExample);
		return floorDayCountDataList;
	}


	@Override
	public List<? extends BaseModel> getDaysData(List<DateCriteria> dates, List<Long> ids) {
		FloorDayCountDataExample floorDayCountDataExample = new FloorDayCountDataExample();
		floorDayCountDataExample.createColumns();
		FloorDayCountDataExample.Criteria criteria = floorDayCountDataExample.createCriteria();
		if(ids != null && ids.size() > 0){
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		floorDayCountDataExample.setOrderByClause(floorDayCountDataExample.getTableAlias()+".counttime asc");
		List<FloorDayCountData> floorDayCountDataList = floorDayCountDataService.selectByExample(floorDayCountDataExample);
		return floorDayCountDataList;
	}

	@Override
	public List<? extends BaseModel> getFaceDayData(List<Date> dates, List<Long> ids) {
		FloorDayFaceRecognitionStaExample example = new FloorDayFaceRecognitionStaExample();
		example.createColumns();
		FloorDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andFloorIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCountdateEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCountdateIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".countdate asc");
		return floorDayFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceHourData(List<Date> dates, List<Long> ids) {
		FloorHourFaceRecognitionStaExample example = new FloorHourFaceRecognitionStaExample();
		example.createColumns();
		FloorHourFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andFloorIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() ==1) {
			criteria.andCounttimeEqualTo(dates.get(0));
		}else if(dates != null && dates.size() > 1) {
			criteria.andCounttimeIn(dates);
		}
		example.setOrderByClause(example.getTableAlias()+".counttime asc");
		return floorHourFaceRecognitionStaService.selectByExample(example);
	}

	@Override
	public List<? extends BaseModel> getFaceDaysData(List<DateCriteria> dates, List<Long> ids) {
		FloorDayFaceRecognitionStaExample example = new FloorDayFaceRecognitionStaExample();
		example.createColumns();
		FloorDayFaceRecognitionStaExample.Criteria criteria = example.createCriteria();
		if (ids != null && ids.size() == 1) {
			criteria.andFloorIdEqualTo(ids.get(0));
		}else  if(ids != null && ids.size() > 1) {
			criteria.andFloorIdIn(ids);
		}
		if (dates != null && dates.size() > 0) {
			for (DateCriteria date2 : dates) {
				Date start = date2.getStartDate();
				Date end = date2.getEndDate();
				criteria.andCountdateBetween(start, end);
			}
		}
		example.setOrderByClause(example.getTableAlias()+".countdate asc");
		return floorDayFaceRecognitionStaService.selectByExample(example);
	}
	
	
}