package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.GateHourFaceRecognitionStaService;
import com.viontech.mall.service.adapter.GateService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 客群分时统计统计
 * @author dugw
 *
 */
@Service
public class FaceCountAnalyzeStaReportServiceImp extends ChartReportBaseService {

	@Value("${Age.stage}")
	private String ageStage;
	
	@Resource
	private GateHourFaceRecognitionStaService gateHourFaceRecognitionStaService;
	
	@Resource
	private GateService gateService;

	@Resource
	private MallReportDataService mallReportDataService;
	

	private final static String PARAM_DIC_GENDER = "gender";

	private final static short PARAM_PERSON_TYPE = 0;//只获取顾客数据

	private final static short PARAM_DIRECTION = 1;//只获取进入方向的抓拍数据
	
	private final static String FELID_GATE_HAS_FACE="gatesHasFace";
	
	private final static String FELID_FACE_DATA_UNIQ="uniqFaceDatas";

	private final static String FELID_FACE_DATA = "faceDatas";
	
	/**
	 * 人脸性别统计详情
	 */
	private final static  String  REPORT_FACE_GENDER_DETAILE = "faceGenderDetail";
	/**
	 * 人脸年龄统计详情
	 */
	private final static  String  REPORT_FACE_AGE_DETAILE = "faceAgeDetail";
	
	
	
	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		if(dataMap.get("orgIds")==null) {
			dataMap.put("orgIds",orgIds);
		}
		//得到需要获取数据的监控点
		Long[] gateIds = getGateHasFace(orgIds, dataMap);
		if(gateIds == null || gateIds.length == 0) {
			return null;
		}
		//获取监控点的人脸数据
		List<GateHourFaceRecognitionSta> faceDatas = getFaceDatas(gateIds, startDate, endDate, dataMap);
		
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_FACE_GENDER_DETAILE:
			chart = faceCountGenderDetailReport(faceDatas, dataMap, reportChart);
			break;
		case REPORT_FACE_AGE_DETAILE:
			chart = faceCountAgeDetailReport(faceDatas, dataMap, reportChart);
			break;
		default:
			break;
		}
		return chart;
	}
	/**
	 * 人脸年龄统计详情
	 * @param faceDatas
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart faceCountAgeDetailReport(List<GateHourFaceRecognitionSta> faceDatas, Map<String, Object> dataMap, ReportChart reportChart){


		String[] ages = ageStage.split(",");
		List<Integer> ageStages = new ArrayList<>();
		for (String age : ages) {
			Integer ageInt = Integer.parseInt(age);
			ageStages.add(ageInt);
		}
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
		final String time = LocalMessageUtil.getMessage("DateMessage.time");
		final String total = LocalMessageUtil.getMessage("CountMessage.total");



		List<String> tableheads = new ArrayList<String>();
		tableheads.add(time);
		tableheads.addAll(Arrays.asList(ageThresholdName));
		tableheads.add(total);

        Table table = new Table(reportChart.getTitle()){
            @Override
            public Object calcValue(String name, int index, List data_raw) {
                int index_total = getIndexByTableHead(total);
                int index_time = getIndexByTableHead(time);
                if(index_total == index){
                    int totalNum = 0 ;
                    for (String tableHead : tableheads) {
                        int index_head = getIndexByTableHead(tableHead);
                        if(index_head == index_total || index_head == index_time) {
							continue;
						}
                        int value = data_raw.get(index_head) == null ? 0 :(Integer)data_raw.get(index_head);
                        totalNum += value;
                    }
                    return totalNum;
                }else{
                    if(data_raw.get(index) == null) {
						return 0;
					}
                }
                return super.calcValue(name, index, data_raw);
            }

        };

		//表头
		TableHead tableHead = new TableHead();
		for (String head : tableheads) {
			tableHead.addData(head);
		}
		table.setTableHead(tableHead);

		BaseDataServiceImpl.DateCriteria dateCriteria = new BaseDataServiceImpl.DateCriteria();
		Long[] orgIds = (Long[])dataMap.get("orgIds");
		dateCriteria = mallReportDataService.getMallOpentimesByOrgId(orgIds[0], OrgType.mall, dataMap);
		Date openTime = dateCriteria.getStartDate();
		Date closeTime = dateCriteria.getEndDate();
		Date currentTime = openTime;

		while(currentTime.before(closeTime) || currentTime.equals(closeTime)){
			String dateStr = DateUtil.format("HH:00",currentTime);
			table.getRow(dateStr).putValueByHeadColumn(time,dateStr);
			currentTime = DateUtil.addHours(currentTime,1);
		}

		for (GateHourFaceRecognitionSta face : faceDatas) {
			Date date = face.getCounttime();
			String dateStr = DateUtil.format("HH:00",date);
			//table.getRow(dateStr).putValueByHeadColumn(time, dateStr);

            String maleStage = face.getMaleStage();
            String femaleStage = face.getFemaleStage();
            if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
                continue;
            }
            String[] maleAgestatic = maleStage.split(",", -2);
            String[] femaleAgestatic = femaleStage.split(",", -2);
            if (maleAgestatic.length != femaleAgestatic.length) {
                continue;
            }
            for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
                int maleNum = Integer.parseInt("" + maleAgestatic[rangeNum].trim());
                int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
                String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
                table.getRow(dateStr).adjustOrPutValueByHeadColumn(ageRange,NumberUtil.valueAdd(maleNum,femaleNum));
            }
		}
/*		table.sort(new Comparator<Series>() {
			@Override
			public int compare(Series s1, Series s2) {
				if(s1 == null) 
					return 0;
				if(s2 == null) 
					return 0;
				String o1 = (String) s1.getValueByCoordinate(time);
				String o2 = (String) s2.getValueByCoordinate(time);
				return DateUtil.compareDate("HH:00", o1, o2);
			}
		});*/
		return table;
	}
	/**
	 * 人脸性别统计详情
	 * @param faceDatas
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart faceCountGenderDetailReport(List<GateHourFaceRecognitionSta> faceDatas, Map<String, Object> dataMap, ReportChart reportChart){
		final String time = LocalMessageUtil.getMessage("DateMessage.time");
		final String male = LocalMessageUtil.getMessage("ParamName.male");
		final String female = LocalMessageUtil.getMessage("ParamName.female");
		final String total = LocalMessageUtil.getMessage("Face.allCount");
		final String personTime = LocalMessageUtil.getMessage("Face.allTime");
	
		Table table = new Table(reportChart.getTitle());
		//表头
		TableHead tableHead = new TableHead();
		tableHead.addData(time);
		tableHead.addData(personTime);
		tableHead.addData(total);
		tableHead.addData(male);
		tableHead.addData(female);
		table.setTableHead(tableHead);


		BaseDataServiceImpl.DateCriteria dateCriteria = new BaseDataServiceImpl.DateCriteria();
		Long[] orgIds = (Long[])dataMap.get("orgIds");
		dateCriteria = mallReportDataService.getMallOpentimesByOrgId(orgIds[0], OrgType.mall, dataMap);
		Date openTime = dateCriteria.getStartDate();
		Date closeTime = dateCriteria.getEndDate();
		Date currentTime = openTime;

		while(currentTime.before(closeTime)|| currentTime.equals(closeTime)){
			String dateStr = DateUtil.format("HH:00",currentTime);
			table.getRow(dateStr).putValueByHeadColumn(time,dateStr);
			currentTime = DateUtil.addHours(currentTime,1);
		}

		for (GateHourFaceRecognitionSta faceData : faceDatas) {
			Date date = faceData.getCounttime();
			String dateStr = DateUtil.format("HH:00",date);
            table.getRow(dateStr).adjustOrPutValueByHeadColumn(personTime, faceData.getCustomMantime());
            table.getRow(dateStr).adjustOrPutValueByHeadColumn(total, faceData.getCustomCount());
            table.getRow(dateStr).adjustOrPutValueByHeadColumn(male, faceData.getMaleCount());
            table.getRow(dateStr).adjustOrPutValueByHeadColumn(female, faceData.getFemaleCount());

        }

/*		table.sort(new Comparator<Series>() {
			@Override
			public int compare(Series s1, Series s2) {
				if(s1 == null) 
					return 0;
				if(s2 == null) 
					return 0;
				String o1 = (String) s1.getValueByCoordinate(time);
				String o2 = (String) s2.getValueByCoordinate(time);
				return DateUtil.compareDate("HH:00", o1, o2);
			}
		});*/
		return table;
	}
	
	/**
	 * 获取有人脸的监控点
	 * @param orgIds
	 * @param dataMap
	 * @return
	 */
	private Long[] getGateHasFace(Long[] orgIds,Map<String, Object> dataMap){
		Long[] gateIds = (Long[]) dataMap.get(FELID_GATE_HAS_FACE);
		if(gateIds == null){
			OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
			GateExample gateExample = new GateExample();
			if(orgType == OrgType.mall){
				gateExample.createCriteria().andIsHasFaceEqualTo(PARAM_GATE_HAS_FACE).andMallIdIn(Arrays.asList(orgIds));
				List<Gate> hasFaceGates = gateService.selectByExample(gateExample);
				if(hasFaceGates == null) {
					return null;
				}
				gateIds = new Long[hasFaceGates.size()];
				for (int i = 0; i < hasFaceGates.size(); i++) {
					gateIds[i] =  hasFaceGates.get(i).getId();
				}
			}else if(orgType == OrgType.gate){
				gateIds = orgIds;
			}
			dataMap.put(FELID_GATE_HAS_FACE, gateIds);
		}
		
		return gateIds;
	}
	
	/**
	 * 获取人脸抓拍表的数据
	 * @param gateIds
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @return
	 */
	private List<GateHourFaceRecognitionSta> getFaceDatas(Long[] gateIds,Date startDate, Date endDate, Map<String, Object> dataMap){
		List<GateHourFaceRecognitionSta> faceDatas = (List<GateHourFaceRecognitionSta>) dataMap.get(FELID_FACE_DATA);
		if(faceDatas == null){
			faceDatas = new ArrayList<>();
			if(gateIds == null) {
				return faceDatas;
			}
			GateHourFaceRecognitionStaExample faceRecognitionExample = new GateHourFaceRecognitionStaExample();
			faceRecognitionExample.createCriteria().andGateIdIn(Arrays.asList(gateIds)).andCounttimeBetween(startDate,endDate);
            faceDatas = gateHourFaceRecognitionStaService.selectByExample(faceRecognitionExample);
			dataMap.put(FELID_FACE_DATA, faceDatas);
		}
		return faceDatas;
	}
	
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
