package com.viontech.mall.report.service.impl;

import com.viontech.mall.model.MallDayFaceRecognitionSta;
import com.viontech.mall.model.MallDayFaceRecognitionStaExample;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.service.adapter.MallDayFaceRecognitionStaService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 客群统计
 *
 * @author dugw
 */
@Service
public class FaceAnalyzeStaReportServiceImp extends AbstractFaceAnalyzeStaReportServiceImpl {

    private final static String FELID_FACE_DATA="mallFaceDatas";

    @Resource
    private MallDayFaceRecognitionStaService mallDayFaceRecognitionStaService;


    @Override
    protected List<FaceVo> getFaceData(Long[] orgIds,Date startDate, Date endDate, Map<String, Object> dataMap) {
        List<FaceVo> faceDatas = (List<FaceVo>) dataMap.get(FELID_FACE_DATA);
        List<MallDayFaceRecognitionSta> faceDatasRaw = null;
        if(faceDatas == null){
            faceDatas = new ArrayList<FaceVo>();
            MallDayFaceRecognitionStaExample mallDayFaceRecognitionStaExample = new MallDayFaceRecognitionStaExample();
            mallDayFaceRecognitionStaExample.createCriteria().andCountdateBetween(startDate,endDate).andMallIdIn(Arrays.asList(orgIds));
            faceDatasRaw = mallDayFaceRecognitionStaService.selectByExample(mallDayFaceRecognitionStaExample);
            FaceVo  faceVo = null;
            for(MallDayFaceRecognitionSta mallDayFaceRecognitionSta:faceDatasRaw){
                faceVo = new FaceVo();
                faceVo.setPersonMantime(mallDayFaceRecognitionSta.getPersonMantime());
                faceVo.setPersonCount(mallDayFaceRecognitionSta.getPersonCount());
                faceVo.setCustomMantime(mallDayFaceRecognitionSta.getCustomMantime());
                faceVo.setCustomCount(mallDayFaceRecognitionSta.getCustomCount());
                faceVo.setMaleMantime(mallDayFaceRecognitionSta.getMaleMantime());
                faceVo.setMaleCount(mallDayFaceRecognitionSta.getMaleCount());
                faceVo.setFemaleMantime(mallDayFaceRecognitionSta.getFemaleMantime());
                faceVo.setFemaleCount(mallDayFaceRecognitionSta.getFemaleCount());
                faceVo.setStaffCount(mallDayFaceRecognitionSta.getStaffCount());
                faceVo.setStaffMantime(mallDayFaceRecognitionSta.getStaffMantime());
                faceVo.setCountdate(mallDayFaceRecognitionSta.getCountdate());
                faceVo.setMallId(mallDayFaceRecognitionSta.getMallId());
                faceVo.setAccountId(mallDayFaceRecognitionSta.getAccountId());
                faceVo.setMaleStage(mallDayFaceRecognitionSta.getMaleStage());
                faceVo.setFemaleStage(mallDayFaceRecognitionSta.getFemaleStage());
                faceDatas.add(faceVo);
            }
            dataMap.put(FELID_FACE_DATA,faceDatas);
        }
        return faceDatas;
    }
}
