package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.Row;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.MallDayCountData;
import com.viontech.mall.model.MallDayFaceRecognitionSta;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class EnteringRateReportServiceImpl extends ChartReportBaseService {

    @Resource
    private MallReportDataService mallReportDataService;

    /**
     * 存放
     * 本月      开始日期结束日期
     * 上月      开始日期结束日期
     * 去年同期  开始日期结束日期
     * 的数据列表
     */
    private final String DATEMAP = "dateMap";

    /**
     * 进店率报表
     */
    private final String ENTERINGRATECHART = "enteringRateChart";
    /**
     * 进店率表格
     */
    private final String ENTERINGTATETABLE="enteringRateTable";

    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return  null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = null;
        //获取去年同期的开始日期
        Date lastYear_startDate = DateUtil.getLastYear(startDate);

        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
        List<DataVo> dataVos = new ArrayList<DataVo>();
        List<FaceVo> faceVos = new ArrayList<FaceVo>();
        if (orgType == OrgType.mall) {
            List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds,lastYear_startDate,endDate, dataMap);
            dataVos = mallReportDataService.convert2Data(dayDatas);
            List<MallDayFaceRecognitionSta> dayFaceRecognitionStas = mallReportDataService.getOrQueryMallFaceData(orgIds,lastYear_startDate,endDate, dataMap);
            if(!dayFaceRecognitionStas.isEmpty()){
                faceVos = mallReportDataService.convertFace2Data(dayFaceRecognitionStas);
            }
        }
        switch (reportChart.getKey()) {
            case ENTERINGRATECHART:
                chart = enteringRateChart(chart, dataVos,startDate,endDate, dataMap,reportChart);
                break;
            case ENTERINGTATETABLE:
                chart = enteringRateTable(chart, dataVos,startDate,endDate, dataMap,reportChart,faceVos);
                break;
            default:
                break;
        }
        return chart;
    }

    private Chart enteringRateChart(Chart chart,List<DataVo> dataVos,Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
        chart = new Chart(reportChart.getTitle(), SeriesType.line);

        Axis<String> axis = AxisFactory.createStringAxis();
        List<Date> daysBetweenDates = DateUtil.getDaysBetweenDates(startDate, endDate);
        for (Date daysBetweenDate : daysBetweenDates) {
            String format = DateUtil.format(DateUtil.FORMAT_DD, daysBetweenDate);
            axis.addData(format);
        }
        chart.setXAxis(axis);

        chart.createSeries(DateType.MONTH.toString());
        chart.createSeries(DateType.LASTMONTH.toString());
        chart.createSeries(DateType.LASTYEARMONTH.toString());


        Date date = startDate;
        for (DataVo dataVo : dataVos) {
            Date dataDate = dataVo.getDate();
            DateType dateType = DateType.valueOfMonth(date,dataDate);
            if (dateType.equals(DateType.MONTH) || dateType.equals(DateType.LASTMONTH) || dateType.equals(DateType.LASTYEARMONTH)){
                Number  result = getKpiResult(dataVo,dataVos,dataMap,KPIType.ENTERINGRATE);
                String dateStr = DateUtil.format(DateUtil.FORMAT_DD, dataDate);
                chart.getSeries(dateType.toString()).putValueByCoordinate(dateStr,result);
            }
        }
        return chart;
    }


    private Chart enteringRateTable(Chart table, List<DataVo> dataVos, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart, List<FaceVo> faceVos){
        table = new Table(reportChart.getTitle(),SeriesType.table);

        final String dateStr = LocalMessageUtil.getMessage("ENTERINGRATE.DATE");
        final String effectiveTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.EFFECTIVE");
        final String outsideTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.OUTSIDETRAFFIC");
        final String autiTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.AUTITRAFFIC");
        final String TotalTraffic = LocalMessageUtil.getMessage("ENTERINGRATE.TOTALTRAFFIC");
        final String TodayRate = LocalMessageUtil.getMessage("ENTERINGRATE.TODAYENTERINGRATE");
        final String lastmonthRate = LocalMessageUtil.getMessage("ENTERINGRATE.LASTMONTHDAYENTERINGRATE");
        //初始化title
        TableHead tableHead = new TableHead();
        tableHead.addHeadColumn(dateStr,effectiveTraffic,outsideTraffic,autiTraffic,TotalTraffic,TodayRate,lastmonthRate);
        ((Table) table).setTableHead(tableHead);

        //获取日期数据，放入表格中
        List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
        Map<String, Date> serierDateMap = new HashMap<String, Date>();//更加格式化后的日期字符串获取日期，为了少一次日期转换
        for (Date date : dates) {
            String format = DateUtil.format(DateUtil.FORMAT_SHORT, date);
            table.getSeries(format).putValueByCoordinate(dateStr,format);
            serierDateMap.put(format,date);
        }

        List<Row> rows = table.getSeries();
        for (Row row : rows) {
            String serierName = row.getName();
            Date date = serierDateMap.get(serierName);
            for (DataVo dataVo : dataVos) {
                DateType dateType = DateType.valueOfDay(date, dataVo.getDate());
                int innum = dataVo.getInnum();
                int passNum = dataVo.getPassInnum()+dataVo.getPassOutnum()+innum;
                Number enterRate = getKpiResult(dataVo, dataVos, dataMap, KPIType.ENTERINGRATE);
                enterRate = Optional.ofNullable(enterRate).orElse(0.0);
                String percentStr = enterRate +"%";
                if (DateType.LASTMONTHDAY.equals(dateType)){
                    table.getSeries(serierName).putValueByCoordinate(lastmonthRate,percentStr);
                }else if (DateType.TODAY.equals(dateType)){
                    table.getSeries(serierName).putValueByCoordinate(effectiveTraffic,innum);
                    table.getSeries(serierName).putValueByCoordinate(outsideTraffic,dataVo.getPassInnum());
                    table.getSeries(serierName).putValueByCoordinate(autiTraffic,dataVo.getPassOutnum());
                    table.getSeries(serierName).putValueByCoordinate(TotalTraffic,passNum);
                    table.getSeries(serierName).putValueByCoordinate(TodayRate,percentStr);
                }
            }
        }
        return table;
    }

}
