package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class DateComparedReportServiceImpl extends ChartReportBaseService {
	
	@Resource
	private GateReportDataService gateReportDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;
	

	private final String KPILOOPREPORT = "kpiLoop";
	
	private final String KPIRADARROPORT="kpiRadar";
	
	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		//需要获取数据的日期，通过set去除重复日期
		Set<Date> dates = new HashSet<Date>();
		List<Date> dates1 = DateUtil.getDaysBetweenDates(startDate, endDate);
		dates.addAll(dates1);
		Date startDate1 = (Date) dataMap.get("startDate1");
		Date endDate1 = (Date) dataMap.get("endDate1");
		List<Date> dates2 = DateUtil.getDaysBetweenDates(startDate1, endDate1);
		dates.addAll(dates2);
		//把set数据转为List
		List<Date> datesList = new ArrayList<Date>(dates);
		
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		List<DataVo> dataVos = new ArrayList<DataVo>();
		List<KPIType> kpis = new ArrayList<KPIType>();
		
		if (orgType == OrgType.gate) {
			List<GateDayCountData> dayDatas = gateReportDataService.getOrQueryGateInDatesDayTraffic(orgIds, datesList, dataMap);
			dataVos = gateReportDataService.convert2Data(dayDatas);
			kpis = Arrays.asList(KPIType.TRAFFIC);
		}else if (orgType == OrgType.zone) {
			List<ZoneDayCountData> dayDatas = zoneReportDataService.getOrQueryZoneInDatesDayTraffic(orgIds, datesList, dataMap);
			dataVos = zoneReportDataService.convert2Data(dayDatas);
			List<Sale> saleDatas = zoneReportDataService.getOrQueryZoneInDatesSale(orgIds, datesList, dataMap);
			dataVos.addAll(zoneReportDataService.convert2Data(saleDatas));
			kpis = Arrays.asList(KPIType.TRAFFIC,KPIType.SALES,KPIType.ENTERINGRATE,KPIType.PREPRICE,KPIType.PERAREAVALUE,KPIType.ORDER,KPIType.HANDBAGRATE);
		}else if (orgType == OrgType.floor) {
			List<FloorDayCountData> dayDatas = floorReportDataService.getOrQueryFloorInDatesDayTraffic(orgIds, datesList, dataMap);
			dataVos = floorReportDataService.convert2Data(dayDatas);
			List<Sale> saleDatas = floorReportDataService.getOrQueryFloorInDateDaySale(orgIds,datesList, dataMap);
			dataVos.addAll(floorReportDataService.convert2Data(saleDatas));
			kpis = Arrays.asList(KPIType.TRAFFIC,KPIType.SALES);
		}else if (orgType == OrgType.mall) {
			List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallInDatesDayTraffic(orgIds, datesList, dataMap);
			dataVos = mallReportDataService.convert2Data(dayDatas);
			List<Sale> saleDatas = mallReportDataService.getOrQueryMallInDateDaySale(orgIds,datesList, dataMap);
			dataVos.addAll(mallReportDataService.convert2Data(saleDatas));
			kpis = Arrays.asList(KPIType.TRAFFIC,KPIType.SALES,KPIType.PREPRICE,KPIType.PERAREAVALUE);
		}
		dataMap.put("kpis", kpis);
		switch (reportChart.getKey()) {
		case KPILOOPREPORT:
			chart = kpiLoopReport(chart, dates1, dates2, dataVos, dataMap,reportChart);
			break;
		case KPIRADARROPORT:
			chart = kpiRadarReport(chart, dates1, dates2, dataVos, dataMap,reportChart);
			break;
		default:
			break;
		}
		
		return chart;
	}
	
	/*kpi环状图报表*/
	private Chart kpiLoopReport(Chart chart,List<Date> dates1,List<Date> dates2,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		chart = new Chart(reportChart.getTitle(), SeriesType.pie);
		
		String dateStr1 = LocalMessageUtil.getMessage("date1");
		String dateStr2 = LocalMessageUtil.getMessage("date2");
		
		if (dataVos != null && dataVos.size() > 0) {
			List<KPIType> kpis = (List<KPIType>) dataMap.get("kpis");
			
			for (DataVo dataVo : dataVos) {
				Date date = dataVo.getDate();
				for (KPIType kpiType : kpis) {
					String seriesName = kpiType.toString();
					Number result = getKpiResult(dataVo, dataVos, dataMap,kpiType);
					String coordinateName = null;
					if (dates2.contains(date)) {
						coordinateName = dateStr2;
						chart.getSeries(seriesName).adjustOrPutValueByCoordinate(coordinateName, result);
					}
					if (dates1.contains(date)) {
						coordinateName = dateStr1;
						chart.getSeries(seriesName).adjustOrPutValueByCoordinate(coordinateName, result);
					}
						
				}
			}
		}
		
		return chart;
	}
	
	private Chart kpiRadarReport(Chart chart,List<Date> dates1,List<Date> dates2,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		chart = new Chart(reportChart.getTitle(), SeriesType.radar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		List<KPIType> kpis = (List<KPIType>) dataMap.get("kpis");
		for (KPIType kpiType : kpis) {
			xAxis.addData(kpiType.toString());
		}
		chart.setXAxis(xAxis);
		
		
		if (dataVos != null && dataVos.size() > 0) {
			String dateStr1 = LocalMessageUtil.getMessage("date1");
			String dateStr2 = LocalMessageUtil.getMessage("date2");
			
			for (DataVo dataVo : dataVos) {
				Date date = dataVo.getDate();
				String seriesName = null;
				for (KPIType kpiType : kpis) {
					if (dates2.contains(date)) {
						seriesName = dateStr2;
					}
					
					String  coordinateName = kpiType.toString();
					Number result = getKpiResult(dataVo, dataVos, dataMap,kpiType);
					if (result == null || result.equals(-10001)) {
						continue;
					}
					if (dates2.contains(date)) {
						seriesName = dateStr2;
						chart.getSeries(seriesName).adjustOrPutValueByCoordinate(coordinateName, result);
					}
					if (dates1.contains(date)) {
						seriesName = dateStr1;
						chart.getSeries(seriesName).adjustOrPutValueByCoordinate(coordinateName, result);
					}
					
				}
			}
		}
		
		return chart;
	}
	
	
	
	
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
