package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.DateAxis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class BasicReportServiceImpl extends ChartReportBaseService{
	
	@Resource
	private GateReportDataService gateReportDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;
	
	private final String KPIDAYDATAREPORT = "kpiData";
	private final String DETAILDATAEPORT = "detailData";

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		List<DataVo> dataVos = new ArrayList<DataVo>();
		List orgList = new ArrayList();
		if (orgType == OrgType.gate) {
			List<GateDayCountData> gateDatas = gateReportDataService.getOrQueryGateBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			List<DataVo> dayDataVos = gateReportDataService.convert2Data(gateDatas);
			dataVos.addAll(dayDataVos);
			for (Long orgId : orgIds) {
				Gate gate = gateReportDataService.getGateInfoById(orgId, dataMap);
				orgList.add(gate);
			}
		}else if (orgType == OrgType.zone) {
			List<ZoneDayCountData> zoneDatas = zoneReportDataService.getOrQueryZoneBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			List<DataVo> dayDataVos = zoneReportDataService.convert2Data(zoneDatas);
			dataVos.addAll(dayDataVos);
			
			List<Sale> saleDatas = zoneReportDataService.getOrQueryZoneBetweenDateSale(orgIds, startDate, endDate, dataMap);
			List<DataVo> saleVos = zoneReportDataService.convert2Data(saleDatas);
			dataVos.addAll(saleVos);

			for (Long orgId : orgIds) {
				Zone zone = zoneReportDataService.getOrQueryZoneById(orgId, dataMap);
				orgList.add(zone);
			}
		}else if (orgType == OrgType.floor) {
			List<FloorDayCountData> floorDatas = floorReportDataService.getOrQueryFloorBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			List<DataVo> dayDataVos = floorReportDataService.convert2Data(floorDatas);
			dataVos.addAll(dayDataVos);
			
			List<Sale> saleDatas = floorReportDataService.getOrQueryFloorBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			List<DataVo> saleVos = floorReportDataService.convert2Data(saleDatas);
			dataVos.addAll(saleVos);

			for (Long orgId : orgIds) {
				Floor floor = floorReportDataService.getFloorInfoById(orgId, dataMap);
				orgList.add(floor);
			}
		}else if (orgType == OrgType.mall) {
			List<MallDayCountData> dayDatas = mallReportDataService.getOrQueryMallBetweenDateDayTraffic(orgIds, startDate, endDate, dataMap);
			List<DataVo> dayDataVos = mallReportDataService.convert2Data(dayDatas);
			dataVos.addAll(dayDataVos);
			List<Sale> saleDatas = mallReportDataService.getOrQueryMallBetweenDateDaySale(orgIds, startDate, endDate, dataMap);
			List<DataVo> saleVos = mallReportDataService.convert2Data(saleDatas);
			dataVos.addAll(saleVos);

			for (Long orgId : orgIds) {
				Mall mall = mallReportDataService.getMallByMallId(orgId, dataMap);
				orgList.add(mall);
			}
		}
		
		Chart chart  = null;

		Object chartOption = dataMap.get("chartOption");
		switch (reportChart.getKey()) {
		case KPIDAYDATAREPORT:
			//chart = kpiDayDataReport(orgList,dataVos, dataMap, reportChart);
			break;
		case DETAILDATAEPORT:
			KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
			if (OptionsContain.TAB_TABLE.equals(chartOption))
				chart = DetailDataReport(orgList,dataVos, dataMap, startDate, endDate,kpiType ,reportChart);
			else if (OptionsContain.TAB_CHART.equals(chartOption))
				chart = DetailDataReportChart(orgList,dataVos, dataMap, startDate, endDate,kpiType ,reportChart);
			break;
		default:
			break;
		}
		
		return chart;
	}
	/**
	 * 今日数据汇总
	 * @return
	 */
	/*private Chart kpiDayDataReport(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Table table = new Table(reportChart.getTitle(), SeriesType.table){
			@Override
			public Object calcValue(String name, int index, List data_raw) {
				int index1 = getIndexByCoordinate(KPIType.ENTERINGRATE.toString());
				int index2 = getIndexByCoordinate(KPIType.PREPRICE.toString());
				if ((index == index1 || index == index2)&& getRow(name).getCountByIndex(index)!=null ) {
					int count = getRow(name).getCountByIndex(index);
					return NumberUtil.divide(NumberUtil.parseDouble(data_raw.get(index)), count, 2);
				}
				return data_raw.get(index);
			}
		};

		TableHead heads = new TableHead();
		heads.addData(LocalMessageUtil.getMessage("layerOrKPI"));
		List<KPIType> tableHeads = new ArrayList<KPIType>();
		tableHeads.addAll(Arrays.asList(KPIType.TRAFFIC,KPIType.SALES,KPIType.ENTERINGRATE,KPIType.ORDER,KPIType.PREPRICE,KPIType.PERAREAVALUE));
		for (KPIType kpiType : tableHeads) {
			heads.addHeadColumn(kpiType.toString());
		}
		table.setTableHead(heads);

		table.setCalcTypeByCoordinate(KPIType.ENTERINGRATE.toString(), Series.CALC_TYPE_AVG);
		table.setCalcTypeByCoordinate(KPIType.PREPRICE.toString(), Series.CALC_TYPE_AVG);


		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (Object o : orgList) {
			String seriesName = getSeriesName(orgType, o);
			if (seriesName == null || seriesName.isEmpty()){
				continue;
			}
			table.getRow(seriesName).putValueByHeadColumn(LocalMessageUtil.getMessage("layerOrKPI"), seriesName);
		}

		for (DataVo dataVo : dataVos) {
			String rowName = getOrgName(dataVo,dataMap);
			if (rowName == null || rowName.isEmpty()){
				continue;
			}
			String coordinateName = null;
			for (KPIType kpiType : tableHeads) {
				coordinateName = kpiType.toString();
				Number result = getKpiResult(dataVo, dataVos, dataMap,kpiType);
				if ( result== null || result.equals(-10001) ) {
					continue;
				}
				table.getRow(rowName).adjustOrPutValueByHeadColumn(coordinateName, result);
			}
		}
		return table;
	}*/
	/**
	 * 数据详情报表
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart DetailDataReportChart(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap,Date startDate, Date endDate,KPIType kpiType, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);

		Axis axis = new DateAxis("MM-dd(E)",Calendar.DAY_OF_YEAR);
		axis.setMin(startDate);
		axis.setMax(endDate);
		chart.setXAxis(axis);

		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (Object o : orgList) {
			String orgName = getOrgName(orgType, o);
			chart.createSeries(orgName);
		}

		for (DataVo dataVo : dataVos) {
			Number traffic = getKpiResult(dataVo, dataVos, dataMap,kpiType);
			Date date = dataVo.getDate();
			String orgName = getOrgName(dataVo, dataMap);
			chart.getSeries(orgName).putValueByCoordinate(date,traffic);
		}

		return chart;
	}



	/**
	 * 数据详情报表
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart DetailDataReport(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap,Date startDate, Date endDate,KPIType kpiType, ReportChart reportChart){
		Table table = new Table(reportChart.getTitle(),SeriesType.table);
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		TableHead heads = new TableHead();
		heads.addData(LocalMessageUtil.getMessage("date")); //日期  国际化
		heads.addData(LocalMessageUtil.getMessage("week")); //星期   国际化
		for (Object o : orgList) {
			String seriesName = getOrgName(orgType, o);
			heads.addHeadColumn(seriesName);
		}
		table.setTableHead(heads);
		
	    Date currentDate = startDate;
		while (!currentDate.after(endDate)) {
			//日期
			String rowName = DateUtil.format(DateUtil.FORMAT_SHORT,currentDate);
			table.getRow(rowName).putValueByHeadColumn(LocalMessageUtil.getMessage("date"), rowName);
			//星期
			String weekStr = DateUtil.format(DateUtil.FORMAT_DAY_OF_WEEK_SORT_CN,currentDate);
			table.getRow(rowName).putValueByHeadColumn(LocalMessageUtil.getMessage("week"), weekStr);
			
			for (DataVo dataVo : dataVos) {
				Date dataDate = dataVo.getDate();
				if (!dataDate.equals(currentDate)) {
					continue;
				}
				String tableHeadStr = getOrgName(dataVo,dataMap);
				if (tableHeadStr == null)
					continue;
				Number reulst = getKpiResult(dataVo, dataVos, dataMap,kpiType);
				if (reulst != null && reulst.equals(-10001)) {
					continue;
				}
				table.getRow(rowName).adjustOrPutValueByHeadColumn(tableHeadStr, reulst);
			}
			currentDate = DateUtil.addDays(currentDate, 1);
		}
		
		return table;
	}

	protected String getOrgName(OrgType orgType, Object o) {
		String seriesName = null;
		if(OrgType.mall == orgType){
			Mall mall = (Mall) o;
			seriesName = mall.getName();
		}else if(OrgType.floor == orgType){
			Floor floor = (Floor) o;
			seriesName = floor.getName();
		}else if(OrgType.zone == orgType){
			Zone zone = (Zone) o;
			seriesName = zone.getName();
		}else if(OrgType.gate == orgType){
			Gate gate = (Gate) o;
			seriesName = gate.getName();
		}
		return seriesName;
	}


	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
