package com.viontech.mall.report.service.impl;

import com.viontech.keliu.base.BaseModel;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.DateAxis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.adapter.FloorReportDataService;
import com.viontech.mall.report.service.adapter.GateReportDataService;
import com.viontech.mall.report.service.adapter.MallReportDataService;
import com.viontech.mall.report.service.adapter.ZoneReportDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class BasicDayReportServiceImpl extends ChartReportBaseService{
	
	@Resource
	private GateReportDataService gateReportDataService;
	
	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;
	
	private final String KPIDAYDATAREPORT = "kpiData";
	private final String TRAFFICHOURREPORT = "trafficHour";
	private final String TRAFFIC10MINUTEREPORT = "traffic10Min";

	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Date date = startDate;
		
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		List<DataVo> dataVos = new ArrayList<>();
		List<DataVo> minDataVos = new ArrayList<>();
		List<DataVo> hourDataVos = new ArrayList<>();

		Object chartOption = dataMap.get("chartOption");

		Chart chart  = null;
		List orgList = new ArrayList();
		switch (reportChart.getKey()) {
			case KPIDAYDATAREPORT:
				if (orgType == OrgType.gate) {
					List<GateDayCountData> gateDayDatas = gateReportDataService.getOrQueryGateInDatesDayTraffic(orgIds,Arrays.asList(date), dataMap);
					dataVos= gateReportDataService.convert2Data(gateDayDatas);
					for (Long orgId : orgIds) {
						Gate gate = gateReportDataService.getGateInfoById(orgId, dataMap);
						orgList.add(gate);
					}
				}else if (orgType == OrgType.zone) {
					List<ZoneDayCountData> zoneDayDatas = zoneReportDataService.getOrQueryZoneInDatesDayTraffic(orgIds, Arrays.asList(date), dataMap);
					dataVos = zoneReportDataService.convert2Data(zoneDayDatas);
					List<Sale> zoneSaleDatas = zoneReportDataService.getOrQueryZoneBetweenDateSale(orgIds, date, date, dataMap);
					List<DataVo> saleVos = zoneReportDataService.convert2Data(zoneSaleDatas);
					dataVos.addAll(saleVos);
					for (Long orgId : orgIds) {
						Zone zone = zoneReportDataService.getOrQueryZoneById(orgId, dataMap);
						orgList.add(zone);
					}
				}else if (orgType == OrgType.floor) {
					List<FloorDayCountData> floorDayDatas = floorReportDataService.getOrQueryFloorInDatesDayTraffic(orgIds, Arrays.asList(date), dataMap);
					dataVos = floorReportDataService.convert2Data(floorDayDatas);
					List<Sale> floorSaleDatas = floorReportDataService.getOrQueryFloorInDateDaySale(orgIds, Arrays.asList(date), dataMap);
					List<DataVo> saleVos = floorReportDataService.convert2Data(floorSaleDatas);
					dataVos.addAll(saleVos);
					for (Long orgId : orgIds) {
						Floor floor = floorReportDataService.getFloorInfoById(orgId, dataMap);
						orgList.add(floor);
					}
				}else if (orgType == OrgType.mall) {
					List<MallDayCountData> mallDayDatas = mallReportDataService.getOrQueryMallInDatesDayTraffic(orgIds, Arrays.asList(date), dataMap);
					dataVos= mallReportDataService.convert2Data(mallDayDatas);
					List<Sale> mallSales = mallReportDataService.getOrQueryMallInDateDaySale(orgIds, Arrays.asList(date), dataMap);
					List<DataVo> saleDataVos = mallReportDataService.convert2Data(mallSales);
					dataVos.addAll(saleDataVos);
					for (Long orgId : orgIds) {
						Mall mall = mallReportDataService.getMallByMallId(orgId, dataMap);
						orgList.add(mall);
					}
				}
				if (OptionsContain.TAB_TABLE.equals(chartOption))
					chart = kpiDayDataReport(orgList,dataVos, dataMap, reportChart);
				else if (OptionsContain.TAB_CHART.equals(chartOption))
					chart = kpiDayDataReportChart(orgList,dataVos, dataMap, reportChart);
				break;
			case TRAFFICHOURREPORT:
				if (orgType == OrgType.gate) {
					List<GateHourCountData> gateHourDatas = gateReportDataService.getOrQueryGateDaysHourData(orgIds,Arrays.asList(date), dataMap);
					hourDataVos = gateReportDataService.convert2Data(gateHourDatas);
					for (Long orgId : orgIds) {
						Gate gate = gateReportDataService.getGateInfoById(orgId, dataMap);
						orgList.add(gate);
					}
				}else if (orgType == OrgType.zone) {
					List<ZoneHourCountData> zoneHourDatas = zoneReportDataService.getOrQueryZoneInDatesHourTraffic(orgIds, Arrays.asList(date), dataMap);
					hourDataVos = zoneReportDataService.convert2Data(zoneHourDatas);
					for (Long orgId : orgIds) {
						Zone zone = zoneReportDataService.getOrQueryZoneById(orgId, dataMap);
						orgList.add(zone);
					}
				}else if (orgType == OrgType.floor) {
					List<FloorHourCountData> floorHourCountDatas = floorReportDataService.getOrQueryFloorInDatesHourTraffic(orgIds, Arrays.asList(date), dataMap);
					hourDataVos = floorReportDataService.convert2Data(floorHourCountDatas);
					for (Long orgId : orgIds) {
						Floor floor = floorReportDataService.getFloorInfoById(orgId, dataMap);
						orgList.add(floor);
					}
				}else if (orgType == OrgType.mall) {
					List<MallHourCountData> mallHourDatas = mallReportDataService.getOrQueryMallDaysHourTraffic(orgIds, Arrays.asList(date), dataMap);
					hourDataVos = mallReportDataService.convert2Data(mallHourDatas);
					for (Long orgId : orgIds) {
						Mall mall = mallReportDataService.getMallByMallId(orgId, dataMap);
						orgList.add(mall);
					}
				}
				if (OptionsContain.TAB_TABLE.equals(chartOption))
					chart = TrafficHourReport(orgList,hourDataVos, dataMap, reportChart,false);
				else if (OptionsContain.TAB_CHART.equals(chartOption))
					chart = TrafficHourReportChart(hourDataVos, dataMap, reportChart,false);
				break;
			case TRAFFIC10MINUTEREPORT:
				if (orgType == OrgType.gate) {
					List<GateMinuteCountData> gateMinuteDatas = gateReportDataService.getOrQueryGateDays10MinData(orgIds, Arrays.asList(date), dataMap);
					minDataVos = gateReportDataService.convert2Data(gateMinuteDatas);
					for (Long orgId : orgIds) {
						Gate gate = gateReportDataService.getGateInfoById(orgId, dataMap);
						orgList.add(gate);
					}
				}else if (orgType == OrgType.zone) {
					List<ZoneMinuteCountData> minuteCountDatas = zoneReportDataService.getOrQueryZoneInDates10MinetuTraffic(orgIds, Arrays.asList(date), dataMap);
					minDataVos = zoneReportDataService.convert2Data(minuteCountDatas);
					for (Long orgId : orgIds) {
						Zone zone = zoneReportDataService.getOrQueryZoneById(orgId, dataMap);
						orgList.add(zone);
					}
				}else if (orgType == OrgType.floor) {
					List<FloorMinuteCountData> floorMinuteCountDatas = floorReportDataService.getOrQueryFloorInDatesMinTraffic(orgIds, Arrays.asList(date), dataMap);
					minDataVos = floorReportDataService.convert2Data(floorMinuteCountDatas);
					for (Long orgId : orgIds) {
						Floor floor = floorReportDataService.getFloorInfoById(orgId, dataMap);
						orgList.add(floor);
					}
				}else if (orgType == OrgType.mall) {
					List<MallMinuteCountData> mallMinuteDatas = mallReportDataService.getOrQueryMallInDatesMinTraffic(orgIds, Arrays.asList(date), dataMap);
					minDataVos = mallReportDataService.convert2Data(mallMinuteDatas);
					for (Long orgId : orgIds) {
						Mall mall = mallReportDataService.getMallByMallId(orgId, dataMap);
						orgList.add(mall);
					}
				}
				if (OptionsContain.TAB_TABLE.equals(chartOption))
					chart = TrafficHourReport(orgList,minDataVos, dataMap, reportChart,true);
				else if (OptionsContain.TAB_CHART.equals(chartOption))
					chart = TrafficHourReportChart(minDataVos, dataMap, reportChart,true);
				break;
			default:
				break;
		}
		return chart;
	}
	/**
	 * 今日数据汇总
	 * @return
	 */
	private Chart kpiDayDataReport(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Table table = new Table(reportChart.getTitle(), SeriesType.table);
		
		List<KPIType> tableHeads = new ArrayList<>();
		tableHeads.addAll(Arrays.asList(KPIType.TRAFFIC,KPIType.OUTNUM,KPIType.DURATIONNUM));

		TableHead heads = new TableHead();
		heads.addData(LocalMessageUtil.getMessage("layerOrKPI"));
		for (KPIType kpiType : tableHeads) {
			heads.addHeadColumn(kpiType.toString());
		}
		table.setTableHead(heads);

		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (Object o : orgList) {
			String seriesName  = getOrgName(orgType, (BaseModel) o);
			table.getRow(seriesName).putValueByHeadColumn(LocalMessageUtil.getMessage("layerOrKPI"), seriesName);;
		}
		
		for (DataVo dataVo : dataVos) {
			String rowName = getOrgName(dataVo,dataMap);
			if (rowName == null)
				continue;
			String coordinateName = null;
			for (KPIType kpiType : tableHeads) {
				coordinateName = kpiType.toString();
				Number result = getKpiResult(dataVo, dataVos, dataMap,kpiType);
				if ( result== null || result.equals(-10001) ) {
					continue;
				}
				table.getRow(rowName).adjustOrPutValueByHeadColumn(coordinateName, result);
			}
		}
		return table;
	}

	/**
	 * 今日数据汇总报表
	 * @return
	 */
	private Chart kpiDayDataReportChart(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis axis = AxisFactory.createStringAxis();
		chart.setXAxis(axis);

		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		for (Object o : orgList) {
			String orgName  = getOrgName(orgType, (BaseModel) o);
			chart.getSeries(KPIType.TRAFFIC.toString()).putValueByCoordinate(orgName,0);
			chart.getSeries(KPIType.OUTNUM.toString()).putValueByCoordinate(orgName,0);
		}

		for (DataVo dataVo : dataVos) {
			String orgName = getOrgName(dataVo,dataMap);
			if (orgName == null)
				continue;
			Number traffic = getKpiResult(dataVo, dataVos, dataMap, KPIType.EFFECTIVETRAFFIC);
			chart.getSeries(KPIType.TRAFFIC.toString()).putValueByCoordinate(orgName,traffic);
			Number outNum = getKpiResult(dataVo, dataVos, dataMap, KPIType.OUTNUM);
			chart.getSeries(KPIType.OUTNUM.toString()).putValueByCoordinate(orgName,outNum);
		}
		return chart;
	}
	/**
	 * 今日小时|分钟级客流详情
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart TrafficHourReport(List orgList,List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart,Boolean isMinTabel){
		Table table = new Table(reportChart.getTitle(),SeriesType.table);
		if (dataVos == null || dataVos.size() <= 0) {
			return table;
		}
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		
		TableHead heads = new TableHead();
		heads.addData(LocalMessageUtil.getMessage("timeQuantum")); //时间段  国际化

		for (Object o : orgList) {
			String seriesName  = getOrgName(orgType, (BaseModel) o);
			heads.addHeadColumn(seriesName);
		}
		table.setTableHead(heads);
		
		//获取商场的营业时间
		DataVo dataVot = dataVos.get(0);
		DateCriteria dateCriteria = getMallOpenTime(dataMap, orgType, dataVot);
		Date mallOpenTime = dateCriteria.getStartDate();
		Date mallCloseTime = dateCriteria.getEndDate();

		Date currentTime = mallOpenTime;
		while (currentTime.before(mallCloseTime)) {
			String currentTimeStr ;
			String nextTimeStr;
			//时间段
			Date nextTime = null;
			if(isMinTabel){
				currentTimeStr = DateUtil.format(DateUtil.FORMAT_HHMM,currentTime);
				nextTime = DateUtil.addMinutes(currentTime, 10);
				nextTimeStr = DateUtil.format(DateUtil.FORMAT_HHMM,nextTime);
			}else {
				currentTimeStr = DateUtil.format("HH:00",currentTime);
				nextTime = DateUtil.addHours(currentTime, 1);
				nextTimeStr = DateUtil.format("HH:00",nextTime);
			}
			String timeQuanTumStr = currentTimeStr+"-"+nextTimeStr;
			table.getRow(currentTimeStr).putValueByHeadColumn(LocalMessageUtil.getMessage("timeQuantum"), timeQuanTumStr);
			currentTime = nextTime;
		}
		for (DataVo dataVo : dataVos) {
			if (dataVo.getDataType() == DataVo.DATA_TYPE_SALE) {
				continue;
			}
			Date dataVoTime = dataVo.getTime();
			String dataTimeStr = DateUtil.format(DateUtil.FORMAT_HHMM, dataVoTime);
			boolean inOpenTime = DateUtil.isInOpenTime(dataVoTime, mallOpenTime, mallCloseTime);
			if (!inOpenTime){
				continue;
			}

			String tableHeadStr = getOrgName(dataVo,dataMap);

			Number result = getKpiResult(dataVo, dataVos, dataMap,KPIType.TRAFFIC);
			if (result.equals(-10001)) {
				continue;
			}
			table.getRow(dataTimeStr).adjustOrPutValueByHeadColumn(tableHeadStr, result);
		}
		
		return table;
	}

	/**
	 * 今日小时|分钟级客流报表
	 * @param dataVos
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	private Chart TrafficHourReportChart(List<DataVo> dataVos, Map<String, Object> dataMap, ReportChart reportChart,Boolean isMinTabel){
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);
		if (dataVos == null || dataVos.size() <= 0) {
			return chart;
		}
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		//获取商场的营业时间
		DataVo dataVot = dataVos.get(0);
		DateCriteria dateCriteria = getMallOpenTime(dataMap, orgType, dataVot);
		Date mallOpenTime = dateCriteria.getStartDate();
		Date mallCloseTime = dateCriteria.getEndDate();

		String dataFormatStr = "HH:00";
		Integer dateType = Calendar.HOUR_OF_DAY;
		Integer dateScale = 1;

		if(isMinTabel){
			dataFormatStr = DateUtil.FORMAT_HHMM;
			dateType = Calendar.MINUTE;
			dateScale = 10;
		}

		Axis axis = new DateAxis(dataFormatStr,dateType);
		axis.setMin(mallOpenTime);
		axis.setMax(mallCloseTime);
		axis.setScale(dateScale);
		axis.lockMinMax();
		chart.setXAxis(axis);

		for (DataVo dataVo : dataVos) {
			Date dataVoTime = dataVo.getTime();
//			String dataTimeStr = DateUtil.format(DateUtil.FORMAT_HHMM, dataVoTime);
			boolean inOpenTime = DateUtil.isInOpenTime(dataVoTime, mallOpenTime, mallCloseTime);
			if (!inOpenTime){
				continue;
			}
			String orgName = getOrgName(dataVo,dataMap);
			Number result = getKpiResult(dataVo, dataVos, dataMap,KPIType.TRAFFIC);
			chart.getSeries(orgName).adjustOrPutValueByCoordinate(dataVoTime, result);
		}

		return chart;
	}


	private String getOrgName(OrgType orgType, BaseModel o) {
		String seriesName = "";
		if(OrgType.mall == orgType){
			Mall mall = (Mall) o;
			seriesName = mall.getName();
		}else if(OrgType.floor == orgType){
			Floor floor = (Floor) o;
			seriesName = floor.getName();
		}else if(OrgType.zone == orgType){
			Zone zone = (Zone) o;
			seriesName = zone.getName();
		}else if(OrgType.gate == orgType){
			Gate gate = (Gate) o;
			seriesName = gate.getName();
		}
		return seriesName;
	}

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		return null;
	}

}
