package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.DateAxis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.MallDayCountData;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.ParamName;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class AccountYearReportServiceImpl extends AbstractAccountReportServiceImpl {

	
	/** 城市下属商场的营业额收入（日） */
	public static final String REPORT_ACCOUNT_YEAR_CITYTRAFFIC = "CityTraffic";
	/**客流和销售额年趋势(天)*/
	public static final  String REPORT_ACCOUNT_YEAR_TRAFFICANDSALE_DAY_TREND ="trafficAndSaleDayTrend";
	/**客流和销售额年趋势(周)*/
	public static final  String REPORT_ACCOUNT_YEAR_TRAFFICANDSALE_WEEK_TREND ="trafficAndSaleWeekTrend";
	/**客流和销售额年趋势(月)*/
	public static final  String REPORT_ACCOUNT_YEAR_TRAFFICANDSALE_MONTH_TREND ="trafficAndSaleMonthTrend";
	/**全国商场排名--客流量*/
	public static final String REPORT_ACCOUNT_YEAR_TRAFFIC_RANK = "trifficRank";
	/**全国商场排名--销售额*/
	public static final String REPORT_ACCOUNT_YEAR_SALE_RANK = "saleRank";
	/**全国商场排名--游逛深度*/
	public static final String REPORT_ACCOUNT_YEAR_DEPTH_RANK = "depthRank";
	/**全国商场排名--客单价*/
	public static final String REPORT_ACCOUNT_YEAR_PREPRICE_RANK = "prePriceRank";
	/**全国商场排名--坪效*/
	public static final String REPORT_ACCOUNT_YEAR_AREAEFFECTIVENESS_RANK = "areaEffRank";
	/**全国商场排名--滞留时间*/
	public static final String REPORT_ACCOUNT_YEAR_DWELLTIME_RANK = "dwellTimeRank" ;

	/**集团全国业态排名--客流量*/
	public static final String REPORT_FORMAT_YEAR_TRAFFIC_RANKING ="format_traffic_ranking";
	/**集团全国业态排名--销售额*/
	public static final String REPORT_FORMAT_YEAR_SALE_RANKING ="format_sale_ranking";
	
	/**集团顾客特征--性别分布*/
	public static final String REPORT_ACCOUNT_YEAR_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**集团顾客特征--年龄分布*/
	public static final String REPORT_ACCOUNT_YEAR_CUSTOMERFEATURE_AGE ="customerfeature_age";

	/** 年客流环比 */
	private  final String FIELD_YEAR_COMPARED_INNUM = "comparedYearInnum";

	/** 环比年的数据 */
	private final String FIELD_LAST_YEAR_INNUM = "lastYearInnum";



	/**  */

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Map<String, Object> head = super.getHead(orgIds, startDate, endDate, dataMap);
		Long orgId = orgIds[0];
		Integer comparedInnum=null;
		java.util.List<MallDayCountData> historyDatas = getAccountHistoryVisitor(orgId, DateUtil.getLastYear(startDate), DateUtil.getLastDateOfYear(DateUtil.getLastYear(endDate)), dataMap);
		if(historyDatas != null && historyDatas.size() > 0){
			comparedInnum = 0;
			for (MallDayCountData mallDayCountData : historyDatas) {
				comparedInnum += mallDayCountData.getInnum();
			}
		}

		String trafficgrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ACCOUNT_INNUM))), comparedInnum);
		if (trafficgrowRate != null) {
			head.put(FIELD_YEAR_COMPARED_INNUM,trafficgrowRate.replace("%", ""));
			head.put(FIELD_LAST_YEAR_INNUM,comparedInnum);
		}
		return head;
	}

	@Override
	public Chart getChart(Long[] orgIds, Date startDate,Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		Long orgId = orgIds[0];
		double start = System.currentTimeMillis() ;
		switch (reportChart.getKey()) {
			case REPORT_ACCOUNT_YEAR_CITYTRAFFIC:// 城市当日客流（日）
				chart = CityTrafficReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_TRAFFICANDSALE_DAY_TREND : //客流量、销售额周趋势报表(天)
				chart = visitorDateTypeTrendReport(orgId, startDate,endDate, dataMap, reportChart,DateType.DAY);
				break;
			case  REPORT_ACCOUNT_YEAR_TRAFFICANDSALE_WEEK_TREND : //客流量、销售额周趋势报表(周)
				chart = visitorDateTypeTrendReport(orgId, startDate,endDate, dataMap, reportChart,DateType.WEEK);
				break;
			case  REPORT_ACCOUNT_YEAR_TRAFFICANDSALE_MONTH_TREND : //客流量、销售额周趋势报表(月)
				chart = visitorDateTypeTrendReport(orgId, startDate,endDate, dataMap, reportChart,DateType.MONTH);
				break;
			case  REPORT_ACCOUNT_YEAR_TRAFFIC_RANK : /**全国商场排名--客流量*/
				chart = trafficRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_SALE_RANK : /**全国商场排名--销售额*/
				chart = salesRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_DEPTH_RANK :/**全国商场排名--游逛深度*/
				chart = depthRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_PREPRICE_RANK :/**全国商场排名--客单价*/
				chart = PrepriceRankingReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_AREAEFFECTIVENESS_RANK  : /**全国商场排名--坪效*/
				chart = perAreaValueRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_DWELLTIME_RANK: /**全国商场排名--滞留时间*/
				chart = trafficRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_FORMAT_YEAR_TRAFFIC_RANKING :/**集团全国业态排名--客流量*/
				chart = formatTrifficRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_FORMAT_YEAR_SALE_RANKING :/**集团全国业态排名--销售额*/
				chart = FormatSalesRankReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_CUSTOMERFEATURE_GENDER  : /**集团顾客特征--性别分布*/
				chart = genderDistributionReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_YEAR_CUSTOMERFEATURE_AGE: /**集团顾客特征--年龄分布*/
				chart = ageDistributionReport(orgId, startDate,endDate, dataMap, reportChart);
				break;
			default :
				break;
		}
		double end = System.currentTimeMillis() ;
		System.out.println(chart.getTitle()+"time is : " +(end - start));
		return chart;
	}
	

	/**根据DateTyp类型获取集团的年趋势*/
	private Chart visitorDateTypeTrendReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart,DateType dateType) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		DateAxis XAxis = null;
		if (dateType== DateType.MONTH) {
			XAxis = (DateAxis) AxisFactory.createMonthOFYearAxis();
			XAxis.setMin(startDate);
			XAxis.setMax(endDate);
			XAxis.setDateFormatStr("M月");
		}else if (dateType== DateType.DAY) {
			XAxis = (DateAxis) AxisFactory.createDayOFYearAxis(startDate, endDate);
		}else if (dateType== DateType.WEEK) {
			XAxis = (DateAxis) AxisFactory.createWeekOFYearAxis();
			XAxis.setMin(startDate);
			XAxis.setMax(endDate);
		}
		chart.setXAxis(XAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		//chart.createSeries(ParamName.SALES.toString(), SeriesType.line);
		
		//客流量
		List<MallDayCountData> dayDatas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		for (MallDayCountData mallDayCountData : dayDatas) {
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(
					mallDayCountData.getCountdate(), mallDayCountData.getInnum());
		}
		//销售额
//		List<Sale> sales = getAccountSales(orgId, startDate, endDate, dataMap);
//		for (Sale sale : sales) {
//			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(),sale.getMoney());
//		}
		return chart;
	}

}
