package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.MallDayCountData;
import com.viontech.mall.model.ReportChart;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service
public class AccountWeekReportServiceImpl extends AbstractAccountReportServiceImpl {
	
	/** 城市下属商场的营业额收入（日） */
	public static final String REPORT_ACCOUNT_WEEK_CITYTRAFFIC = "CityTraffic";
	/**集团近期趋势*/
	public static final String REPORT_ACCOUNT_WEEK_COSTOMER_TREND = "costomerTrend";
	/**全国商场排名--客流量*/
	public static final String REPORT_ACCOUNT_WEEK_TRAFFIC_RANK = "trifficRank";
	/**全国商场排名--销售额*/
	public static final String REPORT_ACCOUNT_WEEK_SALE_RANK = "saleRank";
	/**全国商场排名--游逛深度*/
	public static final String REPORT_ACCOUNT_WEEK_DEPTH_RANK = "depthRank";
	/**全国商场排名--客单价*/
	public static final String REPORT_ACCOUNT_WEEK_PREPRICE_RANK = "prePriceRank";
	/**全国商场排名--坪效*/
	public static final String REPORT_ACCOUNT_WEEK_AREAEFFECTIVENESS_RANK = "areaEffRank";
	/**全国商场排名--滞留时间*/
	public static final String REPORT_ACCOUNT_WEEK_DWELLTIME_RANK = "dwellTimeRank" ;

	/**集团全国业态排名--客流量*/
	public static final String REPORT_FORMAT_WEEK_TRAFFIC_RANKING ="format_traffic_ranking";
	/**集团全国业态排名--销售额*/
	public static final String REPORT_FORMAT_WEEK_SALE_RANKING ="format_sale_ranking";
	
	/**集团顾客特征--性别分布*/
	public static final String REPORT_ACCOUNT_WEEK_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**集团顾客特征--年龄分布*/
	public static final String REPORT_ACCOUNT_WEEK_CUSTOMERFEATURE_AGE ="customerfeature_age";

	/** 周客流环比 */
	private  final String FIELD_WEEK_COMPARED_INNUM = "comparedWeekInnum";

	/** 上周客流数据 */
	private final String FIELD_LAST_WEEK_INNUM = "lastWeekInnum";

	/**年客流同比 */
	private final String FIELD_YEAR_COMPARED_INNUM = "comparedYearInnum";

	/** 去年同比周客流数据 */
	private final String FIELD_LAST_YEAR_INNUM = "lastYearInnum";

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Map<String, Object> head = super.getHead(orgIds, startDate, endDate, dataMap);
		Date lastWeekDate = DateUtil.getLastWeek(endDate);
		Date lastYearDate = DateUtil.getLastYear(endDate);
		Long orgId = orgIds[0];
		Integer comparedInnum=null;
		Integer compareLastYear = null;
		//环比天级数据
		java.util.List<MallDayCountData> historyDatas = getAccountHistoryVisitor(orgId, DateUtil.getLastYear(startDate), DateUtil.getSundayOfWeek(DateUtil.getLastWeek(endDate)), dataMap);
		if(historyDatas != null && historyDatas.size() > 0){
			comparedInnum = 0;
			compareLastYear = 0;
			for (MallDayCountData mallDayCountData : historyDatas) {
				if(DateUtil.isSameWeek(mallDayCountData.getCountdate(),lastWeekDate)) {
					comparedInnum += mallDayCountData.getInnum();
				}
				if(DateUtil.isSameWeek(mallDayCountData.getCountdate(),lastYearDate)) {
					compareLastYear += mallDayCountData.getInnum();
				}
			}
		}
		String trafficgrowRate =  "";
		if(head.get(FIELD_ACCOUNT_INNUM)!=null){
			trafficgrowRate =NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ACCOUNT_INNUM))), comparedInnum);
			if (trafficgrowRate != null) {
				head.put(FIELD_WEEK_COMPARED_INNUM,trafficgrowRate.replace("%", ""));
				head.put(FIELD_LAST_WEEK_INNUM,comparedInnum);
			}

			String trafficLastYeargrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ACCOUNT_INNUM))), compareLastYear);
			if(trafficLastYeargrowRate != null){
				head.put(FIELD_YEAR_COMPARED_INNUM,trafficLastYeargrowRate.replace("%", ""));
				head.put(FIELD_LAST_YEAR_INNUM,compareLastYear);
			}
		}
		return head;
	}

	/**
	 * 
	 * @param orgType  机构对象类型  accout/mall/floor/shop（必须）
	 * @param orgId    机构id（必须）
	 * @param date     查询日期（可选）
	 * @param startDate   查询起始日期（可选）
	 * @param endDate     查询结束日期（可选）
	 * @param dataMap     数据存放Map（可以将该报表中重复使用的数据放入）
	 * @param reportChart  该报表的基本信息（必须）
	 * @return
	 */
	@Override
	public Chart getChart(Long[] orgIds,  Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		Long orgId = orgIds[0];
		switch (reportChart.getKey()) {
			case REPORT_ACCOUNT_WEEK_CITYTRAFFIC:// 城市当日客流（日）
				chart = CityTrafficReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_ACCOUNT_WEEK_COSTOMER_TREND:/**集团近期趋势*/
				chart = trafficAndSaleTrendReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_ACCOUNT_WEEK_TRAFFIC_RANK:/**全国商场排名--客流量*/
				chart = trafficRankReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_ACCOUNT_WEEK_SALE_RANK:/**全国商场排名--销售额*/
				chart = salesRankReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_ACCOUNT_WEEK_PREPRICE_RANK:/**全国商场排名--客单价*/
				chart = PrepriceRankingReport(orgId, startDate, endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_WEEK_AREAEFFECTIVENESS_RANK  : /**全国商场排名--坪效*/
				chart = perAreaValueRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case REPORT_ACCOUNT_WEEK_DEPTH_RANK:/**全国商场排名--游逛深度*/
				chart = depthRankReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_FORMAT_WEEK_TRAFFIC_RANKING:/**集团全国业态排名--客流量*/
				chart = formatTrifficRankReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_FORMAT_WEEK_SALE_RANKING:/**集团全国业态排名--销售额*/
				chart = FormatSalesRankReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_ACCOUNT_WEEK_CUSTOMERFEATURE_GENDER:/**集团顾客特征--性别分布*/
				chart = genderDistributionReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case REPORT_ACCOUNT_WEEK_CUSTOMERFEATURE_AGE:/**集团顾客特征--年龄分布*/
				chart = ageDistributionReport(orgId,  startDate, endDate, dataMap, reportChart);
				break ;
			default:
				break;
		}
		return chart;
	}
	
	
	
}
