package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.MallDayCountData;
import com.viontech.mall.model.ReportChart;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service
public class AccountMonthReportServiceImpl extends AbstractAccountReportServiceImpl {


	/** 城市下属商场的营业额收入（日） */
	public static final String REPORT_ACCOUNT_MONTH_CITYTRAFFIC = "CityTraffic";
	/**集团月报表-周客流和销售额趋势*/
	public static final  String REPORT_ACCOUNT_MONTH_TRAFFICANDSALE_TREND ="trafficAndSaleTrend";
	/**全国商场排名--客流量*/
	public static final String REPORT_ACCOUNT_MONTH_TRAFFIC_RANK = "trifficRank";
	/**全国商场排名--销售额*/
	public static final String REPORT_ACCOUNT_MONTH_SALE_RANK = "saleRank";
	/**全国商场排名--游逛深度*/
	public static final String REPORT_ACCOUNT_MONTH_DEPTH_RANK = "depthRank";
	/**全国商场排名--客单价*/
	public static final String REPORT_ACCOUNT_MONTH_PREPRICE_RANK = "prePriceRank";
	/**全国商场排名--坪效*/
	public static final String REPORT_ACCOUNT_MONTH_AREAEFFECTIVENESS_RANK = "areaEffRank";
	/**全国商场排名--滞留时间*/
	public static final String REPORT_ACCOUNT_MONTH_DWELLTIME_RANK = "dwellTimeRank" ;

	/**集团全国业态排名--客流量*/
	public static final String REPORT_FORMAT_MONTH_TRAFFIC_RANKING ="format_traffic_ranking";
	/**集团全国业态排名--销售额*/
	public static final String REPORT_FORMAT_MONTH_SALE_RANKING ="format_sale_ranking";
	
	/**集团顾客特征--性别分布*/
	public static final String REPORT_ACCOUNT_MONTH_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**集团顾客特征--年龄分布*/
	public static final String REPORT_ACCOUNT_MONTH_CUSTOMERFEATURE_AGE ="customerfeature_age";

	/** 月客流环比 */
	private  final String FIELD_MONTH_COMPARED_INNUM = "comparedMonthInnum";

	/** 上月环比数据 */
	private final String FEILD_lAST_MONTH_INNUM = "lastMonthInnum";

	/** 去年同比率 */
	private final String FIELD_YEAR_COMPARED_INNUM = "comparedYearInnum";

	/** 去年同比数据*/
	private final String FEILD_lAST_YEAR_INNUM = "lastYearInnum";

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Map<String, Object> head = super.getHead(orgIds, startDate, endDate, dataMap);
		Date lastMonth = DateUtil.getLastMonth(endDate);
		Date lastYear = DateUtil.getLastYear(endDate);
		Long orgId = orgIds[0];
		Integer comparedInnum=null;
		Integer comparedLastYearInnum=null;
		java.util.List<MallDayCountData> historyDatas = getAccountHistoryVisitor(orgId, DateUtil.getLastYear(startDate), DateUtil.getLastDateOfMonth(DateUtil.getLastMonth(endDate)), dataMap);
		if(historyDatas != null && historyDatas.size() > 0){
			comparedInnum = 0;
			comparedLastYearInnum = 0;
			for (MallDayCountData mallDayCountData : historyDatas) {
				if(DateUtil.isSameMonth(mallDayCountData.getCountdate(),lastMonth)) {
					comparedInnum += mallDayCountData.getInnum();
				}
				if(DateUtil.isSameMonth(mallDayCountData.getCountdate(),lastYear)){
					comparedLastYearInnum += mallDayCountData.getInnum();
				}
			}
		}
		String trafficgrowRate = null;
		if (head.get(FIELD_ACCOUNT_INNUM) != null) {
			trafficgrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ACCOUNT_INNUM))), comparedInnum);
		}
		if(trafficgrowRate != null) {
			head.put(FIELD_MONTH_COMPARED_INNUM, trafficgrowRate.replace("%", ""));
			head.put(FEILD_lAST_MONTH_INNUM, comparedInnum);
		}


		String lastYearTrafficGrowRate = null;
		if (head.get(FIELD_ACCOUNT_INNUM) != null) {
			lastYearTrafficGrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ACCOUNT_INNUM))), comparedLastYearInnum);
		}
		if(lastYearTrafficGrowRate != null) {
			head.put(FIELD_YEAR_COMPARED_INNUM, lastYearTrafficGrowRate.replace("%", ""));
			head.put(FEILD_lAST_YEAR_INNUM, comparedLastYearInnum);
		}

		//同比数据
/*		Integer comparedLastYearInnum=null;
		java.util.List<MallDayCountData> historyLastYearDatas = getAccountHistoryVisitor(orgId, DateUtil.getLastYear(startDate), DateUtil.getLastDateOfMonth(DateUtil.getLastYear(endDate)), dataMap);
		if(historyLastYearDatas != null && historyLastYearDatas.size() > 0){
			comparedLastYearInnum = 0;
			for (MallDayCountData mallDayCountData : historyLastYearDatas) {
				comparedLastYearInnum += mallDayCountData.getInnum();
			}
		}
		String lastYearTrafficGrowRate = null;
		if (head.get(FIELD_ACCOUNT_INNUM) != null) {
			lastYearTrafficGrowRate = NumberUtil.growthRate(Integer.parseInt(String.valueOf(head.get(FIELD_ACCOUNT_INNUM))), comparedLastYearInnum);
		}
		if(lastYearTrafficGrowRate != null) {
			head.put(FIELD_YEAR_COMPARED_INNUM, lastYearTrafficGrowRate.replace("%", ""));
			head.put(FEILD_lAST_YEAR_INNUM, comparedLastYearInnum);
		}*/

		return head;
	}





	@SuppressWarnings("rawtypes")
	@Override
	public Chart getChart(Long[] orgIds, Date startDate,Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = null;
		Long orgId = orgIds[0];
		switch (reportChart.getKey()) {
			case REPORT_ACCOUNT_MONTH_CITYTRAFFIC:// 城市当日客流（日）
				chart = CityTrafficReport(orgId,  startDate, endDate, dataMap, reportChart);
				break;
			case  REPORT_ACCOUNT_MONTH_TRAFFICANDSALE_TREND : //客流量、销售额周趋势报表
				chart = trafficAndSaleTrendReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_TRAFFIC_RANK : /**全国商场排名--客流量*/
				chart = trafficRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_SALE_RANK : /**全国商场排名--销售额*/
				chart = salesRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_DEPTH_RANK :/**全国商场排名--游逛深度*/
				chart = depthRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_PREPRICE_RANK :/**全国商场排名--客单价*/
				chart = PrepriceRankingReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_AREAEFFECTIVENESS_RANK  : /**全国商场排名--坪效*/
				chart = perAreaValueRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_DWELLTIME_RANK: /**全国商场排名--滞留时间*/
				chart = trafficRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_FORMAT_MONTH_TRAFFIC_RANKING :/**集团全国业态排名--客流量*/
				chart = formatTrifficRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_FORMAT_MONTH_SALE_RANKING :/**集团全国业态排名--销售额*/
				chart = FormatSalesRankReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_CUSTOMERFEATURE_GENDER  : /**集团顾客特征--性别分布*/
				chart = genderDistributionReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			case  REPORT_ACCOUNT_MONTH_CUSTOMERFEATURE_AGE: /**集团顾客特征--年龄分布*/
				chart = ageDistributionReport(orgId, startDate,endDate, dataMap, reportChart);	
				break;
			default :
				break;
		}
		return chart;
	}
	

	

}
