package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.DateType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.AccountDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.MallDayFaceRecognitionStaService;
import com.viontech.mall.service.adapter.ZoneDayCountDataService;
import com.viontech.mall.vo.MallVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

@Service
public class AccountDayReportServiceImpl extends AbstractAccountReportServiceImpl {
	Logger logger = LoggerFactory.getLogger(this.getClass());

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private AccountDataService accountDataService;

	@Resource
	private ZoneDayCountDataService zoneDayCountDataService;

	@Resource
	private MallDayFaceRecognitionStaService mallDayFaceRecognitionStaService;
	

	/** 已开业商场数量 */
	private  final String FIELD_MALL_OPENED_COUNT = "mallOpenedCount";
	/** 集团商场总数 */
	private  final String FIELD_MALL_ALL_COUNT = "mallAllCount";
	/** 已开业面积 */
	private  final String FIELD_MALL_OPENED_AREA = "mallOpenedArea";
	/** 日累计客流量 */
	private  final String FIELD_DAY_INNUM = "dayInnum";
	/** 昨日累计客流量 */
	private final String FIELD_YESTERDAY_INUM = "yesterdayInnum";
	/** 日累计销售额 */
	private  final String FIELD_DAY_SALES = "daySales";
	/** 日客流环比 */
	private  final String FIELD_DAY_COMPARED_INNUM = "comparedInnum";

	/** 日销售额环比 */
	private  final String FIELD_DAY_COMPARED_SALE = "comparedSale";

	/** 日客流同比  年 */
	private  final String FIELD_DAY_COMPARED_LASTYEAR_INNUM = "comparedLastYearInnum";
	/**日客流同比  周 */
	private final String FIELD_DAY_COMPARED_LASTWEEK_INNUM = "comparedLastWeekInnum";
	/** 上周同比数据 */
	private final String FEILD_DAY_LASTWEEK = "dayLastweekInnum";

	/** 去年同比数据 */
	private final String FEILD_DAY_LASTYEAR = "dayLastyearInnum";

	/** 城市下属商场的营业额收入（日） */
	private  final String REPORT_ACCOUNT_DAY_CITYTRAFFIC = "CityTraffic";
	/** 集团实时客流（日） */
	private  final String REPORT_ACCOUNT_DAY_COSTOMERCOUNTING = "CustomerCounting";
	/** 集团累计客流（日） */
	private  final String REPORT_ACCOUNT_DAY_COSTOMERADD = "Customeradd";
	/** 集团近期趋势--近7天（日） */
	private  final String REPORT_ACCOUNT_DAY_TREND7 = "trend7";
	/** 集团近期趋势--近15天（日） */
	private  final String REPORT_ACCOUNT_DAY_TREND15 = "trend15";
	/** 集团近期趋势--近30天（日） */
	private  final String REPORT_ACCOUNT_DAY_TREND30 = "trend30";
	/** 集团全国商场排名--客流量（日） */
	private  final String REPORT_ACCOUNT_DAY_COSTOMER_RANKING = "costomer_ranking";
	/** 集团全国商场排名--销售额（日） */
	private  final String REPORT_ACCOUNT_DAY_SALE_RANKING = "sale_ranking";
	/** 集团全国商场排名--客单价（日） */
	private  final String REPORT_ACCOUNT_DAY_PREPRICE_RANKING = "preprice_ranking";
	/** 集团全国商场排名--坪效（日） */
	private final String REPORT_ACCOUNT_DAY_SALES_PERSQUAREMETERRANK = "perSquareMeterRank";
	/** 集团全国商场排名--滞留时间（日） */
	private final String REPORT_ACCOUNT_DAY_DURATIONTIMERANK= "durationtimeRank";
	/** 集团全国商场排名--游逛深度（日） */
	private  final String REPORT_ACCOUNT_DAY_DEPTH_RANKING = "depth_ranking";
	/** 集团全国业态排名--客流量（日） */
	private  final String REPORT_FORMAT_DAY_COSTOMER_RANKING = "format_costomer_ranking";
	/** 集团全国业态排名--销售额（日） */
	private  final String REPORT_FORMAT_DAY_SELL_RANKING = "format_sell_ranking";
	/** 集团全国业态排名--进店率（日） */
	private  final String REPORT_FORMAT_DAY_ENTERINGRATE_RANKING = "format_enteringrate_ranking";
	/** 集团顾客特征--性别分布（日） */
	private  final String REPORT_ACCOUNT_DAY_CUSTOMERFEATURE_SEX = "customerfeature_sex";
	/** 集团顾客特征--年龄分布（日） */
	private  final String REPORT_ACCOUNT_DAY_CUSTOMERFEATURE_AGE = "customerfeature_age";

	/**获取商场小时级数据  （今天   昨天  上周同期    上月同期   上年同期 ）*/
	private final String KEY_MALL_HOUR_TRAFFIC = "todayTraffic";
	/**集团  天级区域客流数据  （今天）*/
	private final String KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA = "AccountZoneDayData";

	

	
	@SuppressWarnings("unchecked")
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Date date = startDate;
		Long orgId = orgIds[0];
		Map<String, Object> head = new HashMap<String, Object>();
		Map<Long,Mall> malls = getOrQueryMallMap(orgId, dataMap);
		// 集团下属商场总计
		head.put(FIELD_MALL_ALL_COUNT, malls.size());
		// 已开业商场数量
		Integer opened = null;
		Float openArea = null;
		if (malls != null && malls.size() >0) {
			opened = 0;
			openArea = (float) 0;
			for (Mall mall : malls.values()) {
				if (mall.getStatus().intValue() == PARAM_MALL_STATUS_OPEN) {
					opened++;
				}
				if(mall.getArea() != null){
					openArea += mall.getArea();
				}
			}
		}
		head.put(FIELD_MALL_OPENED_COUNT, opened);
		// 已开业商场面积
		head.put(FIELD_MALL_OPENED_AREA, openArea);

		// 今日累计客流     累计客流环比
		Integer accountInNum = null,comparedInnum = null,comparedLastYearInnum=null,comparedLastWeekInnum = null;
		Date comparedDate = DateUtil.getYesterday(date);
		Date comparedLastYearDate=DateUtil.getLastYear(date);
		Date comparedLastWeekDate = DateUtil.getLastWeek(date);
		List<MallHourCountData> accountDatas =  getAccountHourData(orgId,date, dataMap);
		if (accountDatas != null && accountDatas.size() >0) {
			accountInNum = 0;
			comparedInnum = 0;
			comparedLastYearInnum=0;
			comparedLastWeekInnum = 0 ;
			for (MallHourCountData mallHourCountData : accountDatas) {
				if (DateUtil.isSameDay(mallHourCountData.getCountdate(), date)) {
					accountInNum += mallHourCountData.getInnum();
				}
				if (DateUtil.isSameDay(mallHourCountData.getCountdate(), comparedDate)) {
					comparedInnum += mallHourCountData.getInnum();
				}
				if (DateUtil.isSameDay(mallHourCountData.getCountdate(), comparedLastYearDate)) {
					comparedLastYearInnum += mallHourCountData.getInnum();
				}
				if(DateUtil.isSameDay(mallHourCountData.getCountdate(),comparedLastWeekDate)){
					comparedLastWeekInnum += mallHourCountData.getInnum();
				}
			}
		}
		// 今日累计客流   
		head.put(FIELD_DAY_INNUM, accountInNum);
		// 累计客流环比
		String trafficgrowRate = NumberUtil.growthRate(accountInNum, comparedInnum);
		if (trafficgrowRate != null) {
			head.put(FIELD_DAY_COMPARED_INNUM,trafficgrowRate.replace("%", ""));
			//返回昨天的客流数据
			head.put(FIELD_YESTERDAY_INUM,comparedInnum);
		}
		// 累计客流同比
		String trafficlastyeargrowRate = NumberUtil.growthRate(accountInNum, comparedLastYearInnum);
		if (trafficlastyeargrowRate != null) {
			head.put(FIELD_DAY_COMPARED_LASTYEAR_INNUM, trafficlastyeargrowRate.replace("%", ""));
			//去年同比数据
			head.put(FEILD_DAY_LASTYEAR,comparedLastYearInnum);
		}

		//上周数据同比
		String trafficlastweekgrowRate = NumberUtil.growthRate(accountInNum,comparedLastWeekInnum);
		if(trafficlastweekgrowRate != null){
			head.put(FIELD_DAY_COMPARED_LASTWEEK_INNUM,trafficlastweekgrowRate.replace("%", ""));
			head.put(FEILD_DAY_LASTWEEK,comparedLastWeekInnum);
		}

		// 累计销售额    昨日销售额
		/*Double sales = null, yesterdaySales = null;
		List<Sale> salesDatas = (List<Sale>) getAccountSaleDayData(orgId, date, dataMap);
		if (salesDatas != null && salesDatas.size() > 0) {
			yesterdaySales = 0.0;
			sales = 0.0;
			for (Sale sale : salesDatas) {
				if (DateUtil.isSameDay(date, sale.getSaledate())) {
					sales += sale.getMoney();
				} else if (DateUtil.isSameDay(comparedDate, sale.getSaledate())) {
					yesterdaySales += sale.getMoney();
					
				} 
			}
		}
		//累计销售额  
		head.put(FIELD_DAY_SALES, sales);
		// 销售额环比
		String saleGrowRate = ""+NumberUtil.growthRate(sales, yesterdaySales);
		if (!"null".equals(saleGrowRate)) {
			head.put(FIELD_DAY_COMPARED_SALE, saleGrowRate.replace("%", ""));
		}*/

		//有效客流、店员人才、男性顾客人数、女性顾客人数
		Integer effectiveTraffic = null;
		Integer staffTime = null;
		Integer maleTraffic = null;
		Integer femaleTraffic = null;

		List<MallDayFaceRecognitionSta> faceDatas = getMallFaceSta(orgId, date, date, dataMap);
		if (faceDatas != null && faceDatas.size() > 0) {
			for (MallDayFaceRecognitionSta mallFaceRecognitionSta : faceDatas) {
				if(mallFaceRecognitionSta.getCustomCount() != null){
					if (effectiveTraffic == null)
						effectiveTraffic = mallFaceRecognitionSta.getCustomCount();
					else
						effectiveTraffic += mallFaceRecognitionSta.getCustomCount();
				}
				if(mallFaceRecognitionSta.getStaffCount() != null){
					if (staffTime == null)
						staffTime = mallFaceRecognitionSta.getStaffMantime();
					else
						staffTime += mallFaceRecognitionSta.getStaffMantime();
				}
				if(mallFaceRecognitionSta.getMaleCount() != null){
					if (maleTraffic == null)
						maleTraffic = mallFaceRecognitionSta.getMaleCount();
					else
						maleTraffic += mallFaceRecognitionSta.getMaleCount();
				}
				if(mallFaceRecognitionSta.getFemaleCount() != null){
					if (femaleTraffic == null)
						femaleTraffic = mallFaceRecognitionSta.getFemaleCount();
					else
						femaleTraffic += mallFaceRecognitionSta.getFemaleCount();
				}
			}
		}
		head.put(FIELD_ENABLE_INNUM,effectiveTraffic);
		head.put(FIELD_STAFF_INNUM,staffTime);
		head.put(FIELD_MALE_INNUM,maleTraffic);
		head.put(FIELD_FEMALE_INNUM,femaleTraffic);

		//全国商场分布(用来展示数据)
		head.put(CHART_DETAIL_DATA, getDetail(orgId,date,dataMap));
		// 获取省份客流量(用来展示色块)
		List<MallDayCountData> mallDatas = getAccountTodayData(orgId, date, dataMap);
		Map<String, Integer> provinceMap = new HashMap<String, Integer>();
		for (MallDayCountData mallDayCountData : mallDatas) {
			int innum = mallDayCountData.getInnum();
			Long mallId = mallDayCountData.getMallId();
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			Long cityId = mall.getCityId();
			City city = getOrQueryCityById(cityId, dataMap);
			String provinceName  = "未知";
			if (city != null) {
				provinceName  = city.getProvinceName();
			}
					
			int pinnum = 0;
			if (provinceMap.get(provinceName)!=null) {
				pinnum = provinceMap.get(provinceName);
			}
			pinnum+=innum;
			provinceMap.put(provinceName, pinnum);
		}
		head.put(CHART_TRAFFIC_DATA, provinceMap);
		return head;
	}
	
	/**全国商场布局*/
	public List<MallVo> getDetail(Long orgId,Date date, Map<String, Object> dataMap){
		Map<Long,MallVo> mallVos = new HashMap<Long,MallVo>();
		// 获取当天商场的客流数据
		List<MallDayCountData> mallDatas = getAccountTodayData(orgId, date, dataMap);
		//获取当天商场的销售数据
		/*List<Sale> mallSales = getAccountSaleTodayData(orgId, date, dataMap);
		Map<Long, Double> saleMap = new HashMap<Long, Double>();
		for (Sale sale : mallSales) {
			Long mallId = sale.getMallId();
			Double money = sale.getMoney();
			if (saleMap.get(mallId) != null) {
				money = saleMap.get(mallId);
				money += sale.getMoney();
			}
			saleMap.put(mallId, money);
		}*/
		//获取集团下的所有商场
		Map<Long, Mall> malls = getOrQueryMallMap(orgId, dataMap);
		for (Entry<Long, Mall> entity : malls.entrySet()) {
			Mall mall = entity.getValue();
			if(mall.getStatus() != 1)
				continue;
			Long mallId = entity.getKey();
			MallVo mallVo = new MallVo();
			mallVo.setModel(mall);
			mallVos.put(mallId, mallVo);
		}
		//获取客流数据
		for (MallDayCountData mallDayCountData : mallDatas) {
			Long mallId = mallDayCountData.getMallId();
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			if(mall.getStatus() != 1)
				continue;
			MallVo mallVo = mallVos.get(mallId);
			if (mallVo == null) {
				 mallVo = new MallVo();
				 mallVos.put(mallId, mallVo);
			}
			mallVo.setModel(mall);
			mallVo.setInNum(mallDayCountData.getInnum());
			//mallVo.setRevenues(saleMap.get(mall.getId()));//营业额
		}
		return new ArrayList<MallVo>(mallVos.values());
	}
	


	@Override
	public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Long startTime = null;
		Date date = startDate;
		Long orgId = orgIds[0];
		Chart chart = null;
		switch (reportChart.getKey()) {
		case REPORT_ACCOUNT_DAY_CITYTRAFFIC:// 城市客流排行
			startTime = System.currentTimeMillis();
			chart = CityTrafficReport(orgId, date, dataMap, reportChart);
			logger.debug("城市客流排行--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_COSTOMERCOUNTING:// 集团实时客流（日）
			startTime = System.currentTimeMillis();
			chart = CostomecountingReport(orgId, date, dataMap, reportChart);
			logger.debug("集团实时客流（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_COSTOMERADD:// 集团累计客流（日）
			startTime = System.currentTimeMillis();
			chart = CostomeaddReport(orgId, date, dataMap, reportChart);
			logger.debug(" 集团累计客流（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_TREND7:// 集团近期趋势--近7天（日）
			startTime = System.currentTimeMillis();
			chart = trafficTrendReport(orgId, date, dataMap, reportChart, -6);
			logger.debug("集团近期趋势--近7天（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_TREND15:// 集团近期趋势--近15天（日）
			startTime = System.currentTimeMillis();
			chart = trafficTrendReport(orgId, date, dataMap, reportChart, -14);
			logger.debug("集团近期趋势--近15天（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_TREND30:// 集团近期趋势--近30天（日）
			startTime = System.currentTimeMillis();
			chart = trafficTrendReport(orgId, date, dataMap, reportChart, -29);
			logger.debug("集团近期趋势--近30天（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_COSTOMER_RANKING:// 集团全国商场排名--客流量（日）
			startTime = System.currentTimeMillis();
			chart = trafficRankReport(orgId, date, dataMap, reportChart);
			logger.debug(" 集团全国商场排名--客流量（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_SALE_RANKING:// 集团全国商场排名--销售额（日）
			startTime = System.currentTimeMillis();
			chart = salesRankReport(orgId, date, dataMap, reportChart);
			logger.debug("集团全国商场排名--销售额（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_PREPRICE_RANKING:// 集团全国商场排名--客单价（日）
			startTime = System.currentTimeMillis();
			chart = PrepriceRankingReport(orgId, date, dataMap, reportChart);
			logger.debug("集团全国商场排名--客单价（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_SALES_PERSQUAREMETERRANK:// 集团全国商场排名--坪效
			startTime = System.currentTimeMillis();
			chart = perAreaValueRankReport(orgId, date, dataMap, reportChart);
			logger.debug("集团全国商场排名--坪效--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_DURATIONTIMERANK:// 集团全国商场排名--滞留时间
			break;
		case REPORT_ACCOUNT_DAY_DEPTH_RANKING:// 集团全国商场排名--游逛深度（日）
			startTime = System.currentTimeMillis();
			chart = DepthRankingReport(orgId, date, dataMap, reportChart);
			logger.debug(" 集团全国商场排名--游逛深度（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_FORMAT_DAY_COSTOMER_RANKING://业态客流排行
			startTime = System.currentTimeMillis();
			chart = formatTrifficRankReport(orgId, date, dataMap, reportChart);
			logger.debug("业态客流排行--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_FORMAT_DAY_SELL_RANKING:// 业态销售额排行
			startTime = System.currentTimeMillis();
			chart = FormatSalesRankReport(orgId, date, dataMap, reportChart);
			logger.debug(" 业态销售额排行--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_CUSTOMERFEATURE_SEX:// 集团顾客特征--性别分布（日）
			startTime = System.currentTimeMillis();
			chart = genderDistributionReport(orgId, date, dataMap, reportChart);
			logger.debug("集团顾客特征--性别分布（日）--"+(System.currentTimeMillis()-startTime));
			break;
		case REPORT_ACCOUNT_DAY_CUSTOMERFEATURE_AGE:// 集团顾客特征--年龄分布（日）
			startTime = System.currentTimeMillis();
			chart = ageDistributionReport(orgId, date, dataMap, reportChart);
			logger.debug("集团顾客特征--年龄分布（日）--"+(System.currentTimeMillis()-startTime));
			break;
		default:
			break;
		}
		return chart;
	}

	/**城市客流排行*/
	private Chart CityTrafficReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		List<MallHourCountData> datas = getAccountHourData(orgId, date, dataMap);
		if (datas != null && datas.size() > 0) {
			
			for (MallHourCountData mallHourCountData : datas) {
				Date countDate = mallHourCountData.getCountdate();
				Long mallId = mallHourCountData.getMallId();
				Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
				if(mall == null)
					continue;
				Long cityId = mall.getCityId();
				City city = getOrQueryCityById(cityId, dataMap);
				if (!DateUtil.isSameDay(countDate, date) || city == null)
					continue;

				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(city.getCityName(), mallHourCountData.getInnum().intValue());
			}
			chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
				@Override
				public int compare(Integer o1, Integer o2) {
					return Integer.compare(o1.intValue(), o2.intValue());
				}
			});
			chart.subData(0, 15);
		}
		
		return chart;
	}

	/**客流性别分布*/
	private Chart genderDistributionReport(Long orgId, Date date,  Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
		
		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());
	
		MallDayFaceRecognitionStaExample example = new MallDayFaceRecognitionStaExample();
		example.createColumns().hasAccountIdColumn().hasMaleCountColumn().hasFemaleCountColumn().hasCountdateColumn();
		example.createCriteria().andAccountIdEqualTo(orgId).andCountdateEqualTo(date);
		List<MallDayFaceRecognitionSta> datas = mallDayFaceRecognitionStaService.selectByExample(example);
		
		for (MallDayFaceRecognitionSta mallFaceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),mallFaceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), mallFaceRecognitionSta.getMaleCount());
		}	
		return chart;
	}
	
	/**年龄分布图*/
	private Chart ageDistributionReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
        String[] ages = ageStage.split(",");
        List<Integer> ageStages = new ArrayList<>();
        for (String age : ages) {
            Integer ageInt = Integer.parseInt(age);
            ageStages.add(ageInt);
        }
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
		
		
		MallDayFaceRecognitionStaExample ageStatisticExample = new MallDayFaceRecognitionStaExample();
		ageStatisticExample.createColumns().hasAccountIdColumn().hasMaleStageColumn().hasFemaleStageColumn().hasCountdateColumn();
		ageStatisticExample.createCriteria().andAccountIdEqualTo(orgId).andCountdateEqualTo(date);
		List<MallDayFaceRecognitionSta> ageSta = mallDayFaceRecognitionStaService.selectByExample(ageStatisticExample);
		
		if (ageSta != null && ageSta.size() >0) {
			
			for (MallDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);

				if (maleAgestatic.length != femaleAgestatic.length) {
					continue;
				}

				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
					int maleNum = Integer.parseInt(""+ maleAgestatic[rangeNum].trim());
					int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}
			}
		}
		return chart;
	}
	
	/** 集团日报表--集团业态排名--销售额top10 */
	private Chart FormatSalesRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.SALES.toString());
		
		List<Sale> sales = getAccountSaleTodayData(orgId, date, dataMap);
		for (Sale sale : sales) {
			Zone zone = getOrQueryZoneById(orgId, sale.getZoneId(), dataMap);
			Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(format.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/** 集团日报表--集团业态排名--客流量top10 */
	private Chart formatTrifficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		List<ZoneDayCountData> triffic = getAccountZoneDayTriffic(orgId, date, dataMap);
		if (triffic != null && triffic.size()>0) {
			for (ZoneDayCountData zoneDayCountData : triffic) {
				Zone zone = getOrQueryZoneById(orgId, zoneDayCountData.getZoneId(), dataMap);
				Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
				String formatName = LocalMessageUtil.getMessage("unknownFormat");
				if (format != null && !format.getName().isEmpty()) {
					formatName =format.getName();
				}
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(formatName, zoneDayCountData.getInnum().intValue());		
			}
			chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
				@Override
				public int compare(Integer o1, Integer o2) {
					return Integer.compare(o1.intValue(), o2.intValue());
				}
			});
			chart.subData(0, 10);
		}
		return chart;
	}
	
	/**商场坪效排行      总销售额/总面积*/
	private Chart perAreaValueRankReport(Long orgId, Date date , Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PERAREAVALUE.toString());
		
		List<Sale> sales = getAccountSaleTodayData(orgId, date, dataMap);
		
		for (Sale sale : sales) {
			Mall mall = getOrQueryMallById(sale.getMallId(), orgId, dataMap);
			chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(mall.getName(), sale.getMoney()/mall.getArea());
		}
		chart.sort(ParamName.PERAREAVALUE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/** 集团日报表--集团商场排名--客单价top10   */
	private Chart PrepriceRankingReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PREPRICE.toString());
		
		List<Sale> sales = getAccountSaleTodayData(orgId, date, dataMap);
		
		Map<Long, Double> mallMoney = new HashMap<Long, Double>();
		Map<Long ,Integer> mallInnum = new HashMap<Long, Integer>();  
		
		//计算商场的总销售额   总的消费单数
		for (Sale sale : sales) {
			Long mallId = sale.getMallId();
			
			//商场中销售额
			Double money = sale.getMoney();
			if (mallMoney.get(mallId) != null) {
				money+= mallMoney.get(mallId);
			}
			mallMoney.put(mallId, money);
			//商场中消费单数
			int dealNum = sale.getSalecount();
			if (mallInnum.get(mallId) != null) {
				dealNum += mallInnum.get(mallId);
			}
			mallInnum.put(mallId, dealNum);
		}
		
		for (Long mallId : mallInnum.keySet()) {
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(mall.getName(),NumberUtil.divide(mallMoney.get(mallId), mallInnum.get(mallId), 2));
		}
		chart.sort(ParamName.PREPRICE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/** 集团日报表--集团商场排名--游逛深度top10 */
	private Chart DepthRankingReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		return chart;
	}

	/** 集团日报表--集团商场排名--销售额top10 */
	private Chart salesRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.SALES.toString());
		
		List<Sale> sales = getAccountSaleTodayData(orgId, date, dataMap);
		
		for (Sale sale : sales) {
			Long mallId = sale.getMallId();
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(mall.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/** 集团日报表--集团商场排名--客流量top10 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private Chart trafficRankReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		// 客流量
		List<MallDayCountData> mallDayCostomer =  getAccountTodayData(orgId,date, dataMap);
		
		if (mallDayCostomer != null && mallDayCostomer.size() >0) {
			for (MallDayCountData mallDayCountData : mallDayCostomer) {
				Long mallId = mallDayCountData.getMallId();
				Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(mall.getName(),mallDayCountData.getInnum().intValue());
			}
			chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
				@Override
				public int compare(Integer o1, Integer o2) {
					return Integer.compare(o1.intValue(), o2.intValue());
				}
			});
			chart.subData(0, 10);
		}
		return chart;
	}

	/** 集团日报表--集团近期趋势--近n天 */
	@SuppressWarnings("rawtypes")
	private Chart trafficTrendReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart, int DayNum) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Date beforeDate = DateUtil.addDays(date, DayNum);
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(beforeDate, date);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		//chart.createSeries(ParamName.SALES.toString());
		// 客流量
		List<MallDayCountData> mallDayCostomer = getAccountDayData(orgId, date, dataMap);
		List<Date> dates = DateUtil.getDaysBetweenDates(beforeDate, date);
		for (MallDayCountData mallDayCountData : mallDayCostomer) {
			Date dataTime = mallDayCountData.getCountdate();
			if (dates.contains(dataTime)) {
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(mallDayCountData.getCountdate(), mallDayCountData.getInnum());
			}
		}
		//销售额
//		List<Sale> sales = getAccountSaleDayData(orgId, date, dataMap);
//		for (Sale sale : sales) {
//			Date saleDate = sale.getSaledate();
//			if (dates.contains(saleDate)) {
//				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
//			}
//		}
		return chart;
	}

	/** 集团日报表--集团累计客流 */
	@SuppressWarnings("rawtypes")
	private Chart CostomeaddReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line) {
			@Override
			public Object calcValue(String name,int index, List data) {
				Double result = null;
				if (data.get(index) != null) {
					result = Double.parseDouble(data.get(index).toString());
					if(index==0){
						return result;
					}
					int pre = index;
					while((--pre) > 0){
						if(data.get(pre) == null){
							continue;
						}
						result += Double.parseDouble(data.get(pre).toString());
						break;
					}
				}
				return result;
			}
		};
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = getAccountOpentime(orgId);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);


		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());

		List<MallHourCountData> mallHourCountDatas = (List<MallHourCountData>) getAccountHourData(orgId, date, dataMap);

		for (MallHourCountData mallHourCountData : mallHourCountDatas) {
			Date dateTemp = mallHourCountData.getCountdate();
			Date xDate = mallHourCountData.getCounttime();
			DateType dateType = DateType.valueOfDay(date, dateTemp);
			chart.getSeries(dateType.toString()).adjustOrPutValueByCoordinate(xDate, mallHourCountData.getInnum());
		}
		return chart;
	}

	/** 集团日报表--集团实时客流 */
	@SuppressWarnings("rawtypes")
	private Chart CostomecountingReport(Long orgId, Date date, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 创建x小时轴
		Axis<Date> xAxis = AxisFactory.creatSdfDateAxix("HH:00",Calendar.HOUR);
		DateCriteria opentime = getAccountOpentime(orgId);
		xAxis.setMin(opentime.getStartDate());
		xAxis.setMax(opentime.getEndDate());
		xAxis.lockMinMax();
		chart.setXAxis(xAxis);

		// 创建报表显示系列
		chart.createSeries(DateType.TODAY.toString());
		chart.createSeries(DateType.YESTERDAY.toString());
		chart.createSeries(DateType.LASTWEEKDAY.toString());
		chart.createSeries(DateType.LASTMONTHDAY.toString());
		chart.createSeries(DateType.LASTYEARDAY.toString());

		List<MallHourCountData> mallHourCountDatas = (List<MallHourCountData>) getAccountHourData(orgId, date, dataMap);

		for (MallHourCountData mallHourCountData : mallHourCountDatas) {
			Date countData = mallHourCountData.getCountdate();
			Date xDate = mallHourCountData.getCounttime();
			DateType dateType = DateType.valueOfDay(date, countData);
			chart.getSeries(dateType.toString()).adjustOrPutValueByCoordinate(xDate, mallHourCountData.getInnum());

		}
		return chart;
	}
	
	/** 集团日报表  小时级客流数据  （今天   昨天  上周同期    上月同期   上年同期 ）*/
	private List<MallHourCountData> getAccountHourData(Long orgId,Date date,  Map<String, Object> dataMap) {
		List<Date> dates = new ArrayList<Date>();
		dates.add(date);
		Date yesterday = DateUtil.getYesterday(date);
		dates.add(yesterday);
		Date lastWeekDay = DateUtil.getLastWeek(date);
		dates.add(lastWeekDay);
		Date lastMontdDay = DateUtil.getLastMonth(date);
		dates.add(lastMontdDay);
		Date lastYearDay = DateUtil.getLastYear(date);
		dates.add(lastYearDay);
		
		List<MallHourCountData> datas = (List<MallHourCountData>) dataMap.get(KEY_MALL_HOUR_TRAFFIC);
		if (datas == null) {
			datas = (List<MallHourCountData>) accountDataService.getHourData(dates, orgId);
			dataMap.put(KEY_MALL_HOUR_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**集团日报表  天级客流数据（近n天 默认30天）*/
	private List<MallDayCountData> getAccountDayData(Long orgId,Date date,Map<String, Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_ACCOUNT_TRIFFIC_DAYDATA);
		if ( datas == null || datas.size() <= 0) {
			Date beforeDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);// 向前推n天的日期
			datas = getAccountVisitor(orgId, beforeDate, date, dataMap);
			dataMap.put(KEY_ACCOUNT_TRIFFIC_DAYDATA, datas);
		}
		return datas;
	}
	
	/**集团日报表   今天客流数据（天级）*/
	private List<MallDayCountData> getAccountTodayData(Long orgId,Date today,Map<String, Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_ACCOUNT_TRIFFIC_DAYDATA);
		List<MallDayCountData> todayDatas = new ArrayList<MallDayCountData>();
		if (datas == null || datas.size() <= 0) {
			datas = new ArrayList<MallDayCountData>();
			datas =  getAccountDayData(orgId, today ,dataMap);
		}
		if (datas != null && datas.size()>0) {
			for (MallDayCountData mallDayCountData : datas) {
				if (DateUtil.isSameDay(today, mallDayCountData.getCountdate()))
					todayDatas.add(mallDayCountData);
			}
		}
		return todayDatas;
	}
	
	/**获取集团 店铺  客流数据（天级）*/
	private List<ZoneDayCountData> getAccountZoneDayTriffic(Long orgId, Date  date, Map<String, Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA);
		if (datas == null) {
			datas = new ArrayList<ZoneDayCountData>();
			ZoneDayCountDataExample example = new ZoneDayCountDataExample();
			example.createColumns();
			example.createCriteria().andAccountIdEqualTo(orgId).andCountdateEqualTo(date);
		    datas = zoneDayCountDataService.selectByExample(example);
		    dataMap.put(KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA, datas);
		}
		return datas;
	}
	
	/**集团日报表   天级销售数据（默认近30天）*/
	private List<Sale> getAccountSaleDayData(Long orgId,Date date,Map<String, Object> dataMap){
		List<Sale> datas = (List<Sale>) dataMap.get(KEY_ACCOUNT_SALES);
		if (datas == null) {
			Date beforeDate = DateUtil.addDays(date, PARAM_DEFAULT_BEFOREDAY30);// 向前推n天的日期
			datas = getAccountSales(orgId, beforeDate, date, dataMap);
			dataMap.put(KEY_ACCOUNT_SALES, datas);
		}
		return datas;
	}
	
	/**集团日报表   今天销售数据*/
	private List<Sale> getAccountSaleTodayData(Long orgId,Date date,Map<String,Object> dataMap){
		List<Sale> datas = (List<Sale>) dataMap.get(KEY_ACCOUNT_SALES);
		List<Sale> todayData = new ArrayList<Sale>();
		if(dataMap.get(KEY_ACCOUNT_SALES) == null){
			datas = getAccountSaleDayData(orgId, date, dataMap);
		}
		for (Sale sale : datas) {
			if (DateUtil.isSameDay(date, sale.getSaledate())) {
				todayData.add(sale);
			}
		}
		return todayData;
	}

}
