package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.FloorDataService;
import com.viontech.mall.report.service.adapter.ZoneDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.SaleService;
import com.viontech.mall.service.adapter.ZoneDayFaceRecognitionStaService;
import com.viontech.mall.service.adapter.ZoneService;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

public abstract class AbstractZoneReportServiceImpl extends ChartReportBaseService {

    @Value("${Age.stage}")
    private String ageStage;

    @Resource
    private ZoneDataService zoneDataService;

    @Resource
    private FloorDataService floorDataService;

    @Resource
    private ZoneDayFaceRecognitionStaService zoneFaceRecognitionStaService;

    @Resource
    private SaleService saleService;

    @Resource
    private ZoneService zoneService;

    /**
     * 累计客流
     */
    public static final String FIELD_ZONE_ACCUMULATIVE_TRAFFIC = "accumulativeTraffic";
    /**
     * 累计销售额
     */
    public static final String FIELD_ACCUMULATIVE_SALE = "accumulativeSale";
    /**
     * 进店率
     */
    public static final String FIELD_ENTERINGRATE = "enteringRate";
    /**
     * 客流占比
     */
    public static final String FIELD_RATIOOFTRAFFIC = "trafficRatio";
    /**
     * 滞留时间
     */
    public static final String FIELD_DURATIONTIME = "durationTime";
    /**
     * 坪效
     */
    public static final String FIELD_PERSQUAREMETER = "perSquaremeter";
    /**
     * 成交量
     */
    public static final String FIELD_TURNOVER = "turnover";
    /**
     * 客单价
     */
    public static final String FIELD_PERCUSTOMERTRANSACTION = "perTransaction";
    /**
     * 提袋率
     */
    public static final String FIELD_HANDBAGRATE = "handbagRate";
    /**
     * 平均客流量
     */
    public static final String FIELD_AVERAGE_INNUM = "averageInnum";
    /**
     * 工作日平均客流量
     */
    public static final String FIELD_WORKDAY_AVERAGE_INNUM = "workdayAverageInnum";
    /**
     * 休息日平均客流量
     */
    public static final String FIELD_WEEKEND_AVERAGE_INNUM = "weekendAverageInnum";
    /**
     * 平均销售额
     */
    public static final String FIELD_AVERAGE_SALES = "averageSales";
    /**
     * 工作日平均销售额
     */
    public static final String FIELD_WORKDAY_AVERAGE_SALES = "workdayAverageSales";
    /**
     * 休息日平均销售额
     */
    public static final String FIELD_WEEKEND_AVERAGE_SALES = "weekendAverageSales";

    /**
     * 有效客流
     */
    public static final String FIELD_ENABLE_INNUM = "effectiveTraffic";
    /**
     * 店员客流
     */
    public static final String FIELD_STAFF_INNUM = "staffManTime";
    /**
     * 男性客流
     */
    public static final String FIELD_MALE_INNUM = "maleTraffic";
    /**
     * 女性客流
     */
    public static final String FIELD_FEMALE_INNUM = "femaleTraffic";


    /**
     * 店铺顾客特征--性别分布
     */
    public static final String REPORT_ZONE_CUSTOMERFEATURE_GENDER = "customerfeature_gender";
    /**
     * 店铺顾客特征--年龄分布
     */
    public static final String REPORT_ZONE_CUSTOMERFEATURE_AGE = "customerfeature_age";
    /**
     * 店铺顾客特征--新老顾客
     */
    public static final String REPORT_ZONE_CUSTOMERFEATURE_NAO = "customerfeature_NAO";
    /**
     * 店铺近期客流趋势
     */
    public static final String REPORT_ZONE_DAY_TRAFFIC_TREND = "trafficTrend";
    /**
     * 店铺近期销售额趋势
     */
    public static final String REPORT_ZONE_DAY_SALE_TREND = "SaleTrend";
    /**
     * 店铺近期进店率趋势
     */
    public static final String REPORT_ZONE_DAY_ENTERINGRATE_TREND = "EnteringRateTrend";
    /**
     * 店铺近期客单价趋势
     */
    public static final String REPORT_ZONE_DAY_PERTRANSACTION_TREND = "PerTransactionTrend";
    /**
     * 店铺近期坪效趋势
     */
    public static final String REPORT_ZONE_DAY_PERSQUARE_TREND = "PerSquareTrend";
    /**
     * 店铺近期提袋率趋势
     */
    public static final String REPORT_ZONE_DAY_HANDBAGRATE_TREND = "HandbagRateTrend";
    /**
     * 店铺近期滞留时间趋势
     */
    public static final String REPORT_ZONE_DAY_DURATIONTIME_TREND = "durationtimeTrend";


    /**
     * 店铺客流数据（天级）
     */
    public static final String KEY_ZONE_DAY_TRAFFIC = "zoneDayTraffic";
    /**
     * 店铺销售额
     */
    public static final String KEY_ZONE_DAY_SALE = "zoneDaySale";
    /**
     * 店铺      人脸抓拍统计
     */
    public static final String KEY_ZONE_FACE_RECOGNITION = "zoneFaceRecognition";
    /**
     * 店铺 信息
     */
    public static final String KEY_ZONE_INFO = "zoneInfo";
    /**
     * 商场营业时间
     */
    public static final String KEY_MALL_OPENTIME = "mallOpenTime";
    /**
     * 店铺     客流量（小时级）
     */
    public static final String KEY_ZONE_HOUR_TRAFFIC = "zoneHourTraffic";

    /**
     * 店铺面积
     */
    private final String FIELD_ZONE_OPENED_AREA = "zoneArea";
    /**
     * 商场  历史同期天级客流数据
     */
    public static final String KEY_ZONE_TRIFFIC_HISTORY_DATA = "ZoneHistoryData";


    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate,
                                       Map<String, Object> dataMap) {
        Long orgId = orgIds[0];
        Map<String, Object> head = new HashMap<String, Object>();
        Zone zone = getOrQueryZoneById(orgId, dataMap);
        head.put(FIELD_ZONE_OPENED_AREA, zone.getArea());
        //累计客流
        List<ZoneDayCountData> zoneData = getOrQueryZoneDayTraffic(orgId, startDate, endDate, dataMap);
        Integer zoneInnum = null, outsideNum = null, stayNum = null, workDayNum = null, weekendDayNum = null;
        Integer allDay = null, workDay = null, weekendDay = null;
        Long floorId = null;
        Double dayStay = 0d;
        if (zoneData != null && zoneData.size() > 0) {
            outsideNum = 0;
            zoneInnum = 0;
            stayNum = 0;
            workDayNum = 0;
            weekendDayNum = 0;
            allDay = 0;
            workDay = 0;
            weekendDay = 0;
            for (ZoneDayCountData zoneDayCountData : zoneData) {
                floorId = zoneDayCountData.getFloorId();
                zoneInnum += zoneDayCountData.getInnum();
                Integer outsideInnum = Optional.ofNullable(zoneDayCountData.getOutsideInnum()).orElse(0);
                Integer outsideOutnum = Optional.ofNullable(zoneDayCountData.getOutsideOutnum()).orElse(0);
                outsideNum += (outsideInnum + outsideOutnum);
                int zoneNowNum = zoneDayCountData.getInnum() - zoneDayCountData.getOutnum();
                //stayNum += (zoneNowNum < 0 ? 0 : zoneNowNum);
                stayNum = (zoneNowNum < 0 ? 0 : zoneNowNum);
                if (zoneDayCountData.getInnum() != 0 && stayNum != 0) {
                    dayStay += NumberUtil.divide(stayNum, zoneDayCountData.getInnum(), 2);
                }
                allDay++;
                if (DateUtil.getDayOfWeek(zoneDayCountData.getCountdate()) < 6) {
                    workDay++;
                    workDayNum += zoneDayCountData.getInnum();
                } else {
                    weekendDay++;
                    weekendDayNum += zoneDayCountData.getInnum();
                }
            }
        }
        head.put(FIELD_ZONE_ACCUMULATIVE_TRAFFIC, zoneInnum);

        //客流占比
        Integer floorInnum = null;
        List<FloorDayCountData> floorDatas = null;
        if (floorId != null) {
            floorDatas = (List<FloorDayCountData>) floorDataService
                    .getDayData(startDate, endDate, floorId);
        }
        if (floorDatas != null && floorDatas.size() > 0) {
            floorInnum = 0;
            for (FloorDayCountData floorCountData : floorDatas) {
                floorInnum += floorCountData.getInnum();
            }
        }
        Double trafficRatio = NumberUtil.percentage(zoneInnum, floorInnum, 2);
        head.put(FIELD_RATIOOFTRAFFIC, trafficRatio);
        //滞留时间
        Double stayTime = NumberUtil.divide(dayStay, allDay, 2);
        head.put(FIELD_DURATIONTIME, stayTime);

        //有效客流、店员人才、男性顾客人数、女性顾客人数
        Integer effectiveTraffic = null;
        Integer staffTime = null;
        Integer maleTraffic = null;
        Integer femaleTraffic = null;

        //获取系统配置参数
        Long mallId = Optional.ofNullable(zone.getMallId()).orElse(0L);
        Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
        ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
        String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

        List<ZoneDayFaceRecognitionSta> datas = getOrQueryZoneDayFaceRecognitionStaData(orgId,
                startDate, endDate, dataMap);
        if (datas != null && datas.size() > 0) {
            for (ZoneDayFaceRecognitionSta faceData : datas) {
                //计算有效客流
                if (effectiveTraffic == null) {
                    if ("0".equals(enableTrafficFlag)) {
                        effectiveTraffic = faceData.getCustomCount();
                    } else {
                        effectiveTraffic = faceData.getMaleCount() + faceData.getFemaleCount();
                    }
                } else {
                    if ("0".equals(enableTrafficFlag)) {
                        effectiveTraffic += faceData.getCustomCount();
                    } else {
                        effectiveTraffic += (faceData.getMaleCount() + faceData.getFemaleCount());
                    }
                }
                if (faceData.getStaffCount() != null) {
                    if (staffTime == null) {
                        staffTime = faceData.getStaffMantime();
                    } else {
                        staffTime += faceData.getStaffMantime();
                    }
                }
                if (faceData.getMaleCount() != null) {
                    if (maleTraffic == null) {
                        maleTraffic = faceData.getMaleCount();
                    } else {
                        maleTraffic += faceData.getMaleCount();
                    }
                }
                if (faceData.getFemaleCount() != null) {
                    if (femaleTraffic == null) {
                        femaleTraffic = faceData.getFemaleCount();
                    } else {
                        femaleTraffic += faceData.getFemaleCount();
                    }
                }
            }
        }
        head.put(FIELD_ENABLE_INNUM, effectiveTraffic);
        head.put(FIELD_STAFF_INNUM, staffTime);
        head.put(FIELD_MALE_INNUM, maleTraffic);
        head.put(FIELD_FEMALE_INNUM, femaleTraffic);

        //进店率
        Double enterRate = 0.0;
        ConfigParams enterRateConfig = configParamsMap.get("enterRateConfig");
        String enterRateConfigFlag = Optional.ofNullable(enterRateConfig.getValue()).orElse("0");
        if ("0".equals(enterRateConfigFlag)) {
            Number outsideTraffic = (Number) NumberUtil.valueAdd(outsideNum, zoneInnum);
            enterRate = NumberUtil.percentage(zoneInnum, outsideTraffic, 2);
        } else if ("1".equals(enterRateConfigFlag)) {
            Number outsideTraffic = (Number) NumberUtil.valueAdd(outsideNum, effectiveTraffic);
            enterRate = NumberUtil.percentage(effectiveTraffic, outsideTraffic, 2);
        } else if ("2".equals(enterRateConfigFlag)) {
            enterRate = NumberUtil.percentage(zoneInnum, outsideNum, 2);
        } else {
            enterRate = NumberUtil.percentage(effectiveTraffic, outsideNum, 2);
        }
        head.put(FIELD_ENTERINGRATE, enterRate);

        //日均客流
        Double avgTraffic = NumberUtil.divide(zoneInnum, allDay, 0);
        head.put(FIELD_AVERAGE_INNUM, avgTraffic);
        //工作日平均客流
        Double wordDayTraffic = NumberUtil.divide(workDayNum, workDay, 0);
        head.put(FIELD_WORKDAY_AVERAGE_INNUM, wordDayTraffic);
        //双休日平均客流
        Double weekendDayTraffic = NumberUtil.divide(weekendDayNum, weekendDay, 0);
        head.put(FIELD_WEEKEND_AVERAGE_INNUM, weekendDayTraffic);
        /**累计销售额*/
        List<Sale> sales = getOrQueryZoneSales(orgId, startDate, endDate, dataMap);
        Double accumulativeSale = null, workDaysale = null, weekendDaySale = null;
        Integer saleCount = null, workDaySaleDay = null, weekendDaySaleDay = null, allDaySaleDay = null;
        if (sales != null && sales.size() > 0) {
            accumulativeSale = 0.0;
            workDaysale = 0.0;
            weekendDaySale = 0.0;
            saleCount = 0;
            workDaySaleDay = 0;
            weekendDaySaleDay = 0;
            allDaySaleDay = 0;
            for (Sale sale : sales) {
                accumulativeSale += sale.getMoney();
                saleCount += sale.getSalecount();
                allDaySaleDay++;
                if (DateUtil.getDay(sale.getSaledate()) < 6) {
                    workDaySaleDay++;
                    workDaysale += sale.getMoney();
                } else {
                    weekendDaySaleDay++;
                    weekendDaySale += sale.getMoney();
                }
            }
        }
        head.put(FIELD_ACCUMULATIVE_SALE, accumulativeSale);

        Double avgSaleNum = null, avgWorkDaySaleNum = null, avgWeekendDaySaleNum = null;
        avgSaleNum = NumberUtil.divide(accumulativeSale, allDaySaleDay, 2);
        avgWorkDaySaleNum = NumberUtil.divide(workDaysale, workDaySaleDay, 2);
        avgWeekendDaySaleNum = NumberUtil.divide(weekendDaySale, weekendDaySaleDay, 2);
        head.put(FIELD_AVERAGE_SALES, avgSaleNum);//日均销售额
        head.put(FIELD_WORKDAY_AVERAGE_SALES, avgWorkDaySaleNum);//工作日平均销售额
        head.put(FIELD_WEEKEND_AVERAGE_SALES, avgWeekendDaySaleNum);//双休日平均销售额
        /**坪效*/
        Double perAreaPrice = null;
        if (zone != null && zone.getArea() != null) {
            float zoneArea = zone.getArea();
            perAreaPrice = NumberUtil.divide(accumulativeSale, zoneArea, 2);
        }
        head.put(FIELD_PERSQUAREMETER, perAreaPrice);
        /**成交量*/
        head.put(FIELD_TURNOVER, saleCount);
        /**客单价*/
        head.put(FIELD_PERCUSTOMERTRANSACTION, NumberUtil.divide(accumulativeSale, saleCount, 2));
        /**提袋率*/
        head.put(FIELD_HANDBAGRATE, NumberUtil.percentage(saleCount, zoneInnum, 2));
        return head;
    }

    /**
     * 店铺近期滞留时间趋势
     */
    public Chart DurationTimeTrendReport(Long orgId, Date startDate, Date endDate,
                                         Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.DURATIONTIME.toString(), SeriesType.line);

        Map<Date, List<ZoneHourCountData>> datas = getOrQueryZoneHourMapData(orgId, startDate, endDate,
                dataMap);
        for (Entry<Date, List<ZoneHourCountData>> entry : datas.entrySet()) {
            Date keyDate = entry.getKey();
            //获取店铺当日以小时为单位的客流量
            List<ZoneHourCountData> zoneHourDatas = entry.getValue();
            int innumHour = 0, innumDay = 1;
            for (ZoneHourCountData zoneHourCountData : zoneHourDatas) {
                innumHour += zoneHourCountData.getInnum();
            }

            //获取店铺当日的日客流量
            List<ZoneDayCountData> zoneDayCountDatas = getOrQueryZoneDayTraffic(orgId, startDate, endDate,
                    dataMap);
            List<ZoneDayCountData> todayZoneDatas = new ArrayList<ZoneDayCountData>();
            for (ZoneDayCountData zoneDayCountData : zoneDayCountDatas) {
                if (DateUtil.isSameDay(keyDate, zoneDayCountData.getCountdate())) {
                    todayZoneDatas.add(zoneDayCountData);
                }
            }
            if (todayZoneDatas != null && todayZoneDatas.size() > 0) {
                innumDay = todayZoneDatas.get(0).getInnum();
            }

            chart.getSeries(ParamName.DURATIONTIME.toString()).adjustOrPutValueByCoordinate(keyDate,
                    NumberUtil.divide(innumHour, innumDay, 2));
        }

        return chart;
    }

    /**
     * 店铺近期提袋率趋势
     */
    public Chart HandbagRateTrendReport(Long orgId, Date startDate, Date endDate,
                                        Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.HANDBAGRATE.toString());

        List<ZoneDayCountData> zoneDatas = getOrQueryZoneDayTraffic(orgId, startDate, endDate, dataMap);
        Map<Date, ZoneDayCountData> zoneDataMap = new HashMap<Date, ZoneDayCountData>();
        for (ZoneDayCountData zoneDayCountData : zoneDatas) {
            zoneDataMap.put(zoneDayCountData.getCountdate(), zoneDayCountData);
        }

        List<Sale> sales = getOrQueryZoneSales(orgId, startDate, endDate, dataMap);
        if (sales != null && sales.size() > 0) {
            for (Sale sale : sales) {
                Date saleDate = sale.getSaledate();
                int innum = 1;
                ZoneDayCountData zoneDayCountData = zoneDataMap.get(saleDate);
                if (zoneDayCountData != null) {
                    innum = zoneDayCountData.getInnum();
                }
                chart.getSeries(ParamName.HANDBAGRATE.toString()).adjustOrPutValueByCoordinate(saleDate,
                        NumberUtil.percentage(sale.getSalecount(), innum, 2));
            }
        }
        return chart;
    }

    /**
     * 店铺近期坪效趋势
     */
    public Chart PerSquareTrendReport(Long orgId, Date startDate, Date endDate,
                                      Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.PERAREAVALUE.toString());

        List<Sale> sales = getOrQueryZoneSales(orgId, startDate, endDate, dataMap);
        if (sales != null && sales.size() > 0) {
            Zone zone = getOrQueryZoneById(orgId, dataMap);
            float area = zone.getArea();
            for (Sale sale : sales) {
                chart.getSeries(ParamName.PERAREAVALUE.toString())
                        .adjustOrPutValueByCoordinate(sale.getSaledate()
                                , NumberUtil.divide(sale.getMoney(), area, 2));
            }
        }
        return chart;
    }

    /**
     * 店铺近期客单价趋势
     */
    public Chart PerTransactionTrendReport(Long orgId, Date startDate, Date endDate,
                                           Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.PREPRICE.toString());

        List<Sale> sales = getOrQueryZoneSales(orgId, startDate, endDate, dataMap);
        if (sales != null && sales.size() > 0) {
            for (Sale sale : sales) {
                chart.getSeries(ParamName.PREPRICE.toString())
                        .adjustOrPutValueByCoordinate(sale.getSaledate(),
                                NumberUtil.divide(sale.getMoney(), sale.getSalecount(), 2));
            }
        }
        return chart;
    }

    /**
     * 店铺近期进店率趋势
     */
    public Chart EnteringRateTrendReport(Long orgId, Date startDate, Date endDate,
                                         Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.ENTERINGRATE.toString());

        List<ZoneDayCountData> datas = getOrQueryZoneDayTraffic(orgId, startDate, endDate, dataMap);
        if (datas != null && datas.size() > 0) {
            for (ZoneDayCountData z : datas) {
                chart.getSeries(ParamName.ENTERINGRATE.toString())
                        .adjustOrPutValueByCoordinate(z.getCountdate(),
                                NumberUtil.percentage(z.getInnum(), z.getOutsideInnum() + z.getOutsideOutnum(), 2));
            }
        }

        return chart;
    }

    /**
     * 店铺近期销售额趋势
     */
    public Chart SaleTrendReport(Long orgId, Date startDate, Date endDate,
                                 Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.SALES.toString());
        //销售额
        List<Sale> sales = getOrQueryZoneSales(orgId, startDate, endDate, dataMap);
        for (Sale sale : sales) {
            chart.getSeries(ParamName.SALES.toString())
                    .adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
        }
        return chart;
    }

    /**
     * 店铺近期客流量趋势
     */
    public Chart trafficTrendReport(Long orgId, Date startDate, Date endDate,
                                    Map<String, Object> dataMap, ReportChart reportChart) {
        // 创建报表Chart
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
        // 向前推N天的日期
        Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.TRAFFIC.toString());
        // 客流量
        List<ZoneDayCountData> DayTraffic = getOrQueryZoneDayTraffic(orgId, startDate, endDate,
                dataMap);
        for (ZoneDayCountData DayCountData : DayTraffic) {
            chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(
                    DayCountData.getCountdate(), DayCountData.getInnum());
        }
        return chart;
    }

    /**
     * 店铺顾客特征--性别分布
     */
    public Chart genderDistributionReport(Long orgId, Date startDate, Date endDate,
                                          Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);

        Axis<String> xAxis = AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);

        chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());

        List<ZoneDayFaceRecognitionSta> datas = getOrQueryZoneDayFaceRecognitionStaData(orgId,
                startDate, endDate, dataMap);
        for (ZoneDayFaceRecognitionSta zoneFaceRecognitionSta : datas) {
            chart.getSeries(ParamName.GENDERDISTRIBUTION.toString())
                    .adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),
                            zoneFaceRecognitionSta.getFemaleCount());
            chart.getSeries(ParamName.GENDERDISTRIBUTION.toString())
                    .adjustOrPutValueByCoordinate(ParamName.MALE.toString(),
                            zoneFaceRecognitionSta.getMaleCount());
        }
        return chart;
    }

    /**
     * 店铺顾客特征--年龄分布
     */
    public Chart ageDistributionReport(Long orgId, Date startDate, Date endDate,
                                       Map<String, Object> dataMap, ReportChart reportChart) {
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

        Axis<String> xAxis = AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);
        String[] ages = ageStage.split(",");
        List<Integer> ageStages = new ArrayList<>();
        for (String age : ages) {
            Integer ageInt = Integer.parseInt(age);
            ageStages.add(ageInt);
        }
        String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);

        List<ZoneDayFaceRecognitionSta> ageSta = getOrQueryZoneDayFaceRecognitionStaData(orgId,
                startDate, endDate, dataMap);

        if (ageSta != null && ageSta.size() > 0) {
            for (ZoneDayFaceRecognitionSta ageStatistic : ageSta) {
                String maleStage = ageStatistic.getMaleStage();
                String femaleStage = ageStatistic.getFemaleStage();
                if (maleStage == null || maleStage.isEmpty() || femaleStage == null || femaleStage
                        .isEmpty()) {
                    continue;
                }
                String[] maleAgestatic = maleStage.split(",", -2);
                String[] femaleAgestatic = femaleStage.split(",", -2);

                if (maleAgestatic.length != femaleAgestatic.length) {
                    continue;
                }
                for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
                    int maleNum = Integer.parseInt("" + maleAgestatic[rangeNum].trim());
                    int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
                    String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum, ageStages)];
                    chart.getSeries(ageRange)
                            .adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
                    chart.getSeries(ageRange)
                            .adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
                    //chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
                }
            }
        }
        return chart;
    }


    /**
     * 店铺   人脸抓拍统计表
     */
    public List<ZoneDayFaceRecognitionSta> getOrQueryZoneDayFaceRecognitionStaData(Long zoneId,
                                                                                   Date startDate, Date endDate, Map<String, Object> dataMap) {
        List<ZoneDayFaceRecognitionSta> datas = (List<ZoneDayFaceRecognitionSta>) dataMap
                .get(KEY_ZONE_FACE_RECOGNITION);
        if (datas == null) {
            datas = new ArrayList<>();
            ZoneDayFaceRecognitionStaExample example = new ZoneDayFaceRecognitionStaExample();
            example.createCriteria().andZoneIdEqualTo(zoneId).andCountdateBetween(startDate, endDate);
            datas = zoneFaceRecognitionStaService.selectByExample(example);
            dataMap.put(KEY_ZONE_FACE_RECOGNITION, datas);
        }
        return datas;
    }

    /**
     * 获取店铺天级的客流数据
     */
    public List<ZoneDayCountData> getOrQueryZoneDayTraffic(Long zoneId, Date StartDate, Date endDate,
                                                           Map<String, Object> dataMap) {
        List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
        if (datas == null) {
            datas = (List<ZoneDayCountData>) zoneDataService.getDayData(StartDate, endDate, zoneId);
            dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
        }
        return datas;
    }

    /**
     * 获取店铺天级的历史客流数据
     */
    public List<ZoneDayCountData> getOrQueryHistoryZoneDayTraffic(Long zoneId, Date StartDate,
                                                                  Date endDate, Map<String, Object> dataMap) {
        List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap
                .get(KEY_ZONE_TRIFFIC_HISTORY_DATA);
        if (datas == null) {
            datas = (List<ZoneDayCountData>) zoneDataService.getDayData(StartDate, endDate, zoneId);
            dataMap.put(KEY_ZONE_TRIFFIC_HISTORY_DATA, datas);
        }
        return datas;
    }

    /**
     * 获取店铺小时级的客流数据     近n天的数据+上周同期+上月同期+上年同期
     */
    public Map<Date, List<ZoneHourCountData>> getOrQueryZoneHourMapData(Long zoneId, Date StartDate,
                                                                        Date endDate, Map<String, Object> dataMap) {
        Map<Date, List<ZoneHourCountData>> datas = (Map<Date, List<ZoneHourCountData>>) dataMap
                .get(KEY_ZONE_HOUR_TRAFFIC);
        Date todayDate = endDate;
        if (datas == null) {
            datas = new HashMap<Date, List<ZoneHourCountData>>();
            Set<Date> dates = new HashSet();
            dates.addAll(DateUtil.getDaysBetweenDates(StartDate, endDate));
            dates.add(todayDate);
            Date yesterday = DateUtil.getYesterday(todayDate);
            dates.add(yesterday);
            Date lastWeekDay = DateUtil.getLastWeek(todayDate);
            dates.add(lastWeekDay);
            Date lastMontdDay = DateUtil.getLastMonth(todayDate);
            dates.add(lastMontdDay);
            Date lastYearDay = DateUtil.getLastYear(todayDate);
            dates.add(lastYearDay);

            List<ZoneHourCountData> dataList = (List<ZoneHourCountData>) zoneDataService
                    .getHourData(new ArrayList<Date>(dates), zoneId);

            for (ZoneHourCountData zoneHourCountData : dataList) {
                Date date2 = zoneHourCountData.getCountdate();
                List<ZoneHourCountData> dayList = datas.get(date2);
                if (dayList == null) {
                    dayList = new ArrayList<ZoneHourCountData>();
                }
                dayList.add(zoneHourCountData);
                datas.put(date2, dayList);

            }

            dataMap.put(KEY_ZONE_HOUR_TRAFFIC, datas);
        }
        return datas;
    }

    /**
     * 获取店铺的销售额
     */
    public List<Sale> getOrQueryZoneSales(Long zoneId, Date StartDate, Date endDate,
                                          Map<String, Object> dataMap) {
        List<Sale> sales = (List<Sale>) dataMap.get(KEY_ZONE_DAY_SALE);
        if (sales == null) {
            SaleExample example = new SaleExample();
            example.createColumns().hasZoneIdColumn().hasSaledateColumn().hasSalecountColumn()
                    .hasMoneyColumn();
            example.createCriteria().andZoneIdEqualTo(zoneId).andSaledateBetween(StartDate, endDate);
            sales = saleService.selectByExample(example);
            dataMap.put(KEY_ZONE_DAY_SALE, sales);
        }
        return sales;
    }

    /**
     * 根据店铺id获取店铺信息
     */
    public Zone getOrQueryZoneById(Long zoneId, Map<String, Object> dataMap) {
        Zone zone = (Zone) dataMap.get(KEY_ZONE_INFO);
        if (zone == null) {
            zone = zoneService.selectByPrimaryKey(zoneId);
            dataMap.put(KEY_ZONE_INFO, zone);
        }
        return zone;
    }
}
