package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.*;
import com.viontech.util.ParamsUtil;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

public abstract class AbstractMallReportServiceImpl extends ChartReportBaseService {

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private SaleDataService saleDataService;

	@Resource
	private MallDataService mallDataService;

	@Resource
	private FloorDataService floorDateService;

	@Resource
	private ZoneDataService zoneDataService;

	@Resource
	private GateDataService gateDateService;

	@Resource
	private MallDayFaceRecognitionStaService mallDayFaceRecognitionStaService;

	@Resource
	private MallService mallService;

	@Resource
	private FloorService floorService;

	@Resource
	private ZoneService zoneService;

	@Resource
	private GateService gateService;

	@Resource
	private ParamsUtil paramsUtil;


	/** 商场顾客特征--性别分布 */
	public static  final String REPORT_MALL_CUSTOMERFEATURE_GENDER = "customerfeature_denger";
	/** 商场顾客特征--年龄分布 */
	public static final String REPORT_MALL_CUSTOMERFEATURE_AGE = "customerfeature_age";
	/**楼层顾客特征--新老顾客*/
	public static final String REPORT_FLOOR_CUSTOMERFEATURE_NAO ="customerfeature_NAO";
	/** 商场趋势*/
	public static final String REPORT_MALL_TRAFFICANDSALE_TREND = "trafficAndSaleTrend";
	/** 商场主力店排名--客流量（日） */
	public static final String REPORT_MALL_COSTOMER_RANKING = "costomer_ranking";
	/** 商场主力店场排名--进店率（日） */
	public static final String REPORT_MALL_ENTERING_RANKING = "entering_ranking";
	/** 商场主力店排名--销售额（日） */
	public static final String REPORT_MALL_SALE_RANKING = "mall_sale_ranking";
	/** 商场主力店排名--客单价（日） */
	public static final String REPORT_MALL_PERCUSTOMERTRANSACTIONRANK = "perTransactionRank";
	/** 商场主力店排名--坪效（日） */
	public static final String REPORT_MALL_SALES_PERSQUAREMETERRANK = "perSquareMeterRank";
	/** 商场主力店排名--成交量（日） */
	public static final String REPORT_MALL_TURNOVERRANK = "turnoverRank";
	/** 商场主力店排名--提袋率（日） */
	public static final String REPORT_MALL_HANDBAGRATERANK = "handbagRateRank";
	/** 商场主力店排名--滞留时间（日） */
	public static final String REPORT_MALL_DURATIONTIMERANK = "durationTimeRank";
	/** 商场业态排名--销售额（日） */
	public static final String REPORT_FORMAT_SALE_RANKING = "format_sale_ranking";
	/** 商场业态排名--客流量（日） */
	public static final String REPORT_FORMAT_TRIFFIC_RANKING = "triffic_ranking";
	/** 商场出入口--客流量（日） */
	public static final String REPORT_GATE_TRIFFIC = "gate_triffic";
	/** 商场楼层--客流量（日） */
	public static final String REPORT_FLOOR_TRIFFIC = "floor_triffic";

	/**商场所有的楼层*/
	public static final String KEY_FLOOR_ALL = "floorsOfMall";
	/**商场所有的店铺*/
	public static final String KEY_ZONE_ALL = "zonesOfMall";
	/**商场所有的出入口*/
	public static final String KEY_GATE_ALL = "gatesOfMall";
	/**商场天级客流*/
	public static final String KEY_MALL_DAY_TRAFFIC = "mallDayTrafffic";
	/**出入口天级客流*/
	public static final String KEY_GATE_DAY_TRAFFIC = "gateDayTraffic";
	/**店铺天级客流*/
	public static final String KEY_ZONE_DAY_TRAFFIC = "zoneDayTraffic";
	/**楼层天级客流*/
	public static final String KEY_FLOOR_DAY_TRAFFIC = "floorDayTraffic";
	/**商场人脸数据*/
	public static final String KEY_FACERECONGNITION = "faceRecognition";
	/**商场销售额（销售额是以店铺为单位）*/
	public static final String KEY_MALL_SALES = "Sale";


	/** 累计客流量 */
	public static final String FIELD_DAY_INNUM = "dayInnum";
	/** 有效客流 */
	public static final String FIELD_DAY_ENABLE_INNUM = "effectiveTraffic";
	/** 店员客流 */
	public static final String FIELD_DAY_STAFF_INNUM = "staffManTime";
	/** 男性客流 */
	public static final String FIELD_MALE_INNUM = "maleTraffic";
	/** 女性客流 */
	public static final String FIELD_FEMALE_INNUM = "femaleTraffic";

	/** 累计销售额 */
	public static final String FIELD_DAY_SALE_MONEY = "daySaleMoney";
	/** 客单价 */
	public static final String FIELD_DAY_PERTRANSACTION = "perTransaction";
	/** 坪效 */
	public static final String FIELD_DAY_PERSQUARE = "perSquare";
	/**游逛深度 */
	public static final String FIELD_DAY_DEPTH = "Depth";
	/** 平均客流量 */
	public static final String FIELD_AVERAGE_INNUM = "averageInnum";
	/** 工作日平均客流量 */
	public static final String FIELD_WORKDAY_AVERAGE_INNUM = "workdayAverageInnum";
	/** 休息日平均客流量 */
	public static final String FIELD_WEEKEND_AVERAGE_INNUM = "weekendAverageInnum";
	/** 平均销售额 */
	public static final String FIELD_AVERAGE_SALES = "averageSales";
	/** 工作日平均销售额 */
	public static final String FIELD_WORKDAY_AVERAGE_SALES = "workdayAverageSales";
	/** 休息日平均销售额 */
	public static final String FIELD_WEEKEND_AVERAGE_SALES = "weekendAverageSales";

	/** 商场面积 */
	private  final String FIELD_MALL_OPENED_AREA = "mallArea";
	/**商场  历史同期天级客流数据*/
	public static final String KEY_MALL_TRIFFIC_HISTORY_DATA = "MallHistoryData";

	protected  static  final  Short KEY_MAIN_SHOP_KEY = 3;

	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
		Long orgId = orgIds[0];
		Map<String, Object> head = new HashMap<String, Object>();
		Mall mall = getMallById(orgId);
		/** 商场面积 */
		head.put(FIELD_MALL_OPENED_AREA,mall.getArea());
		/** 累计客流量 */
		List<MallDayCountData> mallData = getOrQueryMallDayData(orgId, startDate, endDate, dataMap);
		Integer innum = null,workDayInnum =null,weekendDayInnum = null;
		Integer allDays =null,workDays = null,weekendDays = null;

		List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
		if (dates != null && dates.size() > 0) {
			allDays = 0 ;workDays = 0 ;weekendDays = 0;
			for (Date date : dates) {
				allDays ++;
				int weekNum = DateUtil.getDayOfWeek(date);
				if (weekNum <6) {
					workDays++;
				}else {
					weekendDays++;
				}
			}
		}

		if (mallData != null && mallData.size() > 0) {
			innum = 0;workDayInnum =0;weekendDayInnum = 0;
			for (MallDayCountData mallCountData : mallData) {
				int dayNum = DateUtil.getDayOfWeek(mallCountData.getCountdate());
				innum += mallCountData.getInnum();
				if (dayNum <6) {
					workDayInnum += mallCountData.getInnum();
				}else {
					weekendDayInnum += mallCountData.getInnum();
				}
			}
		}
		head.put(FIELD_DAY_INNUM, innum);

		Double averageInnum = null,aveWorkDayInnum = null,aveWeekendDayInnum = null;
		averageInnum = NumberUtil.divide(innum, allDays, 0);
		head.put(FIELD_AVERAGE_INNUM, averageInnum);//日平均客流
		aveWorkDayInnum = NumberUtil.divide(workDayInnum, workDays, 0);
		head.put(FIELD_WORKDAY_AVERAGE_INNUM, aveWorkDayInnum);//工作日客流
		aveWeekendDayInnum = NumberUtil.divide(weekendDayInnum, weekendDays, 0);
		head.put(FIELD_WEEKEND_AVERAGE_INNUM, aveWeekendDayInnum);//双休日客流

		List<MallDayFaceRecognitionSta> faceDatas = getOrQueryFaceRecognitionStas(orgId, startDate, endDate, dataMap);
		Integer enableInnum = null;
		Integer staffInnum = null;
		Integer maleInnum = null;
		Integer femaleInnum = null;

		//获取系统配置参数
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(orgId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

		if (faceDatas != null && faceDatas.size() > 0) {
			for (MallDayFaceRecognitionSta mallFaceRecognitionSta : faceDatas) {

				//计算有效客流
				if (enableInnum == null){
					if("0".equals(enableTrafficFlag))
						enableInnum = mallFaceRecognitionSta.getCustomCount();
					else
						enableInnum = mallFaceRecognitionSta.getMaleCount()+mallFaceRecognitionSta.getFemaleCount();
				}else{
					if("0".equals(enableTrafficFlag))
						enableInnum += mallFaceRecognitionSta.getCustomCount();
					else
						enableInnum += mallFaceRecognitionSta.getMaleCount()+mallFaceRecognitionSta.getFemaleCount();
				}

				if(mallFaceRecognitionSta.getStaffCount() != null){
					if (staffInnum == null)
						staffInnum = mallFaceRecognitionSta.getStaffMantime();
					else
						staffInnum += mallFaceRecognitionSta.getStaffMantime();
				}
				if(mallFaceRecognitionSta.getMaleCount() != null){
					if (maleInnum == null)
						maleInnum = mallFaceRecognitionSta.getMaleCount();
					else
						maleInnum += mallFaceRecognitionSta.getMaleCount();
				}
				if(mallFaceRecognitionSta.getFemaleCount() != null){
					if (femaleInnum == null)
						femaleInnum = mallFaceRecognitionSta.getFemaleCount();
					else
						femaleInnum += mallFaceRecognitionSta.getFemaleCount();
				}
			}
		}
		/** 有效客流 */
		head.put(FIELD_DAY_ENABLE_INNUM, enableInnum);
		/**店员人数*/
		head.put(FIELD_DAY_STAFF_INNUM, staffInnum);
		/**男性客流 */
		head.put(FIELD_MALE_INNUM, maleInnum);
		/**女性客流*/
		head.put(FIELD_FEMALE_INNUM, femaleInnum);
		/** 累计销售额 */
		List<Sale> todaySales = getOrQueryMallSales(orgId, startDate, endDate, dataMap);
		Double salesNum =null,workDaySaleNum = null,weekendDaySaleNum = null;
		Integer saleCount = null;
		if (todaySales != null && todaySales.size() > 0) {
			salesNum = 0.0;workDaySaleNum = 0.0;weekendDaySaleNum = 0.0;saleCount = 0;
			for (Sale sale : todaySales) {
				salesNum += sale.getMoney();
				saleCount += sale.getSalecount();
				int dayNum = DateUtil.getDayOfWeek(sale.getSaledate());
				if (dayNum < 6) {
					workDaySaleNum +=sale.getMoney();
				}else {
					weekendDaySaleNum += sale.getMoney();
				}
			}
		}
		//累计销售额
		head.put(FIELD_DAY_SALE_MONEY, salesNum);
		//日均销售额
		Double avgSaleNum = null,avgWorkDaySaleNum = null,avgWeekendDaySaleNum =null;
		avgSaleNum = NumberUtil.divide(salesNum, allDays, 2);
		head.put(FIELD_AVERAGE_SALES, avgSaleNum);
		//工作日平均销售额
		avgWorkDaySaleNum = NumberUtil.divide(workDaySaleNum, workDays, 2);
		head.put(FIELD_WORKDAY_AVERAGE_SALES, avgWorkDaySaleNum);
		//双休日平均销售额
		avgWeekendDaySaleNum = NumberUtil.divide(weekendDaySaleNum, weekendDays, 2);
		head.put(FIELD_WEEKEND_AVERAGE_SALES, avgWeekendDaySaleNum);
		/** 客单价 */
		head.put(FIELD_DAY_PERTRANSACTION, NumberUtil.divide(salesNum, saleCount, 2));
		/** 坪效 */
		Double perAreaPrice = null;
		if (mall != null  && mall.getArea()!= null) {
			perAreaPrice = NumberUtil.divide(salesNum, mall.getArea(), 2);
		}
		head.put(FIELD_DAY_PERSQUARE, perAreaPrice);
		/**游逛深度 */
		head.put(FIELD_DAY_DEPTH, null);
		return head;
	}

	/**顾客特征--年龄分布*/
	public Chart ageDistributionReport(Long mallId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
		String[] ages = ageStage.split(",");
		List<Integer> ageStages = new ArrayList<>();
		for (String age : ages) {
			Integer ageInt = Integer.parseInt(age);
			ageStages.add(ageInt);
		}
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);

		MallDayFaceRecognitionStaExample ageStatisticExample = new MallDayFaceRecognitionStaExample();
		ageStatisticExample.createColumns().hasMallIdColumn().hasMaleStageColumn().hasFemaleStageColumn().hasCountdateColumn();
		ageStatisticExample.createCriteria().andMallIdEqualTo(mallId).andCountdateBetween(startDate, endDate);
		List<MallDayFaceRecognitionSta> ageSta = mallDayFaceRecognitionStaService.selectByExample(ageStatisticExample);

		if (ageSta != null && ageSta.size() >0) {
			long startTime  = System.currentTimeMillis();
			int i=0;
			for (MallDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);
				if(maleAgestatic.length!=femaleAgestatic.length){
					continue;
				}
//				if(i%10 == 0) {
//					long endTime = System.currentTimeMillis();
//					System.out.println(">>>>>>>>>>> 处理"+i+"条" + (endTime - startTime));
//				}
				i++;
				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
					int maleNum = Integer.parseInt(String.valueOf(maleAgestatic[rangeNum].trim()));
					int femaleNum = Integer.parseInt(String.valueOf(femaleAgestatic[rangeNum].trim()));
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}
			}
//			long endTime  = System.currentTimeMillis();
//			System.out.println(">>>>>>>>>>> 处理全部"+(endTime-startTime));
		}
		return chart;
	}

	/**顾客特征--性别分布*/
	public Chart genderDistributionReport(Long mallId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);

		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());

		List<MallDayFaceRecognitionSta> datas = getOrQueryFaceRecognitionStas(mallId, startDate,endDate, dataMap);

		for (MallDayFaceRecognitionSta faceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),faceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), faceRecognitionSta.getMaleCount());
		}
		return chart;
	}

	/**近期趋势*/
	public Chart trafficAndSaleTrendReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		final String effectiveTraffic = LocalMessageUtil.getMessage("effective");
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		// 向前推N天的日期
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		//chart.createSeries(ParamName.SALES.toString(), SeriesType.line);
		chart.createSeries(effectiveTraffic, SeriesType.line);
		// 客流量
		List<MallDayCountData> DayTraffic = getOrQueryMallDayData(orgId, startDate,endDate, dataMap);
		for (MallDayCountData DayCountData : DayTraffic) {
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(DayCountData.getCountdate(), DayCountData.getInnum());
		}
//		//销售额
//		List<Sale> sales = getOrQueryMallSales(orgId,  startDate,endDate, dataMap);
//		for (Sale sale : sales) {
//				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
//		}
		//有效客流
		List<MallDayFaceRecognitionSta> mallDayFaceRecognitionStas = getOrQueryFaceRecognitionStas(orgId,startDate,endDate, dataMap);
		//获取配置
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(orgId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");
		for(MallDayFaceRecognitionSta mallDayFaceRecognitionSta:mallDayFaceRecognitionStas){
			if("0".equals(enableTrafficFlag)) {
				chart.getSeries(effectiveTraffic).adjustOrPutValueByCoordinate(mallDayFaceRecognitionSta.getCountdate(), mallDayFaceRecognitionSta.getCustomCount());
			}else{
				chart.getSeries(effectiveTraffic).adjustOrPutValueByCoordinate(mallDayFaceRecognitionSta.getCountdate(), mallDayFaceRecognitionSta.getFemaleCount()+mallDayFaceRecognitionSta.getMaleCount());
			}
		}

		return chart;
	}


	/**
	 * 周、月、年   tab切换趋势图
	 * @param orgId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @param reportChart
	 * @return
	 */
	public Chart trafficAndSaleTrend2Report(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		final String effectiveTraffic = LocalMessageUtil.getMessage("effective");
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		Axis<Date> xAxis = null;
		OptionsContain option = (OptionsContain) dataMap.get("chartOption");
		if(option == OptionsContain.TAB_WEEK){
			xAxis = AxisFactory.createWeekOFYearAxis();
		}else if(option == OptionsContain.TAB_MONTH){
			xAxis = AxisFactory.createMonthOFYearAxis();
		}else{
			xAxis = AxisFactory.createDayOFMonthAxis();
		}
		xAxis.setMin(startDate);
		xAxis.setMax(endDate);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		//chart.createSeries(ParamName.SALES.toString(), SeriesType.line);
		chart.createSeries(effectiveTraffic, SeriesType.line);
		// 客流量
		List<MallDayCountData> DayTraffic = getOrQueryMallDayData(orgId, startDate,endDate, dataMap);
		for (MallDayCountData DayCountData : DayTraffic) {
			Date date = DayCountData.getCountdate();
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(date, DayCountData.getInnum());
		}
//		//销售额
//		List<Sale> sales = getOrQueryMallSales(orgId,  startDate,endDate, dataMap);
//		for (Sale sale : sales) {
//				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
//		}
		//有效客流
		List<MallDayFaceRecognitionSta> mallDayFaceRecognitionStas = getOrQueryFaceRecognitionStas(orgId,startDate,endDate, dataMap);
		for(MallDayFaceRecognitionSta mallDayFaceRecognitionSta:mallDayFaceRecognitionStas){
			chart.getSeries(effectiveTraffic).adjustOrPutValueByCoordinate(mallDayFaceRecognitionSta.getCountdate(), mallDayFaceRecognitionSta.getCustomCount());
		}
		return chart;
	}


	/**店铺排行--客流量*/
	public Chart trafficRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		// 客流量
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		chart.createSeries(ParamName.TRAFFIC.toString());

		Map<Long,List<ZoneDayCountData>>  trafficMap =  getOrQueryZoneDayMapData(orgId, startDate, endDate, dataMap);
		for (Entry<Long, List<ZoneDayCountData>> entry: trafficMap.entrySet()) {
			Long zoneId = entry.getKey();
			Map<Long, Zone> zoneMaps = getOrQueryZonesOfMallMap(orgId, dataMap);
			if (zoneMaps == null || zoneMaps.get(zoneId)== null) {
				continue;
			}
			Zone zone = zoneMaps.get(zoneId);
			int zoneInnum = 0;
			for (ZoneDayCountData zoneCountData : entry.getValue()) {
				zoneInnum += zoneCountData.getInnum();
			}
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(zone.getName(),zoneInnum);
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if(o1 == null) o1 = Integer.MIN_VALUE;
				if(o2 == null) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--销售额*/
	public Chart salesRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.SALES.toString());

		List<Sale> sales = getOrQueryMallSales(orgId, startDate,endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(zone.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--进店率*/
	public Chart enteringRateReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);

		Axis< String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.ENTERINGRATE.toString());

		Map<Long,List<ZoneDayCountData>> zoneDatas =  getOrQueryZoneDayMapData(orgId, startDate, endDate, dataMap);
		for (Entry<Long,List<ZoneDayCountData>> entry: zoneDatas.entrySet()) {
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			List<ZoneDayCountData> dates = entry.getValue();
			int allInum = 0;//店铺总近店人数
			int allNum = 1;//总经过人数
			if (dates != null && dates.size() > 0) {
				allNum = 0;
			}
			for (ZoneDayCountData zoneCountData : dates) {
				allNum += (zoneCountData.getOutsideInnum()+zoneCountData.getOutsideOutnum());
				allInum += zoneCountData.getInnum();
			}
			chart.getSeries(ParamName.ENTERINGRATE.toString()).adjustOrPutValueByCoordinate(
					zone.getName(),NumberUtil.percentage(allInum, allNum, 2));
		}
		chart.sort(ParamName.ENTERINGRATE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--客单价*/
	public Chart perPriceTransactionReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.PREPRICE.toString());

		List<Sale> sales = getOrQueryMallSales(orgId, startDate,endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			Double perPrice = NumberUtil.divide(sale.getMoney(), sale.getSalecount(), 2);
			chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(zone.getName() ,perPrice);
		}
		chart.sort(ParamName.PREPRICE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--坪效*/
	public Chart perAreaValueReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.PERAREAVALUE.toString());
		List<Sale> sales = getOrQueryMallSales(orgId, startDate,endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			float area = zone.getArea();
			chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(zone.getName(),
					NumberUtil.divide(sale.getMoney(), area, 2));
		}
		chart.sort(ParamName.PERAREAVALUE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--成交量*/
	public Chart saleCountReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.ORDER.toString());
		List<Sale> sales = getOrQueryMallSales(orgId, startDate,endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			chart.getSeries(ParamName.ORDER.toString()).adjustOrPutValueByCoordinate(zone.getName(),sale.getSalecount());
		}
		chart.sort(ParamName.ORDER.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if(o1 == null) o1 = Integer.MIN_VALUE;
				if(o2 == null) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--提袋率*/
	public Chart handbagRateReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.HANDBAGRATE.toString());

		List<Sale> sales = getOrQueryMallSales(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			int takebagNum = sale.getSalecount();
			int inNum = 1;
			List<ZoneDayCountData> zoneDatas = getOrQueryZoneDayMapData(orgId, startDate, endDate, dataMap).get(zoneId);
			if (zoneDatas != null && zoneDatas.size() > 0) {
				for (ZoneDayCountData zoneCountData : zoneDatas) {
					inNum += zoneCountData.getInnum();
				}
			}
			/*if (NumberUtil.percentage(takebagNum, inNum, 2) > 100) {
				System.out.println("店铺名称："+zone.getName()+"||  提袋率:"+NumberUtil.percentage(takebagNum, inNum, 2));
			}*/
			chart.getSeries(ParamName.HANDBAGRATE.toString()).adjustOrPutValueByCoordinate(zone.getName(),
					NumberUtil.percentage(takebagNum, inNum, 2));
		}
		chart.sort(ParamName.HANDBAGRATE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**店铺排行--滞留时间       滞留时间 = （总进人数 - 总出人数）* 统计时间单位 / 进店总人数   */
	public Chart durationTimeReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.DURATIONTIME.toString());
		Map<Long, List<ZoneDayCountData>> zoneDataMap =  getOrQueryZoneDayMapData(orgId, startDate, endDate, dataMap);

		for(Entry<Long, List<ZoneDayCountData>> entry: zoneDataMap.entrySet()){
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			int allInnum = 0,allOutnum = 0,allDurationTime = 0;
			for (ZoneDayCountData zoneCountData : entry.getValue()) {
				allInnum += zoneCountData.getInnum();
				allOutnum += zoneCountData.getOutnum();
				int durationNum = allInnum-allOutnum;
				if (allInnum-allOutnum < 0 ) {
					durationNum = 0;
				}
				allDurationTime += durationNum;
			}
			chart.getSeries(ParamName.DURATIONTIME.toString()).adjustOrPutValueByCoordinate(zone.getName(),
					NumberUtil.divide(allDurationTime, allInnum, 2));
		}
		chart.sort(ParamName.DURATIONTIME.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**业态排名--销售额*/
	public Chart FormatSalesRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.SALES.toString());

		List<Sale> sales = getOrQueryMallSales(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZonesOfMallMap(orgId, dataMap).get(zoneId);
			Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(format.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if(o1 == null) o1 = Double.MIN_VALUE;
				if(o2 == null) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**业态排名--客流量 */
	public Chart formatTrifficRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());

		Map<Long,List<ZoneDayCountData>> trifficMaps =  getOrQueryZoneDayMapData(orgId, startDate,endDate, dataMap);

		for (Entry<Long,List<ZoneDayCountData>>  entry: trifficMaps.entrySet()) {
			Long zoneId = entry.getKey();
			Map<Long, Zone> zoneMaps = getOrQueryZonesOfMallMap(orgId, dataMap);
			if (zoneMaps == null || zoneMaps.get(zoneId) == null) {
				continue;
			}
			Zone zone = zoneMaps.get(zoneId);
			if (zone.getFormatId() == null) {
				continue;
			}
			Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
			String formatName = LocalMessageUtil.getMessage("unknownFormat");
			if (format != null && !format.getName().isEmpty()) {
				formatName =format.getName();
			}
			int innum = 0;
			for (ZoneDayCountData zoneDayCountData : entry.getValue()) {
				innum += zoneDayCountData.getInnum();
			}
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(formatName, innum);
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if(o1 == null) o1 = Integer.MIN_VALUE;
				if(o2 == null) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**出入口客流*/
	public Chart gateTrafficRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());

		Map<Long, Gate> gateMaps= getOrQueryGatesOfMall(orgId, dataMap);

		List<GateDayCountData> datas = getOrQueryGateDayData(orgId,startDate, endDate, dataMap);
		if (datas != null && datas.size() > 0) {
			for (GateDayCountData gateCountData : datas) {
				Long gateId = gateCountData.getGateId();
				Gate gate = gateMaps.get(gateId);
				short isMallGate = gate.getIsMallGate();
				if (isMallGate == 1) {
					chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(gate.getName(), gateCountData.getInnum().intValue());
				}
			}
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null) o1 = Integer.MIN_VALUE;
				if(o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层客流排行*/
	public Chart FloorTrifficRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());

		List<FloorDayCountData> triffic = getOrQueryFloorDayTraffic(orgId, startDate, endDate, dataMap);

		for (FloorDayCountData floorCountData : triffic) {
			Long floorId = floorCountData.getFloorId();
			Floor floor = getOrQueryFloorsOfMall(orgId, dataMap).get(floorId);
			if (floor == null)
				continue;
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(floor.getName(),floorCountData.getInnum().intValue());
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null) o1 = Integer.MIN_VALUE;
				if(o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}




	/**获取出入口天级客流*/
	public List<GateDayCountData> getOrQueryGateDayData(Long mallId, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<GateDayCountData> datas =  (List<GateDayCountData>) dataMap.get(KEY_GATE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<>();
			//获取商场所有的出入口
			Map gateMaps = getOrQueryGatesOfMall(mallId, dataMap);
			if (gateMaps != null && gateMaps.size() > 0 ) {
				datas = (List<GateDayCountData>) gateDateService.getDayData(startDate,endDate, new ArrayList<Long>(gateMaps.keySet()));
			}
			dataMap.put(KEY_GATE_DAY_TRAFFIC, datas);
			//获取出入口客流数据
		}
		return datas;
	}

	/**获取店铺天级客流*/
	public Map<Long,List<ZoneDayCountData>> getOrQueryZoneDayMapData(Long mallId, Date startDate, Date endDate, Map<String, Object> dataMap){
		Map<Long, List<ZoneDayCountData>> datas = (Map<Long, List<ZoneDayCountData>>) dataMap.get(KEY_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new  HashMap<Long, List<ZoneDayCountData>>();
			//获取商场所有店铺
			Map<Long, Zone> zoneMaps = getOrQueryZonesOfMallMap(mallId, dataMap);
			List<ZoneDayCountData> zoneDataList = (List<ZoneDayCountData>) zoneDataService.getDayData(startDate, endDate,
					new ArrayList<Long>(zoneMaps.keySet()));
			for (ZoneDayCountData zoneCountData : zoneDataList) {
				Long zoneId = zoneCountData.getZoneId();
				List<ZoneDayCountData> addMapDatas = datas.get(zoneId);
				if (addMapDatas == null) {
					addMapDatas = new ArrayList<ZoneDayCountData>();
				}
				addMapDatas.add(zoneCountData);
				datas.put(zoneId, addMapDatas);
			}
			dataMap.put(KEY_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}

	/**获取楼层天级客流*/
	public List<FloorDayCountData> getOrQueryFloorDayTraffic(Long mallId,Date startDate, Date endDate,Map<String,Object> dataMap){
		List<FloorDayCountData> datas = (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_DAY_TRAFFIC);
		if (datas == null) {
			Map<Long, Floor> floorMaps = getOrQueryFloorsOfMall(mallId, dataMap);
			datas = (List<FloorDayCountData>) floorDateService.getDayData(startDate,endDate,new ArrayList<Long>(floorMaps.keySet()));
			dataMap.put(KEY_FLOOR_DAY_TRAFFIC, datas);
		}
		return datas;
	}

	/**获取商场人脸统计数据*/
	public List<MallDayFaceRecognitionSta> getOrQueryFaceRecognitionStas(Long mallId,Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayFaceRecognitionSta> datas = (List<MallDayFaceRecognitionSta>) dataMap.get(KEY_FACERECONGNITION);
		if (datas == null ) {
			datas = new ArrayList<>();
			MallDayFaceRecognitionStaExample example = new MallDayFaceRecognitionStaExample();
			example.createCriteria().andMallIdEqualTo(mallId).andCountdateBetween(startDate, endDate);
			datas = mallDayFaceRecognitionStaService.selectByExample(example);
			dataMap.put(KEY_FACERECONGNITION, datas);
		}
		return datas;
	}

	/**获取商场天级客流*/
	protected List<MallDayCountData>  getOrQueryMallDayData(Long mallId,Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayCountData> datas =  (List<MallDayCountData>) dataMap.get(KEY_MALL_DAY_TRAFFIC);
		if (datas == null) {
			datas = (List<MallDayCountData>) mallDataService.getDayData(startDate, endDate, mallId);
			dataMap.put(KEY_MALL_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	/**获取商场历史同期天级客流*/
	protected List<MallDayCountData>  getOrQueryHistoryMallDayData(Long mallId,Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayCountData> datas =  (List<MallDayCountData>) dataMap.get(KEY_MALL_TRIFFIC_HISTORY_DATA);
		if (datas == null) {
			datas = (List<MallDayCountData>) mallDataService.getDayData(startDate, endDate, mallId);
			dataMap.put(KEY_MALL_TRIFFIC_HISTORY_DATA, datas);
		}
		return datas;
	}

	/**获取商场销售额*/
	protected List<Sale> getOrQueryMallSales(Long mallId, Date startDate, Date endDate, Map<String, Object> dataMap) {
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_MALL_SALES);
		if ( sales == null) {
			sales = (List<Sale>) saleDataService.getDayData(startDate, endDate, mallId, OrgType.mall);
			dataMap.put(KEY_MALL_SALES, sales);
		}
		return sales;
	}

	/**获取商场的基本信息*/
	public Mall getMallById(Long mallId){
		return mallService.selectByPrimaryKey(mallId);
	}

	/** 获取商场所有的楼层数据 */
	public Map<Long,Floor> getOrQueryFloorsOfMall(Long mallId, Map<String, Object> dataMap) {
		Map<Long,Floor> datas =  (Map<Long, Floor>) dataMap.get(KEY_FLOOR_ALL);
		if (datas == null) {
			datas = new HashMap();
			FloorExample floorExample = new FloorExample();
			floorExample.createColumns().hasIdColumn().hasNameColumn().hasMallIdColumn();
			floorExample.createCriteria().andMallIdEqualTo(mallId);
			List<Floor>  floors = floorService.selectByExample(floorExample);
			if (floors != null && floors.size()>0) {
				for (Floor floor : floors) {
					datas.put(floor.getId(), floor);
				}
			}
			dataMap.put(KEY_FLOOR_ALL, datas);
		}
		return datas;
	}

	/** 获取商场所有的主力店铺数据 */
	public Map<Long,Zone> getOrQueryZonesOfMallMap(Long mallId, Map<String, Object> dataMap) {
		Map<Long,Zone> datas = (Map<Long,Zone>) dataMap.get(KEY_ZONE_ALL);
		if (datas == null) {
			datas =new HashMap<>();
			ZoneExample zoneExample = new ZoneExample();
			zoneExample.createColumns().hasIdColumn().hasNameColumn().hasTypeColumn().hasStatusColumn()
					.hasFormatIdColumn().hasBrandIdColumn().hasFloorIdColumn().hasMallIdColumn().hasAccountIdColumn().hasAreaColumn();
			mallId = Optional.ofNullable(mallId).orElse(0L);
			zoneExample.createCriteria().andMallIdEqualTo(mallId).andTypeEqualTo(KEY_MAIN_SHOP_KEY);
			List<Zone> zones = zoneService.selectByExample(zoneExample);
			if (zones != null) {
				for (Zone zone : zones) {
					datas.put(zone.getId(), zone);
				}
			}
			dataMap.put(KEY_ZONE_ALL, datas);
		}
		return datas;
	}

	/**获取商场的监控点信息*/
	public Map<Long ,Gate> getOrQueryGatesOfMall(Long mallId, Map<String, Object> dataMap) {
		Map<Long ,Gate> datas = (Map<Long ,Gate>) dataMap.get(KEY_GATE_ALL);
		if (datas == null) {
			datas = new HashMap<>();
			GateExample gateExample = new GateExample();
			gateExample.createColumns().hasIdColumn().hasNameColumn().hasMallIdColumn().hasIsMallGateColumn().hasFloorIdColumn()
					.hasTypeColumn().hasStatusColumn().hasIdColumn();
			gateExample.createCriteria().andMallIdEqualTo(mallId).andIsMallGateEqualTo(PARAM_IS_MALL_GATE);
			List<Gate> gates = gateService.selectByExample(gateExample);
			if (gates != null) {
				for (Gate gate : gates) {
					datas.put(gate.getId(), gate);
				}
			}
			dataMap.put(KEY_GATE_ALL, datas);
		}
		return datas;
	}
}
