package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.*;
import com.viontech.mall.vo.ZoneVo;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.*;
import java.util.Map.Entry;

public abstract class AbstractFloorReportServiceImpl extends ChartReportBaseService {

	@Value("${Age.stage}")
	private String ageStage;

	@Resource
	private FloorDataService floorDataService;
	
	@Resource
	private SaleDataService saleDataService;
	
	@Resource
	private GateDataService gateDataService;
	
	@Resource
	private ZoneDataService zoneDataService;

	@Resource
	private MallDataService mallDataService;
	
	@Resource
	private FloorDayFaceRecognitionStaService floorDayFaceRecognitionStaService;
	
	@Resource
	private FloorService floorService;
	
	@Resource
	private ZoneService zoneService;

	@Resource
	private GateService gateService;
	
	@Resource
	private FloorGateService floorGateService;
	
	/**累计客流*/
	public static final String FIELD_ACCUMULATIVE_TRAFFIC = "accumulativeTraffic";
	/**客流占比*/
	public static final String FIELD_RATIOOFTRAFFIC ="trafficRatio";
	/**累计销售额*/
	public static final String FIELD_ACCUMULATIVE_SALE ="accumulativeSale";
	/**业态数*/
	public static final String FIELD_FORMAT_NUM ="formatNum";
	/**店铺数*/
	public static final String FIELD_STORE_NUM = "storeNum";
	/**出入口个数*/
	public static final String FIELD_GATE_NUM = "gateNum";
	/** 平均客流量 */
	public static final String FIELD_AVERAGE_INNUM = "averageInnum";
	/** 工作日平均客流量 */
	public static final String FIELD_WORKDAY_AVERAGE_INNUM = "workdayAverageInnum";
	/** 休息日平均客流量 */
	public static final String FIELD_WEEKEND_AVERAGE_INNUM = "weekendAverageInnum";
	/** 平均销售额 */
	public static final String FIELD_AVERAGE_SALES = "averageSales";
	/** 工作日平均销售额 */
	public static final String FIELD_WORKDAY_AVERAGE_SALES = "workdayAverageSales";
	/** 休息日平均销售额 */
	public static final String FIELD_WEEKEND_AVERAGE_SALES = "weekendAverageSales";
	/**楼层平面图地址*/
	private final String FIELD_FLOOR_MAP_URL ="floorMapUrl";

	/** 有效客流 */
	public static final String FIELD_ENABLE_INNUM = "effectiveTraffic";
	/** 店员客流 */
	public static final String FIELD_STAFF_INNUM = "staffManTime";
	/** 男性客流 */
	public static final String FIELD_MALE_INNUM = "maleTraffic";
	/** 女性客流 */
	public static final String FIELD_FEMALE_INNUM = "femaleTraffic";
	
	/**楼层顾客特征--性别分布*/
	public static final String REPORT_FLOOR_CUSTOMERFEATURE_GENDER ="customerfeature_gender";
	/**楼层顾客特征--年龄分布*/
	public static final String REPORT_FLOOR_CUSTOMERFEATURE_AGE ="customerfeature_age";
	/**楼层顾客特征--新老顾客*/
	public static final String REPORT_FLOOR_CUSTOMERFEATURE_NAO ="customerfeature_NAO";
	/**楼层近期趋势*/
	public static final String REPORT_FLOOR_TRAFFICANDSALE_TREND = "trafficAndSaleTrend";
	/**楼层店铺排行--客流量*/
	public static final String REPORT_FLOOR_TRAFFICRANK ="trafficRank";
	/**楼层店铺排行--销售额*/
	public static final String REPORT_FLOOR_SALERANK = "saleRank";
	/**楼层店铺排行--进店率*/
	public static final String REPORT_FLOOR_ENTERINGRATERANK = "enteringRateRank";
	/**楼层店铺排行--客单价*/
	public static final String REPORT_FLOOR_PERCUSTOMERTRANSACTIONRANK = "perTransactionRank";
	/**楼层店铺排行--坪效*/
	public static final String REPORT_FLOOR_SALES_PERSQUAREMETERRANK = "perSquareMeterRank";
	/**楼层店铺排行--成交量*/
	public static final String REPORT_FLOOR_TURNOVERRANK = "turnoverRank";
	/**楼层店铺排行--提袋率*/
	public static final String REPORT_FLOOR_HANDBAGRATERANK = "handbagRateRank";
	/**楼层店铺排行--滞留时间 */
	public static final String REPORT_FLOOR_DURATIONTIMERANK = "durationTimeRank";
	/**楼层出入口客流*/
	public static final String REPORT_FLOOR_GATETRAFFIC = "gateTraffic";
	
	
	
	/**楼层      天级客流数据*/
	public final String KEY_FLOOR_TRAFFIC_DAY = "dayTraffic";
	/**楼层      天级人脸数据*/
	public final String KEY_FLOOR_FACE_DATA = "floorFaceData";
	/**楼层      店铺的天级客流数据*/
	public final String KEY_FLOOR_ZONE_DAY_TRAFFIC = "zoneDayTraffic";
	/**楼层    销售数据*/
	public final String KEY_FLOOR_SALE = "floorSale";
	/**楼层    店铺列表*/
	public final String KEY_FLOOR_ZONE_ALL = "allZone";
	/**楼层      出入口 对应关系*/
	public final String KEY_FLOOR_GATE_ALL = "floorGates";
	/**楼层       店铺小时客流*/
	public final String KEY_FLOOR_ZONE_HOUR_TRAFFIC = "floorZoneHourTraffic"; 
	/**楼层       监控点天级客流*/
	public final String KEY_FLOOR_GATE_DAY_TRAFFIC ="floorGateDayTraffic";
	/**楼层品牌列表信息*/
	public final String KEY_FLOOR_BRAND = "floorBrands";
	/**楼层出入口信息*/
	public final String KEY_GATES = "gates";


	/** 楼层面积 */
	private  final String FIELD_FLOOR_OPENED_AREA = "floorArea";
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate,Map<String, Object> dataMap) {
		Map<String,Object> head = new HashMap<String, Object>();
		Long orgId = orgIds[0];
		List<FloorDayCountData> floorDatas = getOrQueryFloorDayTraffic(orgId, startDate, endDate, dataMap);
        Floor floor =  floorService.selectByPrimaryKey(orgId);
        /** 商场面积 */
        head.put(FIELD_FLOOR_OPENED_AREA,floor.getArea());
		//累计客流
		Integer floorInnum = null,workDayInnum = null,weekendDayInnum = null;
		Integer allDays = null,workDays = null,weekendDays = null;
		
		if (floorDatas != null && floorDatas.size() > 0) {
			floorInnum = 0;workDayInnum = 0;weekendDayInnum = 0;
		    allDays = 0;workDays = 0;weekendDays = 0;
			for (FloorDayCountData floorDayCountData : floorDatas) {
				int dayNum = DateUtil.getDayOfWeek(floorDayCountData.getCountdate());
				floorInnum += floorDayCountData.getInnum();
				allDays ++;
				if (dayNum <6) {
					workDayInnum += floorDayCountData.getInnum();
					workDays ++;
				}else {
					weekendDayInnum += floorDayCountData.getInnum();
					weekendDays ++;
				}
			}
		}
		head.put(FIELD_ACCUMULATIVE_TRAFFIC, floorInnum);//累计客流
		
		Double averageInnum = null,aveWorkDayInnum = null,aveWeekendDayInnum = null;
		averageInnum = NumberUtil.divide(floorInnum, allDays, 0);
		head.put(FIELD_AVERAGE_INNUM, averageInnum);//日平均客流
		aveWorkDayInnum = NumberUtil.divide(workDayInnum, workDays, 0);
		head.put(FIELD_WORKDAY_AVERAGE_INNUM, aveWorkDayInnum);//工作日客流
		aveWeekendDayInnum = NumberUtil.divide(weekendDayInnum, weekendDays, 0);
		head.put(FIELD_WEEKEND_AVERAGE_INNUM, aveWeekendDayInnum);//双休日客流
		//客流占比
		Integer mallInnum = null;
		head.put(FIELD_FLOOR_MAP_URL, floor.getMap());
		if (floor != null && floor.getMallId() != null) {
			Long mallId = floor.getMallId();
			List<MallDayCountData> mallDatas = (List<MallDayCountData>) mallDataService.getDayData(startDate, endDate, mallId);
			if (mallDatas != null && mallDatas.size() >0) {
				mallInnum = 0;
				for (MallDayCountData mallDayCountData : mallDatas) {
					mallInnum += mallDayCountData.getInnum();
				}
			}
		}
		head.put(FIELD_RATIOOFTRAFFIC,NumberUtil.percentage(floorInnum, mallInnum, 2));
		//累计销售额
		Double saleNum = null,workDaySaleNum = null,weekendDaySaleNum =null;
		Integer saleDays = null,workDaySaleDays = null,weekendDaySaleDays = null;
		List<Sale> sales = getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		if (sales != null && sales.size() >0) {
		    saleNum = 0.0;workDaySaleNum = 0.0;weekendDaySaleNum = 0.0;
		    saleDays = 0 ;workDaySaleDays = 0 ;weekendDaySaleDays = 0;
			for (Sale sale : sales) {
				int dayNum = DateUtil.getDayOfWeek(sale.getSaledate());
				saleNum += sale.getMoney();
				saleDays ++;
				if (dayNum < 6) {
					workDaySaleNum +=sale.getMoney();
					workDaySaleDays ++;
				}else {
					weekendDaySaleNum += sale.getMoney();
					weekendDaySaleDays++;
				}
			}
		}
		head.put(FIELD_ACCUMULATIVE_SALE, saleNum);//累计销售额
		
		Double avgSaleNum = null,avgWorkDaySaleNum = null,avgWeekendDaySaleNum = null;
		avgSaleNum = NumberUtil.divide(saleNum, saleDays, 2);
		head.put(FIELD_AVERAGE_SALES, avgSaleNum);//日均销售额
		avgWorkDaySaleNum = NumberUtil.divide(workDaySaleNum, workDaySaleDays, 2);
		head.put(FIELD_WORKDAY_AVERAGE_SALES, avgWorkDaySaleNum);//工作日平均销售额
		avgWeekendDaySaleNum = NumberUtil.divide(weekendDaySaleNum, weekendDaySaleDays, 2);
		head.put(FIELD_WEEKEND_AVERAGE_SALES, avgWeekendDaySaleNum);//双休日平均销售额


		//有效客流、店员人才、男性顾客人数、女性顾客人数
		Integer effectiveTraffic = null;
		Integer staffTime = null;
		Integer maleTraffic = null;
		Integer femaleTraffic = null;

		//获取系统配置参数
		Long mallId = Optional.ofNullable(floor.getMallId()).orElse(0L);
		Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
		ConfigParams enableTrafficConfig = configParamsMap.get("enableTrafficConfig");
		String enableTrafficFlag = Optional.ofNullable(enableTrafficConfig.getValue()).orElse("0");

		List<FloorDayFaceRecognitionSta> faceDatas = getOrQueryFloorFaceSta(orgId, startDate, endDate, dataMap);
		if (faceDatas != null && faceDatas.size() > 0) {
			for (FloorDayFaceRecognitionSta faceData : faceDatas) {
				//计算有效客流
				if (effectiveTraffic == null){
					if("0".equals(enableTrafficFlag))
						effectiveTraffic = faceData.getCustomCount();
					else
						effectiveTraffic = faceData.getMaleCount()+faceData.getFemaleCount();
				}else{
					if("0".equals(enableTrafficFlag))
						effectiveTraffic += faceData.getCustomCount();
					else
						effectiveTraffic += faceData.getMaleCount()+faceData.getFemaleCount();
				}
				if(faceData.getStaffCount() != null){
					if (staffTime == null)
						staffTime = faceData.getStaffMantime();
					else
						staffTime += faceData.getStaffMantime();
				}
				if(faceData.getMaleCount() != null){
					if (maleTraffic == null)
						maleTraffic = faceData.getMaleCount();
					else
						maleTraffic += faceData.getMaleCount();
				}
				if(faceData.getFemaleCount() != null){
					if (femaleTraffic == null)
						femaleTraffic = faceData.getFemaleCount();
					else
						femaleTraffic += faceData.getFemaleCount();
				}
			}
		}
		head.put(FIELD_ENABLE_INNUM,effectiveTraffic);
		head.put(FIELD_STAFF_INNUM,staffTime);
		head.put(FIELD_MALE_INNUM,maleTraffic);
		head.put(FIELD_FEMALE_INNUM,femaleTraffic);
		
		//业态数
		Integer formatNum = null,zoneNum = null;
		Map<Long, Zone> zoneMaps = getOrQueryFloorZoneMaps(orgId, dataMap);
		Set<Long> formats = new HashSet<Long>();
		if (zoneMaps != null && zoneMaps.size() > 0) {
			for (Zone zone : zoneMaps.values()) {
				formats.add(zone.getFormatId());
			}
			zoneNum = zoneMaps.size();
			formatNum = formats.size();
		}
		head.put(FIELD_FORMAT_NUM, formatNum);
		//店铺数
		head.put(FIELD_STORE_NUM, zoneNum);
		//出入口
		Integer gateNum = null;
		List<FloorGate> floorGates = getOrQueryFloorGates(orgId, dataMap);
		if (floorDatas != null && floorDatas.size() > 0) {
			gateNum = floorGates.size();
		}
		head.put(FIELD_GATE_NUM,gateNum);
		
		//楼层分布详细信息
		List<ZoneVo> zoneDetails = floorDetail(orgId, dataMap);
		head.put(CHART_DETAIL_DATA, zoneDetails);
		//楼层业态列表
		Map<String, Set<Brand>> floorBrandsMap = new HashMap<String, Set<Brand>>();
		for (ZoneVo zoneVo : zoneDetails) {
			Brand brand = zoneVo.getBrand();
			if(brand == null)
				continue;
			String key = brand.getName();
			Set<Brand> values = floorBrandsMap.get(key);
			if (values == null) {
				values = new HashSet<Brand>();
				floorBrandsMap.put(key, values);
			}
			values.add(brand);
		}
		head.put(KEY_FLOOR_BRAND, floorBrandsMap);
		return head;
	}
	
	/**楼层店铺分布图*/
	public List<ZoneVo> floorDetail(Long floorId,Map<String,Object> dataMap){
		Map<Long,Zone> zoneMap = getOrQueryFloorZoneMaps(floorId,dataMap);
		List<ZoneVo> result = new ArrayList<ZoneVo>();
		for (Zone zone : zoneMap.values()) {
			ZoneVo zoneVo = new ZoneVo();
			zoneVo.setModel(zone);
			result.add(zoneVo);
		}
		return result;
	}

	
	/**楼层顾客特征--性别分布*/
	public Chart genderDistributionReport(Long orgId,  Date startDate, Date endDate,Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
		
		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());

		List<FloorDayFaceRecognitionSta> datas = getOrQueryFloorFaceSta(orgId,startDate,endDate,dataMap);
		for (FloorDayFaceRecognitionSta faceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),faceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), faceRecognitionSta.getMaleCount());
		}
		return chart;
	}
	
	/**楼层顾客特征--年龄分布*/
	public Chart ageDistributionReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();
		chart.setXAxis(xAxis);
        String[] ages = ageStage.split(",");
        List<Integer> ageStages = new ArrayList<>();
        for (String age : ages) {
            Integer ageInt = Integer.parseInt(age);
            ageStages.add(ageInt);
        }
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);

		List<FloorDayFaceRecognitionSta> ageSta = getOrQueryFloorFaceSta(orgId,startDate,endDate,dataMap);
		
		if (ageSta != null && ageSta.size() >0) {
			for (FloorDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);

				if (maleAgestatic.length != femaleAgestatic.length) {
					continue;
				}


				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {

					int maleNum = Integer.parseInt("" + maleAgestatic[rangeNum].trim());
					int femaleNum = Integer.parseInt("" + femaleAgestatic[rangeNum].trim());
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}
			}
		}
		return chart;
	}
	
	
	
	/**楼层趋势*/
	public Chart trafficAndSaleTrendReport(Long orgId,Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		
		Axis<Date> xAxis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
		chart.setXAxis(xAxis);

		chart.createSeries(ParamName.TRAFFIC.toString());
		chart.createSeries(ParamName.SALES.toString(), SeriesType.line);
		// 客流量
		List<FloorDayCountData> floorDayTraffic = getOrQueryFloorDayTraffic(orgId, startDate, endDate, dataMap);
		for (FloorDayCountData floorDayCountData : floorDayTraffic) {
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(floorDayCountData.getCountdate(), floorDayCountData.getInnum());
		}
		//销售额
		List<Sale> sales = getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(), sale.getMoney());
		}
		
		return chart;
	}
	
	/**楼层店铺排行--滞留时间       滞留时间 = （总进人数 - 总出人数）* 统计时间单位 / 进店总人数   */
	public Chart durationTimeReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.DURATIONTIME.toString());
		Map<Long, List<ZoneHourCountData>> zoneDataMap =  getOrQueryZoneHourTraffic(orgId, startDate, endDate, dataMap);
		for(Entry<Long, List<ZoneHourCountData>> entry: zoneDataMap.entrySet()){
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				int allInnum = 0,allOutnum = 0,allDurationTime = 0; 
				for (ZoneHourCountData zoneHourCountData : entry.getValue()) {
					allInnum += zoneHourCountData.getInnum();
					allOutnum += zoneHourCountData.getOutnum();
					int durationNum = allInnum-allOutnum;
					if (allInnum-allOutnum < 0 ) {
						durationNum = 0;
					}
					allDurationTime += durationNum;
				}
				chart.getSeries(ParamName.DURATIONTIME.toString()).adjustOrPutValueByCoordinate(zone.getName(), 
						NumberUtil.divide(allDurationTime, allInnum, 2));
			}
		}
		chart.sort(ParamName.DURATIONTIME.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--提袋率*/
	public Chart handbagRateReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.HANDBAGRATE.toString());
		
		int takebagNum = 0;
		List<Sale> sales = getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				takebagNum = sale.getSalecount();
				int inNum = 1;
				List<ZoneDayCountData> zoneDatas = getOrQueryZoneDayTraffic(zoneId, startDate, endDate, dataMap);
				if (zoneDatas != null && zoneDatas.size() != 0) {
					inNum = 0;
					for (ZoneDayCountData zoneDayCountData : zoneDatas) {
						inNum += zoneDayCountData.getInnum();
					}
				}
				chart.getSeries(ParamName.HANDBAGRATE.toString()).adjustOrPutValueByCoordinate(zone.getName(),
						NumberUtil.percentage(takebagNum, inNum, 2));
			}
		}
		chart.sort(ParamName.HANDBAGRATE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--成交量*/
	public Chart saleCountReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.ORDER.toString());
		List<Sale> sales = getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if(zone != null){
				chart.getSeries(ParamName.ORDER.toString()).adjustOrPutValueByCoordinate(zone.getName(),sale.getSalecount());
			}
		}
		chart.sort(ParamName.ORDER.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null ) o1 = Integer.MIN_VALUE;
				if (o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--坪效*/
	public Chart perAreaValueReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PERAREAVALUE.toString());
		List<Sale> sales =  getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if(zone != null){
				float area = zone.getArea();
				chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(zone.getName(), 
						NumberUtil.divide(sale.getMoney(), area, 2));
			}
		}
		chart.sort(ParamName.PERAREAVALUE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--客单价*/
	public Chart perPriceTransactionReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PREPRICE.toString());
		
		List<Sale> sales =  getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		Map<Long, List<Sale>> saleMaps = new HashMap<Long, List<Sale>>();
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			List<Sale> zoneSales = saleMaps.get(zoneId);
			if (zoneSales == null || zoneSales.size() == 0) {
				zoneSales = new ArrayList<Sale>();
			}
			zoneSales.add(sale);
			saleMaps.put(zoneId, zoneSales);
		}
		
		for (Entry<Long, List<Sale>> entry : saleMaps.entrySet()) {
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				List<Sale> zoneSales = entry.getValue();
				int allCount = 1;
				double allMoney = 0.0;
				if (zoneSales != null && zoneSales.size()>0) {
					allCount = 0;
					for (Sale sale2 : zoneSales) {
						allCount += sale2.getSalecount();
						allMoney += sale2.getMoney();
					}
				}
				Double perPrice = NumberUtil.divide(allMoney, allCount, 2);
				chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(zone.getName() ,perPrice);
			}
		}
		chart.sort(ParamName.PREPRICE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--进店率*/
	public Chart enteringRateReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		
		Axis< String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.ENTERINGRATE.toString());
		
		List<ZoneDayCountData> zoneDatas =  getOrQueryZoneDayTraffic(orgId, startDate, endDate, dataMap);
		Map<Long, List<ZoneDayCountData>> zoneMaps = new HashMap<Long, List<ZoneDayCountData>>();
		for (ZoneDayCountData zoneDayCountData : zoneDatas) {
			Long zoneId = zoneDayCountData.getZoneId();
			List<ZoneDayCountData> zoneDatas2 = zoneMaps.get(zoneId);
			if (zoneDatas2 == null || zoneDatas2.size() ==0) {
				zoneDatas2 = new ArrayList<ZoneDayCountData>();
			}
			zoneDatas2.add(zoneDayCountData);
			zoneMaps.put(zoneId, zoneDatas2);
		}
		
		for (Entry<Long,List<ZoneDayCountData>> entry: zoneMaps.entrySet()) {
			Long zoneId = entry.getKey();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				List<ZoneDayCountData> dates = entry.getValue();
				int allInum = 0;//店铺总近店人数
				int allNum = 1;//总经过人数
				for (ZoneDayCountData zoneDayCountData : dates) {
					allNum += (zoneDayCountData.getOutsideInnum()+zoneDayCountData.getOutsideOutnum());
					allInum += zoneDayCountData.getInnum();
				}
				
				chart.getSeries(ParamName.ENTERINGRATE.toString()).adjustOrPutValueByCoordinate(
						zone.getName(),NumberUtil.percentage(allInum, allNum, 2));
			}
		}
		chart.sort(ParamName.ENTERINGRATE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--销售额*/
	public Chart salesRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.SALES.toString());
		
		List<Sale> sales = getOrQueryFloorSale(orgId, startDate, endDate, dataMap);
		for (Sale sale : sales) {
			Long zoneId = sale.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(zone.getName(), sale.getMoney());
			}
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				if (o1 == null ) o1 = Double.MIN_VALUE;
				if (o2 == null ) o2 = Double.MIN_VALUE;
				return Double.compare(o1.doubleValue(), o2.doubleValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}

	/**楼层店铺排行--客流量*/
	public Chart trafficRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		// 客流量
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		List<ZoneDayCountData>  traffic =  getOrQueryZoneDayTraffic(orgId, startDate, endDate, dataMap);
		for (ZoneDayCountData zoneDayCountData: traffic) {
			Long zoneId = zoneDayCountData.getZoneId();
			Zone zone = getOrQueryZoneById(zoneId, orgId, dataMap);
			if (zone != null) {
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(zone.getName(),zoneDayCountData.getInnum().intValue());
			}
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null ) o1 = Integer.MIN_VALUE;
				if (o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/**楼层出入口客流*/
	public Chart gateTrafficReport(Long orgId,Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		
		List<GateDayCountData> datas = getOrQueryGateDayTraffic(orgId, startDate, endDate, dataMap);
		if (datas != null && datas.size() >0) {
			Map<Long, Gate> gateMap = getOrQueryGatesMap(orgId, dataMap);
			for (GateDayCountData gateDayCountData : datas) {
				Long gateId = gateDayCountData.getGateId();
				Gate gate = gateMap.get(gateId);
				if (gate != null ) {
					chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(gate.getName(), gateDayCountData.getInnum().intValue());
				}
			}
		}
		
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				if (o1 == null ) o1 = Integer.MIN_VALUE;
				if (o2 == null ) o2 = Integer.MIN_VALUE;
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/**楼层  监控点的客流数据(天级)*/
	public List<GateDayCountData> getOrQueryGateDayTraffic(Long floorId,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<GateDayCountData> datas =  (List<GateDayCountData>) dataMap.get(KEY_FLOOR_GATE_DAY_TRAFFIC);
		if (datas ==  null) {
			datas = new ArrayList<GateDayCountData>();
			//获取楼层---监控点对应关系
			List<FloorGate> floorGates = getOrQueryFloorGates(floorId, dataMap);
			List<Long> gateIds = new ArrayList<Long>();
			for (FloorGate floorGate : floorGates) {
				gateIds.add(floorGate.getGateId());
			}
			datas =  (List<GateDayCountData>) gateDataService.getDayData(startDate, endDate, gateIds);
			dataMap.put(KEY_FLOOR_GATE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**楼层   所有店铺的客流量（小时级）*/
	public Map<Long,List<ZoneHourCountData>> getOrQueryZoneHourTraffic(Long floorId,Date startDate,Date endDate,Map<String,Object> dataMap){
		Map<Long,List<ZoneHourCountData>> datas = (Map<Long, List<ZoneHourCountData>>) dataMap.get(KEY_FLOOR_ZONE_HOUR_TRAFFIC);
		if (datas == null) {
			datas = new HashMap<Long, List<ZoneHourCountData>>();
			Map<Long,Zone> zoneMaps =  getOrQueryFloorZoneMaps(floorId, dataMap);
			List<Long> zoneIds = new ArrayList<Long>(zoneMaps.keySet());
			List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
		    List<ZoneHourCountData>	zoneDatas = (List<ZoneHourCountData>) zoneDataService.getHourData(dates, zoneIds);
		    if (zoneDatas != null && zoneDatas.size() >0) {
		    	for (ZoneHourCountData zoneHourCountData : zoneDatas) {
			    	Long zoneId = zoneHourCountData.getZoneId();
			    	List<ZoneHourCountData> zoneDataList = datas.get(zoneId);
			    	if (zoneDataList == null || zoneDataList.size() == 0) {
						zoneDataList = new ArrayList<ZoneHourCountData>();
					}
			    	zoneDataList.add(zoneHourCountData);
					datas.put(zoneId, zoneDataList);
				}
			}
			dataMap.put(KEY_FLOOR_ZONE_HOUR_TRAFFIC, datas);
		}
		return datas;
	}

	/**
	 * 获取楼层的人脸数据
	 * @param floorId
	 * @param startDate
	 * @param endDate
	 * @param dataMap
	 * @return
	 */
	public List<FloorDayFaceRecognitionSta> getOrQueryFloorFaceSta(Long floorId,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<FloorDayFaceRecognitionSta> datas = (List<FloorDayFaceRecognitionSta>) dataMap.get(KEY_FLOOR_FACE_DATA);
		if (datas == null){
			datas = new ArrayList<>();
			FloorDayFaceRecognitionStaExample example = new FloorDayFaceRecognitionStaExample();
			example.createCriteria().andFloorIdEqualTo(floorId).andCountdateBetween(startDate, endDate);
			datas= floorDayFaceRecognitionStaService.selectByExample(example);
			dataMap.put(KEY_FLOOR_FACE_DATA,datas);
		}
		return  datas;
	}
	
	
	/**楼层   所有店铺的客流量(天级)*/
	public List<ZoneDayCountData> getOrQueryZoneDayTraffic(Long floorId,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_FLOOR_ZONE_DAY_TRAFFIC);
		if (datas == null) {
			datas = new ArrayList<ZoneDayCountData>();
			 Map<Long,Zone> zoneMaps =  getOrQueryFloorZoneMaps(floorId, dataMap);
			 List<Long> zoneIds = new ArrayList<Long>(zoneMaps.keySet());
			 datas = (List<ZoneDayCountData>) zoneDataService.getDayData(startDate, endDate,zoneIds);
			 dataMap.put(KEY_FLOOR_ZONE_DAY_TRAFFIC, datas);
		}
		return datas;
	}
	
	/**楼层   楼层的客流数据(天级)*/
	public List<FloorDayCountData> getOrQueryFloorDayTraffic(Long floorId,Date startDate,Date endDate,Map<String,Object> dataMap){
		List<FloorDayCountData> datas =  (List<FloorDayCountData>) dataMap.get(KEY_FLOOR_TRAFFIC_DAY);
		if (datas==null) {
			datas = new ArrayList<FloorDayCountData>();
			datas =  (List<FloorDayCountData>) floorDataService.getDayData(startDate, endDate, floorId);
			dataMap.put(KEY_FLOOR_TRAFFIC_DAY, datas);
		}
		return datas;
	}
	
	/**楼层   所有店铺的销售数据*/
	public List<Sale> getOrQueryFloorSale(Long floorId,Date startDate,Date endDate,Map<String, Object> dataMap){
		List<Sale> sales = (List<Sale>) dataMap.get(KEY_FLOOR_SALE);
		if (sales == null) {
			sales = new ArrayList<Sale>();
			sales = (List<Sale>) saleDataService.getDayData(startDate, endDate, floorId, OrgType.floor);
			dataMap.put(KEY_FLOOR_SALE, sales);
		}
		return sales;
	}
	
	/**楼层    所有店铺的map数据*/
	public Map<Long,Zone> getOrQueryFloorZoneMaps(Long floorId,Map<String,Object> dataMap){
		Map<Long,Zone> zoneMaps =  (Map<Long, Zone>) dataMap.get(KEY_FLOOR_ZONE_ALL);
		if (zoneMaps == null) {
			zoneMaps = new HashMap<Long, Zone>();
			ZoneExample zoneExample = new ZoneExample();
			zoneExample.createColumns().hasIdColumn().hasFormatIdColumn().hasTypeColumn().hasFloorIdColumn().
			hasNameColumn().hasBrandIdColumn().hasAreaColumn();
			zoneExample.createBrandColumns().hasIdColumn().hasNameColumn();
			zoneExample.createFormatColumns().hasIdColumn().hasNameColumn();
			zoneExample.createCriteria().andFloorIdEqualTo(floorId);
			List<Zone> zones =  zoneService.selectByExample(zoneExample);
			for (Zone zone : zones) {
				zoneMaps.put(zone.getId(), zone);
			}
			dataMap.put(KEY_FLOOR_ZONE_ALL, zoneMaps);
		}
		return zoneMaps;
	}
	
	/**根据店铺id获取店铺*/
	public Zone getOrQueryZoneById(Long zoneId,Long floorId,Map<String,Object> dataMap){
		Map<Long,Zone> zoneMaps =  (Map<Long, Zone>) dataMap.get(KEY_FLOOR_ZONE_ALL);
		if (zoneMaps == null) {
			zoneMaps = getOrQueryFloorZoneMaps(floorId, dataMap);
		}
		return zoneMaps.get(zoneId);
	}
	
	/**楼层-所有出入口信息 */
	public Map<Long, Gate> getOrQueryGatesMap(Long floorId,Map<String,Object> dataMap){
		Map<Long, Gate> datas = (Map<Long, Gate>) dataMap.get(KEY_GATES);
		if (datas == null) {
			datas = new HashMap<Long, Gate>();
			List<FloorGate> floorGates =getOrQueryFloorGates(floorId, dataMap);
			List<Long> gateIds = new ArrayList<Long>();
			if(floorGates != null && floorGates.size() >0){
				for (FloorGate floorGate : floorGates) {
					gateIds.add(floorGate.getGateId());			
				}
				GateExample example = new GateExample();
				example.createColumns().hasIdColumn().hasNameColumn();
				example.createCriteria().andIdIn(gateIds);
				List<Gate> gates = gateService.selectByExample(example);
				for (Gate gate : gates) {
					datas.put(gate.getId(), gate);
				}
			}
			dataMap.put(KEY_GATES, datas);
		}
		return datas;
	}
	

	/**楼层---出入口  对应关系*/
	public List<FloorGate> getOrQueryFloorGates(Long floorId,Map<String,Object> dataMap){
		List<FloorGate> datas = (List<FloorGate>) dataMap.get(KEY_FLOOR_GATE_ALL);
		if (datas == null) {
			datas = new ArrayList<FloorGate>();
			FloorGateExample example = new FloorGateExample();
			example.createColumns().hasFloorIdColumn().hasGateIdColumn().hasTypeColumn();
			example.createCriteria().andFloorIdEqualTo(floorId).andTypeEqualTo((short)1);
			datas = floorGateService.selectByExample(example);
			dataMap.put(KEY_FLOOR_GATE_ALL, datas);
		}
		return datas;
	}
}
