package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.Table;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.axis.TableHead;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.model.FaceVo;
import com.viontech.mall.report.util.AgeProcessUtil;
import org.springframework.beans.factory.annotation.Value;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: WJY
 * @Date: 2018-11-07 16:38
 */
public abstract class AbstractFaceAnalyzeStaReportServiceImpl extends ChartReportBaseService {

    @Value("${Age.stage}")
    private String ageStage;


    /**
     * 人脸统计详情
     */
    private final static  String  REPORT_FACE_COUNT_DETAIL = "faceCountDetail";
    /**
     * 人脸性别统计
     */
    private final static  String  REPORT_FACE_GENDER = "faceGender";
    /**
     * 人脸年龄统计
     */
    private final static  String  REPORT_FACE_AGE = "faceAge";

    @Override
    public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) {
        return null;
    }

    @Override
    public Chart getChart(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
        List<FaceVo> gateFaceData = this.getFaceData(orgIds,startDate,endDate,dataMap);
        Chart chart = null;
        switch (reportChart.getKey()){
            case REPORT_FACE_COUNT_DETAIL :
                chart = faceCountReport(gateFaceData,reportChart);
                break;
            case REPORT_FACE_GENDER :
                chart = faceGenderReport(gateFaceData,reportChart);
                break;
            case REPORT_FACE_AGE :
                chart = faceAgeReport(gateFaceData,reportChart);
            default:
                break;
        }

        return chart;
    }

    /**
     * 人脸统计详情报表
     * @return
     */
    private Chart faceCountReport(List<FaceVo> gateFaceData, ReportChart reportChart){
        final String allTime = LocalMessageUtil.getMessage("Face.allTime");
        final String allCount = LocalMessageUtil.getMessage("Face.allCount");
        final String customerTime = LocalMessageUtil.getMessage("Face.customerTime");
        final String customerCount = LocalMessageUtil.getMessage("Face.customerCount");
        final String staffTime = LocalMessageUtil.getMessage("Face.staffTime");
        final String staffCount = LocalMessageUtil.getMessage("Face.staffCount");

        Table table = new Table(reportChart.getTitle());

        //表头
        TableHead tableHead = new TableHead();
        tableHead.addData(allTime);
        tableHead.addData(allCount);
        tableHead.addData(customerTime);
        tableHead.addData(customerCount);
        tableHead.addData(staffTime);
        tableHead.addData(staffCount);
        table.setTableHead(tableHead);

        for (FaceVo faceData : gateFaceData) {

            //总人数
            Integer allC = faceData.getPersonCount();
            table.getRow(reportChart.getTitle()).adjustOrPutValueByHeadColumn(allCount,allC);

            //顾客人数
            Integer customerC = faceData.getCustomCount();
            table.getRow(reportChart.getTitle()).adjustOrPutValueByHeadColumn(customerCount, customerC);

            //店员人数
            Integer staffC = faceData.getStaffCount();
            table.getRow(reportChart.getTitle()).adjustOrPutValueByHeadColumn(staffCount, staffC);

            //总人次
            Integer allT = faceData.getPersonMantime();
            table.getRow(reportChart.getTitle()).adjustOrPutValueByHeadColumn(allTime, allT);

            //顾客人次
            Integer customerT = faceData.getCustomMantime();
            table.getRow(reportChart.getTitle()).adjustOrPutValueByHeadColumn(customerTime, customerT);

            //店员人次
            Integer staffT = faceData.getStaffMantime();
            table.getRow(reportChart.getTitle()).adjustOrPutValueByHeadColumn(staffTime, staffT);
        }
        return table;
    }

    /**
     * 人脸性别统计
     * @return
     */
    private Chart faceGenderReport(List<FaceVo> gateFaceData, ReportChart reportChart){

        final String male = LocalMessageUtil.getMessage("ParamName.male");
        final String female = LocalMessageUtil.getMessage("ParamName.female");


        Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
        chart.getSeries(reportChart.getTitle()).putValueByCoordinate(male,0);
        chart.getSeries(reportChart.getTitle()).adjustOrPutValueByCoordinate(female, 0);

        for (FaceVo faceData : gateFaceData) {

            Integer maleCount = faceData.getMaleCount();
            Integer femaleCount = faceData.getFemaleCount();
            chart.getSeries(reportChart.getTitle()).adjustOrPutValueByCoordinate(male, maleCount);
            chart.getSeries(reportChart.getTitle()).adjustOrPutValueByCoordinate(female, femaleCount);
        }

        return chart;
    }

    /**
     * 人脸年龄统计
     * @return
     */
    private Chart   faceAgeReport(List<FaceVo> gateFaceData, ReportChart reportChart){
        Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);

        Axis<String> xAxis = AxisFactory.createStringAxis();
        String[] ages = ageStage.split(",");
        List<Integer> ageStages = new ArrayList<>();
        for (String age : ages) {
            Integer ageInt = Integer.parseInt(age);
            ageStages.add(ageInt);
        }
        String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);
        xAxis.addData(ageThresholdName);
        chart.setXAxis(xAxis);

        for (FaceVo faceDate : gateFaceData) {
            String maleStage = faceDate.getMaleStage();
            String femaleStage = faceDate.getFemaleStage();
            if(maleStage == null || maleStage.isEmpty() || femaleStage == null || femaleStage.isEmpty()){
                continue;
            }

            String[] maleAgeStatic = maleStage.split(",",-2);
            String[] femaleAgeStatic = femaleStage.split(",",-2);
            if(maleAgeStatic.length != femaleAgeStatic.length){
                continue;
            }

            for(int i = 0 ; i<maleAgeStatic.length ; i++){
                String femaleNum = femaleAgeStatic[i]==null?"0":femaleAgeStatic[i];
                String maleNum = maleAgeStatic[i]==null?"0":maleAgeStatic[i];
                Integer ageNum = Integer.parseInt(femaleNum.trim())+Integer.parseInt(maleNum.trim());

                chart.getSeries(reportChart.getTitle()).adjustOrPutValueByCoordinate(ageThresholdName[AgeProcessUtil.getIndexByAge(i,ageStages)], ageNum);
            }
        }

        return chart;
    }

    /**
     * 获得face数据
     * @param startDate
     * @param endDate
     * @param dataMap
     * @return
     */
    protected abstract List<FaceVo> getFaceData(Long[] orgIds,Date startDate, Date endDate, Map<String, Object> dataMap);
}
