package com.viontech.mall.report.service.impl;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.enums.ParamName;
import com.viontech.mall.report.service.adapter.AccountDataService;
import com.viontech.mall.report.service.adapter.SaleDataService;
import com.viontech.mall.report.util.AgeProcessUtil;
import com.viontech.mall.service.adapter.*;
import com.viontech.mall.vo.MallVo;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.*;
import java.util.Map.Entry;

public abstract class AbstractAccountReportServiceImpl extends ChartReportBaseService {

	@Value("${Age.stage}")
	private String ageStage;
	
	@Resource
	private MallService mallService;

	@Resource
	private ZoneService zoneService;
	
	@Resource
	private CityService cityService;
	
	@Resource
	private SaleDataService saleDataService;

	@Resource
	private ZoneDayCountDataService zoneDayCountDataService;
	
	@Resource
	private AccountDataService accountDataService;
	
	@Resource
	private MallDayFaceRecognitionStaService mallDayFaceRecognitionStaService;
	
	
	@Resource
	private MallOpentimeService mallOpentimeService;
	
	
	/** 已开业商场数量 */
	public static final String FIELD_MALL_OPENED_COUNT = "openedCount";
	/** 集团商场总数 */
	public static final String FIELD_MALL_ALL_COUNT = "allCount";
	/**已开业面积*/
	public static final String FIELD_MALL_OPENED_AREA="mallOpenedArea";
	/** 累计客流 */
	public static final String FIELD_ACCOUNT_INNUM = "innum";
	/** 累计销售额 */
	public static final String FIELD_ACCOUNT_SALES = "sales";
	/** 平均客流量 */
	public static final String FIELD_ACCOUNT_AVERAGE_INNUM = "averageInnum";
	/** 工作日平均客流量 */
	public static final String FIELD_ACCOUNT_WORKDAY_AVERAGE_INNUM = "workdayAverageInnum";
	/** 休息日平均客流量 */
	public static final String FIELD_ACCOUNT_WEEKEND_AVERAGE_INNUM = "weekendAverageInnum";
	/** 平均销售额 */
	public static final String FIELD_ACCOUNT_AVERAGE_SALES = "averageSells";
	/** 工作日平均销售额 */
	public static final String FIELD_ACCOUNT_WORKDAY_AVERAGE_SALES = "workdayAverageSales";
	/** 休息日平均销售额 */
	public static final String FIELD_ACCOUNT_WEEKEND_AVERAGE_SALES = "weekendAverageSales";
	/** 有效客流 */
	public static final String FIELD_ENABLE_INNUM = "effectiveTraffic";
	/** 店员客流 */
	public static final String FIELD_STAFF_INNUM = "staffCount";
	/** 男性客流 */
	public static final String FIELD_MALE_INNUM = "maleTraffic";
	/** 女性客流 */
	public static final String FIELD_FEMALE_INNUM = "femaleTraffic";

	/** 商场开业状态 */
	public static final int MALL_STATUS_OPEN = 1;

	/** 双休日较工作日的客流增长率 */
	public final String FIELD_WORK_DAY_COMPARED_INNUM = "compareWorkDay";

	
	/**集团  天级客流数据*/
	public static final String KEY_ACCOUNT_TRIFFIC_DAYDATA = "AccountMallDayData";
	/**集团  天级人脸数据*/
	public static final String KEY_ACCOUNT_FACE_DATA = "AccountMallDayFaceData";
	/**集团  天级区域客流数据*/
	public static final String KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA = "AccountZoneDayData";
	/**集团  销售数据*/
	public static final String KEY_ACCOUNT_SALES = "AccountSales";
	/**集团  店铺信息列表*/
	public static final String KEY_ACCOUNT_ZONE_ALL = "allZone";
	/**集团  下属商场列表*/
	public static final String KEY_ACCOUNT_MALL_ALL = "allMall";
	/**城市列表数据*/
	public static final String KEY_ALL_CITY = "allCity";
	/**集团  历史同期天级客流数据*/
	public static final String KEY_ACCOUNT_TRIFFIC_HISTORY_DATA = "AccountMallHistoryData";
	
	@Override
	public Map<String, Object> getHead(Long[] orgIds, Date startDate, Date endDate,Map<String, Object> dataMap) {
		Long orgId = orgIds[0];
		Map<String, Object> head = new HashMap<String, Object>();
		Map<Long, Mall> malls = getOrQueryMallMap(orgId, dataMap);
		//集团下属商场总计
		head.put(FIELD_MALL_ALL_COUNT, malls.size());
		//已开业商场数量
		Integer opened = null;
		Float openArea = null;
		if (malls != null && malls.size() >0) {
			opened = 0;
			openArea = (float) 0;
			for (Mall mall : malls.values()) {
				if (mall.getStatus().intValue() == MALL_STATUS_OPEN) {
					opened++;
				}
				if(mall.getArea() != null){
					openArea += mall.getArea();
				}
			}
		}
		head.put(FIELD_MALL_OPENED_COUNT, opened);
		//已开业商场面积
		head.put(FIELD_MALL_OPENED_AREA, openArea);
		//获取工作日、双休日天数
		Integer allDays = null ,workDays = null ,weekendDays = null;
		List<Date> dates = DateUtil.getDaysBetweenDates(startDate, endDate);
		if (dates != null && dates.size() > 0) {
			allDays = 0 ;workDays = 0 ;weekendDays = 0;
			for (Date date : dates) {
				allDays++;
				int weekNum = DateUtil.getDayOfWeek(date);
				if (weekNum <6) {
					workDays++;
				}else {
					weekendDays++;
				}
			}
		}
		
		// 累计客流    工作日累计客流   双休日累计客流
		Integer innum = null, wokedayInnum = null, weedendInnum = null;
		List<MallDayCountData> datas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		if(datas != null && datas.size() > 0){
			innum = 0; wokedayInnum = 0; weedendInnum = 0;
			for (MallDayCountData mallDayCountData : datas) {
				innum += mallDayCountData.getInnum();
				int weekNum = DateUtil.getDayOfWeek(mallDayCountData.getCountdate());
				if (weekNum <6) {
					wokedayInnum += mallDayCountData.getInnum();
				}else {
					weedendInnum += mallDayCountData.getInnum();
				}
			}
		}
		head.put(FIELD_ACCOUNT_INNUM, innum);
		// 平均客流量(忽略未开业的商
		// )   工作日平均客流    双休日平均客流
		Double avgInnum = null ,wokedayAvgInnum = null , weekendAvgInnum = null;
		avgInnum =NumberUtil.divide(innum, allDays, 0);
		head.put(FIELD_ACCOUNT_AVERAGE_INNUM, avgInnum);
		wokedayAvgInnum =NumberUtil.divide(wokedayInnum, workDays, 0);
		head.put(FIELD_ACCOUNT_WORKDAY_AVERAGE_INNUM, wokedayAvgInnum);
		weekendAvgInnum =NumberUtil.divide(weedendInnum, weekendDays, 0);
		head.put(FIELD_ACCOUNT_WEEKEND_AVERAGE_INNUM, weekendAvgInnum);

		String trafficWeekedVWorkegrowRate = NumberUtil.growthRate(weekendAvgInnum, wokedayAvgInnum);
		if (trafficWeekedVWorkegrowRate != null) {
			head.put(FIELD_WORK_DAY_COMPARED_INNUM,trafficWeekedVWorkegrowRate.replace("%", ""));
		}

		//有效客流、店员人才、男性顾客人数、女性顾客人数
		Integer effectiveTraffic = null;
		Integer staffTime = null;
		Integer maleTraffic = null;
		Integer femaleTraffic = null;

		List<MallDayFaceRecognitionSta> faceDatas = getMallFaceSta(orgId, startDate, endDate, dataMap);
		if (faceDatas != null && faceDatas.size() > 0) {
			for (MallDayFaceRecognitionSta mallFaceRecognitionSta : faceDatas) {
				if(mallFaceRecognitionSta.getCustomCount() != null){
					if (effectiveTraffic == null)
						effectiveTraffic = mallFaceRecognitionSta.getCustomCount();
					else
						effectiveTraffic += mallFaceRecognitionSta.getCustomCount();
				}
				if(mallFaceRecognitionSta.getStaffCount() != null){
					if (staffTime == null)
						staffTime = mallFaceRecognitionSta.getStaffMantime();
					else
						staffTime += mallFaceRecognitionSta.getStaffMantime();
				}
				if(mallFaceRecognitionSta.getMaleCount() != null){
					if (maleTraffic == null)
						maleTraffic = mallFaceRecognitionSta.getMaleCount();
					else
						maleTraffic += mallFaceRecognitionSta.getMaleCount();
				}
				if(mallFaceRecognitionSta.getFemaleCount() != null){
					if (femaleTraffic == null)
						femaleTraffic = mallFaceRecognitionSta.getFemaleCount();
					else
						femaleTraffic += mallFaceRecognitionSta.getFemaleCount();
				}
			}
		}
		head.put(FIELD_ENABLE_INNUM,effectiveTraffic);
		head.put(FIELD_STAFF_INNUM,staffTime);
		head.put(FIELD_MALE_INNUM,maleTraffic);
		head.put(FIELD_FEMALE_INNUM,femaleTraffic);

		// 累计销售额  工作日销售额   双休日销售额
		Double sales = null, workdaySales = null, weekendSales = null;
		List<Sale> saleDatas = getAccountSales(orgId, startDate, endDate, dataMap);
		if (saleDatas != null && saleDatas.size() > 0) {
			sales = 0.0; workdaySales = 0.0; weekendSales = 0.0;
			for (Sale sale : saleDatas) {
				sales += sale.getMoney();
				int weekNum = DateUtil.getDayOfWeek(sale.getSaledate());
				if (weekNum <6) {
					workdaySales += sale.getMoney();
				}else {
					weekendSales += sale.getMoney();
				}
			}
		}
		head.put(FIELD_ACCOUNT_SALES, sales);
		// 平均销售额    工作日平均销售额    双休日平均销售额
		Double avgSales = null, workdayAvgSales = null, weekendAvgSales = null;
		avgSales =NumberUtil.divide(sales, allDays, 2);
		head.put(FIELD_ACCOUNT_AVERAGE_SALES, avgSales);
		workdayAvgSales =NumberUtil.divide(workdaySales, workDays, 2);
		head.put(FIELD_ACCOUNT_WORKDAY_AVERAGE_SALES, workdayAvgSales);
		weekendAvgSales = NumberUtil.divide(weekendSales, weekendDays, 2);
		head.put(FIELD_ACCOUNT_WEEKEND_AVERAGE_SALES, weekendAvgSales);
		//全国商场分布
		head.put(CHART_DETAIL_DATA, getDetail(orgId,startDate,endDate,dataMap));
		// 获取省份客流量
		List<MallDayCountData> mallDatas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		Map<String, Integer> provinceMap = new HashMap<String, Integer>();
		for (MallDayCountData mallDayCountData : mallDatas) {
			int mallInnum = mallDayCountData.getInnum();
			Long mallId = mallDayCountData.getMallId();
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			Long cityId = mall.getCityId();
			City city = getOrQueryCityById(cityId, dataMap);

			String provinceName  =Optional.ofNullable(city).map(x->x.getProvinceName()).orElse(LocalMessageUtil.getMessage("ParamName.unknown"));
			int pinnum = 0;
			if (provinceMap.get(provinceName)!=null) {
				pinnum = provinceMap.get(provinceName);
			}
			pinnum+=mallInnum;
			provinceMap.put(provinceName, pinnum);
		}
		head.put(CHART_TRAFFIC_DATA, provinceMap);
		return head;
	}
	
	/**全国商场布局*/
	public List<MallVo> getDetail(Long orgId,Date startDate, Date endDate, Map<String, Object> dataMap){
		Map<Long,MallVo> mallVoMaps = new HashMap<Long, MallVo>();
		//获取商场的销售数据
		List<Sale> mallSales = getAccountSales(orgId, startDate, endDate, dataMap);
		Map<Long, Double> saleMap = new HashMap<Long, Double>();
		for (Sale sale : mallSales) {
			Long mallId = sale.getMallId();
			Double money =  sale.getMoney();
			if (saleMap.get(mallId) != null) {
				money = saleMap.get(mallId);
				money += sale.getMoney();
			}
			saleMap.put(mallId, money);
		}
		//获取集团下的所有商场
		Map<Long, Mall> malls = getOrQueryMallMap(orgId, dataMap);
		for (Entry<Long, Mall> entity : malls.entrySet()) {
			Mall mall = entity.getValue();
			if (mall.getStatus() != 1)
				continue;
			Long mallId = entity.getKey();
			MallVo mallVo = new MallVo();
			mallVo.setModel(mall);
			mallVoMaps.put(mallId, mallVo);
		}
		// 获取商场的客流数据
		List<MallDayCountData> mallDatas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		
		for (MallDayCountData mallDayCountData : mallDatas) {
			Long mallId = mallDayCountData.getMallId();
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			if (mall.getStatus() != 1)
				continue;
			MallVo mallVo = mallVoMaps.get(mallId);
			if (mallVo == null ) {
				mallVo = new MallVo();
				mallVo.setModel(mall);
				mallVo.setInNum(mallDayCountData.getInnum());
				mallVo.setRevenues(saleMap.get(mall.getId()));//营业额
			}else {
				mallVo.setInNum(mallVo.getInNum()+mallDayCountData.getInnum());
			}
			mallVoMaps.put(mallId, mallVo);
		}
		
		return new ArrayList<MallVo>(mallVoMaps.values());
	}
	
	public Chart CityTrafficReport(Long orgId,Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		List<MallDayCountData> datas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		if (datas != null && datas.size() > 0) {
			for (MallDayCountData mallDayCountData : datas) {
				Date countDate = mallDayCountData.getCountdate();
				Long mallId = mallDayCountData.getMallId();
				Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
				Long cityId = mall.getCityId();
				City city = getOrQueryCityById(cityId, dataMap);
				String cityName = Optional.ofNullable(city).map(x->x.getCityName()).orElse(LocalMessageUtil.getMessage("ParamName.unknown"));
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(cityName, mallDayCountData.getInnum().intValue());
			}
			chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
				@Override
				public int compare(Integer o1, Integer o2) {
					return Integer.compare(o1.intValue(), o2.intValue());
				}
			});
			chart.subData(0, 15);
		}
		return chart;
	}
	
	
	/**集团客流/销售额 趋势报表*/
	public Chart trafficAndSaleTrendReport( Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {

		Chart chart = new Chart(reportChart.getTitle(), SeriesType.line);
		
		Axis<Date> axis = AxisFactory.createDayOFMonthAxis(startDate, endDate);
		chart.setXAxis(axis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		//chart.createSeries(ParamName.SALES.toString());
		
		List<MallDayCountData> accoundDatas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		for (MallDayCountData mallDayCountData : accoundDatas) {
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(mallDayCountData.getCountdate(), mallDayCountData.getInnum());
		}
		//销售额
//		List<Sale> sales = getAccountSales(orgId, startDate, endDate, dataMap);
//		if (sales != null && sales.size() >0) {
//			for (Sale sale : sales) {
//				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(sale.getSaledate(),sale.getMoney());
//			}
//		}
		return chart;
	}
	
	/**集团业态排名--销售额top10 */
	public Chart FormatSalesRankReport(Long orgId,  Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.SALES.toString());
		
		List<Sale> sales = getAccountSales(orgId, startDate, endDate, dataMap);
		
		for (Sale sale : sales) {
			Zone zone = getOrQueryZoneById(orgId, sale.getZoneId(), dataMap);
			Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
			chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(format.getName(), sale.getMoney());
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/** 业态排名--客流量top10 */
	public Chart formatTrifficRankReport(Long orgId,  Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.TRAFFIC.toString());
		
		List<ZoneDayCountData> triffic = getAccountZoneDayTriffic(orgId, startDate,endDate, dataMap);
		
		for (ZoneDayCountData zoneDayCountData : triffic) {
			Zone zone = getOrQueryZoneById(orgId, zoneDayCountData.getZoneId(), dataMap);
			Format format = getOrQueryFormatById(zone.getFormatId(), dataMap);
			String formatName = LocalMessageUtil.getMessage("unknownFormat");
			if (format != null && !format.getName().isEmpty()) {
				formatName = format.getName();
			}
			chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(formatName, zoneDayCountData.getInnum().intValue());		
		}
		chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
			@Override
			public int compare(Integer o1, Integer o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/**游逛深度排行*/
	public Chart depthRankReport( Long orgId,  Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		return chart;
	}
	
	/** 客单价排行      总销售额/总消费单数   */
	public Chart PrepriceRankingReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		// 创建报表Chart
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PREPRICE.toString());
		
		List<Sale> sales = getAccountSales(orgId, startDate, endDate, dataMap);
		
		Map<Long, Double> mallMoney = new HashMap<Long, Double>();
		Map<Long ,Integer> mallInnum = new HashMap<Long, Integer>();  
		
		//计算商场的总销售额   总的消费单数
		for (Sale sale : sales) {
			Long mallId = sale.getMallId();
			
			//商场中销售额
			Double money = sale.getMoney();
			if (mallMoney.get(mallId) != null) {
				money+= mallMoney.get(mallId);
			}
			mallMoney.put(mallId, money);
			//商场中消费单数
			int dealNum = sale.getSalecount();
			if (mallInnum.get(mallId) != null) {
				dealNum += mallInnum.get(mallId);
			}
			mallInnum.put(mallId, dealNum);
		}
		
		for (Long mallId : mallInnum.keySet()) {
			Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
			chart.getSeries(ParamName.PREPRICE.toString()).adjustOrPutValueByCoordinate(mall.getName(),NumberUtil.divide(mallMoney.get(mallId), mallInnum.get(mallId), 2));
		}
		chart.sort(ParamName.PREPRICE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/**销售额排行*/
	public Chart salesRankReport( Long orgId,  Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.SALES.toString());
		
		//销售额
		List<Sale> sales = getAccountSales(orgId, startDate, endDate, dataMap);
		if (sales != null && sales.size() >0) {
			for (Sale sale : sales) {
				Long mallId = sale.getMallId();
				Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
				chart.getSeries(ParamName.SALES.toString()).adjustOrPutValueByCoordinate(mall.getName(),sale.getMoney());
			}
		}
		chart.sort(ParamName.SALES.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/**商场客流排行*/
	public Chart trafficRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
		
		Axis<String> yAxis =AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
 		
		chart.createSeries(ParamName.TRAFFIC.toString());
		//客流量
		List<MallDayCountData> dayDatas = getAccountVisitor(orgId, startDate, endDate, dataMap);
		
		if (dayDatas != null && dayDatas.size() > 0) {
			for (MallDayCountData mallDayCountData : dayDatas) {
				Long mallId = mallDayCountData.getMallId();
				Mall mall = getOrQueryMallById(mallId, orgId, dataMap);
				chart.getSeries(ParamName.TRAFFIC.toString()).adjustOrPutValueByCoordinate(mall.getName(), mallDayCountData.getInnum().intValue());
			}
			chart.sort(ParamName.TRAFFIC.toString(), new Comparator<Integer>() {
				@Override
				public int compare(Integer o1, Integer o2) {
					return Integer.compare(o1.intValue(), o2.intValue());
				}
			});
			chart.subData(0, 10);
		}
		
		return chart;
	}
	
	/**商场坪效排行      总销售额/总面积*/
	public Chart perAreaValueRankReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart){
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> yAxis = AxisFactory.createStringAxis();
		chart.setYAxis(yAxis);
		
		chart.createSeries(ParamName.PERAREAVALUE.toString());
		
		List<Sale> sales = getAccountSales(orgId, startDate, endDate, dataMap);
		
		for (Sale sale : sales) {
			Mall mall = getOrQueryMallById(sale.getMallId(), orgId, dataMap);
			chart.getSeries(ParamName.PERAREAVALUE.toString()).adjustOrPutValueByCoordinate(mall.getName(), sale.getMoney()/mall.getArea());
		}
		chart.sort(ParamName.PERAREAVALUE.toString(), new Comparator<Double>() {
			@Override
			public int compare(Double o1, Double o2) {
				return Integer.compare(o1.intValue(), o2.intValue());
			}
		});
		chart.subData(0, 10);
		return chart;
	}
	
	/**客流性别分布*/
	public Chart genderDistributionReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
	    Chart chart = new Chart(reportChart.getTitle(), SeriesType.pie);
		
		chart.createSeries(ParamName.GENDERDISTRIBUTION.toString());

		List<MallDayFaceRecognitionSta> datas = getMallFaceSta(orgId,startDate,endDate,dataMap);
		
		for (MallDayFaceRecognitionSta mallFaceRecognitionSta : datas) {
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.FEMALE.toString(),mallFaceRecognitionSta.getFemaleCount());
			chart.getSeries(ParamName.GENDERDISTRIBUTION.toString()).adjustOrPutValueByCoordinate(ParamName.MALE.toString(), mallFaceRecognitionSta.getMaleCount());
		}	
		return chart;
	}
	
	/**年龄分布图*/
	public Chart ageDistributionReport(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart) {
		Chart chart = new Chart(reportChart.getTitle(), SeriesType.bar);
		
		Axis<String> xAxis = AxisFactory.createStringAxis();

		chart.setXAxis(xAxis);

		String[] ages = ageStage.split(",");
		List<Integer> ageStages = new ArrayList<>();
		for (String age : ages) {
			Integer ageInt = Integer.parseInt(age);
			ageStages.add(ageInt);
		}
		String[] ageThresholdName = AgeProcessUtil.calAgeThresholdName(ageStages);

		List<MallDayFaceRecognitionSta> ageSta = getMallFaceSta(orgId,startDate,endDate,dataMap);
		if (ageSta != null && ageSta.size() >0) {
			for (MallDayFaceRecognitionSta ageStatistic : ageSta) {
				String maleStage = ageStatistic.getMaleStage();
				String femaleStage = ageStatistic.getFemaleStage();
				if( maleStage==null ||  maleStage.isEmpty() ||  femaleStage==null || femaleStage.isEmpty()){
					continue;
				}
				String[] maleAgestatic = maleStage.split(",", -2);
				String[] femaleAgestatic = femaleStage.split(",", -2);
				
				if (maleAgestatic.length != femaleAgestatic.length) {
					continue;
				}

				for (int rangeNum = 0; rangeNum < maleAgestatic.length; rangeNum++) {
					int maleNum = Integer.parseInt(String.valueOf(maleAgestatic[rangeNum].trim()));
					int femaleNum = Integer.parseInt(String.valueOf(femaleAgestatic[rangeNum].trim()));
					String ageRange = ageThresholdName[AgeProcessUtil.getIndexByAge(rangeNum,ageStages)];
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.MALEAGEDISTRIBUTION.toString(), maleNum);
					chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.FEMALEAGEDISTRIBUTION.toString(), femaleNum);
					//chart.getSeries(ageRange).adjustOrPutValueByCoordinate(ParamName.AGEDISTRIBUTION.toString(), maleNum + femaleNum);
				}

			}
		}
		return chart;
	}

	/**
	 * 获取该集团下所有商场的人脸数据
	 * @param orgId   集团id
	 * @param startDate
	 * @param endDate
	 * @param dataMap  内存缓存对象
	 * @return
	 */
	public List<MallDayFaceRecognitionSta> getMallFaceSta(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayFaceRecognitionSta> datas = (List<MallDayFaceRecognitionSta>) dataMap.get(KEY_ACCOUNT_FACE_DATA);
		if (datas == null){
			datas = new ArrayList<>();
			MallDayFaceRecognitionStaExample example = new MallDayFaceRecognitionStaExample();
			example.createCriteria().andAccountIdEqualTo(orgId).andCountdateBetween(startDate, endDate);
			datas = mallDayFaceRecognitionStaService.selectByExample(example);
			dataMap.put(KEY_ACCOUNT_FACE_DATA,datas);
		}
		return  datas;
	}


	/**获取集团商场客流数据（天级）*/
	public List<MallDayCountData> getAccountVisitor(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap){
		 List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_ACCOUNT_TRIFFIC_DAYDATA);
		if (datas == null) {
			datas = new ArrayList<MallDayCountData>();
			datas =  (List<MallDayCountData>) accountDataService.getDayData(startDate, endDate, orgId);
			dataMap.put(KEY_ACCOUNT_TRIFFIC_DAYDATA, datas);
		}
		return datas;
	}
	/**获取集团商场同时期历史客流数据（天级）*/
	public List<MallDayCountData> getAccountHistoryVisitor(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<MallDayCountData> datas = (List<MallDayCountData>) dataMap.get(KEY_ACCOUNT_TRIFFIC_HISTORY_DATA);
		if (datas==null || datas.size() <= 0) {
			datas = new ArrayList<MallDayCountData>();
			datas =  (List<MallDayCountData>) accountDataService.getDayData(startDate, endDate, orgId);
			dataMap.put(KEY_ACCOUNT_TRIFFIC_HISTORY_DATA, datas);
		}
		return datas;
	}
	
	
	/**获取集团 店铺  客流数据（天级）*/
	public List<ZoneDayCountData> getAccountZoneDayTriffic(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<ZoneDayCountData> datas = (List<ZoneDayCountData>) dataMap.get(KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA);
		if (dataMap.get(KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA) == null) {
			datas = new ArrayList<ZoneDayCountData>();
			ZoneDayCountDataExample example = new ZoneDayCountDataExample();
			example.createColumns();
			example.createCriteria().andAccountIdEqualTo(orgId).andCountdateBetween(startDate, endDate);
		    datas = zoneDayCountDataService.selectByExample(example);
		    dataMap.put(KEY_ACCOUNT_ZONE_TRIFFIC_DAYDATA, datas);
		}
		return datas;
	}
	
	/**获取集团商场销售额*/
	@SuppressWarnings("unchecked")
	public List<Sale> getAccountSales(Long orgId, Date startDate, Date endDate, Map<String, Object> dataMap){
		List<Sale> sales = new ArrayList<Sale>();
		if (dataMap.get(KEY_ACCOUNT_SALES)!=null) {
			sales = (List<Sale>) dataMap.get(KEY_ACCOUNT_SALES);
		}else {
			sales = (List<Sale>) saleDataService.getDayData(startDate, endDate, orgId, OrgType.account);
			dataMap.put(KEY_ACCOUNT_SALES, sales);
		}
		
		return sales;
	}

	
	/**获取集团下属所有的商场*/
	public Map<Long,Mall> getOrQueryMallMap(Long orgId,Map dataMap){
		Map<Long,Mall> mallMap = (Map<Long,Mall>) dataMap.get(KEY_ACCOUNT_MALL_ALL);
		if(mallMap == null){
			mallMap = new HashMap();
			MallExample example = new MallExample();
			example.createColumns().hasIdColumn().hasAreaColumn().hasCityIdColumn().hasLatitudeColumn().
				hasLongitudeColumn().hasNameColumn().hasStatusColumn().hasOpenDateColumn();
			example.createCriteria().andAccountIdEqualTo(orgId);
			List<Mall> malls = mallService.selectByExample(example);
			for (Mall mall : malls) {
				mallMap.put(mall.getId(), mall);
			}
			dataMap.put(KEY_ACCOUNT_MALL_ALL, mallMap);
		}
		return mallMap;
	}
	
	/**根据id获取商场数据*/
	public Mall getOrQueryMallById(Long mallId,Long orgId, Map dataMap){
		Map mallMap = getOrQueryMallMap(orgId,dataMap);
		return (Mall) mallMap.get(mallId);
	}
	
	/**获取集团的店铺数据*/
	@SuppressWarnings("unchecked")
	public Map getOrQueryZones(Long accountId,Map<String, Object> dataMap){
		Map datas = (Map)dataMap.get(KEY_ACCOUNT_ZONE_ALL);
		if (datas == null) {
			datas = new HashMap<Long, Zone>();
			List<Zone> zones = new ArrayList<Zone>();
			ZoneExample zoneExample = new ZoneExample();
			zoneExample.createColumns().hasIdColumn().hasNameColumn().hasTypeColumn().hasStatusColumn().
				hasFormatIdColumn().hasBrandIdColumn().hasFloorIdColumn().hasMallIdColumn().hasAccountIdColumn();
			zoneExample.createCriteria().andAccountIdEqualTo(accountId);
			zones = zoneService.selectByExample(zoneExample);
			if (zones != null && zones.size()>0) {
				for (Zone zone : zones) {
					datas.put(zone.getId(), zone);
				}
				dataMap.put(KEY_ACCOUNT_ZONE_ALL, datas);
			}
		}
		return datas;
	}
	
	/**根据id获取店铺*/
	public Zone getOrQueryZoneById(Long accountId,Long zoneId,Map<String, Object> dataMap){
		Map datas = getOrQueryZones(accountId, dataMap);
		return (Zone) datas.get(zoneId);
	}

	/**获取所有城市列表*/
	public City getOrQueryCityById(Long cityId,Map<String, Object> dataMap){
		Map<Long, City> datas = (Map<Long, City>) dataMap.get(KEY_ALL_CITY);
		if (datas == null) {
			datas = new HashMap<Long, City>();
			CityExample example = new CityExample();
			example.createColumns().hasCityIdColumn().hasCityNameColumn().hasProvinceIdColumn().hasProvinceNameColumn();
			List<City> citys = cityService.selectByExample(example);
			for (City city : citys) {
				datas.put(city.getCityId(), city);
			}
			dataMap.put(KEY_ALL_CITY, datas);
		}
		return datas.get(cityId);
	}
	
	/**
	 * 获取集团中商场的最早营业时间和最晚结束时间
	 * @param accountId
	 * @return
	 * @throws ParseException 
	 */
	public DateCriteria getAccountOpentime(Long accountId){
		 DateCriteria dateCriteria = new DateCriteria();
		 MallOpentimeExample example = new MallOpentimeExample();
		 example.createColumns();
		 example.createCriteria().andAccountIdEqualTo(accountId);
		 List<MallOpentime> mallOpentimes =  mallOpentimeService.selectByExample(example);
		 Date minDate = null,maxDate = null;
		 
		 if (mallOpentimes == null || mallOpentimes.size() <= 0) {
			 try {
					minDate = DateUtil.parse(DateUtil.FORMAT_HHMM, "00:00");
					maxDate = DateUtil.parse(DateUtil.FORMAT_HHMM, "23:00");
				} catch (ParseException e) {
					e.printStackTrace();
				}
			 dateCriteria.setStartDate(minDate);
			 dateCriteria.setEndDate(maxDate);
			 return dateCriteria;
		 }
		
		 for (MallOpentime mallOpentime : mallOpentimes) {
			 Date temp_min = mallOpentime.getStartTime();
			 Date temp_max = mallOpentime.getEndTime();
			 //同一商场的营业时间结束时间小于开业时间（跨天），结束日期+24小时
			 if(DateUtil.compareDate(temp_min,temp_max) >= 0)
				 temp_max = DateUtil.addHours(temp_max,24);
			 if (minDate == null || minDate.after(temp_min)) {
				 minDate = temp_min;
			 }
			 if (maxDate == null || maxDate.before(temp_max)) {
				 maxDate = temp_max;
			 }
		 }

		dateCriteria.setStartDate(minDate);
		dateCriteria.setEndDate(maxDate);
		return dateCriteria;
	}
	
}
