package com.viontech.mall.report.service.adapter;

import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface ZoneReportDataService {
	
	/**获取多个店铺时间点的10分钟级的客流数据*/
	public List<ZoneMinuteCountData> getOrQueryZoneInDates10MinetuTraffic(Long[] zoneIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个店铺时间段的小时级的客流数据*/
	public List<ZoneHourCountData>  getOrQueryZoneBetweenDateHourTraffic(Long[] zoneIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	/**获取多个店铺时间点的小时级的客流数据*/
	public List<ZoneHourCountData>  getOrQueryZoneInDatesHourTraffic(Long[] zoneIds,List<Date> dates ,Map<String,Object> dataMap);
	
	/**获取多个店铺时间段的天级的客流数据*/
	public List<ZoneDayCountData>  getOrQueryZoneBetweenDateDayTraffic(Long[] zoneIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	/**获取多个店铺时间点的天级的客流数据*/
	public List<ZoneDayCountData> getOrQueryZoneInDatesDayTraffic(Long[] zoneIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个店铺时间段的天级的销售数据*/
	public List<Sale> getOrQueryZoneBetweenDateSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取多个店铺时间点的天级的销售数据*/
	public List<Sale> getOrQueryZoneInDatesSale(Long[] zoneIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**多个店铺一段时间的人脸数据*/
	public List<ZoneDayFaceRecognitionSta> getOrQueryZoneDayFaceRecognitionStas(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap) ;
	
	/** 商场营业时间*/
	public DateCriteria getMallOpentimesByOrgId(Long id,OrgType orgType ,Map<String,Object> dataMap);
	/**根据店铺id获取店铺信息*/
	public Zone getOrQueryZoneById(Long zoneId,Map<String,Object> dataMap);
	/**店铺人脸数据转成通用人脸数据*/
	public List<FaceVo> convertFace2Data(List<ZoneDayFaceRecognitionSta> zoneFaceDatas);
	/** 把店铺的小时客流、天级客流、销售    数据转成通用的数据类*/
	public   <T> List<DataVo> convert2Data(List<T> datas);
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//------------------------------------------------------以下代码需要后续修改简化--------------------------------------------------------------------//
	/**获取店铺近5年 的客流数据 */
	public List<ZoneDayCountData> getNear5YearZoneTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺近5年 的销售数据 */
	public List<Sale> getNear5YearZoneSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺近三月添加客流数据     本月  +  上月    + 去年同月*/
	public List<ZoneDayCountData> getNear3MonthZoneTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺近三月 的客流数据     本月  +  上月    + 去年同月*/
	public List<Sale> getNear3MonthZoneSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期 (当天)*/
	public List<ZoneHourCountData> getZoneNearCurrentDayHourTraffic(Long zoneId,Date date,Map<String,Object> dataMap);
	public List<ZoneHourCountData> getZoneNearCurrentDayHourTraffic(Long[] zoneIds,Date date,Map<String,Object> dataMap);
	/**获取店铺天级的客流数据   近15天*/
	public List<ZoneDayCountData> getZoneNear15DayTraffic(Long zoneId,Date date,Map<String,Object> dataMap);
	public List<ZoneDayCountData> getZoneNear15DayTraffic(Long[] zoneIds,Date date,Map<String,Object> dataMap);
	/**获取店铺的销售数据  当天   昨天  上周同期     上月同期    上年同期   近15天*/
	public List<Sale> getZoneNear15DaySales(Long zoneId,Date date,Map<String,Object> dataMap);
	public List<Sale> getZoneNear15DaySales(Long[] zoneIds,Date date,Map<String,Object> dataMap);
	/**获取店铺近三周添加客流数据     本周  +  上周     + 去年同周*/
	public List<ZoneDayCountData> getNear3WeekZoneTraffic(Long zoneId, Date startDate, Date endDate, Map<String, Object> dataMap);
	public List<ZoneDayCountData> getNear3WeekZoneTraffic(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	public List<Sale> getNear3WeekZoneSale(Long zoneId, Date startDate, Date endDate, Map<String, Object> dataMap);
	public List<Sale> getNear3WeekZoneSale(Long[] zoneIds, Date startDate, Date endDate, Map<String, Object> dataMap);

	

}
