package com.viontech.mall.report.service.adapter;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseModel;
import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.axis.Axis;
import com.viontech.keliu.chart.factory.AxisFactory;
import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.service.impl.*;
import com.viontech.mall.service.adapter.FloorService;
import com.viontech.mall.service.adapter.GateService;
import com.viontech.mall.service.adapter.MallService;
import com.viontech.mall.service.adapter.ZoneService;

import javax.annotation.Resource;
import javax.print.attribute.standard.DateTimeAtCompleted;
import java.util.*;
import java.util.function.LongFunction;
import java.util.stream.Collectors;

/**
 * @program: ShoppingMall-parent
 * @description: 日周乐年同环比分析基础类
 * @author: WJY
 * @create: 2019-02-28 13:56
 **/
public abstract class YoYOrMoMBaseService extends ChartReportBaseService{

    @Resource
    private MallReportDataServiceImpl mallReportDataServiceImpl;

    @Resource
    private FloorReportDataServiceImpl floorReportDataServiceImpl;

    @Resource
    private ZoneReportDataServiceImpl zoneReportDataServiceImpl;

    @Resource
    private GateReportDataServiceImpl gateReportDataService;

    @Resource
    private ZoneService zoneService;

    @Resource
    private GateService gateService;

    @Resource
    private MallService mallService;

    @Resource
    private FloorService floorService;

    @Resource
    private MallDataService mallDataService;

    @Resource
    private SaleDataService saleDataService;

    @Resource
    private FloorDataService floorDataService ;

    @Resource
    private GateDataService gateDataService;

    @Resource
    private ZoneDataService zoneDataService;

    public class Data<T,O,Z>{
        private Date countTime;
        private Date countDate;
        private T value;
        private O value2;
        private Z value3;

        public Data(Date countTime, Date countDate, T value) {
            this(countTime,countDate,value,null);
        }

        public Data(Date countTime, Date countDate, T value, O value2) {
            this.countTime = countTime;
            this.countDate = countDate;
            this.value = value;
            this.value2 = value2;
        }

        public Data(Date countTime, Date countDate, T value, O value2,Z value3) {
            this.countTime = countTime;
            this.countDate = countDate;
            this.value = value;
            this.value2 = value2;
            this.value3 = value3;
        }

        public Date getCountTime() {
            return countTime;
        }
        public void setCountTime(Date countTime) {
            this.countTime = countTime;
        }
        public Date getCountDate() {
            return countDate;
        }
        public void setCountDate(Date countDate) {
            this.countDate = countDate;
        }
        public T getValue() {
            return value;
        }
        public void setValue(T value) {
            this.value = value;
        }

        public Z getValue3() {
            return value3;
        }

        public void setValue3(Z value3) {
            this.value3 = value3;
        }

        public O getValue2() {
            return value2;
        }

        public void setValue2(O value2) {
            this.value2 = value2;
        }
    }

    /**
     * @Description: 得到天级的客流量趋势图
     * @Param: [startDate, endDate, datas, reportChart]
     * @return: com.viontech.keliu.chart.Chart
     * @Date: 2019/3/4
     */
    protected Chart getTrafficTrendLine(Date startDate, Date endDate, List<Data> datas, ReportChart reportChart){
        Chart chart = new Chart(reportChart.getKey(), SeriesType.line);
        Axis<String> xAxis = AxisFactory.createStringAxis();
        //Date sunDayOfWeek = DateUtil.getSundayOfWeek(endDate);
        Date currentDate = startDate;
        while(currentDate.before(endDate)|| currentDate.equals(endDate)){
            String dateStr = DateUtil.format("yyyy-MM-dd",currentDate);
            xAxis.addData(dateStr);
            currentDate = DateUtil.addDays(currentDate,1);
        }
        //当日
        String today = LocalMessageUtil.getMessage("DateType.today");
        //上月同期
        String lastMonth = LocalMessageUtil.getMessage("DateType.lastMonthDay");
        //去年同期
        String lastYear = LocalMessageUtil.getMessage("DateType.lastYearDay");
        chart.setXAxis(xAxis);
/*        Collections.sort(datas, new Comparator<Data>() {
            @Override
            public int compare(Data o1, Data o2) {
                return o1.countDate.compareTo(o2.countDate);
            }
        });*/

        chart.getSeries(today);
        chart.getSeries(lastMonth);
        chart.getSeries(lastYear);
        List<Data> dataNow = new ArrayList<>();
        List<Data> dataLastMonth = new ArrayList<>();
        List<Data> dataLastYear = new ArrayList<>();
        Date startDateLastMonth = DateUtil.getLastMonth(startDate);
        Date endDateLastMonth = DateUtil.getLastMonth(endDate);
        Date startDateLastYear = DateUtil.getLastYear(startDate);
        Date endDateLastYear = DateUtil.getLastYear(endDate);
        for(Data data : datas){
            if(DateUtil.compareDate(data.countDate,startDate)!=-1){
                dataNow.add(data);
            }else if(DateUtil.compareDate(data.countDate,startDateLastMonth)!= -1 && DateUtil.compareDate(data.countDate,endDateLastMonth) != 1){
                dataLastMonth.add(data);
            }else if(DateUtil.compareDate(data.countDate,startDateLastYear)!= -1 && DateUtil.compareDate(data.countDate,endDateLastYear) != 1){
                dataLastYear.add(data);
            }
        }
        for(Data data : dataNow){
            chart.getSeries(today).adjustOrPutValueByCoordinate(DateUtil.format("yyyy-MM-dd",data.countDate),data.getValue());
        }
        for (Data data : dataLastMonth){
            Date now = DateUtil.getNextMonth(data.countDate);
            chart.getSeries(lastMonth).adjustOrPutValueByCoordinate(DateUtil.format("yyyy-MM-dd",now),data.getValue());
        }
        for (Data data : dataLastYear){
            Date now = getNextYear(data.getCountDate());
            chart.getSeries(lastYear).adjustOrPutValueByCoordinate(DateUtil.format("yyyy-MM-dd",now),data.getValue());
        }

        return chart;
    }

    /**
     * @Description: 得到天级同环比趋势折线图
     * @Param: [startDate, endDate, datas, reportChart]
     * @return: com.viontech.keliu.chart.Chart
     * @Date: 2019/3/5
     */
    protected Chart getYOTrendLine(Date startDate,Date endDate,List<Data> datas,ReportChart reportChart){
        Chart chart  = new Chart(reportChart.getTitle(),SeriesType.line);
        Axis<String> xAxis = AxisFactory.createStringAxis();
        //Date sunDayOfWeek = DateUtil.getSundayOfWeek(endDate);
        Date currentDate = startDate;
        while(currentDate.before(endDate)|| currentDate.equals(endDate)){
            String dateStr = DateUtil.format("yyyy-MM-dd",currentDate);
            xAxis.addData(dateStr);
            currentDate = DateUtil.addDays(currentDate,1);
        }
        chart.setXAxis(xAxis);
        //上月环比
        String mD = LocalMessageUtil.getMessage("ToMD");
        //去年同比
        String yD = LocalMessageUtil.getMessage("ToYD");

        Map<Date,Object> dataNow = new HashMap<>();
        Map<Date,Object> dataLastMonth = new HashMap<>();
        Map<Date,Object> dataLastYear = new HashMap<>();
        Date startDateLastMonth = DateUtil.getLastMonth(startDate);
        Date endDateLastMonth = DateUtil.getLastMonth(endDate);
        Date startDateLastYear = DateUtil.getLastYear(startDate);
        Date endDateLastYear = DateUtil.getLastYear(endDate);
        for(Data data : datas){
            if(DateUtil.compareDate(data.countDate,startDate)!=-1){
                dataNow.put(data.countDate,data.getValue());
            }else if(DateUtil.compareDate(data.countDate,startDateLastMonth)!= -1 && DateUtil.compareDate(data.countDate,endDateLastMonth) != 1){
                Date now = DateUtil.getNextMonth(data.countDate);
                dataLastMonth.put(now,data.getValue());
            }else if(DateUtil.compareDate(data.countDate,startDateLastYear)!= -1 && DateUtil.compareDate(data.countDate,endDateLastYear) != 1){
                Date now = getNextYear(data.getCountDate());
                dataLastYear.put(now,data.getValue());
            }
        }
        List<Date> dateList  = DateUtil.getDaysBetweenDates(startDate,endDate);
        Double nowDate = null;
        Double lastMonth = null;
        Double lastYear = null;
        for (Date date : dateList){
            if(dataNow.get(date)==null){
                continue;
            }
            nowDate = Double.parseDouble(dataNow.get(date).toString());
            String lastMonthGrowth = null;
            String lastYearGrowth = null;
            if(dataLastMonth.get(date)!=null) {
                lastMonth = Double.parseDouble(dataLastMonth.get(date).toString());
                lastMonthGrowth = NumberUtil.growthRate(nowDate, lastMonth);
                if(lastMonthGrowth != null) {
                    lastMonthGrowth = lastMonthGrowth.replace("%", "");
                }
            }
            if(dataLastYear.get(date)!=null) {
                lastYear = Double.parseDouble(dataLastYear.get(date).toString());
                lastYearGrowth = NumberUtil.growthRate(nowDate,lastYear);
                if(lastYearGrowth != null) {
                    lastYearGrowth = lastYearGrowth.replace("%", "");
                }
            }
            chart.getSeries(mD).adjustOrPutValueByCoordinate(DateUtil.format("yyyy-MM-dd",date),lastMonthGrowth);
            chart.getSeries(yD).adjustOrPutValueByCoordinate(DateUtil.format("yyyy-MM-dd",date),lastYearGrowth);
        }
        return chart;
    }

    /**
     * @Description: 得到周月年的近期对比柱状图
     * @Param: [datas, reportChart]
     * @return: com.viontech.keliu.chart.Chart
     * @Date: 2019/3/5
     */
    public Chart getRecentBar(List<String>keys,Map<String,Map<String,Object>> datas,Date startDate,ReportChart reportChart){
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.bar);
        //datas中最外层中存储的是x轴的数据
        Axis<String> xAxis =AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);
        //int nowWeek = DateUtil.getWeekOfYear(startDate);
        String now = DateUtil.format("yyyy",startDate);
        String last = DateUtil.format("yyyy",DateUtil.getLastYear(startDate));
        //注意key值一定要全,生成轴按照顺序
//        for (Map.Entry entry : datas.entrySet()){
//            String x = entry.getKey().toString();
//            Map<String, Object> rowData =(Map<String, Object>) entry.getValue();
//            //String now = rowData.get("now").toString();
//            //String xName = LocalMessageUtil.getMessage("weekOfyearStrFormat",new Object[]{nowWeek-Integer.parseInt(x)+1});
//            chart.getSeries(now).adjustOrPutValueByCoordinate(x,rowData.get(now));
//            chart.getSeries(last).adjustOrPutValueByCoordinate(x,rowData.get(last));
//        }
        for(int index = keys.size()-1;index>=0;index--){
            if(datas.get(keys.get(index))!=null) {
                chart.getSeries(now).adjustOrPutValueByCoordinate(keys.get(index), datas.get(keys.get(index)).get(now));
                chart.getSeries(last).adjustOrPutValueByCoordinate(keys.get(index), datas.get(keys.get(index)).get(last));
            }else{
                chart.getSeries(now).adjustOrPutValueByCoordinate(keys.get(index), null);
                chart.getSeries(last).adjustOrPutValueByCoordinate(keys.get(index), null);
            }
        }

//        for(int index = 0;index<keys.size();index++){
//            if(datas.get(keys.get(index))!=null) {
//                chart.getSeries(now).adjustOrPutValueByCoordinate(keys.get(index), datas.get(keys.get(index)).get(now));
//                chart.getSeries(last).adjustOrPutValueByCoordinate(keys.get(index), datas.get(keys.get(index)).get(last));
//            }else{
//                chart.getSeries(now).adjustOrPutValueByCoordinate(keys.get(index), null);
//                chart.getSeries(last).adjustOrPutValueByCoordinate(keys.get(index), null);
//            }
//        }
        return chart;
    }

    /**
     * @Description: 同比趋势的折线图
     * @Param: [reportChart, datas]
     * @return: com.viontech.keliu.chart.Chart
     * @Date: 2019/3/5
     */
    public Chart getYoyTrend(List<String>keys,ReportChart reportChart,Map<String,Object> datas){
        Chart chart = new Chart(reportChart.getTitle(),SeriesType.line);
        Axis xAxis = AxisFactory.createStringAxis();
        chart.setXAxis(xAxis);
        String yD = LocalMessageUtil.getMessage("ToYD");
//        for(Map.Entry entry: datas.entrySet()){
//            chart.getSeries(yD).adjustOrPutValueByCoordinate(entry.getKey(),entry.getValue());
//        }
        for(int index = keys.size()-1;index>=0;index--){
            chart.getSeries(yD).adjustOrPutValueByCoordinate(keys.get(index),datas.get(keys.get(index)));
        }

//        for(int index = 0;index<keys.size();index++){
//            chart.getSeries(yD).adjustOrPutValueByCoordinate(keys.get(index),datas.get(keys.get(index)));
//        }
        return chart;
    }

    /**
     * @Description: 得到当天的明年此时的日期
     * @Param: [date]
     * @return: java.util.Date
     * @Date: 2019/3/5
     */
    public static Date getNextYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        return calendar.getTime();
    }

    /** 得到当前时间或时间端数据及去年对应时间或时间段数据 */
    public void generatDataMap(Map<String,Map<String,Object>> excelMap, String key, Data data, Date startDate, Date endDate,String now,String last){
        if(DateUtil.compareDate(data.countDate,startDate) !=-1 && DateUtil.compareDate(data.countDate,endDate)==-1){
            Map<String,Object>dataMap = excelMap.get(key);
            if(dataMap==null){
                dataMap = new HashMap<>();
            }
            if(dataMap.get(now)==null){
                dataMap.put(now,0);
                excelMap.put(key,dataMap);
            }
            Double nowWeek = null;
            if((dataMap.get(now)!=null)) {
                nowWeek = Double.parseDouble(dataMap.get(now).toString());
                nowWeek = Double.parseDouble(data.value.toString()) + nowWeek;
            }
            dataMap.put(now,nowWeek);
            excelMap.put(key,dataMap);
        }
        Date startDateTemple1LastYear = DateUtil.getLastYear(startDate);
        Date endDateTempleLastYear = DateUtil.getLastYear(endDate);
        if(DateUtil.compareDate(data.countDate,startDateTemple1LastYear) !=-1 && DateUtil.compareDate(data.countDate,endDateTempleLastYear)==-1){
            Map<String,Object>dataMap = excelMap.get(key);
            if(dataMap==null){
                dataMap = new HashMap<>();
            }
            if(dataMap.get(last)==null){
                dataMap.put(last,0);
                excelMap.put(key,dataMap);
            }
            Double nowWeek = Double.parseDouble(dataMap.get(last).toString());
            nowWeek = Double.parseDouble(data.value.toString())+nowWeek;
            dataMap.put(last,nowWeek);
            excelMap.put(key,dataMap);
        }
    }

    /** 根据时间得到数据的Map */
    public Map<String,Map<String,Object>> getDataMap(List<Date> dates,List<Data> datas,List<String> keys){
        Collections.sort(datas, new Comparator<Data>() {
            @Override
            public int compare(Data o1, Data o2) {
                return o1.getCountDate().compareTo(o2.getCountDate());
            }
        });
        Map<String,Map<String,Object>> excelMap = new LinkedHashMap<>();
//        for(int i=0;i<keys.size();i++){
//            excelMap.put(keys.get(0),null);
//        }
//        Date startDateTemple1 = startDate;
//        Date endDateTemple = endDate;
//        Date startDateTemple2 = DateUtil.getLastWeek(startDateTemple1);
//        Date startDateTemple3 = DateUtil.getLastWeek(startDateTemple2);
//        Date startDateTemple4 = DateUtil.getLastWeek(startDateTemple3);
//        Date startDateTemple5 = DateUtil.getLastWeek(startDateTemple4);
//        Date startDateTemple6 = DateUtil.getLastWeek(startDateTemple5);
//        Date startDateTemple7 = DateUtil.getLastWeek(startDateTemple6);
//        Date startDateTemple8 = DateUtil.getLastWeek(startDateTemple7);
        Date startDate = dates.get(1);
        Date endDate = dates.get(0);
        String now = DateUtil.format("yyyy",startDate);
        String last = DateUtil.format("yyyy",DateUtil.getLastYear(startDate));
        for (Data data : datas){
            Date date = data.getCountDate();
            System.out.println("当前data时间"+data.getCountDate());
            if(DateUtil.compareDate(data.getCountDate(),startDate) !=-1 && DateUtil.compareDate(data.getCountDate(),endDate)!=1){
                Map<String,Object>dataMap = excelMap.get(keys.get(0));
                if(dataMap==null){
                    dataMap = new HashMap<>();
                    dataMap.put(now,0);
                }
                Double nowWeek  = null;
                if(dataMap.get(now) != null) {
                    nowWeek = Double.parseDouble(dataMap.get(now).toString());
                    nowWeek = Double.parseDouble(data.getValue().toString())+nowWeek;
                }

                dataMap.put(now,nowWeek);
                excelMap.put(keys.get(0),dataMap);
            }
            Date startDateTemple1LastYear = DateUtil.getLastYear(startDate);
            Date endDateTempleLastYear = DateUtil.getLastYear(endDate);
            if(DateUtil.compareDate(data.getCountDate(),startDateTemple1LastYear) !=-1 && DateUtil.compareDate(data.getCountDate(),endDateTempleLastYear)!=1){
                Map<String,Object>dataMap = excelMap.get(keys.get(0));
                if(dataMap==null){
                    dataMap = new HashMap<>();
                    dataMap.put(last,0);
                }
                Double nowWeek = Double.parseDouble(dataMap.get(last).toString());
                nowWeek = Double.parseDouble(data.getValue().toString())+nowWeek;
                dataMap.put(last,nowWeek);
                excelMap.put(keys.get(0),dataMap);
            }
            for(int i = 0;i<keys.size()-1;i++){
                generatDataMap(excelMap,keys.get(i+1),data,dates.get(i+2),dates.get(i+1),now,last);
            }
//            generatDataMap(excelMap,keys.get(1),data,startDateTemple2,startDateTemple1);
//            generatDataMap(excelMap,keys.get(2),data,startDateTemple3,startDateTemple2);
//            generatDataMap(excelMap,keys.get(3),data,startDateTemple4,startDateTemple3);
//            generatDataMap(excelMap,keys.get(4),data,startDateTemple5,startDateTemple4);
//            generatDataMap(excelMap,keys.get(5),data,startDateTemple6,startDateTemple5);
//            generatDataMap(excelMap,keys.get(6),data,startDateTemple7,startDateTemple6);
//            generatDataMap(excelMap,keys.get(7),data,startDateTemple8,startDateTemple7);
        }
        return excelMap;
    }

    protected List<Data> getMoreObjectData(Long[] orgIds,Date startDate,Date endDate,Map<String,Object> dataMap){
        dataMap.put("orgIds",orgIds);
        KPIType kpiType = (KPIType) dataMap.get("KPITYPE");
        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
        List datas = null;
        if (orgType == OrgType.zone) {
            datas = getZoneDayReportData(orgIds, startDate,endDate, dataMap,kpiType);
        }else if (orgType == OrgType.gate) {
            datas = getGateDayReportData(orgIds, startDate,endDate, dataMap, kpiType);
        }else if (orgType == OrgType.floor) {
            datas = getFloorDayReportData(orgIds, startDate,endDate, dataMap, kpiType);
        }else if (orgType == OrgType.mall) {
            datas = getMallDayReportData(orgIds, startDate,endDate, dataMap, kpiType);
        }
        return datas;
    }

    /**
     * 得到mall的Data数据
     * @param orgIds
     * @param startDate
     * @param endDate
     * @param dataMap
     * @param kpiType
     * @return
     */
    private List<Data> getMallDayReportData(Long[] orgIds, Date startDate, Date endDate, Map<String,Object> dataMap, KPIType kpiType){
        List<Data> datas = new ArrayList<Data>();
        Date beforeLastYear = DateUtil.getLastYear(DateUtil.getLastYear(startDate));
        if (kpiType == KPIType.TRAFFIC ) {
            /**之后需要修改,之前在dataMap里面存储有相同键值的数据，所以直接手动重新查询*/
            //List<MallDayCountData>  DayDatas = mallReportDataServiceImpl.getOrQueryMallDayTraffic(orgIds,  startDate,endDate, dataMap);
            //List<Date> dateList = DateUtil.getDaysBetweenDates(startDate,endDate);
            List<MallDayCountData>  DayDatas = (List<MallDayCountData>) mallDataService.getDayData(beforeLastYear,endDate, Arrays.asList(orgIds));
            if (DayDatas == null || DayDatas.size() <= 0) {
                return datas;
            }
            for (MallDayCountData mallDayCountData : DayDatas) {
                Date countDate = mallDayCountData.getCountdate();
                Long mallId = mallDayCountData.getMallId();
                if (kpiType == KPIType.TRAFFIC) {
                    int innum = mallDayCountData.getInnum();
                    Data<Integer,Double,Long> data = new Data<Integer,Double,Long>(null, countDate, innum,null,mallId);
                    datas.add(data);
                }
            }
        }else if (kpiType == KPIType.SALES || kpiType == KPIType.PREPRICE || kpiType == KPIType.PERAREAVALUE ) {
            //List<Sale> mallSale = mallReportDataServiceImpl.getOrQueryMallBetweenDateDaySale(orgIds, startDate,endDate, dataMap);
            List<Sale> mallSale = saleDataService.getDayData(beforeLastYear, endDate, Arrays.asList(orgIds), OrgType.mall);
            if (mallSale == null || mallSale.size() <= 0) {
                return datas;
            }
            for (Sale sale : mallSale) {
                Date countDate = sale.getSaledate();
                Long mallId = sale.getMallId();
                Double mallSales = 0.0;
                if (kpiType == KPIType.SALES) {
                    mallSales+= sale.getMoney();
                    Data<Integer,Double,Long> data = new Data<Integer,Double,Long>(null,countDate,null,mallSales,mallId);
                    datas.add(data);
                }else if (kpiType == KPIType.PREPRICE) {
                    int saleCount = sale.getSalecount();
                    Double money = sale.getMoney();
                    Double value = NumberUtil.divide(money, saleCount, 2);
                    Data<Integer,Double,Long> data = new Data<Integer,Double,Long>(null,countDate,null,value,mallId);
                    datas.add(data);
                }else if (kpiType == KPIType.PERAREAVALUE) {
                    Double money = sale.getMoney();
                    float mallArea = mallReportDataServiceImpl.getMallByMallId(mallId, dataMap).getArea();
                    Double value = NumberUtil.divide(money, mallArea, 2);
                    Data<Integer,Double,Long> data = new Data<Integer,Double,Long>(null,countDate,null,value,mallId);
                    datas.add(data);

                }
            }
        }
        return datas;
    }

    /**
     * 得到楼层的Data数据
     * @param orgIds
     * @param startDate
     * @param endDate
     * @param dataMap
     * @param kpiType
     * @return
     */
    private List<Data> getFloorDayReportData(Long[] orgIds,Date startDate,Date endDate,Map<String,Object> dataMap,KPIType kpiType){
        List<Data> datas = new ArrayList<Data>();
        Date beforeLastYearStartDate = DateUtil.getLastYear(DateUtil.getLastYear(startDate));
        if (kpiType == KPIType.TRAFFIC ) {
            //List<FloorDayCountData>  DayDatas = floorReportDataServiceImpl.getOrQueryFloorDayTraffic(orgIds,  startDate,endDate, dataMap);
            //List<Date> dateList = DateUtil.getDaysBetweenDates(startDate,endDate);

            List<FloorDayCountData>  DayDatas = (List<FloorDayCountData>)floorDataService.getDayData(beforeLastYearStartDate,endDate,Arrays.asList(orgIds));
            if (DayDatas == null || DayDatas.size() <= 0) {
                return datas;
            }
            for (FloorDayCountData floorDayCountData : DayDatas) {
                Date countDate = floorDayCountData.getCountdate();
                Long floorId = floorDayCountData.getFloorId();
                if (kpiType == KPIType.TRAFFIC) {
                    int innum = floorDayCountData.getInnum();
                    Data<Integer,Double,Long> data = new Data<Integer,Double, Long>(null, countDate, innum,null,floorId);
                    datas.add(data);
                }
            }
        }else if (kpiType == KPIType.SALES ) {
            //List<Sale> floorSales = floorReportDataServiceImpl.getOrQueryFloorSales(orgIds, startDate,endDate, dataMap);
            List<Sale> floorSales = saleDataService.getDayData(beforeLastYearStartDate, endDate, Arrays.asList(orgIds), OrgType.floor);
            if (floorSales == null || floorSales.size() <= 0) {
                return datas;
            }
            for (Sale sale : floorSales) {
                Date countDate = sale.getSaledate();
                Long floorId = sale.getFloorId();
                if (kpiType == KPIType.SALES) {
                    Double value = sale.getMoney();
                    Data<Integer,Double,Long> data = new Data<Integer, Double, Long>(null,countDate,null,value,floorId);
                    datas.add(data);
                }
            }
        }
        return datas;
    }

    /*
    得到zone的Data数据
     */
    private List<Data>  getZoneDayReportData(Long[] orgIds,Date startDate,Date endDate,Map<String,Object> dataMap,KPIType kpiType){
        List<Data> datas = new ArrayList<Data>();
        //List<Date> dateList = DateUtil.getDaysBetweenDates(startDate, endDate);
        //List<ZoneDayCountData> zoneTraffic = zoneReportDataServiceImpl.getOrQueryZoneDayTraffic(orgIds, startDate, endDate, dataMap);
        //List<Sale> sales = zoneReportDataServiceImpl.getOrQueryZoneSales(orgIds, startDate, endDate, dataMap);
        Date beforeLastYearStartDate = DateUtil.getLastYear(DateUtil.getLastYear(startDate));
        List<ZoneDayCountData> zoneTraffic = (List<ZoneDayCountData>)zoneDataService.getDayData(beforeLastYearStartDate,endDate,Arrays.asList(orgIds));
        List<Sale> sales = saleDataService.getDayData(beforeLastYearStartDate, endDate, Arrays.asList(orgIds), OrgType.zone);
        Map<Date, Integer> trafficMap = new HashMap<Date, Integer>();
        if (kpiType == KPIType.TRAFFIC || kpiType == KPIType.ENTERINGRATE ||kpiType == KPIType.HANDBAGRATE ||
                kpiType == KPIType.DURATIONTIME	) {
            if (zoneTraffic == null || zoneTraffic.size() <= 0 ) {
                return datas;
            }

            for (ZoneDayCountData zoneDayCountData : zoneTraffic) {
                Date date = zoneDayCountData.getCountdate();
                Long zoneId = zoneDayCountData.getZoneId();
                if (kpiType == KPIType.TRAFFIC ) {
                    int value = zoneDayCountData.getInnum();
                    Data data = new Data(null, date, value,null,zoneId);
                    datas.add(data);
                }else if ( kpiType == KPIType.ENTERINGRATE) {
                    int innum = zoneDayCountData.getInnum();
                    int passNum = zoneDayCountData.getOutsideInnum()+zoneDayCountData.getOutsideOutnum();
                    Data data = new Data(null, date, innum, passNum,zoneId);
                    datas.add(data);
                }else if (kpiType == KPIType.HANDBAGRATE) {
                    int innum = zoneDayCountData.getInnum();
                    trafficMap.put(date, innum);
                }else if (kpiType == KPIType.DURATIONTIME) {
                    int innum = zoneDayCountData.getInnum();
                    List<ZoneHourCountData> zoneDatas = zoneReportDataServiceImpl.getZoneNearCurrentDayHourTraffic(orgIds, date, dataMap);
                    int allHourInnum = 0;
                    if (zoneDatas == null || zoneDatas.size() <= 0) {
                        return datas;
                    }
                    for (ZoneHourCountData zoneHourCountData : zoneDatas) {
                        allHourInnum += zoneHourCountData.getInnum();
                    }
                    Data data = new Data(null, date, allHourInnum,innum,zoneId);
                    datas.add(data);
                }
            }
        }
        if(kpiType == KPIType.SALES  || kpiType == KPIType.ORDER || kpiType == KPIType.PREPRICE ||
                kpiType == KPIType.PERAREAVALUE || kpiType == KPIType.HANDBAGRATE){
            if (sales == null || sales.size() <= 0) {
                return datas;
            }
            for (Sale sale : sales) {
                Date date = sale.getSaledate();
                Long zoneId = sale.getZoneId();
                double saleMoney = sale.getMoney();
                if (kpiType == KPIType.SALES ) {
                    double value = saleMoney;
                    Data data = new Data(null, date, value,null,zoneId);
                    datas.add(data);
                }else if (kpiType == KPIType.ORDER) {
                    int value = sale.getSalecount();
                    Data  data =  new Data(null,date,value,null,zoneId);
                    datas.add(data);
                }else if (kpiType == KPIType.PREPRICE) {
                    int saleCount = sale.getSalecount();
                    Data data = new Data(null, date, saleMoney, saleCount,zoneId);
                    datas.add(data);
                }else if (kpiType == KPIType.PERAREAVALUE) {
                    float zoneArea = zoneReportDataServiceImpl.getOrQueryZoneById(zoneId, dataMap).getArea();
                    Data data = new Data(null, date, saleMoney, zoneArea,zoneId);
                    datas.add(data);
                }else if (kpiType == KPIType.HANDBAGRATE) {
                    int innum = trafficMap.get(date);
                    int saleCount = sale.getSalecount();
                    Data data = new Data(null, date, saleCount,innum,zoneId);
                    datas.add(data);
                }
            }
        }
        return datas;
    }

    /**
     * @Description: 得到gate的Data数据
     * @Param: [orgIds, startDate, endDate, dataMap, kpiType]
     * @return: java.util.List<com.viontech.mall.report.service.adapter.YoYOrMoMBaseService.Data>
     * @Date: 2019/3/12
     */
    private List<Data> getGateDayReportData(Long[] orgIds,Date startDate,Date endDate,Map<String,Object> dataMap,KPIType kpiType){
        List<Data> datas = new ArrayList<Data>();
        Date beforeLastYearStartDate = DateUtil.getLastYear(DateUtil.getLastYear(startDate));
        if (kpiType == KPIType.TRAFFIC ) {
            //List<GateDayCountData>  gateDayDatas = gateReportDataService.getOrQueryGateDayTraffic(orgIds, startDate,endDate, dataMap);
            //List<Date> dateList = DateUtil.getDaysBetweenDates(startDate,endDate);

            List<GateDayCountData>  gateDayDatas = (List<GateDayCountData>) gateDataService.getDayData(beforeLastYearStartDate,endDate,Arrays.asList(orgIds));
            if (gateDayDatas == null || gateDayDatas.size() <= 0) {
                return datas;
            }
            for (GateDayCountData gateDayCountData : gateDayDatas) {
                Date countDate = gateDayCountData.getCountdate();
                Long gateId = gateDayCountData.getGateId();
                if (kpiType == KPIType.TRAFFIC) {
                    int innum = gateDayCountData.getInnum();
                    Data data = new Data(null, countDate, innum,null,gateId);
                    datas.add(data);
                }
            }
        }
        return datas;
    }

    protected Map<Long,String> getOrgsMap(Map<String,Object> dataMap){
        OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
        //List orgs = null;
        if (orgType == OrgType.zone) {
            ZoneExample zoneExample = new ZoneExample();
            zoneExample.createColumns().hasIdColumn().hasNameColumn();
            //orgs = zoneService.selectByExample(zoneExample);
            return  zoneService.selectByExample(zoneExample).stream().collect(Collectors.toMap(Zone::getId,Zone::getName));
        }else if (orgType == OrgType.gate) {
            GateExample gateExample = new GateExample();
            gateExample.createColumns().hasIdColumn().hasNameColumn();
            return gateService.selectByExample(gateExample).stream().collect(Collectors.toMap(Gate::getId,Gate::getName));
        }else if (orgType == OrgType.floor) {
            FloorExample floorExample = new FloorExample();
            floorExample.createColumns().hasIdColumn().hasNameColumn();
            return floorService.selectByExample(floorExample).stream().collect(Collectors.toMap(Floor::getId,Floor::getName));
        }else if (orgType == OrgType.mall) {
            MallExample mallExample = new MallExample();
            mallExample.createColumns().hasIdColumn().hasNameColumn();
            return mallService.selectByExample(mallExample).stream().collect(Collectors.toMap(Mall::getId,Mall::getName));
        }else {
            return null;
        }
    }
}
