package com.viontech.mall.report.service.adapter;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 动线图报表实现类
 */
public interface MovingLineReportService {
    /**
     * 获取楼层的动线数据
     * @param floorId
     * @param startDate
     * @param endDate
     * @return
     */
    public Object zoneMovingLineData(Long floorId, Date startDate,Date endDate, Map<String, Object> dataMap);


    /**
     * 顾客动线
     * @param personUnid
     * @param startDate
     * @param endDate
     * @param dataMap
     * @return
     */
    public Object customerMavingLine(String personUnid,Date startDate,Date endDate, Map<String, Object> dataMap);

    /**
     * 顾客路线轨迹分析
     * @param gender
     * @param ageStage
     * @param startDate
     * @param endDate
     * @param zoneSize
     * @param dataMap
     * @return
     */
    public Object trafficMavingLine(List<Short> gender, List<Short> ageStage, Date startDate, Date endDate, Integer zoneSize, Map<String,Object> dataMap);


    /**
     * 顾客人脸动线
     * @param gender
     * @param ageStage
     * @param startDate
     * @param endDate
     * @param dataMap
     * @return
     */
    public Object zoneFaceMovingLine(List<Short> gender,List<Short> ageStage,Date startDate, Date endDate, Map<String, Object> dataMap);
}
