package com.viontech.mall.report.service.adapter;

import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface MallReportDataService {
	
	/**获取多个商场多个时间点的小时级的客流数据*/
	public List<MallMinuteCountData>  getOrQueryMallInDatesMinTraffic(Long[] mallIds,List<Date> dates,Map<String,Object> dataMap);
	
	/**获取多个商场时间段的小时级的客流数据*/
	public List<MallHourCountData>  getOrQueryMallBetweenDateHourTraffic(Long[] mallIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	/**获取多个商场多个时间点的小时级的客流数据*/
	public List<MallHourCountData>  getOrQueryMallDaysHourTraffic(Long[] mallIds,List<Date> dates,Map<String,Object> dataMap);
	
	/**获取多个商场时间段的天级的客流数据*/
	public List<MallDayCountData> getOrQueryMallBetweenDateDayTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取多个商场时间点的天级的客流数据*/
	public List<MallDayCountData> getOrQueryMallInDatesDayTraffic(Long[] mallIds,List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个商场时间段的天级的销售数据*/
	public List<Sale> getOrQueryMallBetweenDateDaySale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap); 
	/**获取多个商场时间段的天级的销售数据*/
	public List<Sale> getOrQueryMallInDateDaySale(Long[] mallIds, List<Date> dates, Map<String, Object> dataMap); 
	
	
	/**获取多个商场时间段的人脸数据*/
	public List<MallDayFaceRecognitionSta> getOrQueryMallFaceData(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	
	/**根据商场id获取商场的营业时间*/
	public DateCriteria getMallOpentimesByOrgId(Long id,OrgType orgType ,Map<String,Object> dataMap);
	/**根据商场ID获取商场信息*/
	public Mall getMallByMallId(Long mallId,Map<String,Object> dataMap);
	/**根据商场id获取商场所有的店铺数据 */
	public List<Zone> getOrQueryZonesOfMallId(Long mallId, Map<String, Object> dataMap);
	/**根据商场id获取商场店铺id列表*/
	public List<Long> getZoneIdsByMallId(Long mallId, Map<String, Object> dataMap);
	/** 把商场人脸数据转成通用人脸数据类中*/
	public List<FaceVo> convertFace2Data(List<MallDayFaceRecognitionSta> gateFaceDatas);
	/** 把商场的小时客流、天级客流、销售    数据转成通用的数据类*/
	public   <T> List<DataVo> convert2Data(List<T> datas);
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//---------------------------------------------------------以下代码需要修改-----------------------------------------------------------------//
	/**获取楼层近5年 的客流数据*/
	public List<MallDayCountData> getNear5YearMallTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近5年的销售数据  */
	public List<Sale> getNear5YearMallSale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三月 的客流数据         本月  +  上月  + 去年同月*/
	public List<MallDayCountData> getNear3MonthMallTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三月 的销售数据         本月  +  上月  + 去年同月*/
	public List<Sale> getNear3MonthMallSale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	public List<MallDayCountData> getNear3WeekMallTraffic(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三周 的销售数据     本周  +  上周  +上月同周   + 去年同周*/
	public List<Sale> getNear3WeekMallSale(Long[] mallIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期 近15天*/
	public List<MallHourCountData> getMallCurrentDayHourTraffic(Long[] mallIds,Date date,Map<String,Object> dataMap);
	/**获取店铺天级的客流数据   近15天*/
	public List<MallDayCountData> getMallNear15DayTraffic(Long[] mallIds,Date date,Map<String,Object> dataMap);
	/**获取店铺的销售数据  当天   昨天  上周同期     上月同期    上年同期   近15天*/
	public List<Sale> getMallNear15DaySales(Long[] mallIds,Date date,Map<String,Object> dataMap);
	/** 获取店铺近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  */
	public List<MallDayCountData> getOrQueryMallDayTraffic(Long[] mallIds,Date startDate,Date endDate,Map<String,Object> dataMap);


}
