package com.viontech.mall.report.service.adapter;

import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface GateReportDataService {
	/**获取多个监控点时间段的天级的客流数据*/
	public List<GateDayCountData> getOrQueryGateBetweenDateDayTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取多个监控点多个时间点的天级的客流数据*/
	public List<GateDayCountData> getOrQueryGateInDatesDayTraffic(Long[] gateIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个监控点多个时间点的小时客流数据*/
	public List<GateHourCountData>  getOrQueryGateDaysHourData(Long[] gateIds,List<Date> dates,Map<String,Object> dataMap);
	/**获取多个监控点多个时间点的10分钟客流数据*/
	public List<GateMinuteCountData> getOrQueryGateDays10MinData(Long[] gateIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个监控点时间段的人脸数据*/
	public List<GateDayFaceRecognitionSta> getOrQueryGateFaceData(Long[] gateIds, Date startDate, Date endDate, Map<String,Object> dataMap);
	
	/**根据楼层id获取楼层信息*/
	public Gate getGateInfoById(Long gateId,Map<String,Object> dataMap);
	/** 商场营业时间*/
	public DateCriteria getMallOpentimesByOrgId(Long id,OrgType orgType ,Map<String,Object> dataMap);
	/** 把楼层人脸数据转成通用人脸数据类中*/
	public List<FaceVo> convertFace2Data(List<GateDayFaceRecognitionSta> gateFaceDatas);
	/** 把楼层的小时客流、天级客流、销售    数据转成通用的数据类*/
	public  <T> List<DataVo> convert2Data(List<T> datas);
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//-----------------------------------------------------需要修改的代码--------------------------------------------------------------------//
	/**获取店铺近5年的客流数据  */
	public List<GateDayCountData> getNear5YearGateTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取店铺近三月 的客流数据     本月  +  上月      + 去年同月  */
	public List<GateDayCountData> getNear3MonthGateTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取监控点近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	public List<GateDayCountData> getNear3WeekGateTraffic(Long gateId, Date startDate, Date endDate, Map<String, Object> dataMap);
	public List<GateDayCountData> getNear3WeekGateTraffic(Long[] gateIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取监控点的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期 （当天）*/
	public List<GateHourCountData> getGateCurrentDayHourTraffic(Long gateId,Date date,Map<String,Object> dataMap);
	public List<GateHourCountData> getGateCurrentDayHourTraffic(Long[] gateIds,Date date,Map<String,Object> dataMap);
	/**获取监控点天级的客流数据   当天+ 上周同期 + 上月同期+ 上年同期  近15天*/
	public List<GateDayCountData> getGateNear15DayTraffic(Long gateId,Date date,Map<String,Object> dataMap);
	public List<GateDayCountData> getGateNear15DayTraffic(Long[] gateIds,Date date,Map<String,Object> dataMap);
	/** 获取监控点近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  */
	public List<GateDayCountData> getOrQueryGateDayTraffic(Long gateId,Date startDate,Date endDate,Map<String,Object> dataMap);
	public List<GateDayCountData> getOrQueryGateDayTraffic(Long[] gateIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	/**获取监控点小时级的客流数据     近n天的数据+上周同期+上月同期+上年同期*/
	public List<GateHourCountData>  getOrQueryGateHourData(Long gateId,Date startDate,Date endDate,Map<String,Object> dataMap);
	public List<GateHourCountData>  getOrQueryGateHourData(Long[] gateIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	
	
}
