package com.viontech.mall.report.service.adapter;

import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.FaceVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface FloorReportDataService {
	
	/**获取多个楼层时间段的天级的客流数据*/
	List<FloorDayCountData> getOrQueryFloorBetweenDateDayTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取多个楼层时间点的天级的客流数据*/
	public List<FloorDayCountData> getOrQueryFloorInDatesDayTraffic(Long[] floorIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个楼层时间段的天级的销售数据*/
	public List<Sale> getOrQueryFloorBetweenDateDaySale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取多个楼层时间点的天级的销售数据*/
	public List<Sale> getOrQueryFloorInDateDaySale(Long[] floorIds, List<Date> dates, Map<String, Object> dataMap);
	
	/**获取多个楼层时间段的小时级的客流数据*/
	public List<FloorHourCountData>  getOrQueryFloorBetweenDateHourTraffic(Long[] floorIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	/**获取多个楼层时间 点的小时级的客流数据*/
	public List<FloorHourCountData>  getOrQueryFloorInDatesHourTraffic(Long[] floorIds,List<Date> dates,Map<String,Object> dataMap);
	
	
	/**获取多个楼层多个时间点的10分钟级的客流数据*/
	public List<FloorMinuteCountData> getOrQueryFloorInDatesMinTraffic(Long[] floorIds, List<Date> dates, Map<String, Object> dataMap);

	
	/**获取店铺的人脸数据*/
	public List<FloorDayFaceRecognitionSta> getOrQueryFloorDayFaceRecognitionStas(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	
	
	/**根据楼层id获取楼层信息*/
	public Floor getFloorInfoById(Long floorId,Map<String,Object> dataMap);
	/**
	 * 根据楼层id获取该楼层的所有店铺
	 * @param floorId
	 * @param dataMap
	 * @return
	 */
	public List<Zone> getZoneOfFloor(Long floorId,Map<String,Object> dataMap);
	/** 商场营业时间*/
	public DateCriteria getMallOpentimesByOrgId(Long id,OrgType orgType ,Map<String,Object> dataMap);
	/** 把楼层人脸数据转成通用人脸数据类中*/
	public List<FaceVo> convertFace2Data(List<FloorDayFaceRecognitionSta> floorFaceDatas);
	/** 把楼层的小时客流、天级客流、销售    数据转成通用的数据类*/
	public   <T> List<DataVo> convert2Data(List<T> datas);
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//-----------------------------------------------------以下代码修改修改-------------------------------------------------------------------------------//
	
	/**获取楼层近5年的销售数据*/
	public List<Sale> getNear5YearFloorSale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近5年 的客流数据*/
	public List<FloorDayCountData> getNear5YearFloorTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三月 的销售数据        本月  +  上月  + 去年同月*/
	public List<Sale> getNear3MonthFloorSale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三月  的客流数据         本月  +  上月  + 去年同月*/
	public List<FloorDayCountData> getNear3MonthFloorTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三周 的销售数据     本周  +  上周  +上月同周   + 去年同周*/
	public List<Sale> getNear3WeekFloorSale(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层近三周 的客流数据     本周  +  上周  +上月同周   + 去年同周*/
	public List<FloorDayCountData> getNear3WeekFloorTraffic(Long[] floorIds, Date startDate, Date endDate, Map<String, Object> dataMap);
	/**获取楼层的小时级客流数据  当天   昨天  上周同期     上月同期    上年同期 近15天*/
	public List<FloorHourCountData> getFloorNearCurrentDayHourTraffic(Long[] floorIds,Date date,Map<String,Object> dataMap);
	/**获取楼层天级的客流数据   近15天*/
	public List<FloorDayCountData> getFloorNear15DayTraffic(Long[] floorIds,Date date,Map<String,Object> dataMap);
	/**获取楼层的销售数据  当天   昨天  上周同期     上月同期    上年同期   近15天*/
	public List<Sale> getFloorNear15DaySales(Long[] floorIds,Date date,Map<String,Object> dataMap);
	/** 获取楼层近段日期       所有的日期的  当天+ 上周同期 + 上月同期+ 上年同期的客流数据  */
	public List<FloorDayCountData> getOrQueryFloorDayTraffic(Long[] floorIds,Date startDate,Date endDate,Map<String,Object> dataMap);
	
	
}
