package com.viontech.mall.report.service.adapter;

import com.viontech.keliu.util.DateUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.base.BaseDataServiceImpl.DateCriteria;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.service.adapter.FloorService;
import com.viontech.mall.service.adapter.GateService;
import com.viontech.mall.service.adapter.MallOpentimeService;
import com.viontech.mall.service.adapter.ZoneService;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.*;


public abstract class AbstractReportDataService {
	
	@Resource
	private SaleDataService saleDataService;
	
	@Resource
	private MallOpentimeService mallOpentimeService;
	
	@Resource
	private ZoneService zoneService;
	
	@Resource
	private FloorService floorService;

	@Resource
	private GateService gateService;
	
	
	/**默认查询数据天数 30天*/
	public static  final int PARAM_DEFAULT_BEFOREDAY30 = -29;
	/**默认查询数据天数 15天*/
	public static  final int PARAM_DEFAULT_BEFOREDAY15 = -14;
	/** 商场开业状态 */
	public static final short PARAM_MALL_STATUS_OPEN = 1;
	
	/**人脸数据*/
	public static final String KEY_FACE_DATA = "faceData";
	/**商场营业时间*/
	public static final String KEY_MALL_OPENTIME = "mallOpenTime";
	/**10分钟级客流数据 */
	public static final String 	KEY_10MINUTE_TRAFFIC = 	"10MinuteTraffic";
	
	/**业态     客流量（小时级）*/
	public static final String KEY_FORMAT_HOUR_TRAFFIC = "formatHourTraffic";
	/**业态    客流数据（天级）*/
	public static final String KEY_FORMAT_DAY_TRAFFIC = "formatDayTraffic";
	/**业态    销售额(天级)*/
	public static final String KEY_FORMAT_DAY_SALE = "formatDaySale";

	/**监控点    客流量（小时级）*/
	public static final String KEY_GATE_HOUR_TRAFFIC = "gateHourTraffic";
	/**监控点    客流数据（天级）*/
	public static final String KEY_GATE_DAY_TRAFFIC = "gateDayTraffic";
	
	/**店铺     客流量（小时级）*/
	public static final String KEY_ZONE_HOUR_TRAFFIC = "zoneHourTraffic";
	/**店铺客流数据（天级）*/
	public static final String KEY_ZONE_DAY_TRAFFIC = "zoneDayTraffic";
	/**店铺销售额(天级)*/
	public static final String KEY_ZONE_DAY_SALE = "zoneDaySale";
	
	/**楼层     客流量（小时级）*/
	public static final String KEY_FLOOR_HOUR_TRAFFIC = "floorHourTraffic";
	/**楼层  	客流数据（天级）*/
	public static final String KEY_FLOOR_DAY_TRAFFIC = "floorDayTraffic";
	/**楼层	销售额(天级)*/
	public static final String KEY_FLOOR_DAY_SALE = "floorDaySale";
	
	/**商场     客流量（小时级）*/
	public static final String KEY_MALL_HOUR_TRAFFIC = "mallHourTraffic";
	/**商场  	客流数据（天级）*/
	public static final String KEY_MALL_DAY_TRAFFIC = "mallDayTraffic";
	/**商场	销售额(天级)*/
	public static final String KEY_MALL_DAY_SALE = "mallDaySale";
	
	/**商场基本信息*/
	public static final String KEY_MALL_INFO = "mallInfo";
	/**商场所有的店铺*/
	public static final String KEY_ZONE_OF_MALL = "zonesOfMall";
	/**楼层基本信息*/
	public static final String KEY_FLOOR_INFO = "floorInfo";
	/**楼层所有的店铺*/
	public static final String KEY_ZONE_OF_FLOOR = "zonesOfFloor";
	/**店铺基本信息*/
	public static final String KEY_ZONE_INFO = "zoneInfo";
	/**监控点信息*/
	public static final String KEY_GATES = "gateData";
	/**业态    店铺列表*/
	public static final String KEY_FORMAT_ZONES = "formatZones";
	
	/**
	 * 获取销售数据
	 * @param orgIds
	 * @param dates
	 * @param dataMap
	 * @return
	 */
	public List<Sale> querySalesByDatesAndOrgIds(Long[] orgIds,List<Date> dates ,Map<String,Object> dataMap){
		List<Sale> sales = new ArrayList<Sale>();
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		sales = saleDataService.getDayData(dates, Arrays.asList(orgIds), orgType);
		return sales;
	}
	
	/** 商场营业时间*/
	public DateCriteria getMallOpentimesByOrgId(Long id,OrgType orgType ,Map<String,Object> dataMap){
		DateCriteria dateCriteria = (DateCriteria) dataMap.get(KEY_MALL_OPENTIME);
		if(orgType == null)
			orgType = (OrgType) dataMap.get("ORGTYPE");

		if (dateCriteria == null) {
			Date currentDate = (Date) dataMap.get("currentDate");
			if (currentDate == null) {
				currentDate = new Date();
			}
			Date timeMin = null;
			Date timeMax = null;
			
			String yyyyMMdd = DateUtil.format(DateUtil.FORMAT_SHORT,currentDate);
			String startTime = "00:00:00";
			String endTime = "00:00:00";
			
			dateCriteria = new DateCriteria();
			Long mallId = null;
			if (orgType == OrgType.zone) {
				Zone zone = zoneService.selectByPrimaryKey(id);
				mallId = zone.getMallId();
			}else if (orgType == OrgType.floor) {
				Floor floor = floorService.selectByPrimaryKey(id);
				mallId = floor.getMallId();
			}else if (orgType == OrgType.mall) {
				mallId = id;
			}else if (orgType == OrgType.gate) {
				Gate gate = gateService.selectByPrimaryKey(id);
				mallId = gate.getMallId();
			}
			
			if (mallId!= null) {
				MallOpentimeExample example = new MallOpentimeExample();
				example.createColumns();
				example.createCriteria().andMallIdEqualTo(mallId);
				List<MallOpentime> mallOpentimes = mallOpentimeService.selectByExample(example);
				if (mallOpentimes != null &&  mallOpentimes.size() > 0) {
					MallOpentime mallOpentime = mallOpentimes.get(0);
					timeMin = mallOpentime.getStartTime();
					timeMax = mallOpentime.getEndTime();
					startTime = DateUtil.format(DateUtil.FORMAT_HHMM, timeMin);
					endTime = DateUtil.format(DateUtil.FORMAT_HHMM, timeMax);
				}
				
			}

			try {
				timeMin = DateUtil.parse("yyyy-MM-dd HH:mm",yyyyMMdd+" "+startTime);
				timeMax = DateUtil.parse("yyyy-MM-dd HH:mm", yyyyMMdd+" "+endTime);
			} catch (ParseException e) {
				e.printStackTrace();
			}

			dateCriteria.setStartDate(timeMin);
			if (DateUtil.compareDate(timeMin,timeMax) >= 0) {
				Date endDate = DateUtil.addHours(timeMax, 24);
				//endDate = DateUtil.addMilliseconds(endDate, -1);
				dateCriteria.setEndDate(endDate);
			}else
				dateCriteria.setEndDate(timeMax);
			dataMap.put(KEY_MALL_OPENTIME,dateCriteria);
		}
		
		return dateCriteria;
	}


	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	//--------------------------------------------------------------------以后要修改的代码-------------------------------------------------------------------------------------//
	
	/**获取近5年的日期*/
	public List<Date> getNear5YearDates(Date startDate,Date endDate){
		Date near5YearDate = DateUtil.addYears(startDate, -4);
		List<Date> dates = DateUtil.getDaysBetweenDates(near5YearDate, endDate);
		return dates;
	}
	
	/**获取近3月的日期  当月+上月+去年同月*/
	public Set<Date> getNear3MonthDates(Date startDate,Date endDate){
		Set<Date> dates = new HashSet<Date>();
		Date startFromDate = DateUtil.addMonths(startDate, -3);
		List<Date> betweenDaysList = DateUtil.getDaysBetweenDates(startFromDate, endDate);
		dates.addAll(betweenDaysList);
		for (Date date : betweenDaysList) {
			Date lastYearDate = DateUtil.addYears(date, -1);
			dates.add(lastYearDate);
		}
		return dates;
	}

	/**获取近3月的日期  */
	public Set<Date> getNear6MonthDates(Date startDate,Date endDate){
		Set<Date> dates = new HashSet<Date>();
		Date startFromDate = DateUtil.addMonths(startDate, -6);
		List<Date> betweenDaysList = DateUtil.getDaysBetweenDates(startFromDate, endDate);
		dates.addAll(betweenDaysList);
		for (Date date : betweenDaysList) {
			Date lastYearDate = DateUtil.addYears(date, -1);
			dates.add(lastYearDate);
		}
		return dates;
	}

	/**获取指定日期的   当天   昨天  上周同期     上月同期    上年同期  **/
	public Set<Date> getComparedDates(Date startDate ,Date endDate){
		List betweenDaysList = DateUtil.getDaysBetweenDates(startDate, endDate);
		Set<Date> dates = new HashSet();
		for (Iterator iterator = betweenDaysList.iterator(); iterator.hasNext();) {
			Date date = (Date) iterator.next();
			dates.add(date);
			Date yesterday = DateUtil.getYesterday(date);
			dates.add(yesterday);
			Date lastWeekDay = DateUtil.getLastWeek(date);
			dates.add(lastWeekDay);
			Date lastMontdDay = DateUtil.getLastMonth(date);
			dates.add(lastMontdDay);
			Date lastYearDay = DateUtil.getLastYear(date);
			dates.add(lastYearDay);
		}
		return dates;
	}
	
	
	/**
	 * 获取近3周的      本周 + 上周 + 本周上月同期+上年同周   的所有日期
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	public  Set<Date> get3WeekDates(Date startDate,Date endDate){
		Set<Date> dates = new HashSet<Date>();
		//先获取近3周的日期
			//本周
		List<Date> thisWeek = DateUtil.getDaysBetweenDates(startDate, endDate);
		dates.addAll(thisWeek);
			//上周
		Date lastWeekStartDate = DateUtil.getLastWeek(startDate);
		Date lastWeekEndDate = DateUtil.getLastWeek(endDate);
		List<Date> lastWeek = DateUtil.getDaysBetweenDates(lastWeekStartDate, lastWeekEndDate);
		dates.addAll(lastWeek);
			//上上周
		Date beforeLastStartDate = DateUtil.getLastWeek(lastWeekStartDate);
		Date beforeLastEndDate = DateUtil.getLastWeek(lastWeekEndDate);
		List<Date> beforeLastWeek = DateUtil.getDaysBetweenDates(beforeLastStartDate, beforeLastEndDate);
		dates.addAll(beforeLastWeek);
		
		//再获取近三周的上周同期
			//只需要再取 “上上周” 的 “上周”  数据就能全部获取
		Date weekOfbeforeLastStartDate = DateUtil.getLastWeek(beforeLastStartDate);
		Date weekOfbeforeLastEndDate = DateUtil.getLastWeek(beforeLastEndDate);
		List<Date> weekOfbeforeLast = DateUtil.getDaysBetweenDates(weekOfbeforeLastStartDate, weekOfbeforeLastEndDate);
		dates.addAll(weekOfbeforeLast);
		
		//获取本周上月同期
		Date lastMonthStartDate = DateUtil.getLastMonth(startDate);
		Date lastMonthEndDate = DateUtil.getLastMonth(endDate);
		List<Date> lastMonth = DateUtil.getDaysBetweenDates(lastMonthStartDate, lastMonthEndDate);
		dates.addAll(lastMonth);
		
		//最后获取近三周的去年同期
			//本周去年同期
		Date lastYearthisWeekStartDate = DateUtil.getLastYear(startDate);
		Date lastYearthisWeekEnDate = DateUtil.getLastYear(endDate);
		List<Date> lastYearOfThisWeek = DateUtil.getDaysBetweenDates(lastYearthisWeekStartDate, lastYearthisWeekEnDate);
		dates.addAll(lastYearOfThisWeek);
		//上周去年同期
		Date lastYearOflastWeekStartDate = DateUtil.getLastWeek(lastWeekStartDate);
		Date lastYearOflastWeekEndDate = DateUtil.getLastWeek(lastWeekEndDate);
		List<Date> lastYearOflastWeek = DateUtil.getDaysBetweenDates(lastYearOflastWeekStartDate, lastYearOflastWeekEndDate);
		dates.addAll(lastYearOflastWeek);
			//上上周去年同期
		Date beforeLastYearStartDate = DateUtil.getLastWeek(lastYearOflastWeekStartDate);
		Date beforeLastYearEndDate = DateUtil.getLastWeek(lastYearOflastWeekEndDate);
		List<Date> beforeLastWeekOfLastYear = DateUtil.getDaysBetweenDates(beforeLastYearStartDate, beforeLastYearEndDate);
		dates.addAll(beforeLastWeekOfLastYear);	
		
		return dates;
	}


	/**
	 * 获取近8周的      本周 + 上周 + 本周上月同期+上年同周   的所有日期
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	public  Set<Date> get8WeekDates(Date startDate,Date endDate){
		Set<Date> dates = new HashSet<Date>();
		//先获取近3周的日期
		//本周
		Date thisWeekEndDate = DateUtil.getSundayOfWeek(endDate);
		List<Date> thisWeek = DateUtil.getDaysBetweenDates(startDate, thisWeekEndDate);
		dates.addAll(thisWeek);
		//上周
		Date lastWeekStartDate = DateUtil.getLastWeek(startDate);
		Date lastWeekEndDate = DateUtil.getLastWeek(thisWeekEndDate);
		List<Date> lastWeek = DateUtil.getDaysBetweenDates(lastWeekStartDate, lastWeekEndDate);
		dates.addAll(lastWeek);
		//上上周
		Date beforeLastStartDate = DateUtil.getLastWeek(lastWeekStartDate);
		Date beforeLastEndDate = DateUtil.getLastWeek(lastWeekEndDate);
		List<Date> beforeLastWeek = DateUtil.getDaysBetweenDates(beforeLastStartDate, beforeLastEndDate);
		dates.addAll(beforeLastWeek);

		//前4周
		Date last4StartDate = DateUtil.getLastWeek(beforeLastStartDate);
		Date last4EndDate = DateUtil.getLastWeek(beforeLastEndDate);
		List<Date> last4WeekList = DateUtil.getDaysBetweenDates(last4StartDate, last4EndDate);
		dates.addAll(last4WeekList);
		//前5周
		Date last5StartDate = DateUtil.getLastWeek(last4StartDate);
		Date last5EndDate = DateUtil.getLastWeek(last4EndDate);
		List<Date> last5WeekList = DateUtil.getDaysBetweenDates(last5StartDate, last5EndDate);
		dates.addAll(last5WeekList);

		//前6周
		Date last6StartDate = DateUtil.getLastWeek(last5StartDate);
		Date last6EndDate = DateUtil.getLastWeek(last5EndDate);
		List<Date> last6WeekList = DateUtil.getDaysBetweenDates(last6StartDate, last6EndDate);
		dates.addAll(last6WeekList);

		//前7周
		Date last7StartDate = DateUtil.getLastWeek(last6StartDate);
		Date last7EndDate = DateUtil.getLastWeek(last6EndDate);
		List<Date> last7WeekList = DateUtil.getDaysBetweenDates(last7StartDate, last7EndDate);
		dates.addAll(last7WeekList);

		//前8周
		Date last8StartDate = DateUtil.getLastWeek(last7StartDate);
		Date last8EndDate = DateUtil.getLastWeek(last7EndDate);
		List<Date> last8WeekList = DateUtil.getDaysBetweenDates(last8StartDate, last8EndDate);
		dates.addAll(last8WeekList);

		//前9周
		Date last9StartDate = DateUtil.getLastWeek(last8StartDate);
		Date last9EndDate = DateUtil.getLastWeek(last8EndDate);
		List<Date> last9WeekList = DateUtil.getDaysBetweenDates(last9StartDate, last9EndDate);
		dates.addAll(last9WeekList);

		//前10周
		Date last10StartDate = DateUtil.getLastWeek(last9StartDate);
		Date last10EndDate = DateUtil.getLastWeek(last9EndDate);
		List<Date> last10WeekList = DateUtil.getDaysBetweenDates(last10StartDate, last10EndDate);
		dates.addAll(last10WeekList);

		//前11周
		Date last11StartDate = DateUtil.getLastWeek(last10StartDate);
		Date last11EndDate = DateUtil.getLastWeek(last10EndDate);
		List<Date> last11WeekList = DateUtil.getDaysBetweenDates(last11StartDate, last11EndDate);
		dates.addAll(last11WeekList);

		//前12周
		Date last12StartDate = DateUtil.getLastWeek(last11StartDate);
		Date last12EndDate = DateUtil.getLastWeek(last11EndDate);
		List<Date> last12WeekList = DateUtil.getDaysBetweenDates(last12StartDate, last12EndDate);
		dates.addAll(last12WeekList);

		//再获取近三周的上周同期
		//只需要再取 “上上周” 的 “上周”  数据就能全部获取
//		Date weekOfbeforeLastStartDate = DateUtil.getLastWeek(beforeLastStartDate);
//		Date weekOfbeforeLastEndDate = DateUtil.getLastWeek(beforeLastEndDate);
//		List<Date> weekOfbeforeLast = DateUtil.getDaysBetweenDates(weekOfbeforeLastStartDate, weekOfbeforeLastEndDate);
//		dates.addAll(weekOfbeforeLast);

		//获取本周上月同期
		Date lastMonthStartDate = DateUtil.getLastMonth(startDate);
		Date lastMonthEndDate = DateUtil.getLastMonth(endDate);
		List<Date> lastMonth = DateUtil.getDaysBetweenDates(lastMonthStartDate, lastMonthEndDate);
		dates.addAll(lastMonth);

		//最后获取近三周的去年同期
		//本周去年同期
//		Date lastYearthisWeekStartDate = DateUtil.getLastYear(startDate);
//		Date lastYearthisWeekEnDate = DateUtil.getLastYear(endDate);
//		List<Date> lastYearOfThisWeek = DateUtil.getDaysBetweenDates(lastYearthisWeekStartDate, lastYearthisWeekEnDate);
//		dates.addAll(lastYearOfThisWeek);
//		//上周去年同期
//		Date lastYearOflastWeekStartDate = DateUtil.getLastWeek(lastWeekStartDate);
//		Date lastYearOflastWeekEndDate = DateUtil.getLastWeek(lastWeekEndDate);
//		List<Date> lastYearOflastWeek = DateUtil.getDaysBetweenDates(lastYearOflastWeekStartDate, lastYearOflastWeekEndDate);
//		dates.addAll(lastYearOflastWeek);
//		//上上周去年同期
//		Date beforeLastYearStartDate = DateUtil.getLastWeek(lastYearOflastWeekStartDate);
//		Date beforeLastYearEndDate = DateUtil.getLastWeek(lastYearOflastWeekEndDate);
//		List<Date> beforeLastWeekOfLastYear = DateUtil.getDaysBetweenDates(beforeLastYearStartDate, beforeLastYearEndDate);
//		dates.addAll(beforeLastWeekOfLastYear);

		//8周的去年同期
		Date lastYearStartDate = DateUtil.getLastYear(last8StartDate);
		Date lastYearEndDate = DateUtil.getLastYear(endDate);
		List<Date> lastYearWeekList = DateUtil.getDaysBetweenDates(lastYearStartDate, lastYearEndDate);
		dates.addAll(lastYearWeekList);

		return dates;
	}
}
