package com.viontech.mall.report.enums;

import static com.viontech.keliu.i18n.util.LocalMessageUtil.getMessage;

public enum KPIType {
	TRAFFIC("traffic"),//客流量
	ORDER("order"),//成交量
	HANDBAGRATE("handbagRate"),//提袋率
	PREPRICE("preprice"),//客单价
	PERAREAVALUE("perAreaValue"),//坪效
	ENTERINGRATE("enteringRate"),//进店率
	DURATIONTIME("durationTime"),//滞留时间
	DURATIONNUM("durationNum"),//滞留量
	DEPTH("depth"),//游逛深度
	SALES("sales"),//销售额
	INNUM("inNum"),//进客流
	OUTNUM("outNum"),//出客流
	ZONENUM("zoneNum"),//店铺数量
	EFFECTIVETRAFFIC("effectiveTraffic"),//有效客流
	PASSTRAFFIC("passTraffic");//店外总客流
	
	
	private String nameCode;
	
	private KPIType(String nameCode) {
		this.nameCode = nameCode;
	}

	@Override
	public String toString() {
		return getMessage(this.nameCode,KPIType.class);
	}

	public String getName() {
		return getMessage(this.nameCode,KPIType.class);
	}
}
