package com.viontech.mall.report.enums;

import com.viontech.keliu.util.DateUtil;

import java.util.Date;

import static com.viontech.keliu.i18n.util.LocalMessageUtil.getMessage;
import static com.viontech.keliu.util.DateUtil.*;


public enum DateType {
	MINUTE("minute"),
	HOUR("hour"),
	DAY("day"),
	TODAY("today"),
	YESTERDAY("yesterday"),
	LASTWEEKDAY("lastWeekDay"),
	LASTMONTHDAY("lastMonthDay"),
	LASTYEARDAY("lastYearDay"),
	WEEK("week"),
	LASTWEEK("lastWeek"),
	LASTYEARWEEK("lastYearWeek"),
	MONTH("month"),
	LASTMONTH("lastMonth"),
	LASTYEARMONTH("lastYearMonth"),
	BEFORELASTYEARMONTH("beforeLastYearMonth"),
	YEAR("year"),
	LASTYEAR("lastYear"),
	BEFORELASTYEAR("beforeLastYear"),
	SEASON("season"),
	LASTSEASON("lastSeason"),
	ANNUALLY("annually"),
	FIRSTWEEK("firstWeek"),
	SECONDWEEK("secondWeek"),
	THIRDWEEK("thirdWeek"),
	FOURTHWEEK("fourthWeek"),
	FIFTHWEEK("fifthWeek"),
	SIXTHWEEK("sixthWeek"),
	WEEKDAY("weekday"),
	WEEKEND("weekend"),
	NONE("none"),
	LASTFOURWEEK("lastFourWeek");
	private String nameCode;
	private DateType(String nameCode) {
		this.nameCode = nameCode;
	}

	@Override
	public String toString() {
		return getMessage(this.nameCode,DateType.class);
	}

	public String getName() {
		return getMessage(this.nameCode,DateType.class);
	}
	
	public final static DateType valueOfWeekDay(Date date){
		if(getDayOfWeek(date)>5){
			return WEEKEND;
		}else {
			return WEEKDAY;
		}
	}
	
	public final static DateType valueOfDay(Date today,Date date){
		if(isSameDay(today, date)){
			return TODAY;
		}else if(isYesterday(today,date)){
			return YESTERDAY;
		}else if (isLastWeekDay(today, date)) {
			return LASTWEEKDAY;
		}else if(isLastMonthDay(today, date)){
			return LASTMONTHDAY;
		}else if(isLastYearDay(today,date)){
			return LASTYEARDAY;
		}else{
			return NONE;
		}
	}
	
	public final static DateType valueOfWeekInMonth(Date date){
		int weekIndex = getWeekOfMonth(date);
		DateType dateType = null;
		switch (weekIndex) {
		case 1:
			dateType = FIRSTWEEK;
			break;
		case 2:
			dateType = SECONDWEEK;
			break;
		case 3:
			dateType = THIRDWEEK;
			break;
		case 4:
			dateType = FOURTHWEEK;
			break;
		case 5:
			dateType = FIFTHWEEK;
			break;
		case 6:
			dateType = SIXTHWEEK;
			break;
		default:
			dateType = NONE;
			break;
		}
		return dateType;
	}
	
	public final static DateType valueOfMonth(Date month,Date otherMonth){
		if(isSameMonth(month, otherMonth)){
			return MONTH;
		}else if(isLastMonth(month,otherMonth)){
			return LASTMONTH;
		}else if (isLastYearMonth(month, otherMonth)) {
			return LASTYEARMONTH;
		}else if (isSameMonth(DateUtil.addYears(month, -2), otherMonth)) {
			return BEFORELASTYEARMONTH;
		}else{
			return NONE;
		}
	}
	public final static DateType valueOfWeek(Date week,Date otherWeek){
		if(isSameWeek(week, otherWeek)){
			return WEEK;
		}else if(isLastWeek(week,otherWeek)){
			return LASTWEEK;
		}else if(isLastYearWeek(week,otherWeek)){
			return LASTYEARWEEK;
		}else if(isInLastFourWeek(week,otherWeek)){
			return LASTFOURWEEK;
		}else{
			return NONE;
		}
	}
	private static boolean isInLastFourWeek(Date date1,Date date2){
		Date lastFourStartDate = DateUtil.addDays(date1,-27);
		if(DateUtil.compareDate(date2,lastFourStartDate)!=-1 && DateUtil.compareDate(date2,date1) == -1){
			return true;
		}else{
			return false;
		}
	}
	public final static DateType valueOfSeason(Date month,Date otherMonth){
		if(isSameSeason(month, otherMonth)){
			return SEASON;
		}else if(isLastSeason(month, otherMonth)){
			return LASTSEASON;
		}else{
			return NONE;
		}
	}
	public final static DateType valueOfYear(Date month,Date otherMonth){
		if(isSameYear(month, otherMonth)){
			return YEAR;
		}else if(isSameYear(DateUtil.addYears(month, -1), otherMonth)){
			return LASTYEAR;
		}else if(isSameYear(DateUtil.addYears(month, -2), otherMonth)){
			return BEFORELASTYEAR;
		}else{
			return NONE;
		}
	}
	
}
