package com.viontech.mall.report.controller;

import com.viontech.mall.report.base.ChartReportBaseController;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.AccountDataService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;


@Controller
@RequestMapping("/report/year/{orgType}")
public class YearReportController extends ChartReportBaseController {
	
	@Resource(name="accountYearReportServiceImpl")
	private ChartReportBaseService accountYearReportServiceImpl;
	
	@Resource(name="mallYearReportServiceImpl")
	private ChartReportBaseService mallYearReportServiceImpl;
	
	@Resource(name="floorYearReportServiceImpl")
	private ChartReportBaseService floorYearReportServiceImpl;
	
	@Resource(name = "zoneYearReportServiceImpl")
	private ChartReportBaseService zoneYearReportServiceImpl;
	
	@Resource
	private AccountDataService accountDataService;
	
	@Override
	public ChartReportBaseService getReportService(OrgType orgType) {
		switch (orgType) {
			case account :
				return accountYearReportServiceImpl;
			case mall :
				return mallYearReportServiceImpl;
			case floor :
				return floorYearReportServiceImpl;
			case zone :
				return zoneYearReportServiceImpl;
			default :
				break;
		}
		return null;
	}
}
