package com.viontech.mall.report.controller;

import com.viontech.mall.report.base.ChartReportBaseController;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.AccountDataService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;

@Controller
@RequestMapping("/report/week/{orgType}")
public class WeekReportController extends ChartReportBaseController{
	
	@Resource(name="accountWeekReportServiceImpl")
	private ChartReportBaseService accountWeekReportServiceImpl;
	
	@Resource(name="mallWeekReportServiceImpl")
	private ChartReportBaseService mallWeekReportServiceImpl;
	
	@Resource(name="floorWeekReportServiceImpl")
	private ChartReportBaseService floorWeekReportServiceImpl;
	
	@Resource(name = "zoneWeekReportServiceImpl")
	private ChartReportBaseService zoneWeekReportServiceImpl;
	
	@Resource
	private AccountDataService accountDataService;

	@Override
	public ChartReportBaseService getReportService(OrgType orgType) {
		switch (orgType) {
		case account:
			return accountWeekReportServiceImpl;
		case mall :
			return mallWeekReportServiceImpl;
		case floor :
			return floorWeekReportServiceImpl;
		case zone :
			return zoneWeekReportServiceImpl;
		default:
			break;
		}
		return null;
	}

}
