package com.viontech.mall.report.controller;

import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.ParamModel;
import com.viontech.mall.report.service.adapter.MovingLineReportService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.*;

@Controller
@RequestMapping("/report/movingLine")
public class MovingLineChart {

    @Resource
    private MovingLineReportService mavingLineService;

    @GetMapping("/{orgType}")
    @ResponseBody
    public Object report(@PathVariable OrgType orgType,ParamModel params) {
        Map<String,Object> dataMap = new HashMap<String, Object>();
        dataMap.put("ORGTYPE",orgType);
        Long orgId = params.getOrgIds()[0];
        Object result = mavingLineService.zoneMovingLineData(orgId, params.getStartDate(), params.getEndDate(),dataMap);
        return JsonMessageUtil.getSuccessJsonMsg(result);
    }
    @GetMapping("/customerLine/{personUnid}")
    @ResponseBody
    public Object customerMovingLine(@PathVariable String personUnid,ParamModel params){
        Map<String,Object> dataMap = new HashMap<String, Object>();
        Long[] orgIds = Optional.ofNullable(params.getOrgIds()).orElse(new Long[]{0L});
        dataMap.put("ORGID", orgIds[0]) ;
        OrgType orgType = params.getOrgType();
        dataMap.put("ORGTYPE",orgType);
        Date startDate =params.getStartDate();
        Optional.ofNullable(startDate).orElse(new Date());
        startDate = DateUtil.setDayMinTime(startDate);
        Date endDate = params.getEndDate();
        Optional.ofNullable(endDate).orElse(new Date());
        endDate = DateUtil.setDayMinTime(endDate);
        return mavingLineService.customerMavingLine(personUnid, startDate, endDate,dataMap);
    }

    @RequestMapping("/faceMavingLines")
    @ResponseBody
    public Object faceMavingLines(ParamModel params,@RequestParam List<Long> zoneIds){
        Map<String,Object> dataMap = new HashMap<String, Object>();
        Long[] orgIds = Optional.ofNullable(params.getOrgIds()).orElse(new Long[]{0L});
        dataMap.put("ORGID", orgIds) ;
        OrgType orgType = params.getOrgType();
        dataMap.put("ORGTYPE",orgType);
        Date startDate =params.getStartDate();
        Optional.ofNullable(startDate).orElse(new Date());
        startDate = DateUtil.setDayMinTime(startDate);
        Date endDate = params.getEndDate();
        Optional.ofNullable(endDate).orElse(new Date());
        endDate = DateUtil.setDayMinTime(endDate);
        //性别
        List<Short> gender = params.getGender();
        //年龄
        List<String> ageStage = params.getAgeStage();
        List<Short> ageList = new ArrayList<>();
        for (String s : ageStage) {
            String[] ageSplit = s.split("-");
            String minAge = ageSplit[0];
            if (minAge == null || minAge.isEmpty()){
                minAge = "0";
            }
            String maxAge ="";
            if (ageSplit.length > 1)
                maxAge = ageSplit[1];
            if (maxAge == null || maxAge.isEmpty()){
                maxAge = "100";
            }
            Short min_age = Short.parseShort(minAge);
            Short max_age = Short.parseShort(maxAge);
            for (Short i = min_age; i<=max_age; i++){
                ageList.add(i);
            }
        }

        dataMap.put("showZoneIds",zoneIds);
        return mavingLineService.zoneFaceMovingLine(gender,ageList,startDate,endDate,dataMap);
    }

    @RequestMapping("/customerLines")
    @ResponseBody
    public Object customerMovingLine(ParamModel params){
        Map<String,Object> dataMap = new HashMap<String, Object>();
        Long[] orgIds = Optional.ofNullable(params.getOrgIds()).orElse(new Long[]{0L});
        dataMap.put("ORGID", orgIds[0]) ;
        OrgType orgType = params.getOrgType();
        dataMap.put("ORGTYPE",orgType);
        Date startDate =params.getStartDate();
        Optional.ofNullable(startDate).orElse(new Date());
        startDate = DateUtil.setDayMinTime(startDate);
        Date endDate = params.getEndDate();
        Optional.ofNullable(endDate).orElse(new Date());
        endDate = DateUtil.setDayMinTime(endDate);
        //性别
        List<Short> gender = params.getGender();
        //年龄
        List<String> ageStage = params.getAgeStage();
        List<Short> ageList = new ArrayList<>();
        for (String s : ageStage) {
            String[] ageSplit = s.split("-");
            String minAge = ageSplit[0];
            if (minAge == null || minAge.isEmpty()){
                minAge = "0";
            }
            String maxAge ="";
            if (ageSplit.length > 1)
                maxAge = ageSplit[1];
            if (maxAge == null || maxAge.isEmpty()){
                maxAge = "100";
            }
            Short min_age = Short.parseShort(minAge);
            Short max_age = Short.parseShort(maxAge);
            for (Short i = min_age; i<=max_age; i++){
                ageList.add(i);
            }
        }
        //区域数量
        Integer zoneSize = params.getZoneSize();

        return mavingLineService.trafficMavingLine(gender,ageList,startDate,endDate,zoneSize,dataMap);
    }
}
