package com.viontech.mall.report.controller;

import com.viontech.mall.report.base.ChartReportBaseController;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.service.adapter.AccountDataService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;

@Controller
@RequestMapping("/report/month/{orgType}")
public class MonthReportController extends ChartReportBaseController{

	@Resource(name = "accountMonthReportServiceImpl")
	private ChartReportBaseService accountMonthReportServiceImpl;
	
	@Resource(name="mallMonthReportServiceImpl")
	private ChartReportBaseService mallMonthReportServiceImpl;
	
	@Resource(name = "floorMonthReportServiceImpl")
	private ChartReportBaseService floorMonthReportServiceImpl;
	
	@Resource(name = "zoneMonthReportServiceImpl")
	private ChartReportBaseService zoneMonthReportServiceImpl;
	
	@Resource
	private AccountDataService accountDataService;
	
	
	
	@Override
	public ChartReportBaseService getReportService(OrgType orgType) {
		switch (orgType) {
			case account :
				return accountMonthReportServiceImpl;
			case mall :
				return mallMonthReportServiceImpl;
			case floor :
				return floorMonthReportServiceImpl;
			case zone :
				return zoneMonthReportServiceImpl;
			default :
				break;
		}
		
		return null;
	}

}
