package com.viontech.mall.report.controller;

import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.ParamModel;
import com.viontech.mall.report.service.adapter.HeatmapChartService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;

@Controller
@RequestMapping("/heatmap")
public class HeatmapChartController  {

    @Resource
    private HeatmapChartService heatmapChartService;

    @RequestMapping("/{orgType}/{param}")
    @ResponseBody
    public Object Heatmap(@PathVariable("orgType") OrgType orgType,@PathVariable("param") Object param,Date startDate,Date endDate){
        Object datas = new ArrayList();
        if (OrgType.floor.equals(orgType)){
            Long orgId = Long.parseLong(param.toString());
            datas = heatmapChartService.getGateHourTraffic(orgId,startDate, endDate);
        }else if (OrgType.zone.equals(orgType) || OrgType.mall.equals(orgType)){
            String channel_serialnum = param.toString();
            datas = heatmapChartService.getHeatmapDataBySerialnum(channel_serialnum,startDate, endDate);
        }
        return JsonMessageUtil.getSuccessJsonMsg("success",datas);
    }

    /**
     * 万达楼层热力图
     * @param floorId
     * @param date
     * @return
     */
    @RequestMapping("/floorHeatmap/{floorId}")
    @ResponseBody
    public Object floorHeatmap(@PathVariable("floorId") Long floorId,ParamModel paramModel){
        return heatmapChartService.getFloorHeatmap(floorId,paramModel);
    }

    @RequestMapping("/zoneHotmap/{orgType}")
    @ResponseBody
    public Object zoneHotmap(@PathVariable("orgType") String orgType, ParamModel paramModel){
        Object result = new Object();
        if (OrgType.mall.toString().equals(orgType)){
            Long[] orgIds = paramModel.getOrgIds();
            if (orgIds == null){
                return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("Message.orgIdIsNull"));
            }
            Long mallId = orgIds[0];
            Date startDate = paramModel.getStartDate();
            if (startDate == null){
                return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("Message.startDateIsNull"));
            }
            Date endDate = paramModel.getEndDate();
            if (endDate == null){
                return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("Message.endDateIsNull"));
            }
            String tab = paramModel.getOption().getTypeValue();
            result = heatmapChartService.getZoneHotmapByFaceForMall(mallId,startDate,endDate,tab);
        }
        return result;
    }

    @RequestMapping("/trackHeatmap/{channelId}")
    @ResponseBody
    public Object zoneCoordinateHeatmap(@PathVariable("channelId") Long channelId, ParamModel paramModel){
        Object result ;
        if (channelId == null){
            return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("通道id不能为空"));
        }
        Date startDate = paramModel.getStartDate();
        if (startDate == null){
            return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("Message.startDateIsNull"));
        }
        Date endDate = paramModel.getEndDate();
        if (endDate == null){
            return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("Message.endDateIsNull"));
        }
        result = heatmapChartService.trackHeatmapByRedis(channelId,startDate,endDate);
        return result;
    }
}
