package com.viontech.mall.report.controller;

import com.viontech.mall.report.base.ChartReportBaseController;
import com.viontech.mall.report.base.ChartReportBaseService;
import com.viontech.mall.report.enums.OrgType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;

@Controller
@RequestMapping("/report/faceAnalyzeSta/{orgType}")
public class FaceAnalyzeStaReportController extends ChartReportBaseController {

    @Resource(name = "faceAnalyzeStaReportServiceImp")
    private ChartReportBaseService faceAnalyzeStaReportServiceImp;

    @Resource(name = "gateFaceAnalyzeStaReportServiceImpl")
    private ChartReportBaseService gateFaceAnalyzeStaReportServiceImp;

    @Override
    public ChartReportBaseService getReportService(OrgType orgType) {
        if(OrgType.mall.equals(orgType)) {
            return faceAnalyzeStaReportServiceImp;
        }else if(OrgType.gate.equals(orgType)){
            return gateFaceAnalyzeStaReportServiceImp;
        }
        return null;

    }
}
