 package com.viontech.mall.report.controller;

 import com.viontech.mall.report.base.ChartReportBaseController;
 import com.viontech.mall.report.base.ChartReportBaseService;
 import com.viontech.mall.report.enums.OrgType;
 import org.springframework.stereotype.Controller;
 import org.springframework.web.bind.annotation.RequestMapping;

 import javax.annotation.Resource;

@Controller
@RequestMapping("/report/day/{orgType}")
public class DayReportController extends ChartReportBaseController{
	
	@Resource(name="accountDayReportServiceImpl")
	private ChartReportBaseService accountDayReportServiceImpl;
	
	@Resource(name="mallDayReportServiceImpl")
	private ChartReportBaseService mallDayReportServiceImpl;
	
	@Resource(name="floorDayReportServiceImpl")
	private ChartReportBaseService floorDayReportServiceImpl;
	
	@Resource(name="zoneDayReportServiceImpl")
	private ChartReportBaseService zoneDayReportServiceImpl;
	
	@Override
	public ChartReportBaseService getReportService(OrgType orgType) {
		switch (orgType) {
			case account:
				return accountDayReportServiceImpl;
			case mall:
				return mallDayReportServiceImpl;
			case floor:
				return floorDayReportServiceImpl;
			case zone:
				return zoneDayReportServiceImpl;
			default:
				break;
		}
		return null;
	}

}
