package com.viontech.mall.report.base;

import com.viontech.mall.model.ReportChart;
import com.viontech.mall.model.ReportChartExample;
import com.viontech.mall.service.adapter.ReportChartService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.util.*;

public abstract class TableReportBaseService {
	
	protected Logger logger = LoggerFactory.getLogger(getClass());
	
	@Resource 
	private ReportChartService reportChartService;

	/*页码*/
	protected int page;
	
	/*每页数据量*/
	protected int pageSize;
	/*排序字段名称*/
	protected String sortName;
	/*排序规则（升序、降序）*/
	protected String sortOrder;
	
	/**
	 * 查询图表
	 * 
	 * @param reportId报表Id
	 * @param storeDivideType店铺分组类型
	 * @param objId查询实体(分组/店铺Id)
	 * @param date查询日期
	 * @return
	 */

	public abstract Object getChart(Long[] orgIds,  Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart);


	/**
	 * 日报(包含表头、各种图表)
	 * 
	 * @param reportId报表Id
	 * @param storeDivideType店铺分组类型
	 * @param objId查询实体(分组/店铺Id)
	 * @param date查询日期
	 * @return
	 */

	public Map<String,Object> getReport(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, Long[] chartIds) {
		Map<String, Object> bodyMap = new HashMap<String, Object>();
		ReportChartExample reportChartExample = new ReportChartExample();
		reportChartExample.createCriteria().andIdIn(Arrays.asList(chartIds));
		List<ReportChart> reportCharts = reportChartService.selectByExample(reportChartExample);
		if(dataMap == null){
			dataMap = new HashMap<String, Object>();
		}
		for (ReportChart reportChart : reportCharts) {
			Object chart = getChart(orgIds, startDate, endDate, dataMap, reportChart);
			bodyMap.put(reportChart.getKey(), chart);
		}
		return bodyMap;
	}
	
	public static boolean isNotNull(Object object) {
		if (object == null) {
			return false;
		}
		if (object.toString().trim().isEmpty()) {
			return false;
		}
		return true;
	}
	
}
