package com.viontech.mall.report.base;

import com.viontech.keliu.chart.series.SeriesType;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.model.Zone;
import com.viontech.mall.model.ZoneExample;
import com.viontech.mall.model.ZoneExample.Criteria;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.service.adapter.ReportChartService;
import com.viontech.mall.service.adapter.ZoneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.*;

public abstract class TableReportBaseController {
	protected final Logger logger = LoggerFactory.getLogger(getClass());

	@Resource
	private ReportChartService reportChartService;

	@Resource
	private ZoneService zoneService;

	/**
	 * 月报表头
	 * 
	 * @param storeDivideType店铺分组类型
	 * @param objIds查询实体(分组/店铺Id)
	 * @param date查询日期
	 * @return
	 */
	@GetMapping("")
	@ResponseBody
	public Object report(@PathVariable OrgType orgType, Long[] orgIds, Date date, Date startDate, Date endDate, Long[] chartIds,
			KPIType kpiType,Long[] formats, @RequestParam(value = "page", defaultValue = "-1") int page,
			@RequestParam(value = "pageSize", defaultValue = "100") int pageSize, String sortName, String sortOrder) {
		if (date != null) {
			startDate = date;
		}
		Map<String, Object> dataMap = new HashMap<String, Object>();
		if (kpiType != null) {
			dataMap.put("KPITYPE", kpiType);
		}
		if (orgType != null) {
			dataMap.put("ORGTYPE", orgType);
		}
		if (formats != null) {
			dataMap.put("FORMATS", formats);
			ZoneExample zoneExample = new ZoneExample();
			Criteria criteria = zoneExample.createCriteria();
			criteria.andFormatIdIn((List<Long>) dataMap.get("FORMATS"));
			if (orgType == OrgType.account) {
				criteria.andAccountIdIn(Arrays.asList(orgIds));
			} else if (orgType == OrgType.mall) {
				criteria.andMallIdIn(Arrays.asList(orgIds));
			} else if (orgType == OrgType.floor) {
				criteria.andFloorIdIn(Arrays.asList(orgIds));
			}
			List<Zone> zones = zoneService.selectByExample(zoneExample);
			orgType = OrgType.zone;
			List<Long> zoneIds = new ArrayList<Long>();
			for (Zone zone : zones) {
				zoneIds.add(zone.getId());
			}
			orgIds = (Long[]) zoneIds.toArray();
		}

		if (page > 0) {
			dataMap.put("page", page);
			dataMap.put("pageSize", pageSize);
			dataMap.put("sortName", sortName);
			dataMap.put("sortOrder", sortOrder);
		}

		Object report = getReportService().getReport(orgIds, startDate, endDate, dataMap, chartIds);
		return JsonMessageUtil.getSuccessJsonMsg(report);
	}

	/**
	 * 查询图表
	 * 
	 * @param reportId报表Id
	 * @param storeDivideType店铺分组类型
	 * @param objId查询实体(分组/店铺Id)
	 * @param date查询日期
	 * @return
	 */
	@GetMapping("/{chartId}")
	@ResponseBody
	public Object chart(@PathVariable OrgType orgType, Long[] orgIds, @PathVariable Long chartId, Date date, Date startDate, Date endDate,
			Long[] chartIds, KPIType kpiType, Long[] formats, @RequestParam(value = "page", defaultValue = "-1") int page,
			@RequestParam(value = "pageSize", defaultValue = "100") int pageSize, String sortName, String sortOrder) {
		Map<String, Object> dataMap = new HashMap<String, Object>();
		if (date != null) {
			startDate = date;
		}
		if (kpiType != null) {
			dataMap.put("KPITYPE", kpiType);
		}
		if (orgType != null) {
			dataMap.put("ORGTYPE", orgType);
		}
		if (formats != null) {
			dataMap.put("FORMATS", formats);
			ZoneExample zoneExample = new ZoneExample();
			Criteria criteria = zoneExample.createCriteria();
			criteria.andFormatIdIn((List<Long>) dataMap.get("FORMATS"));
			if (orgType == OrgType.account) {
				criteria.andAccountIdIn(Arrays.asList(orgIds));
			} else if (orgType == OrgType.mall) {
				criteria.andMallIdIn(Arrays.asList(orgIds));
			} else if (orgType == OrgType.floor) {
				criteria.andFloorIdIn(Arrays.asList(orgIds));
			}
			List<Zone> zones = zoneService.selectByExample(zoneExample);
			orgType = OrgType.zone;
			List<Long> zoneIds = new ArrayList<Long>();
			for (Zone zone : zones) {
				zoneIds.add(zone.getId());
			}
			orgIds = (Long[]) zoneIds.toArray();
		}

		ReportChart reportChart = reportChartService.selectByPrimaryKey(chartId);
		
		if (page > 0 && reportChart.getType().equals(SeriesType.table.toString())) {
			dataMap.put("page", page);
			dataMap.put("pageSize", pageSize);
			dataMap.put("sortName", sortName);
			dataMap.put("sortOrder", sortOrder);
		}
		
		Object chart = getReportService().getChart(orgIds, startDate, endDate, dataMap, reportChart);
		return JsonMessageUtil.getSuccessJsonMsg(chart);
	}

	public abstract TableReportBaseService getReportService();
}
