package com.viontech.mall.report.base;

import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.chart.Chart;
import com.viontech.mall.report.model.ReportVo;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;


public interface ReportService extends BaseService{
	
	
	/**
	 * 获取报表(按时间范围统计)
	 * @param startDate 开始时间
	 * @param endDate 结束时间
	 * @param mallIds 门店id列表
	 * @param chartIds 报表key集合
	 * @param parameter 参数
	 * @return 报表对象
	 */
	public ReportVo getReport(Date startDate, Date endDate, List<Long> mallIds, Long[] chartIds,Object... parameter);
	
	
	/**
	 * 获取报表(按时间统计)
	 * @param date 时间
	 * @param mallIds 门店id列表
	 * @param chartKeys 报表key集合
	 * @param parameter 参数
	 * @return 报表对象
	 */
	public ReportVo getReport(Date date, List<Long> mallIds, List<Long> chartIds,Object... parameter);
	
	
	/**
	 * 获取仅有报表头的数据(按时间范围统计)
	 * @param startDate 开始时间
	 * @param endDate 结束时间
	 * @param mallIds 门店id列表
	 * @param parameter 参数
	 * @return 报表对象
	 */
	public ReportVo getReportOnlyHead(Date startDate, Date endDate, List<Long> mallIds,Object... parameter);

	/**
	 * 获取仅有报表头的数据(按时间点统计)
	 * @param date 时间
	 * @param mallIds 门店id列表
	 * @param parameter 参数
	 * @return 报表对象
	 */
	public ReportVo getReportOnlyHead(Date date, List<Long> mallIds,Object... parameter);

	/**
	 * 获取单个图表(按时间范围统计)
	 * @param startDate 开始时间
	 * @param endDate 结束时间
	 * @param mallIds 门店id列表
	 * @param chartKey 报表key
	 * @param parameter 参数
	 * @return Chart对象
	 */
	public Object getReportChart(Date startDate, Date endDate, List<Long> mallIds, Long chartId,Object... parameter);
	
	/**
	 * 获取单个图表(按时间点统计)
	 * @param date 时间
	 * @param mallIds 门店id列表
	 * @param chartKey 报表key
	 * @param parameter 参数
	 * @return Chart对象
	 */
	public Object getReportChart(Date date, List<Long> mallIds, Long chartId,Object... parameter);
	
	/**
	 * 获取报表的所有图表(按时间范围统计)
	 * @param startDate  开始时间
	 * @param endDate  结束时间
	 * @param mallIds 门店id列表
	 * @param chartKeys 报表key集合
	 * @param parameter 参数
	 * @return Chart对象集合
	 */
	public Map<String,Chart> getReportChartsMap(Date startDate, Date endDate, List<Long> mallIds, Long[] chartIds,Object... parameter);
	
	/**
	 * 获取报表的所有图表(按时间点统计)
	 * @param date 时间
	 * @param mallIds 门店id列表
	 * @param chartKeys 报表key集合
	 * @param parameter 参数
	 * @return Chart对象集合
	 */
	public Map<String,Chart> getReportChartsMap(Date date,List<Long> mallIds, Long[] chartIds,Object... parameter);
	
	/**
	 * 将报表对象转换为excel对象
	 * @param chart 图表对象
	 * @return excel 读取流
	 */
	public InputStream transformChartToExcel(Chart chart);
	
	
}